/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _FILE_H
#define _FILE_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             file_io.h
 * DESCRIPTION:      Header file for file input and output functions.
 *
 **********************************************************************/

#include "typedef.h"
#ifdef PRINT_INTERMEDIATE_RESULTS
#include <stdio.h>
#endif /*  PRINT_INTERMEDIATE_RESULTS */

/**********************************************************************
 * VARIABLES
 **********************************************************************/
#ifdef PRINT_INTERMEDIATE_RESULTS
extern FILE *fp_fconfig_tx, *fp_fframe_tx, *fp_fcrc_tx, *fp_fscram_tx, *fp_frs_tx, *fp_filv_tx, *fp_fqam_tx, *fp_fifft_tx,
            *fp_fconfig_rx, *fp_fframe_rx, *fp_fcrc_rx, *fp_fscram_rx, *fp_frs_rx, *fp_filv_rx, *fp_fqam_rx, *fp_fifft_rx;


#endif /*  PRINT_INTERMEDIATE_RESULTS */

extern int16 gsa_TxDtoABuf[TX_OUTBUF_FRAME_SIZE];     /*  output from TX QAP filter (D/A input) */
extern int16 gsa_TxOutFifo[TX_OUTFIFO_SIZE];          /*  fifo that holds Tx frames */
extern int16 gs_TxOut_GetPtr;
extern int16 gs_TxOut_PutPtr;

extern uint8 *gpucaa_TXChannel_InBufs[NUM_US_BEARER_CHANNELS]; /* Array of pointers in Input data buffers */
extern uint8 *gpucaa_RXChannel_OutBufs[NUM_DS_BEARER_CHANNELS]; /* Array of pointers in output data buffers */
extern int16 gsa_sync_priority[NUM_US_BEARER_CHANNELS];         /*  list of bearer channels, sorted  */
                                                                /*  by their sync control priority */



/* flags set based on file availability.  initialzed to available state.   */

extern int16 gs_TxInputFile;
extern int16 gs_TxOutputFile;
extern int16 gs_TxConfigFile;
extern int16 gs_RxInputFile;
extern int16 gs_RxOutputFile;
extern int16 gs_RxConfigFile;
extern int16 gs_TrailFile;


/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
extern int16 Mphandler(void);
extern int16 Mphandler0(void);
extern int16 Mphandler1(void);
extern void Close_MP(void);
extern int16 ProcCommand(int argc, char *argv[]);
extern int16 OpenFiles(void);
extern int16 ReadTxInputFile(void);
extern int16 ReadRxInputFile(void);
extern int16 WriteOutputFiles(void);
extern int16 CloseFiles(void);
extern void GetFromADCBuf(int16 *psa_OutBuf, int16 s_BlockSize);
extern void PutToADCBuf(int16 *psa_InBuf, int16 s_BlockSize);

#endif /* _FILE_H */

