/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _GDATA_H
#define _GDATA_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1313 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  gdata.h
;
;  Header file for global variable declarations.
;
*****************************************************************************/
// ******************************************************************
// gdata.h
//
// History
//
// 16/04/2010 Nihar: Increase DS performance against Vinax in DTAG lab
//                    DTAG-lab shows higher WhiteNoise level => use -130dBm/Hz instead of
//                    -140dBm/Hz for White Noise detection
//                    Grep for IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz
//
// 03/06/2010 Bhadra: CMV INFO 107 is used to know the status of AFE, DFE and 3 GLP interface(VR9)
//                    underflow overflow and not ready condtions.
//                   Grep for "Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status"
//
// 16/07/2010 Sriram/Bhadra : Added new code pointer in the HNSHK phase to support Amendment 3 to G.994.1 standard
//             Grep for XDSLRTFW-148: SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth
//
// 19/07/2010  Bhadra:Added code for mapping of NE Tx counters(Idle Cell /Non Idle cells) to CMV CNTR 53
//             Grep for " XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping "
//
// 26/07/2010 Nihar: Logic to add extra DS PCB to boost the DS data rate
//                   for short loops in Plus mode. All hashdefines/constants
//                   used as part of this logic are derived from experimentation results.
//                   By default its disabled. To enable it cw INFO 103 1 0x0040
//                   Grep for PERF_DS_PLUS_ALL_GeneralizedPcb
//
// 05/08/2010 Nihar : Added a new global variable to support erasure decoding reporting feature
//          Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 06/08/2010 Nihar : Added "1" variable to enable DS BitSwap
//       for all DSLAMs in DMT mode. Grep for IOP_DS_DMT_ALL_EnableDsBitSwap
//
// 26/07/10  Bhadra/Palaksha Murthy  Added fix against CNXT Cos.Link drops are
//           observed with some old CNXT DSLAMS in ADSL2/+ mode,if all tones are
//           loaded with 1bit(at some long loop fixed rate cases.
//          Solution is to force atleast to have one 2 bit tone.
//          Grep for "IOP_ALL_BISPLus_CNXT_1bitConstellation" to check the changes.
//
// 11/08/2010 ChihWen/Bhadra: Added globle variables for C-Pilot1 detection to fix
//                    a xtalk issue with UT900CNXT/D57/Rev7 DSLAM at Netcom.
//                    By default, this fix is disabled. To enable it cw INFO 103 20 0x0004
//                    Grep for SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det
//
// 11/08/2010 Kannan/Bhadra: Start Channel Identification & TDQ training
//                   from Rx channel '1' against TI & CNXT based COs for better
//                   DS performance. Since this change doesn't degrade the performance make it general.
//                   Grep for PERF_DS_ALL_TI&CNXT_ChIDfrmTone1
// 12/08/2010 Nihar : Added a flag to indicate the Vender ID change in
//                    T1.413 mode against old IFX DSLAMs like AFC 6+6H.
//                    Switch the vender ID in T1413 mode to TI VID
//                    if the CO is Siemens. This improves US rates in long loops.
//                    Grep for IOP_A_US_T1413_OldIFX_SwitchToTIVID
//
// 17/08/2010 AdeelJ/Palaksha/Bhadra: defined global flags for SRA process.
//                     Grer for SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix
//
// 17/08/2010 AdeelJ/Palaksha/Bhadra: Declared global flags for SRA process.
//            Grep for SMS00966303 SMS00954738 Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep
//
// 17/08/2009 Kannan/Bhadra: IOP fix for Downstream Upshift SRA failure
//                    against  ISAM 7302 NALT-C  & Geminax.
//               Grep for SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 09/08/2011 Vinjam/SriRam: Integrated code which finds "OOS" anamoly by reading the PPE register.
//                           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//                           Grep for Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 15/07/2011 Kannan: T1413 bring up and T1413 mode loop length estimation.
//           Grep for XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup
//
// 23/8/2011 Vinjam: Renamed "gl_LOS_detect_power" to "gl_AvgPilotPow".
//           renamed "gs_LOS_sframe_cnt" to "gs_LosDefect_state_cnt".
//           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 30/08/2011 Sriram Shastry :  QLN/HLOG calibration for Annex-A DMT, ADSL2/2+. Calibration is done with respect to the
// line simulator generated refernce data.
//             Grep for "XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration"
//
// 30/8/2011 Vinjam: Integrated "DSL_PPE_CLOCK_CONTROL" code from VR9 VDSL2 code (544316)
//          Add PPE clock change CMV as DSL 15. Bits 0:1 are the new clock setting,
//           Bit 4 is a trigger bit that will be cleared by FW after the register write is done.
//           Grep for XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
// 05/10/2011 Kannan/Vinjam : Relocated "gt_ADSL_TcMode_Reprt" structure (pointed by CMV DSL 14) from "Bis" to "Bulk Memory" data overlay section
// Grep for XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs
//
//
// 09/11/2011 Shakil/Bhadra: Downshift SRA was not performed due to Max Delay constraints. In certain interleaved
//             profiles LQ CPE trains with maximum Delay. When Downshift SRA is triggered line rate (Lp)
//             cannot decrease anymore as it will violate the max delay according to the following equations.
//             Sp = 8*NFEC/Lp
//             Delay = Sp*Dp/4 ms
//             proposed solution is to detect such cases after the first framing calculation and recalculate
//             the framing to incorporate the Downshift SRA into account so that we do not violate the delay
//             constraints after SRA completes. This algorithm is trigerred only if SRA is enabled and
//             max_delay > 1 ms (interleaved profile)
//             Grep for ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved
//
// 09/11/2011 ChihWen/Bhadra: The fix for "ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved":
//       1. The orginal code will start the searching (for max delta_Lp) from 2880, which will take very long time
//          to find the max delta_Lp and fail the training. The maximum allowed starting point (for max delta_Lp)
//          is set to 2000, which will take about 15384 symbols (from 12642 to 28026).
//       2. Considering the max_Lp (Lp + max_delta_Lp) and min_Lp (Lp - min_delta_Lp) before requesting SRA.
//       3. The searching for SRA will be enabled when it is BDCM CO or INFO 103 26 bitmask(0x0400) being one (it is zero by default).
//       Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//

// 21/11/2011 Hanyu: Ported MFD code to VRx. Added FW flag to indicate NLNF measurement is enabled.
//            This feature is triggered by "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additinally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 02/12/2011 Balabath:Added new microstate STATs18D and 19D CMV DSL 16 is used inplace of INFO 121
//       for NLNF measurement.INFO 103 (6:11) are mapped to DSL 18 0 5 (Hybrid information)..
//            Additinally, DSL13 bit2 is used inplace of CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap

//
// 05/12/2011 Balabath/Sabrina: Use LATN to estimate loop length. Conversion values needs to be
//            empirically determined against GMX EVM, E67, D57 and BRCM DSLAMs.
//            They were verified against other chipsets including CTLM, STM in
//            different modes and loop conditions (straight loops and bridgedtaps).
//            Grep for SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate
//
// 30/12/2011 Sriram Shastry : Indicate VDSL2 annex bit and the corresponding Full CLR code points in handshake  during Full CLR message
//    Grep for XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg
//
// 04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap
//
//16/01/2012 Shakil/Balabath:Non Standard T1413 GHS Activation switching required by Telefonica Spain.
//          By default , if no CO activation tones detected the CPE switches between T1413 and GHS activation
//          at every two seconds (i.e. 2 seconds of t1413 followed by 2 seconds of GHS and so on...).
//          This feature changes the switching time from 2 seconds to 60 seconds
//          (i.e. 60 seconds of t1413 followed by 60 seconds of GHS and so on...).
//          This feature is CMV controlled and by default disabled.
//          CNFG 58 0 -> bit 0  (Non standard T1413-GHS activation switching enabled/disabled)
//                   0: disabled (default)
//                   1: enabled
//          CNFG 58 0-> bit 1 (T1413/GHS Activation startup)
//                   0 -> GHS Activation startup (Default)
//                   1-> T1413 activation startup
//       For code changes Grep for XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching
//
// 10/01/2012:Balabath:Enhance_DM_Optimisation
// 12/01/2012 Kannan: Added variable to enable
//            64pt IFFT emulation for TI & CNXT in T1413 mode.
//            Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
// 25/01/2012 Kannan: PLAM counters Eg:"guc_consecutive_sev_err_sec_cnt" is not being updated for every 1secs,
//                    since "gs_bitswap_tx_sframe_count"
//                    is being reset for every 256 super frames, reseting of this counter
//                    will have incorrect update of PLAM counter, i.e not updated for every 1 secs.
//                    For Eg: 0, 59, 118, 177, 236, (256==>0), 59, 118, etc
//                    Grep for BugFix_DS_ADSL1_ALL_SuddenRFI
//
//12/01/2012: Balabath: Added CMV to trigger LPR in idication.DSL 5 0 1 will trigger this.By default
//                      this bit is set to zero.
//                Grep for XDSLRTFW-201 Feature_US_ALL_ALL_LPR
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
// 23/02/2012 Sriram Shastry : Disable PLL bandwidth to reduce DS CRC for 24DSL noise CPE margin verification test.It was observed that if
//      RxAvgmargin drops from 3.5 dB to 2.5 dB , we see Burst of DS CRC's  as a result Sync is Lost.
//      Grep for : Enhc_DS_ALL_ALL_ByPassPLLBWIncrease
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 14/06/2012 Kannan:
//          1. FIFO3 can be used to get the debug data in Rx Path
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 05/01/2009 Vinjam: Declared a new global structure to hold the Transmitter referred downstream
//            virtual noise break points.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
// 19/06/2012 Raghu M
//           L2 changes grep for XDSLRTFW-416 : Enhancement_ALL_BisPLus_ALL_L2
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 19/06/2012 Ram: Merged "ReTx" related MGMT counters and Test Params code from
//                 ARX ADSL code base (Grep: FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams)
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 04/07/2012 Ram: Merged "ReTx" Bitswap code from ARX ADSL code base.
//                 Grep for "XDSLRTFW-443 FEATURE_DS_BisPlus_ALL_BitSwapReTx"
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
// 04/07/2012 Anantha: Added global varibles needed for implementing LCD and NCD failure triggering
//                    Grep for XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 23/08/2012 Vinjam: Added a structure "gt_InteropOptions" for Interop bits common to ADSL/VDSL, attached to "CMV DSL 19"
//            Grep for "XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI"
//
// 26/11/2012 Kannan: Added variable to pull the PPE data when link is down
//                 Grep for "XDSLRTFW-541: Platform_VR9_VRX318"
//
// 14/12/2012 Hanyu/Vinjam: Integrated "XDSLRTFW_523" changes to R5.2 mainline
//          Fixed low ATTANDRds issue when SRA is enabled in capped/fixed rate cases.
//          Replaced gs_RxDesiredMargin with gs_RxDesiredMargin_original from bitloading
//          since gs_RxDesiredMargin could be overwritten by gs_RxAvMargin in SRA,
//          which would cause lower ATTANDRds when gs_RxAvMargin is much higher than target margin in capped/fixed rate cases.
//              Grep for XDSLRTFW-632 XDSLRTFW_523 BugFix_DS_BisPlus_AB_All_UpdateATTNDRds_SRA
//
// 24/12/2012 ChihWen/Vinjam: Integration of R3.5 dying Gasp code changes to R5.2.
//            Overwrite one time the Tx IB FIFO with LPR indication when dying gasp event is happening (GPIO pin 15), so that the LPR will be indicated
//       in the next US OHC frame. The reason for doing so was that there could be one OHC frame delay between the dying gasp event and
//       the time when Tx IB FIFO was empty. This delay would cause one OHC frame later for indicating LPR.
//             Grep for XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline.
//            To avoid long training times in ADSL mode and too early false mode switches to VDSL binary,
//             FW sends the intentional retrain information (using a global variable guc_Forced_Retrain) to SW/DSL API.
//            Code changes connected to Jira XDSLRTFW-248" and Jira XDSLRTFW-255.
//             Grep for XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime
// 08/11/2012 Anantha: 1. Added global variable to store previous Average margin
//                2. Added variable to help decreasing number of bins from which bits are removed
//          grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
//
// 07/01/2013 Ram: Added fix for JIRA 575, 459.
//                 a) 575: Seperate out and align FW internal counters as per Msg spec
//                         Implement incrementing UAS counter during training
//                 b) 459: Implement CMV 'CNTR 51'
//            Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//            Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
//
// 16/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by ADSL FW
//                 Added a new variable to implement CMV 'DSL 19' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 04/02/2013 Sooraj: Added a struct to support CMV "OPTN 25" for controlling EOC polling.
//            Grep for XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead
//
// 07/02/2013 Vinjam: Added support for "CMV CNFG 45" to select "G.Hs Toneset" as per VRx Msg Spec.
//            Inturn, "enale/disable" of "optional upstream interleaver depth" feature is moved to "CMV CNFG 46".
//            Grep for XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 07/02/2013 Vinjam: Send "Vector" code pointer in "VDSL2 code pointers" in ADSL G.Hs Short CLR Message.
//            Vector feature is enabled using "CMV CNFG 82". If enabled, then set "SPAR2 OCTET2 Bit-3(0x8)" & NPAR3 OCTET1 Bit-0(0x1).
//            Grep for XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs
// 20/02/2013 Mahesh:  Removed Ananta's bitswap enhancement changes for L2 & SRA
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by VDSL FW
//                 Added a new variable to implement CMV 'DSL 20' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//26-03-2013 Anantha: Added data structure to trigger bitswap over stored SNR to increase bitswap speed
//             during RFI test
//          grep pattern XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap
// 22-04-2012 Anantha:Added data structres needed forshow time pilot tone averaging
//             grep for XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg
//
// 27/5/2013 Vinjam: Clean up HERC CMV CNFG 17. Removed global structure "gt_Bonding_DiscAggr_ControlCMV".
//            Grep for XDSLRTFW-230 Bug_All_All_All_HercCnfg17_CleanUp
//
// 27/05/2013 Varun : Added strucures and variables needed for the Debug Buffer code
//                    grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 24/5/2013 Vinjam: Added mapping of "HERC CMV INFO 85" to "Showtime SNR with out Virtual Noise" and the existing
//                   HERC/SOC CMV INFO 85 (INFO_RX_CLEAR_EOC) is moved to HERC/SOC CMV INFO 130
//                   Grep for XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85
//
// 20/06/2013 Varun : Added strucures and variables needed for the Debug Buffer code of Showtime
//                    grep for "XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 14/11/2013 : Sriram Shastry : BroadCom CO goes to indefinite stuck state against VR9 based Arcadyan board.
// It has been observed that Arcardyan board perform the splitter switch during first
// training to configure the splitter during first training.
// CPE is not computing the downstream power cut back based on the C-Comb2 siganl due to internal computaion error.
// The solution is : Apply 3dB DSPCB against Broadcom CO upto 2000M . After 2Km apply 1dB of DSPCB against
// Broadcom CO in Annex-J mode only ( Applicable for 3J and 5J mode)
//       Grep for XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN
//
// 04/01/2015 Anantha Ramu/TV Ram: Uncorrected DTUs observed in some test setups. Two types of fixes done
// 1. Fix for uncorrected DTUs due to Q full condition
// 2. Fix for uncorrected DTUs due PLL disturbance(Noise spread) by SHINE pulse.
// grep for XDSLRTFW-1223.
//
// 25/03/2014 Sriram Shastry: Changes done for "SMS01261908:Link drop issue during on-hook/off-hook in G.dmt with Catena/Ciena CNX-5 DSLAMs"
//                   Changed the name of the global variable gsa_RxPilotToneInCReverb4 to gsa_RxPilotToneInCReverb34.
//        Grep for XDSLRTFW-1633 SMS01261908 SMS001231692 PERF_DS_ADSL1_AB_Ciena_PLL_TRACKING_REVERB3
//
// 31/03/2014 ChihWen: DS rate improvement against Adtran Geminax in DMT mode.
//                To improve the DS rate against Adtran Geminax in DMT mode, the solutions are below.
//                1. When preparing the parameters in R-MsgsRA, search the best R (>= 4) which will achieve highest K (best net rate),
//                   then set K in R-MsgsRA accordingly, but set R = 0, coding gain = 5.5 dB, and loaded tone number by the equation below.
//                   (loaded tone number) = 159 * (codeword size) - 232. This one-order equation is from (codeword size, loaded tone number)
//                   = (245,152) and (104,64). After receiving R-MsgsRA, Adtran Geminax will send C-RatesRA with proper options of R and K,
//                   in which AR9 will select the second or third option.
//                2. Report DS LOS when pilot power < gl_PilotTone_PwrThresh/256 instead of gl_PilotTone_PwrThresh due to link drop by CO.
//            This is controlled by CMV info 103 27 bit5 0x0020 and is disabled by default.
//            1: Enabled
//            0: Disabled (Default)
//                Grep for XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate
//
// 10/04/2014 Sriram Shastry: To reduce the training time against CNX5, the
//            following two changes are introduced.
//            1. Remove US bounds/TSSI information from long CLR.
//            2. Remove the additional long CLR which is due to the CPE
//               preferred US PSD MASK is not matched with CO in the G.hs
//               Annex L message. When this happends, CPE just takes the
//               information from CL and doesn't need to send back to CO.
//            This is protected by CMV info 103 26 0x100. The default value
//            is 0 (Disabled.)
//            Grep for ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS
// 15/04/2014 ChiWen/Hanyu: Fine tuned US performance against CNXT DSLAMs based on ADSLRTFW-1480 and ADSLRTFW-1591 with the following changes
//  (1) Added special flat US TSSI;
//  (2) Set tone 32 to zero(gusa_US_Tssi_Value[32] = 0);
//  (3) Enabled special flat US TSSI in C-REVERB1/R-REVERB1 (might have influence over the final PGA training);
//  (4) Enabled special flat US TSSI in C-REVERB2;
//  (5) Renamed gft_USPerf_Midloop_Gspn to gft_USPerf_Gspn for all CNXT CO's;
//  (6) Above changes are applied to all CNXT CO/DSLAMs regardless of CO FW versions and controlled by CMV bit4 (MASK 0x0010) of info 103 27
//      that is ENABLED (bit4=1) by default. This is especially recommended at CenturyLink/USA. So far no side effect has been observed.
//  Grep for XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 30/03/2015 Sriram Shastry:Fail in TR-105i2a1 7.9 Performance Monitoring Counters during G.998.4 retransmission.
//       Grep for : XDSLRTFW-2070
// 12/10/2015 Vinay: Added code to support G.Fast in ADSL G.Hs session.
//            Grep for XDSLRTFW-2298
//  2/12/2015 Sriram Shastry : Observed Quartz instabilities with  AVM  fritzbox[7490]. Added Detection algorithm for frequency drift and  phase drift
//  such that PLL adapt's to  fast setting  instead of  showtime setting .It helps to avoid showtime link drops in field
//
// Grep for : XDSLRTFW-2464
//
// 24/11/2017 Sriram Shastry:VRX518 US CRCs and FECs in Tests of 1TR112 ADSL2+ Anx J.
//       Disable OOB handling if US Bitswap is ongoing .DEC update logic gets into conflict with OLR as both algorithms
//       copy gsa_TxCombinedGains to the inactive gain table / active table.
//       Grep for XDSLRTFW-3479
// ***********************************************************************************************************************************

#include <stdio.h>
#include "common.h"
#include "rt_state.h"
#include "ifft_fix.h"
#include "typedef.h"
#include "aoc.h"
#include "eoc.h"
#include "ib.h"
#include "const_bis.h"
#include "rt_tones.h"
#include "ghs.h"
#include "mp.h"
#include "gpersistent.h"
#include "ovhd_bis.h"
#ifdef DEBUG_STREAMING
#include "Hmp_data.h"
#endif
#ifdef TARGET_HW
#include "gpio.h"
#endif

#ifdef IFX_XTC
#include "customertasks.h"
#endif
#ifdef ADSL_62
// temporary variables
extern int16 gs_save_computed_decdelay, gs_dec_path_delay;
#endif
// XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (Start_End)
#include "plam.h"

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod (Start)
//extern ReTxXmemConfigInfo_t *gpt_ReTxXmemConfigInfo; //PPE_SDRAM_interface changes
extern ReTxConfigInfo_t gt_ReTxConfigInfo;
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod (End)

extern uint32 gul_LEFTR_Defect_sec_cnt;
extern uint32 gul_error_free_bit_cnt;
extern uint32 gul_RETX_EFTR_min;
extern uint32 gul_ReTx_ETR;

extern uint32 gul_curr_EFTR;
extern uint32 gul_prev_EFTR;
extern uint32 gul_leftr_thresh;
extern uint32 gul_RxDtuCorrectedCNT;
extern uint32 gul_RxReTxDtuUncorrectedCNT;
extern uint32 gul_prev_RxReTxDtuUncorr;
//extern uint32 gul_EFD;
// Add seftr as per Homework on BroadCom comment.
extern uint32 gul_sev_eftr;
extern uint32 gul_DTUuc;

extern int16 gs_Force_ReTx_Framing;   //FEATURE_DS_BisPlus_ALL_ForceExplicitFramingForURETX (Start_End)
extern uint16 gus_INP_act_SHINE;
extern uint16 gus_17MSec_RxShowtimeFrameCnt; //Conter for 17 msec
extern int16 gs_norm_DTUuc_1sec;

extern uint8 guc_INP_act_REIN;
extern uint8 guc_delay_act_RETX;

extern RRC_Stat_t gt_RrcStat;
extern uint8 guc_retx_N;
extern uint8 guc_retx_K;
extern uint8 guc_retx_payload_cw1;
extern uint8 guc_XDTUs; // No of DTU's that read out from the Queue and forwarded to PPE

extern volatile uint32 gul_ZrFifoSetupWait;
extern volatile uint32 gul_ZrFifoReadWait;
extern uint32 gul_ZrFifoValidBytes;

extern ReTX_Stats_t gt_ReTXStats;
extern ReTX_Params_t gt_ReTXParams;


extern volatile uint32 gul_ZrFifoSetupWait;
extern volatile uint32 gul_ZrFifoReadWait;
extern uint32 gul_ZrFifoValidBytes;

//XDSLRTFW-1634 (Start)
extern QretxTableEntry_t gta_QretxTable[];
//XDSLRTFW-1634 (End)
//XDSLRTFW-1223 Qrx Full Fix (Start)
#ifdef ENABLE_THREE_NEEDLE_TEST
extern uint8 guc_StartThreeNeedle;
extern uint8 guc_ThreeNeedleBadDTUCount;
extern uint8 guc_ThreeNeedleCount;
extern uint8 guc_CountToNextNeedle;
extern uint16 gus_ThreeNeedleDurationCount;
extern uint16 gus_ThreeNeedleDuration;
#endif

extern QueueNode_t gt_NodeList[]; //Max_QRx => Max_QTx*3 = 63*3;
extern QueueStatus_t gt_FreeBufList;
extern uint8 guca_InpBufList[];
extern uint8 guc_InpBufListIndx;
extern uint32 gula_ZrIlvbWrPtrTable[];

#ifdef PILOT_CAPTURE_518
extern int16 gsa_518Pilot[];
extern uint32 gul_518Pilot_Cnt;
#endif

//XDSLRTFW-1223 Qrx Full Fix (End)
#if 0
    int32 gl_RxHalt;
    int32 gl_NoRetxMsg;         // bit-0 set = RETX not detected in OSMG1
                                // bit-1 set = RETX not detected in OTPS
                                // bit-2 set = msg is not amend 1&3 compliant in OTPS
                                // bit-3 set = RETX not detected in OPMS

#endif
extern FlagT gft_NotFirstDTU;
extern uint8 guc_ReTX_CRC1_ReportTS;
extern uint16 gus_ReTX_crc1;

//XDSLRTFW-1634 (Start)
extern uint8 guc_maxdtuout;
extern uint8 guc_EstimatedTS;

extern FlagT gft_Qrx_Full;
extern uint16 gus_QFullCntr;
extern uint16 gus_dbg_QreTx_full_cntr;
extern uint16 gus_DropPktCntr;
extern uint32 gul_cons_bad_dtu;
extern uint32 gul_cons_good_dtu;
extern uint32 gul_max_cons_bad_dtu;
extern uint16 gus_BufOverWriteCntr;

extern uint8 guc_Curr_Wr_DTU_idx;
extern uint8 guc_Wr_SID_idx; //To be write Index of the Translation table
extern uint8 guc_Rd_SID_idx; //To be read Index of the Translation table
extern uint8 guc_Prev_Rd_SID;
extern uint8 guc_Prev_Rd_SID_idx; //Index of the DTU already forwared to the PPE.
extern uint8 guc_Prev_Rd_DTU_idx;

extern uint8  guc_DsQRx;
extern uint8  guc_DsQTx;
extern uint8  guc_NRET;
extern uint16 gus_DTUSizeDS;
extern uint16 gus_DTUPayloadSizeDS;
extern uint16 gus_DTUSizeInSymbolsDS;
//XDSLRTFW-1634 (End)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

// XDSLRTFW-1942 (Start)
extern uint32 gula_DebugBuffer_BAR15[];
extern uint16 gusa_MedleySnrBuffer_BAR15[];  //
extern uint16 gusa_ReverbSnrBuffer_BAR15[];
extern uint16 gusa_ReverbEchoSnrBuffer_BAR15[];
// XDSLRTFW-1942 (End)

//XDSLRTFW-1223 (Start)
#ifdef PLL_ADAPTATION_SHOW
extern FlagT gft_first_showtime;
extern FlagT gft_av_done;
extern uint8 guc_av_cnt;
extern uint8 guc_delay_count;
extern int16 gs_MaxPhaseErrorThreshold_save;
extern int32 gl_tan_prv;
extern int32 gl_tan;
extern int32 gl_err;
extern int32 gl_err_prv;
extern int32 gl_err_diff;
extern int32 gl_thresh;
extern int32 gl_pll_freq_offset_prv;
extern int32 gl_pll_loopfilter_out_prv;
extern int32 gl_sum_err_diff;
#endif
//XDSLRTFW-1223 (End)

// XDSLRTFW-3662 (Start)
extern uint16 gusa_PPA_FW[2];  // This information is provided/configured by host.
extern uint16 gusa_PPE_FW[2];  // This value is read out from DREG register DREG3
// XDSLRTFW-3662 (End)

#ifdef DEBUG_STREAMING
extern DebugStreamControl_t gt_debugStreamControl;
extern DebugStreamConfigure_t gt_debugStreamConfigure;
extern DSH_Statics_t gt_DshStatics;
extern uint16 gus_Dbg_RequeueCnt;
extern uint16 gus_RequeueBGFunction;
extern uint16 gus_Dbg_DSH_skip_BGF_add;
extern uint16 gus_Dbg_msg_length;
extern DSH_ModemFsmState *gpt_DSH_ModemFsmState;
extern int16 gs_DSH_PrevMacroState;
extern uint8 guc_DSH_VersionInfoStreamed;
extern HMP_DebugStreamMsg_t gt_DebugStreamMsg;
extern uint8 guca_DSH_RX_EOC_msg_buffer[];
extern uint8 guca_DSH_TX_EOC_msg_buffer[];
extern uint16 gus_DSH_RX_EOC_idx;
extern uint16 gus_DSH_TX_EOC_idx;
#endif

extern int32 gl_tle;
// Debug variables
extern FlagT gft_StopDSL;
extern int16 gs_PauseMarker;
extern volatile FlagT gft_Resume;
extern FlagT gft_PauseOff;
extern uint16 gus_BgLoopCnt;       //log the Bg task loops to see whether its incrementing
extern PtrToFunc gl_CurrentBGTask;     //log the current BGTask address

/* Test Parameters */

extern int8 guca_US_BAT23_TCM_ON[32];
extern int8 guca_DS_BAT68_TCM_ON[256];

/* Kernel Variables */

extern int16 gs_GlobalInterruptFlag;
extern int16 gs_InterruptEnableMask;
extern int16 gs_InterruptMask;
extern int16 gs_IntNextFrameEnable;

extern TCB_t gt_TaskArray[NUM_TASK_BUFFERS]; /* allow at most 5 tasks */
extern PtrToFunc gt_BGTaskArray[NUM_BG_BUFFERS];
extern FunctionFifo_t gt_BGTaskFifoBuf,*gp_BGTaskFifo;

extern PtrToLoadingFunction gp_TxLoadingFunctionFifo[LOADING_FUNCTION_FIFO_SIZE+1];
extern PtrToLoadingFunction gp_RxLoadingFunctionFifo[LOADING_FUNCTION_FIFO_SIZE+1];

//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
#ifdef PPE_ENGINE
extern uint32 gula_DREG_AR_OVDROP_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CERRN_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CERRNP_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CVN_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CVNP_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gul_CRC_P_cnt;  //CRC_P
extern uint32 gul_CVC_P_cnt;     //CVC_P
extern uint32 gul_CRC_NP_cnt;  //CRC_NP
extern uint32 gul_CVC_NP_cnt;    //CVC_NP
extern uint8  guc_TPSTCoptions;
//Sriram : For Debug status
extern FlagT gft_enable_PpeExtraRead;
#endif
// XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)
/*
extern G997_PtmPerfCnts_t gt_g997_PtmPerf_Running_NE;
extern G997_PtmPerf_Cur_Prev_t gt_g997_PtmPerf_Cur_Prev_NE;
extern G997_PtmPerfCnts_t gt_g997_PtmPerf_Running_FE;
extern G997_PtmPerf_Cur_Prev_t gt_g997_PtmPerf_Cur_Prev_FE;
*/

//Variable define capabilities in G.Fast
extern uint32 gul_OperationModeCapable_G_Fast;

// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(START)
#ifdef HERC_API
// global variable initialization for PAR2 & PAR3 blocks
// SPAR2 & NPAR3 for SPAR1-Octet-1
extern int16 gs_OPTN_ConfigMode_G993_2_Control;
extern int16 gs_Vdsl2_Profile_Supported;
extern int16 gs_NumOfRFIBands;
extern int16 guc_Initial_IDFT_size;


// SPAR2 & NPAR3 for SPAR1-Octet-2
extern uint8 guc_Annex_A_US0_EU_32_52; // Support for EU Mask from 32 to 52
extern uint8 guc_Annex_A_US0_EU_56_64; // Support for EU Mask from 32 to 52, 128 is a part of the standard but it is excluded for the time being
extern uint8 guc_Annex_A_US0_ADLU_32_52;  // Support for ADLU Mask from 32 to 52
extern uint8 guc_Annex_A_US0_ADLU_56_64;  // Support for ADLU Mask from 32 to 52, 128 is a part of the standard but it is excluded for the time being
extern uint8 guc_US0_supported_profile_12b_17a; // US0 supported in profile 12b,17a

extern uint8 guc_Annex_B_US0_Profile_25_138KHzA_276KHzM_120_276KHz;
extern uint8 guc_Annex_B_US0_Profile_12b_17a;

extern uint8 guc_Annex_C_US0_Profile_25_138KHzb_276KHzb_type;
extern uint8 guc_Annex_C_US0_Profile_25_138KHzco_276KHzco_type;
extern uint8 guc_Annex_C_US0_Profile_12b_17a;
extern uint8 guc_VDSL2_SI_Spar2_Octet1;
extern uint8 guc_VDSL2_SI_Spar2_Octet2;
extern int32 gla_CELength;
#endif
// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(End)
/*  State machine variables */
extern StateMachCntrlStruc_t gt_StateMachCntrl;

extern int32 gl_TxSymbolCount, gl_RxSymbolCount;      /*  this count resets when states change */
extern int32 gl_RxSymbolRunningCount;  /* Rx symbol count that does not get reset to 0 with each state */
extern int32 gl_save_RxSymbolCount, gl_save_TxSymbolCount;
extern int16 gs_save_RxSubState, gs_save_TxSubState;
extern int16 gs_save_RxState, gs_save_TxState;
/*XDSLRTFW-2464*/
extern int32 gla_pll_freq_offset[32];
extern int32 gl_Pll_Freq_delta;
extern uint8 guc_Pll_idx;
/*XDSLRTFW-2464*/
// Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (start end)
extern int16 gs_DSL_EDcontrol;
extern int16 gs_Medley_OffsetXtra;
extern int16 gs_TxState, gs_RxState;
extern int16 gsa_CRCincrement[NUM_DATA_PATHS];
extern int16 gs_TxSubState, gs_RxSubState;
extern int16 gs_TxNextState, gs_RxNextState;
extern int16 gs_TxStopState,  gs_RxStopState;
extern int16 gs_TxDoneState, gs_RxDoneState;       /*  temporary conditions to halt processing */
extern int16 gs_TxStateJumpTo, gs_RxStateJumpTo;
extern int16 gs_TxStateJumpFrom, gs_RxStateJumpFrom, gs_RxSubStateJumpFrom;
//extern int16 gs_TxStateJumpFrom, gs_RxStateJumpFrom, gs_RxSubStateJumpFrom, gs_TxSubStateJumpFrom;
extern int16 gs_TxSubStateCnt, gs_RxSubStateCnt;

/* extern int16 gs_PilotToneMax; */
/* XDSLRTFW-2464 (Start)*/
//#ifdef ISDN
extern Avm_PllRotInfo_t ga_PllRotInfo[];
extern int16 gs_Last_Reported_Phase_Error;
extern int16 gs_New_Phase_Error;
extern int16 gs_Prev_Phase_Error;
extern int16 gs_NumOfIdenticalAdjacentPTPhases;
extern int16 gs_MinNumberOfAdjPhaseErrorsToDeclareNewPhase;
extern uint16 gus_PhaseErrorReporting_Idx;
extern int32 gl_RxPilotTone_SqErr_Threshold_temp;
//#endif
/* XDSLRTFW-2464 (End)*/
extern int16 gs_TxDECTrainSymbolCount, gs_RxDECTrainSymbolCount;
extern int16 gs_StartDECTraining;

extern uint16   gus_TxGain_NoCutBack_default;

//XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup (START)
extern int32 gl_t1413_crevelle_tone_power;  //T1413 - CReveille Tone Linear Power
extern int16 gs_t1413_crevelle_tone_power_dB; //T1413 - CReveille Tone Power in dB
extern int16 gs_t1413_PGA_set;  //Debug
extern int16 gs_t1413_tdq_exp;  //Debug
//XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup  (END)
extern FlagT gft_IFFT64_T1413_TxImages; //PERF_US_T1413_T1&CNXT_64ptIFFT (START - END)

#ifdef  ISDN  // Only for Annex - B
// IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (Start)
// IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (Start)
extern int16  gs_Required_TxPCB;
extern uint16  gusa_TxPwrCut_Table[7];
// IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (End)
// IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (End)

// IOP_DS_DMT_ADI_SendNcloadedEqualToZero (Start_End)
extern FlagT gft_ADI_ANCDA_minSNR_flag;
#endif

#ifndef ISDN   // Only for Anx-A
// IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
extern uint16 guc_TimeWindow_DS_BitSwaps;
extern uint16 guc_TimeWindow_DS_BitSwaps_Delay;
// IOP_DS_DMT_ALL_EnableDsBitSwap (End)
#endif // ifndef ISDN
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)

//XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
extern int16 gs_target_margin; // Minimum margin per Tone during BitSwap.
// Increase of delta step size in MinTonemargin during BitSwap
extern int16 gs_delta_step; //0.5 dB
// Flag to indicate increase min tone margin based on margin.
extern FlagT gft_BitSwapUp;
// Flag to indicate reduce min tone margin based on margin.
extern FlagT gft_BitSwapDown;
//XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)

/* Algorithm State Machine Variables         */
/*                                  */
/*     Each Algorithm State Machine is embedded within a particular state machine   */
/* substate and is called once per frame until complete. The purpose of the         */
/* Algorithm State Machine is to simplify re-use of the training sequence for    */
/* each block, e.g. AEC, Frame Alignment, TDQ, DEC, etc. Encapsulating the       */
/* sequence allows the code to be reused both across time (i.e. multiple times      */
/* within a single train) or across operation modes (e.g. DMT and BIS).          */


extern int16 gs_rx_framecnt;
extern int16 gs_DetSegueFlag;

extern uint8 guc_BkgdTaskState;              // Generic, reusable flag for indicating background task completion.
extern uint8 guc_TdqTrainingState;                 /*  TDQ training in TdqInit() */
extern uint8 guc_FdqTrainingState;                 /*  FDQ training in FdqInit() */
extern uint8 guc_EcTrainingState;                  /*  EC  training in ECTrain() */
extern uint8 guc_AecTrainingState;                 /*  AEC training */
extern uint8 guc_AvgAecLmsSequences;
extern FlagT gft_BitloadState;                     /*  Bitloading status flag */
extern uint8 guc_SnrCalcState;                          /*  SNR calculation status flag */
extern uint8 guc_AccumState;                    /*  Accumulation status flag */
extern uint8 guc_RxSyncFrameProcessingState;
extern uint8 guc_ShowTimeRxState;                  /* Showtime task layer Rx initialization status flag */
extern uint8 guc_ShowTimeTxState;                  /* Showtime task layer Tx initialization status flag */
extern uint8 guc_RxDataPumpState;                  /* Showtime DSL engine Rx initialization status flag */
extern volatile uint8 guc_RxToneOrderLoadState;
extern int16 gs_RxDataPumpLoadState;
extern uint8 guc_TxDataPumpState;                  /* Showtime DSL engine Tx initialization status flag */
extern int16 gs_TxDataPumpLoadState;
extern uint8 guc_PgaTrainingState;
extern uint8 guc_HandshakeDone;

extern FlagT gft_TxImages;       // Set to indicate transmission of Image

/*  Modem configuration variables */
extern int16 gs_TxNumTones;
extern int16 gs_TxFirstChannel;
extern int16 gs_TxLastChannel;
extern int16 gs_TxReverb12FirstCh;
#ifdef ISDN
// IOP_DS_DMT_TI_UseBroaderTxReverbSignal (Start_End)
extern int16 gs_TxReverb12LastCh;
#endif
extern int16 gs_TxMedleyFirstCh;
extern int16 gs_TxMedleyLastCh;
extern int16 gs_TxFirstBd_LeftChn, gs_TxFirstBd_RightChn, gs_TxSecondBd_LeftChn, gs_TxSecondBd_RightChn;
extern int16 gs_TxFftLength;
extern int16 gs_TxLog2FftLength1;
extern int16 gs_TxCPLength;
extern int16 gs_TxLog2FftScaling;

#ifdef ADSL_62
// Vr9 uses an oversampled IFFT.
// In order to share the code with 3.x, 4.x and 5.x,  we let gs_TxFftLength = TX_IFFT_LENGTH = 2*TX_NUM_TONES
// but use gs_TxFftLength_Oversample when configuraring QT/FT/FTB/FDF
extern int16 gs_TxFftLength_Oversample;
extern int16 gs_TxLog2FftLength1_Oversample;
extern int16 gs_TxCPLength_Oversample;
#endif

extern int16 gs_RxNumTones;
extern int16 gs_RxLog2NumTones;
extern int16 gs_RxFirstChannel;
extern int16 gs_RxBitLoadFirstChannel;
extern int16 gs_RxLastChannel;
extern int16 gs_RxBitLoadLastChannel;
extern int16 gs_RxFftLength;
extern int16 gs_RxLog2FftLength1;
extern int16 gs_RxCPLength;
extern int16 gs_RxLog2FftScaling;
extern int16 gs_RxSamplesPerFrame;
extern int16 gs_Log2RxSamplesPerFrame;

// XDSLRTFW-3566 (Start_End)
extern uint16 gus_PPEClock_Configured;

#ifndef  ISDN  // Only for Annex - A
// AR8_TF: PERF_DS_ALL_TI&CNXT_ChIDfrmTone1
extern int16 gs_RxFirstChannelSave;
#endif // ifndef ISDN
extern int16 gs_DS2US_RateRatio;
extern int16 gs_Log2DS2US_RateRatio;

extern int16 gus_TxSineGain;              /*  applied Tx gain */

/*  Data Buffers */
/*  The following variables are defined in gdata_buf.c in the Platform directory */
extern int16 *gpsa_CommonMemoryBlock0;
extern int16 *gpsa_CommonMemoryBlock1;

extern int16 *gsa_RxToneBuf;        // Always use this pointer rather than the array name.

extern int16 gsa_XBlock[];                // 4K bytes for ADSL_62; 8K bytes for other systems
extern int16 gsa_YBlock[];                // 4K bytes for ADSL_62; 8K bytes for other systems

#ifdef ADSL_62
extern int16 gsa_YBlock_Extended[];       // not more than 4Kbytes
extern int16 gsa_XBlock_Extended[];       // not more than 4Kbytes
#endif

extern int16 *gsa_RxBuffer8X_0;
extern int16 *gsa_RxBuffer8X_1;

extern int16 gsa_TxToneBufArray[];     /*  tone buffer prior to IFFT (Tx)  */
extern int16 *gsa_TxToneBuf;        // Always use this pointer rather than the array name.
extern int16 *gsa_Showtime_TxToneBuf;

extern int16 *gpsa_RxToneBuf_sav2;

// VRX518_Compilation
extern int16 gs_MinValBisChan_VR9;
#ifdef ISDN /* Annex B */
extern int16 gsa_VR9_PlusRxAFEFilt_dB[];
extern int16 gsa_VR9_BisRxAFEFilt_dB[];
extern int16 gsa_VR9_DMTRxAFEFilt_dB[];

extern int16 gsa_VR9_PlusRxAFEFilt_A21_old_dB[];
extern int16 gsa_VR9_BisRxAFEFilt_A21_old_dB[];
extern int16 gsa_VR9_DMTRxAFEFilt_A21_old_dB[];
#else
extern int16 gsa_VR9_AnxA_PlusRxAFEFilt_dB[];
extern int16 gsa_VR9_AnxA_BisRxAFEFilt_dB[];
extern int16 gsa_VR9_AnxA_DmtRxAFEFilt_dB[];

extern int16 gsa_VR9_AnxA_PlusRxAFEFilt_A21_old_dB[];
extern int16 gsa_VR9_AnxA_BisRxAFEFilt_A21_old_dB[];
extern int16 gsa_VR9_AnxA_DmtRxAFEFilt_A21_old_dB[];
#endif //#ifdef ISDN



#ifdef ISI_ANALYSIS_ON
extern int16 gsa_RxCPBuf[RX_PREFIX_LENGTH];           /* RX Cyclic Prefix (CP) buffer */
extern int16 gsa_RxMedleyCaptureBuf[(RX_NUM_TONES*2+RX_PREFIX_LENGTH)*RX_MEDLEY_NUM_FRAMES+2]; /* RX Medley capture (CP included) buffer */
extern int16 gsa_RxRepFrameCaptureBuf[RX_FFT_LENGTH]; /* RX Reverb2 representative frame buffer */
extern int16 gsa_RxChannelEstimateBuf[RX_FFT_LENGTH]; /* RX channel estimate buffer */
#endif

#ifdef AEC_ANALYSIS_ON
extern int32 gl_error;
extern int16 gsa_RxLMSCaptureBuf[(AEC_ORDER+3)*NUM_AEC_LMS_ITERATIONS];
#endif

extern int16 gs_log2_NumFramesAvg_SpectrumEst; /* log2 number of frames averaged for spectrum estimation */

extern int16 *gsa_CQuietRefTones;

extern int16 *gsa_CReverbRefTones;

#ifdef CALC_REVERB_SNR
extern int16 gsa_ReverbSnrBuf[RX_NUM_TONES];          /*  REVERB SNR buffer without echo */
#endif
extern int16 gsa_SignalPSD[(HYB_DECIM_POINTS+1)*28];
#ifdef CALC_REVERB_ECHO_SNR
extern int16 gsa_ReverbEchoSnrBuf[RX_NUM_TONES];         /*  REVERB SNR buffer with echo */
#endif

extern int16 gsa_MedleySnrBuf[RX_NUM_TONES];          /*  MEDLEY SNR buffer */

extern int16 *gsa_RefTonesMedleySNR;

extern int16 gsa_FRSnrBuf[];           /*  SNR Buffer at C_R_MEDLEY_FR */

extern int16 *gsa_RxRepFrameAlignBuf;

#ifdef FLOAT_IN_SW
// Used to hold Reverb reference signal for TDQ training. Re-used by TDQ init for other purposes.
// Required size = 2*RX_NUM_TONES+2 words.
extern int16 *gsa_TDQTrainingSignal;

// Floating point version of TDQ input signal.
// Required size is RX_FFT_LENGTH*2 words = RX_FFT_LENGTH doublewords.
extern Float32 *gfa_TDQSignalIn;
#endif

extern int16 *gsa_RxRepFDQTrainBuf;

extern int16 *gsa_RxShowtimeSnrBuf;    /*  SNR buffer at Showtime */
extern int32 *gla_RxShowtimeSnrAccumBuf;
extern int16 *gsa_RxShowtimeFDQAccumBuf;
extern int16 *gsa_RxShowtimeFDQRepBuf;
extern int32 *gla_RxDECXcorr;

//Time period used for monitoring the Rx Delineated cell count
extern uint8 guc_RxCellDelineatePeriod;

extern int32 *gla_RxAccumBuf;
#ifdef NOISEACC_COMB2
extern int32 gla_AccumBufComb[2*(C_COMB_INDEX_CNT_G992_5+20)];
#endif //NOISEACC_COMB2
extern uint8 guca_RxBat[RX_NUM_TONES];                      /*  bit allocation table             */
extern uint8 guca_TxBat[TX_NUM_TONES];             /*  bit allocation table             */

extern int16 gsa_TxFineGains[TX_NUM_TONES];           /*  fine gain table (in Q3.13 format) */

//Required size of gsa_RxFineGains is Rx_NUM_TONES 16-bit words;
extern int16 *gsa_RxFineGains;            /*  Fine gain table (init to 1.0 in Q3.13 format) */

extern RxToneFlags  guca_RxBitswapTones;
extern RxToneFlags p_MEDLEYset_DS;
extern RxToneFlags p_SUPPORTEDset_DS;
extern TxToneFlags gp_MEDLEYset_US;
extern TxToneFlags gp_SUPPORTEDset_US;
extern RxToneFlags p_TonesAllocatedtoLP1_DS;
extern RxToneFlags p_FINEGAINSKIPset;

//============================================
// End of Data buffers
//============================================

//DO_T1413_ISSUE2 : Flags for T1.413 issue 2
extern FlagT gft_ShortRSilent0;     // If TRUE R-SILENT1 lasts for 100ms (HS/T1 multimode), otherwise 2 seconds.

#ifdef  T1413_SUPPORT_EES_OFF
extern FlagT gft_T1413_EesFlag;        // TRUE, perform Expanded exchange sequence for T1.413 issue 2
#endif

extern FlagT gft_C_ACT_flag;
extern int16 gs_NumT1Restarts;         /* Number of T1413 activation restarts due to timeout in R-QUIET2 */

// Power level threshold for tone detection
extern int16 gs_DetectMin;

extern int16 gs_RxDetectCnt;

// variables associated with C-REVERB detection during transceiver training

extern int32 gl_Rx_Total_Power;                    /*  Average received signal power */
extern int32 gl_Rx_Total_Power_Quiet;              /*  Average received signal power for Quiet state */
extern int32 gl_Atten_Rx_Total_Power;              /* signal power used for line attenuation calculation */
extern int16 gs_ToneDetectScale;
extern int32   gl_Rx_Frame_Power;
extern int16 gs_r_c_quiet2_wait ;

// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
#ifndef  ISDN // Only for Annex - A
extern int32 gl_Ghs_PilotAccR;
extern int32 gl_Ghs_PilotAccI;
extern int32 gl_Ghs_NoiseAccH;
extern int32 gl_Ghs_NoiseAccL;
extern int32 gl_Ghs_PilotSNR;
extern int16 gs_Ghs_ToneDetectScale;
extern FlagT gft_Ghs_CPilot1Det_Enabled;
#endif // ifndef ISDN
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)

extern int16 gs_DecimatorPhaseIdx;
extern FlagT gft_DecimatorPhaseSelectDone;
//SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA (Start End)
extern FlagT gft_AllowUpshiftSRA;


extern int16 gs_num_snr_training_symbols;                      /* Number of snr training symbols  */
extern int16 gs_log2_num_snr_training_symbols;                 /* log2 of (Number of snr training symbols) */

extern int16 gs_num_fdq_training_symbols;                      /* Number of FDQ training symbols  */
extern int16 gs_log2_num_fdq_training_symbols;                 /* log2 of (Number of FDQ training symbols) */

extern int16 gs_NumAttenuationSymbols;             /*symbol count to compute loop attenuation */
extern int16 gs_MaxToneForFast;                          /* Maximum tone index (after tone reordering) for fast path) */
extern int16 gs_FirstNonzeroTone;                     /* First non zero tone index */
extern int16 gs_FirstNonzeroTxTone;
extern int16 gs_FirstNonzeroRxTone;

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
extern DsVnPSDDescriptorTable_t gt_DS_RefVirtNoiseLevel_ADSL2;
extern uint16 gus_NumbDsVnBrkPoints;
extern int16 gs_DSL_FeaturesControl;
extern int16 *gpsa_RxSnrBufWoVN;  //Pointer refers to memory location which contains
                           //show time SNR with out virtual noise.
                           //This is used only when DS VN feature is enabled &
                           //Received DS VN PSD Break points in G.Hs & C-MSG-PCB
extern int16 gsa_RxWithOutVnSnrBuf[];
extern FlagT gft_Enable_DsVnInMedley;
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

extern uint16 gft_FrameMode;                    /*  Indicates which {0, 1, 2, 3} framing mode is used */

// Flags and Indicators for S=1/2:
extern int16 gs_MuxFrameSize_Half[NUM_DATA_PATHS][2];
extern int16 gs_CodewordSize[NUM_DATA_PATHS][2];
extern int16 gs_First_Byte[2];
extern int16 *gpsa_RxShowtimeSnrBuf;   //showtime SNR pointer used in Rx DMT bitswap decision
extern FlagT gft_BitSwapPerform;    //Flag indicate the Bkgd PerformRxBitSwap status

//ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start)
extern int16 gs_deltaLp_max;
extern int16 gs_sraOffset;
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
extern FlagT gft_FrameCheckForSRA;
extern int16 gs_MaxLp;
extern int16 gs_MinLp;
extern int16 gs_MaxRateLp;
extern int16 gs_MinRateLp;
extern int16 gus_Scale_FractINP;
extern uint16  gus_ToneNumNon15Bits;
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)
//ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (End)
extern FlagT gft_OneStepSRA;
extern FlagT gft_UpShift_DSProcess;
extern FlagT gft_DnShift_USProcess;
extern int16 gs_delta_INP;
extern uint16 gus_DSorUS_Process_Interval_Timer;
extern uint16 gus_DSorUS_Process_Dbg;


/*  Buffer sizes for DLI */
extern int16 gs_Tx_OutBuf_Size;
extern int16 gs_Rx_InBuf_Size;
extern int16 gs_DtoABuf_Size;                   /* DAC output frame size */
extern int16 gs_AtoDBuf_Size;                   /* ADC input buffer size */
extern int16 gs_TxOutSymbolCount;

/* bit loading variables */
extern Adsl1_Control_t gt_ADSL1_Control;

extern uint16 gus_ncloaded;                        /*  no. of channels with non-zero bit loads */
extern uint16 gus_ncloaded_LP1;                       // number of tones for LP1 with non_zero bitloading
extern uint16 gus_US_max_bits_per_symbol;          /*  the maximum number of bits per symbol for DS channe */
extern uint16 gus_DS_max_bits_per_symbol;          /*  the maximum number of bits per symbol for DS channe */
extern int16 gs_RxDesiredMargin;                /*  desired SNR margin in Q8.8 format */
// XDSLRTFW-632 XDSLRTFW_523 BugFix_DS_BisPlus_AB_All_UpdateATTNDRds_SRA (SATRT_END)
extern int16 gs_RxDesiredMargin_original;
//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (Start_End)
//extern int16 gs_RxDesiredMargin_Delta_bis;          // (8.8 format) Used to adjust the DS snr margin in bitloading. //Moved to HERC CMV OPTN 28

extern int16 gs_RxMinRequestedSTMargin ;              /*  Min margin for Showtime, as requested from CO, 1 dB steps */

extern FlagT gft_BitloadOK;                        /*  indicator if bit loading is FAIL or SUCCEED */
extern int16 gs_RxAvMargin;                        /*  average SNR margin */
extern int16 gs_RxMinMargin;                    /*  minimum SNR margin */
extern int16 gs_RxMinMarginTone;
extern int16 gs_MarginLimit;
extern int16 gs_RxAvFineGain;                   /*  average fine gain */
extern int16 gs_RequestedRxMaxMargin;              // Requested Max Margin in dB (Q8.8)
extern int16 gs_ExcessMarFDQBoost;                 // FDQ boost = 1/(Fine gain reduction) [3.13 format]
extern int32 gl_SumFGainLinSq ;                 // Sum of fine gain linear square
extern int32 gl_SumGiSqTssiSq ;                 // sum gi square tssi square
extern int32 gl_save_SumFGainLinSq;
extern int32 gl_save_SumGiSqTssiSq;
extern int16 gs_MaxNOMATP_DS;                   // MAx NOMATP_DS
extern int32 gl_MaxSumGiSqTssiSqLin;
extern int16 gs_forceeven1bit_notonefound;    // flag to indicate that forceeven1bit can't find a tone to add bits
extern FlagT gft_EnableNomATP;
//XDSLRTFW-1564 / XDSLRTFW-1665 (Start)
extern FlagT gft_FTMarginTune;
extern int16 gs_RxAvMarginOnNon15bits;
extern int16 gs_RxAvMarginNoCap;
extern int16 gs_RxAvMarginWithCap;
extern int16 gs_ReportMargin;
//XDSLRTFW-1564 / XDSLRTFW-1665 (End)
extern int16 gs_RxMaxMargin;                     /* maximum SNR margin in Q8.8 dbgVar*/
extern int16 gs_RxMaxMarginTone;                 /* Tone with the maximum SNR margin dbgVar*/

//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
extern int16 gs_IncBitInBinReduced;
extern int16 gs_RxPrevAvgMargin;
//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(end)

extern int16 gs_SnrMargin_OneOverTen_dB_Resolution;      // DS snr margin with 0.1dB resolution
extern uint16 gus_10sec_SNRUpdate;
extern uint16 gus_10sec_NegSNRMTimer;
extern uint16 gus_PrevSNRUpdateCnt;


extern int16 gs_Margin; /* 8.8 format */
extern int16 gs_Margin_Point1dB; // DS snr margin with 0.1dB resolution


extern int16 gs_init_AvMargin;                     // Average SNR margin computed at the end of Medley in Q8.8
extern int16 gs_init_MinMargin;                    // Min SNR Margin at the end of Medley in Q8.8

extern int16 gsa_TotalCodingGain[2];               /*  the total coding gain in dB applied to each path */

//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
extern uint16 gus_TxPathControl;
extern int16  gs_DEC_SHIFT;
extern int16  gs_DEC_SHIFT_INIT;
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)

extern int16 gs_TxPayload;                      /*  number of payload data bytes per frame (US rate)*/
extern int16 gs_RxPayload;                      /*  number of payload data bytes per frame (DS rate) */

extern uint8 guca_RSCodingGain[9];                 /*  RS coding gain table */

//extern uint8 guca_CodingGain_TCMON[9][7];           /*  RS coding gain table BIS*/

extern int16 gs_tcm_coding_gain ;
extern int16 gs_max_coding_gain ;
extern int16 gs_intlv_tcm_coding_gain ;
extern int16 gs_intlv_max_coding_gain ;


extern int16 *gpsa_MeasuredSnrBuf;                 /* pointer to meansured SNRs */
extern int16 *gsa_RxFineGainPlusBitChannel;
/*  store indices of channels where a extra bit is used */
extern int16 gs_max_fine_gain;
extern int16 gs_min_fine_gain;

extern int16 gs_Capacity;
extern int16 gs_RxExtraBits;                    /* extra bits allocated due to use fine gains */
extern uint8 guc_MaxAllocBitsPerTone;              /* maximum bits per tone allocated to upstream channel */
extern uint8 guc_Log2MaxConstSize;                 /* maximum allowed bits per tone for downstream channel */
extern int16 gs_HighestAllowedRxTone;
extern int16 gsa_SNRRequired[RX_MAX_BITS_PER_TONE+1]; /* required SNR buffer */
extern int16 gsa_ConstellationSNR[RX_MAX_BITS_PER_TONE+1];  /* SNR required for supporting each constellation size */
/* Sync */
extern uint16 gus_SyncOffset;                   /*  offset in words to beginning of code word */
extern uint16 gus_SyncOffset_Corr_Method;          /*  offset in words to beginning of code word, calculated by max correlation method */
extern int16 gs_SyncOffsetDelta;                /* Original Sync offset delta between gus_SyncOffset and gus_SyncOffset_Corr_Method*/
extern int16 gs_PreSyncOffset;

extern int16 gs_HPFEq_actual;
extern int16 gs_HybA_actual;
extern int16 gs_HybB_actual;

extern uint8 guc_AlignmentPreProcState;
extern uint8 guc_AlignmentTrainingState;
extern uint8 guc_AlignmentPostProcState;
extern uint8 guc_log_idx;
extern FlagT gft_AddNMS;
//=================================================
/* Flags and indicators */
//=================================================

extern FlagT gft_RCExchRARcvFlag;                  /*  flag indicating the status of reception of C_Exch_RA */
extern FlagT gft_RCExch1RcvFlag;                /*  flag indicating the status of reception of C_Exch1 */
extern FlagT gft_RCExch2RcvFlag;                /*  flag indicating the status of reception of C_Exch2  */
extern FlagT gft_RCSegue3RcvFlag;                  /*  flag indicating the status of reception of C_Segue3 */

extern uint8 *gpft_RCExchRcvFlag;
extern uint8 *gpft2_RCExchRcvFlag;

extern FlagT gft_ShowTimeFirstPassTx;              /*  flag to set intial buffer sizes for showtime TX */
extern FlagT gft_ShowTimeFirstPassRx;              /*  flag to set intial buffer sizes for showtime RX */

extern FlagT gft_PilotOnDecTraining;               /*  flag indicating type of RX signal during DEC training */
extern FlagT gft_FlagPilotAccDone;                 /* Flag indicating to tx that pilot accumulation is done, it can start sending dec training sequence */
extern FlagT gft_RS_Support;                    /*  flag to indicate supported Reed-Solomon code length (8 or 16) */
extern FlagT gft_TransferMode;                     /* flag indicating if ATM or STM bit is set in G.994.1 MS message */
extern FlagT gft_C_PILOT1_1A_flag;                 /*  = TRUE, when C-PILOT1 or C-PILOT1A is detected */

extern FlagT gft_TcmFlag;
extern int16 gs_Tx_TCM_Ovhd;
extern int16 gs_Rx_TCM_Ovhd;

extern FlagT gft_TxInFastRetrain_flag;
extern FlagT gft_RxInFastRetrain_flag;

extern FlagT gft_FastSyncAvailable_Flag;    /* Used to indicate whether the Fast Byte  */
/* MAY be used for Synchronization Control */
extern FlagT gft_InlvSyncAvailable_Flag;    /* Used to indicate whether the Sync Byte  */
/* MAY be used for Synchronization Control */
extern FlagT gft_TxFastInputEnabled;           /*  (SWEngine Only) Flag for enabling TX input data reads for fast path */
extern FlagT gft_TxInlvInputEnabled;           /*  (SWEngine Only) Flag for enabling TX input data reads for interleaved path */

extern FlagT gft_FailOnCRCBurst;
extern FlagT gft_FR_trigger_on_CRC;    /*  = TRUE, enables jump to fast retrain on CRC Burst */

/*  Switches that can be turned on (when FALSE) or turned off (when TRUE) */
extern FlagT gft_HpfFlag;                       /*  flag indicating if the high-pass filter should be */
/*  used (TRUE) or not (FALSE) */
//extern FlagT gft_CutBackOn;                      /*  TX PowerCutback Enable Flag FALSE = cut back disabled                  */
extern FlagT gft_FineGainOn;                    /*  flag indicating if US fine gain should be used (TRUE) or not (FALSE)  */
extern FlagT gft_ShowTimeSnrFlag;                  /*  flag indicating if SNR is calculated in showtime */
/*  FALSE - not calculated, TRUE - calculated */
extern FlagT gft_LOSDetectFlag;                         /*  TRUE - LOS detection is enabled during showtime, */
/*  FALSE - LOS detection disabled */
extern FlagT gft_SEFDetectFlag;                         /*  TRUE - SEF detection is enabled during showtime */
/*  FALSE - SEF detection disabled */
//XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
//lcd detection variables
extern int32 gla_NESymbolCountOH[];//used to keep track of near end OH period
extern int32 gla_NESymbolCountOHPeriod[];//used to store near end OH period
extern int8 gca_NEFourOHPeriodLCDInfo[];//used for storing fourconsecutive near end LCD defect info
extern int32 gla_FESymbolCountOH[];//used to keep track of far end OH period
extern int32 gla_FESymbolCountOHPeriod[];//used to store far end OH period
extern int8 gca_FEFourOHPeriodLCDInfo[];//used for storing fourconsecutive afr end LCD defect info
//XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
extern FlagT gft_ShowtimeSnrUpdateFlag; /* if showtime SNR has just been updated, this flag is set to TRUE */
/*  = FALSE, otherwise. */

/* when gft_IFFT_On is TRUE, the IFFT is triggered during the Tx Interrupt */
/* when gft_IFFT_On is FALSE, the IFFT is not triggered during the Tx Interrupt  */

extern FlagT gft_IFFT_On;
extern FlagT gft_TxDataPump_On;                    /* Allows data pump to start independently */



extern FlagT gft_CopyRxBuffer;
extern FlagT gft_RxFdqDoneIntOnly;
extern FlagT gft_DisableGetRxTones;
extern FlagT gft_LoadEngineFFTInput;
extern FlagT gft_GetEngineFFTOutput;
extern FlagT gft_GetEngineFFTOutputDone;

extern FlagT gft_ReorderDEC;  /* when TRUE, reorder DEC coefficients in background */
#ifndef ISDN
// IOP_A_US_T1413_OldIFX_SwitchToTIVID (START_END)
extern FlagT gft_IFTN_T1413LongLoop_TIVID;
#endif
extern FlagT gft_BgDetectMultiTonesResult;

//=================================================
/* End of Flags and indicators */
//=================================================

extern uint8 guca_R_C_Msgs1[R_C_MSGS1_NUM_BYTES];     /*  Received R_C_MSGS1 information */
extern int16 gs_num_preproc_frames;                /*  number of preprocessing frames before showtime starts */

extern Option_t gta_DS_options[NUM_DS_RATE_OPTIONS];  /*  Downstream rate options */
extern Option_t gta_US_options[NUM_US_RATE_OPTIONS];  /*  upstream rate options */
extern int16 gs_DS_RateOption;                     /*  highest rate option for DS */
extern int16 gs_US_RateOption;                     /*  highest rate option for US */

/* Exchange messages*/
extern RMsg2_t gt_RMsg2;

//XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs (Start)
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
extern Report_Hsk_TCMode_t gt_ADSL_TcMode_Reprt;
//XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs (End)
extern FlagT gft_Anx_InformationSet;

/*  other variables */
extern Config_t gt_config_set[NUM_CONFIG_SETS];       /*  configuration structures */
extern Config_t gt_rx_config;                   /*  RX configuration */
extern Config_t gt_tx_config;                   /*  TX configuration */
extern uint16 gus_tx_config_num;                /*  configuration number for TX */
extern uint16 gus_rx_config_num;

// Specfies Bearer Channel to Latency Path Mapping
extern uint8  guca_txBCnToLPp[NUM_US_BEARER_CHANNELS_SUPPORTED];
extern uint8  guca_rxBCnToLPp[NUM_DS_BEARER_CHANNELS_SUPPORTED];

extern uint16 gus_R_CRC;                        /*  CRC to be transmitted  */
extern uint16 gus_RC_CRC_computed;                 /*  CRC computed in RX */
extern uint16 gus_RC_CRC_received;                 /*  CRC received */
extern uint16 gus_RC_bkpCRC_computed;                 /*  CRC computed in RX */
extern uint16 gus_RC_bkpCRC_received;                 /*  CRC received */
extern uint16 gus_RC_meanCRC_computed;                /*  CRC computed in RX */
extern uint16 gus_RC_meanCRC_received;                /*  CRC received */

/*  configuration number for RX */
extern uint16 gus_SyncOffset;                   /*  offset in words to beginning of code word */
extern uint16 gus_SyncOffset_Corr_Method;          /*  offset in words to beginning of code word, calculated by max correlation method */
extern int16 gs_AlignmentOffset;                /* input varible for Alignment functions */
extern int16 gs_CumulativeAlignmentOffset;      /* sum of the medley adjustments */

extern int16 gs_CarSet_FirstTone_For_LineProbe; /* Carrier Set First Tone for LineProbe */
extern int16 gsa_CarSet_During_LineProbe[NUM_LINEPROBE_TONES]; /* Carrier Set during LineProbe */

extern int16 gus_TxSineGain;                    /*  Tx sine gain */
extern int16 gus_TxSineGain_Before_LineProbe;         /*  Tx sine gain before entering R_LINE_PROBE_TX state */
extern int32 gla_HarmonicsPower[NUM_LINEPROBE_CUTBACK_CNT]; /*  Line probe Harmonics' energy */
extern uint16 gus_TxSineGain_InitVal_For_LineProbe;
extern uint16 gusa_TxSineGain_During_LineProbe[NUM_LINEPROBE_CUTBACK_CNT]; /* SineGain during Iterations of LineProbe */
extern int16 gs_UC;                 /*  Absolute Upstream Fast Retrain Power Cutback; 0 in full rate*/
extern int16 gs_RDC;                /*  Relative Downstream Fast Retrain Power Cutback; */
extern int16 gs_DPF;                /*  Fast Retrain Politeness Power Cutback; */
//extern const int16 gusa_txgain[32];                 /*  Tx gain table */
extern int16 gus_TxGain_NoCutBack;
extern int16 gus_TxGain_NoCutBack_3A ;
extern int16 gus_TxGain_NoCutBack_3L ;
extern int16 gus_TxGain_NoCutBack_3M ;
extern int16 gus_TxGain_NoCutBack_5A ;
extern int16 gus_TxGain_NoCutBack_5M ;

extern int16 gus_TxGainCutBackFactor;         /* Tx Gain will be computed on the fly */
extern void gNopFunction(void);
extern int16 gs_CRC_burst_thresh;

/* Frame Counters */
extern int16 gs_MuxFrameCntTxFastPath;
extern int16 gs_MuxFrameCntTxInlvPath;
extern int16 gs_MuxFrameTxDelayCnt;
extern int16 gs_MuxFrameCntRxFastPath;
extern int16 gs_MuxFrameCntRxInlvPath;
extern int16 gs_MuxFrameRxDelayCnt;

extern uint32 gul_TotalRxDataFrameCnt;             // Total number of Rx frames received since start of showtime.
extern uint16 gus_1Sec_RxShowtimeFrameCnt;         // 1 sec timer based on the showtime Rx Frames
extern uint16 gus_1Sec_TxShowtimeFrameCnt;            // XDSLRTFW-2070(Start_End)
extern uint16 gus_4096SymbolCnt;
// XDSLRTFW-575: Counter Write back in ADSL mode (Start)
extern uint16 gus_1Sec_RxTrnFrameCnt;                     // 1 sec timer based on the training Rx Frames
// XDSLRTFW-575: Counter Write back in ADSL mode (End)

/* Showtime counters for background updates*/

extern int16 gus_ShowtimeSNRUpdateCount;           // Indicates number of SNR updates performed since entering showtime
extern int16 gus_ShowtimeFDQUpdateCount;           // Indicates number of FDQ updates performed since entering showtime
extern int16 gus_ShowtimeDECUpdateCount;           // Indicates number of DEC updates performed since entering showtime

/*  G.hs variables */
extern FlagT gft_AnxL_PSD_selected;                               /* set when we changed to anxL PSD */
extern int16 gs_HandShake_Cnt;                     /* record the number of times going through GHS */
extern FlagT gft_EscFromFR_Flag;                /*  flag indicating G.hs is initiated from Fast Retrain */
extern uint8 guc_received_ACK2_count;                   /* counts the number of times ACK2 message is received in response to
                                                        to the transmission of a complete MS or CLR message*/
extern FlagT gft_SyncScalingForGenericCOinDMT;        // Flag used for enabling the Sync scaling for DMT mode
extern FlagT gft_Enable_IFFT64;
extern FlagT gft_USPerf_Gspn; //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
/* Exception handler variables */
extern uint16 gus_ExceptionState;                  /*  state where exception occurs */
extern uint32 gus_ExceptionCode;                /*  exception code indicating the cause of exception */
extern uint8  guc_ErrorCode;                           /* Error Code indication in STAT 5 0 */
extern uint8  guc_SubErrorCode;                        /* SubError Code Indication in STAT 5 0 */
extern uint16 gus_WarningCode;                     /*  an error condition that doesn't cause exception */
extern FlagT  gft_AutoRestartFlag;                 /*  = TRUE: auto restart; = FALSE: do not auto restart */

// Bitload_bis exception
extern uint16 gus_BitloadExceptionCode;

/* AFE & PGA control variables */
extern int32 gl_Pa;                             /*  average received power */
extern int16 gs_PGA_required;                   /*  receommended PGA setting, in dB (Q8.8) */
extern int16 gs_test_PGA_required;                 /*  debug variable to verify that PGA Set has indeed taken effect, in dB (Q8.8) */
extern int16 gs_PGA_margin;                        /*  margin added to PGA cutback to provide  */                                /*  further protection against clipping */                        /*  06/01/26 - Stefan */
extern int16 gs_PGA_margin_AGC1;
extern int16 gs_PGA_margin_AGC2;
extern int16 gs_PGA_set;                        /*  current PGA setting, in dB (Q8.8) */
extern int16 gs_PGA_set_In_HLOG;                //XDSLRTFW_3753 gs_PGA_Set back up for HLOG
extern int16 gs_PGA_before_lineprobe;              /*  PGA value before R_LINE_PROBE_TX state */
extern int16 gs_PGA_Reg_Setting;
extern int16 gs_PGA_margin_delta_AnxL_BTloops;
extern int16 gs_PGA_margin_delta_DMT_VR9;
extern int32 gl_Pa_RxOnly;
extern int16 gs_PGA_required_RxOnly;

#ifdef DANUBE_AFE
extern int16 gs_Force_HPFEq_Setting;
extern int16 gs_Force_HybridReg_Setting;
extern int16 gs_PGA1_Calc;
extern int16 gs_PGA2_Calc;
#endif

extern int16 gs_PGA_margin_Threshold;
extern int32 gl_Ghs_ReferencePower_EchoLoop;
extern int16 gs_PGA_required_In_GHS;                  /* PGA value in GHS after R_C_Tones_RX state */
extern int16 gs_PGA_required_In_RCComb1;
extern int16 gs_PGAStepDown;
extern int16 gs_CumulAnlgGain;
#ifndef AMAZON_AFE   /* If not Infineon Amazon-A AFE IC */
extern int16 gs_PGA_reduction, gs_PwrHybdB, gs_PwrAecdB, gs_PATT_lift_dB, gs_PGA_set_cnt;
#endif   /* End of #ifndef AMAZON_AFE */
extern int16 gs_PGA_InitVal_For_LineProbe;
extern int16 gs_PGA_During_LineProbe; /* PGA during LineProbe */
extern int16 gs_RxAvNoisePSD; // Average noise PSD, average of Qln (in dBmper Hz)
extern int16 gs_LowestMinPCB;    // used to limit DS PCB to > 0 for some dslams.
extern int16 gs_HighestMinPCB;
extern int16 gs_DSPCB_COMB_ALGO;
extern int16 gs_DSPCB_GHsPOW_ALGO;
extern int16 gs_DSPCB_Selected_ALGO;
extern int16 gs_firstSupportedTone; // Tested to determine Cabinet mode applications.
extern int16 gsa_DSPCB_DBG_idx;
extern int16 gsa_DSPCB_DBG_currPCB[20];
extern int16 gsa_DSPCB_DBG_calcPCB[20];
extern int32 gla_DSPCB_DBG_pwr[20];

/* =============================================== */
/* global variables used by Frame Sync */
/* ===============================================    */

extern int16 gs_CXY_Threshold;
extern int16 gs_CXY_Threshold_Rsh;
extern int16 gs_MaxEnergyRsh;

//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
extern int16 gs_lpr_frmcnt;
extern int16 gs_lpr_frmcnt_before_drop_line; //320 symbols = 80 ms
extern int32 gl_TxIbFiFoWriteCnt;
//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)

/* floating point PGA */
extern float gf_Pga;

/* AOC variables */
extern TxAocHandlerStruc_t gt_TxAocHandler;  /* structure of TX AOC handler variables */
extern TxAocHandlerStruc_t *gpt_TxAocHandler;   /* pointer to TxAocHandler data structure */
extern RxAocHandlerStruct_t   gt_RxAocHandler;  /* structure of RX AOC handler variables */
extern RxAocHandlerStruct_t *gpt_RxAocHandler;  /* pointer to RxAocHandler data structure */

extern AocMsgStruc_t gt_TxAocMsgBSR;   /* structure containing TX BSR message */
extern AocMsgStruc_t gt_RxAocMsgBSA;   /* structure containing RX BSA message */
extern AocMsgStruc_t gt_RxMsgUTC;      /* structure containing RX UTC message */
extern AocMsgStruc_t gt_RxMsgPMA;      /* structure containing RX PMA message */
extern AocMsgStruc_t gt_TxMsgPMR;      /* structure containing TX PMR message */

extern MessageFifo_t gt_TxAocFifo;
extern uint16 gus_TxAocBuffer[];

extern int16 gus_RxAocRegister;     /* variable to hold AOC message read from Engine Layer */
extern uint8 guca_AOCRxBuffer[]; /* AOC receiver data buffer */
extern uint8 *gpuc_AOCRxPutPtr;     /* write-pointer to AOC receiver data buffer */
extern uint8 *gpuc_AOCRxGetPtr;     /* read-pointer to AOC receiver data buffer */
extern int16 gs_AOCRxDecoderState;  /* AOC receiver state */
extern int16 gs_AOCRxMsgId;         /* ID of received AOC message */
extern int16 gs_AOCRxMsgLength;     /* Length of received AOC message */
extern int16 gs_AOCRxBlockLength;   /* Length of block of AOC received data being decoded */

extern FlagT gft_SendAocMsg_Flag;   /* flag to indicate status of sending BSR message */
/* IDLE: no message to be sent  */
/* (or previous message has been correctly ack.) */
/* OUTSTANDING: one message to be sent  */
/* SUCCEED: message has been sent (but has not been ack. yet) */
extern uint8 guc_AocTxMaxRetries;   /* maximum number of retries for an aoc message */
extern uint8 guc_aoc_msg_id;

extern FlagT gft_TxBitSwapFlag;     /* TRUE means requesting TX bit swap */
extern FlagT gft_RxBitSwapFlag;     /* TRUE means requesting RX bit swap */
//XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap(start)
extern FlagT gft_BitswapAlgoExcecutionInProgress;
extern FlagT gft_InvalidSNR;
extern int16 *gpsa_TempSnrBuff;
extern FlagT gft_InterimStrdSNRBitswapOn;
//XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap(end)
extern BitSwapInfoStruc_t gt_TxBitSwapInfo;  /* structure for TX bit swap information */
extern BitSwapInfoStruc_t gt_RxBitSwapInfo;  /* structure for TX bit swap information */

extern int16 gs_pre_frame_number;            /* previous frame number */
extern int16 gs_bitswap_tx_sframe_count;     /* bitswap tx super frame count */
extern int32 gl_tx_sframe_count;          /* tx super frame count */
extern int16 gs_tx_sframe_count_lsw;      /* tx super frame count (lower byte)*/
extern int16 gs_tx_sframe_count_msw;      /* tx super frame count (upper byte)*/
extern int32 gl_rx_sframe_count;          /* rx super frame count */
//BugFix_DS_ADSL1_ALL_SuddenRFI (START)
//Applicable for ADSL1 mode only, i.e DMT, T1413
extern uint16 gus_1sec_tx_sframe_count;
//BugFix_DS_ADSL1_ALL_SuddenRFI (END)

extern uint8 guc_next_rx_profile_number;     /* next RX profile number */
extern uint8 guc_remote_max_profiles;        /* maximum no. of profiles supported by  */
/* the remote terminal */
extern int16 gs_bitswap_rx_sframe_count;
extern uint8 guc_num_rx_profiles_stored;     /* number of stored RX profiles */
extern uint8 guc_num_tx_profiles_stored;     /* number of stored TX profiles */

extern int16 *gsa_pre_FDQ_coef;        /*  buffer to save initial FDQ */
extern uint8 *guca_pre_FDQ_exp;

extern int16 *gsa_FDQ_coef_sav;                    /* buffer for saving the original FDQ coef */
extern uint8 *guca_FDQ_exp_sav;                    /* buffer for saving the FDQ exponent */

extern int16 *gsa_FDQ_coef_best;    /* buffer for saving the FDQ coef */
extern uint8 *guca_FDQ_exp_best;

/* =============================================== */
/* global vairables used by FDQAdjust() */
/* ===============================================    */
extern int16 *gsa_FDQ_coef_in;
extern uint8 *guca_FDQ_exp_in;
extern int16 *gsa_FDQ_coef_out;
extern uint8 *guca_FDQ_exp_out;

/* =========================================================================== */
/* global vairables used by BgNoiseAcc() and BgMedleyToReverbAccum() in Medley */
/* =========================================================================== */
extern int32 *gla_NoisePower;
extern int16 *gsa_recv_tones;
extern int16 gs_MedleyOffset;
extern int16 gs_MedleyModulo;
extern int16 *gsa_ref_tones;
extern int16 gs_TrainCnt;
extern int16 gs_log2_TrainCnt;
extern uint8 guc_TxSilence;
extern FlagT gft_NMSTxSilence;



/* =========================================================================== */
/* global variables used by BgDetectMultiTones_Comb() */
/* =========================================================================== */


extern int16 gs_EOC_RateCounter;            /* Number of possible EOC frames that  */
/* may be used for Synchronization Control  */
/* until the minimum EOC rate is not maintained */

extern TxShowTimeStruc_t gt_TxShowTimeVars;
extern RxShowTimeStruc_t gt_RxShowTimeVars;


/* =========================================================================== */
/* global variables for reporting link results to ME */
/* =========================================================================== */

extern int32 gla_DSDataRate[NUM_DATA_PATHS];
extern int32 gla_USDataRate[NUM_DATA_PATHS];

extern int16 gsa_DSLatency[NUM_DATA_PATHS];
extern int16 gsa_USLatency[NUM_DATA_PATHS];

extern int16 gsa_DSInp[NUM_DATA_PATHS];
extern int16 gsa_USInp[NUM_DATA_PATHS];


extern int16 gs_CRCf_burst_count;               /*  CRC error burst count, fast path */
extern int16 gs_CRCi_burst_count;               /*  CRC error burst count, interleaved path */
extern int16 gs_RCRecovBurstCnt;

/*  Reed-Solomon error counters */
extern int16 gsa_CorrectedRSErrors[NUM_DATA_PATHS];            // # of corrected Reed-Solomon errors (not # of corrected codewords) in each latency path since start of showtime.
// XDSLRTFW-575: Counter Write back in ADSL mode (Start)
#ifdef ADSL_62
extern uint32 gula_UncorrectableRSCodewordCnt[NUM_DATA_PATHS]; // # of uncorrectable Reed-Solomon codewords in each latency path since start of showtime.
#else
extern int16 gs_UncorrectableRSCodewordCnt[NUM_DATA_PATHS]; // # of uncorrectable Reed-Solomon codewords in each latency path since start of showtime.
#endif
// XDSLRTFW-575: Counter Write back in ADSL mode (End)

//XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start)
extern uint16 gusa_CRC_count[NUM_DATA_PATHS];            /*  CRC error count in each latency path*/
extern uint16 gusa_good_count[NUM_DATA_PATHS];           /* SF's with no CRC indication */
//XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (End)
extern int16 gsa_RSi_err_count[NUM_RS_CODE];    // RS error count, interleaved path
extern uint32 gula_CorrectedRSErrors[NUM_DATA_PATHS];    // 32bit # of corrected Reed-Solomon errors in each latency path since start of showtime
extern uint32 gula_CRC_count[NUM_DATA_PATHS];         // 32 bit # of crcs.

extern uint32 gula_CRC_count_Prev[NUM_DATA_PATHS];
extern uint32 gula_CorrectedRSErrors_Prev[NUM_DATA_PATHS];
extern uint32 gula_UncorrectableRSCodewordCnt_Prev[NUM_DATA_PATHS];

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
// TODO:Check whether it can be clubbed with "gusa_CRC_count[1]"
extern uint32 gul_CRC_count_ReTx;
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

#ifdef HERCULES_ADSL_CPE
extern int32 gla_g997_CRC_Runningcnt[NUM_DATA_PATHS];
extern int32 gla_g997_FEC_Runningcnt[3*NUM_DATA_PATHS];
extern int32 gla_g997_cell_bit_errs[NUM_DATA_PATHS];
extern int32 gla_g997_FE_CRC_Runningcnt[NUM_DATA_PATHS];
extern int32 gla_g997_FE_FEC_Runningcnt[NUM_DATA_PATHS];
#endif // HERCULES_ADSL_CPE


/*  Array containing number of raw data bytes per symbol excluding synch byte for DS  */
/*  AS0, AS1, AS2, AS3, LS0, LS1, LS2 bearer channels for fast and interleaver path */
/*  for 4 DS rate options */
extern uint16 gusa_DS_ReqBytes[NUM_DS_BEARER_CHANNELS*NUM_DS_RATE_OPTIONS*NUM_DATA_PATHS];

/*  Array containing number of check bytes for fast and interleaver path for 4 DS rate options */
extern uint8 guca_DS_CheckBytes[NUM_DS_RATE_OPTIONS*NUM_DATA_PATHS];

/*  Array containing number of raw data bytes per symbol excluding synch byte for US  */
/*  LS0, LS1, LS2 bearer channels for fast and interleaver path for 4 US rate options */
extern uint16 gusa_US_ReqBytes[NUM_US_BEARER_CHANNELS*NUM_US_RATE_OPTIONS*NUM_DATA_PATHS];

/*  Array containing number of check bytes for fast and interleaver path for 4 US rate options */
extern uint8 guca_US_CheckBytes[NUM_US_RATE_OPTIONS*NUM_DATA_PATHS];


extern int16 gsa_TxToneOrder[TX_NUM_TONES];     /* Tone indices after tone ordering in TX */
extern int16 *gsa_RxToneOrder;               /* Tone indices after tone ordering in RX */

#ifdef USE_ENGINE_FOR_BG_FFTS
//=======================================================
// Flags and parameters for engine-based background FFTs
//=======================================================
extern int16 gs_EngineFFTSize;         // Size of FFT. Either 128 or 256.
extern int16 *gpsa_EngineFFTInput;     // Pointer to time-domain input data.
extern int16 *gpsa_EngineFFTOutput;    // Pointer to Fast FFT output data.
volatile extern FlagT gft_StartEngineFFT;       // Flag asserted by background task to initiate Fast FFT.
volatile extern FlagT gft_EngineFFT_Done;       // Flag to indicate completion of Fast FFT.
extern int16 gs_EngineFFT_Substate;    // Substate indicator for Fast FFT state machine.
#endif

/* =============================================== */
/* QAM related variables                     */
/* =============================================== */

/* Table of Mask bits */
extern uint8  guca_ByteMaskTable[9];

/* packed pn sequence   */

extern uint16 gusa_PN512Tab[64];
extern uint16 *gpusa_MedleySeq;

/* QAM encoder gain table */
extern int16 gsa_QAMEncGainTab[16];

/* QAM decoder constellation gain table */
extern int16 gsa_QAMDecGainTab[16];

/* Combined encoder/decoder gains */

extern int16 gsa_TxCombinedGains[TX_NUM_TONES];

extern int16 *gsa_RxCombinedGains;     /* Combined decoder gain */
//XDSLRTFW-1727
extern uint16 gusa_RxL2CombinGains[];

/* Fast retrain variables */

extern int16 gs_US_Profile, gs_DS_Profile;
extern int16 gsa_rx_profile_ord[NUM_PROFILES];
extern TXProfileStruc_t *gta_TXProfile;
extern RXProfileStruc_t *gta_RXProfile;
extern int16 RXProfile[];

// Tx profiles (G.Lite).
// Required size is: NUM_PROFILES * (size in words of TXProfileStruc_t)
extern int16 TXProfile[];
extern FlagT gft_Quiet_Transit; //Flag indicate whether to transit to true DMT RCQuiet2RxF function or not

extern uint8 guc_lineprobe_cutback;                /*  counts the number of 2dB cutbacks */
extern uint8 guc_lineprobe_iter_cnt;               /*  counts the number of times we measure the energy in the harmonics during line probing */

extern uint8 guca_RMsgFR1Tab[R_MSG_FR1_NUM_BYTES];    /*  transmitted R_MSG_FR1 data */
extern uint8 guca_RMsgFR2Tab[R_MSG_FR2_NUM_BYTES];    /*  transmitted R_MSG_FR2 data */
extern uint8 guca_R_C_Msg_FR1[R_C_MSG_FR1_NUM_BYTES]; /*  received R_C_MSG_FR1 information */
extern uint8 guca_R_C_Msg_FR2[R_C_MSG_FR2_NUM_BYTES]; /*  received R_C_MSG_FR1 information */
extern uint8 guc_ProfileLoadOK;                         /*  can be either FAIL or SUCCEED */
extern uint8 guc_TXProfileLoadOK;                         /*  can be either FAIL or SUCCEED */
extern FlagT gft_FR_Truncate_Flag;

extern FlagT gft_QosMode;

extern int16 gsa_fr_cutback_thresh[32];

/* =========================================================================================*/
/*  debug flags                                                            */
/* =========================================================================================*/

extern FlagT gft_MedleyFlag;
extern FlagT gft_ISIanalysis;
extern FlagT gft_OfflineTdq;

extern int16 gs_tx_ConstSize;
extern int16 gs_rx_ConstSize;
extern int16 gs_Num1BitTones;

/* =========================================================================================*/
/*                                                                   */
/* =========================================================================================*/
extern FlagT gft_ResetDmaPtr;

extern int16 AfeCalibrateFlag;

extern int32 gl_BitloadStart;
extern int32 gl_BitloadEnd;
extern int32 gl_TdqStart;
extern int32 gl_TdqEnd;
extern int32 gl_FdqStart;
extern int32 gl_FdqEnd;
extern int32 gl_DecStart;
extern int32 gl_DecEnd;
extern int32 gl_FrameSyncStart;
extern int32 gl_FrameSyncEnd;
extern int32 gl_AecStart;
extern int32 gl_AecEnd;

extern TxEocHandlerStruct_t gt_TxEocHandler;                                    /* structure of the TX EOC handler variables */
extern TxEocHandlerStruct_t *gpt_TxEocHandler;               /* pointer to this structure */

extern TxEocNetworkStruct_t gt_TxEocNetworkHandler;                           /* structure of the TX EOC Network variables */
extern TxEocNetworkStruct_t *gpt_TxEocNetworkHandler; /* pointer to this structure */

extern RxEocHandlerStruct_t gt_RxEocHandler;                                    /* pointer to gt_RxEocHandler */
extern RxEocHandlerStruct_t *gpt_RxEocHandler;               /* pointer to this structure */

extern TxEocDgaspStruct_t gt_TxEocDgasp;
extern TxEocDgaspStruct_t *gpt_TxEocDgasp;                     /* pointer to gt_TxEocDgasp */

extern FlagT gft_send_crc_corrupt_bits_flag;                            /*  = FALSE, stop sending corrupt crc bits from ATU-R */
/*  = TRUE, start sending corrupt crc bits from ATU-R */
extern FlagT gft_receive_crc_corrupt_bits_flag;                         /*  = FALSE, stop receiving corrupt crc bits from ATU-C */
/*  = TRUE, start receiving corrupt crc bits from ATU-C */
extern FlagT gft_no_sync_flag;

extern uint16 gus_TxEocRegister;

extern MessageFifo_t gt_TxEocFifo;
extern uint16 gus_TxEocBuffer[];

extern TxEocNetworkStruct_t gt_TxEocNetworkInput;                               /* structure of the TX EOC Network variables */
extern TxEocNetworkStruct_t *gpt_TxEocNetworkInput;     /* pointer to this structure */

/* =============================================== */
/* global variable declarations for Rx EOC*/
/* =============================================== */
extern RxEocDecodStruct_t gt_RxEocDecod;                       /* structure containing RX msg decoder variables */
extern RxEocDecodStruct_t *gpt_RxEocDecod;    /* pointer to gt_RxEocDecod */
extern RxEocReadStruct_t gt_EocRxReadBuf;
extern RxEocReadStruct_t *gpt_EocRxReadBuf; /* pointer to gt_EocRxReadBuf */

extern uint16 gus_RxEocRegister;                      /* variable to hold EOC message at SW Engine Layer */

extern MessageFifo_t gt_RxEocFifo;
extern uint16 gus_RxEocBuffer[];
/*  Power management variables */
extern FlagT gft_response_to_powerdown;                        /*  = GRANTED, if GNTPDN is received in response to REQPDN */
/*  = REJECTED, if REJPDN is received in response to REQPDN */
extern FlagT gft_tx_msg_pending;
extern uint16 gus_eoc_register_data;

extern uint32 gul_RxIbInfo;
extern RxIbDataStruct_t    gt_RxIbData;

extern TxIbDataStruct_t    gt_TxIbData;    /* structure containing TX Indicator Bits variables */

// (ADSL2 only)
extern uint8 guca_fe_SystemVendorID[VENDOR_ID_LENGTH];
extern uint8 guca_fe_SystemVersionNum[VERSION_NUM_LENGTH];
extern uint8 guca_fe_SystemSerialNum[SERIAL_NUM_LENGTH];

/* near end, from CPE */
extern uint8 guca_ne_G9941_VendorID[VENDOR_ID_LENGTH];
extern uint8 guca_ne_SystemVendorID[VENDOR_ID_LENGTH];
extern uint8 guca_ne_SystemVersionNum[VERSION_NUM_LENGTH];
extern uint8 guca_ne_SystemSerialNum[SERIAL_NUM_LENGTH];
extern FlagT gft_FlagDiagMode;

// near end and far end T1413 Vendor ID
extern int16 gs_ne_T1413_VendorID;
extern int16 gs_fe_T1413_VendorID;

/* =============================================== */
/* global variable declarations for TDQ  */
/* =============================================== */


extern int16 gsa_pre_tdq_h[TDQ_LENGTH];      /* TDQ filter coefficients' mantissas */
extern int16 gs_pre_tdq_h_exp;               /* TDQ filter coefficients' common exponent */

#ifndef FLOAT_IN_SW
extern float gf_TdqNoiseLevel;      /* noise level added to A matrix */
#else
extern Float32 gf_TdqNoiseLevel; /* noise level added to A matrix */
#endif

extern int16 gs_TDQLen;



/* =============================================== */
/* global variable declarations for Multi TDQ  */
/* =============================================== */

extern int16 gs_MultiTdqFlag;                   /* when 1 enables MultiTdq processing           */
extern int16 *gsa_MultiTdqRxSignal;    /* rotated avg C-REVERB Rx signal following     */
/* frame alignment                           */
extern int16 gsa_MultiTdqTaps[TDQ_LENGTH*MULTI_TDQ_FILTERS];   /* stores Multiple TDQ Filters            */
/* sized based on max TDQ_LENGTH             */
extern int16 gsa_MultiTdqCapacity[MULTI_TDQ_FILTERS+1][POSTSYNCH_SEARCH_OFFSET*2+1];
/* stores capacity for Multiple TDQ Filters        */
extern int16 gsa_MultiTdqExp[MULTI_TDQ_FILTERS];      /* stores Multiple TDQ Filters                  */
extern int16 gsa_MultiTdqPreSyncs[MULTI_TDQ_FILTERS]; /* stores the synch adjustments, relative to the   */
/* MultiTdqRxSignal, to be used in calculating TDQs   */
extern int16 gs_presync_stepsize;

#ifdef AMAZON_AFE
#ifdef TX_NOISESHAPER_RESET
extern int8 gc_afeResetDelayCnt;       // Used to control timing of applying reset to Noise shaper.
#else
extern int16 gs_TxToneForNoiseShaper;  // Tx tone on which to send min energy.
#endif
#endif

/* =============================================== */
/* global variable declarations for AEC  */
/* =============================================== */

extern int16 gs_pre_aec_h_exp;
extern int16 gs_pre_aec_h_delay;
extern int16 gsa_pre_aec_h[AEC_ORDER];

extern int16 gs_aec_h_exp;
extern int16 gs_aec_h_delay;
extern int16 gsa_aec_h[AEC_ORDER];

#ifndef FIXED_POINT_AEC
extern Float32 gfa_aec_h[AEC_ORDER];
#endif /*FIXED_POINT_AEC*/


/* =============================================== */
/* global variable declarations for pilot tone estimation  */
/* =============================================== */

extern int16 gs_PilotPeriod;

extern FlagT gft_ModemType;

/* Rx BERT Buffer Select Flags */
extern uint8 guc_BERT_RX_Select;

/* Zephyr Rx Path Byte Stuffing (g.bis and g.dmt framing mode 0) and Robbing (g.dmt framing mode 0) */
extern uint8 guca_fciRxBSR[NUM_BEARER_CHANNELS];
/* Zephyr Tx Path Byte Stuffing (g.bis, Tp > 1) */
extern uint8 guca_fciTxBS[NUM_BEARER_CHANNELS];

extern int16 gs_DS_MeasurementPeriod_ChanEst;
extern int16 gs_RxLog2AccumLenHLin;
extern int16 gs_RxLog2AccumLenChanEst;

extern FlagT gft_ADSL2_doingHlinEstimate;
extern uint16 gus_RxInterleaveStartupDelay[NUM_DATA_PATHS];


/* Fine gains adjustment to make the CO transmit more power */
extern int16 gs_fgain_adjust ;
extern int16 gs_fgain_adjust_ncload3; // Very long loop threshold.

extern FlagT gft_TcmFlag;

/*ADD COMMENT*/
extern uint16 gus_Tx_Tcm_Num1bits;
extern uint16 gus_Rx_Tcm_Num1bits;
extern FlagT  gft_Tx_Tcm_X0_YGT1;
extern FlagT  gft_Rx_Tcm_X0_YGT1;

extern uint16 gus_Rx_MinToneIndx;
extern uint16 gus_Rx_MaxToneIndx;
extern uint8 guc_NonZeroPart;


/* Number of Tx and Rx 'C' Channel counters */
extern uint8 gus_numTxC_Channel;
extern uint8 gus_numRxC_Channel;

/* FFT Buffer Scenario Transition  */
extern RxScenarioTransition_t gt_RxScenarioTransition;

/* For R_C_Medley -- Moved from Platform to Task Layer */
extern int16 gs_RxFirstPNbit;

/* these variables are used by handshake to indicate which bearer channels are supported, in dmt */
extern uint8 guc_DS_BearerChannels; /* each bit of this variable corresponds to one bearer channel. Set that bit to indicate that bearer channel is supported. */
/* for example, if bearer channels AS0,AS1, LS0 are supported, then we need to set this variable to */
/* (AS0_DN | AS1_DN | LS0_DN) */
extern uint8 guc_US_BearerChannels; /* each bit of this variable corresponds to one bearer channel. Set that bit to indicate that bearer channel is supported. */
/* for example, if bearer channels LS0 and LS1 are supported, then we need to set this variable to */
/* (LS0_UP | LS1_UP) */

/* used for hardware based sequence generation in TxProcessTones */
/* TRUE implies trigger QAM */
extern FlagT gft_QAM_On;
/* used to choose between iridia hardware generated tx sequence */
/* 0 -- R_REVERB, 1 -- R_SEGUE, 2 -- DMT MEDLEY, 3 -- BIS MEDLEY */
extern uint8 guc_sequenceToGenerate;
extern int16 gs_SEF_RefAvMargin; /* Reference margin for SEF detection in Q8.8 format */

extern int16 gs_RSDetect_NumBins;
extern int16 gs_RSDetect_NumBins_L2; //XDSLRTFW-416 : Enhancement_ALL_BisPLus_ALL_L2
extern int16 gsa_RSDetect_Bins[NUM_REVERB_SEGUE_BINS];
extern int16 gsa_RSDetect_PNSeq[];
extern int16 gs_RSDetect_SnrThreshold; /* in dB, Q8.8 format */
extern uint8 guc_IntoL2;

extern int16 gs_RxSyncToneType;

extern int16 gs_AlignForRotation;
extern FlagT gft_ChanRespBeyondNyquist;

extern FlagT gft_disableZephyrTxScrambler;
extern FlagT gft_disableZephyrRxScrambler;
extern FlagT gft_disableAlphaeusTxByteFlip;
extern FlagT gft_disableAlphaeusRxByteFlip;

extern uint16 gusa_TxOverflowCnts[NUM_TX_OVFLOW_CNTRS];
extern uint16 gusa_RxOverflowCnts[NUM_RX_OVFLOW_CNTRS];

extern uint16 gus_IRI_Tx_Ovflw;
extern uint16 gus_IRI_Rx_Ovflw;
extern uint16 gus_STR_Ovflw;

extern uint16 gusa_RCReverb2_RxOverflowCnts[NUM_RX_OVFLOW_CNTRS];
extern uint16 gusa_RCPilot3_RxOverflowCnts[NUM_RX_OVFLOW_CNTRS];
extern uint16 gusa_RCReverb3_RxOverflowCnts[NUM_RX_OVFLOW_CNTRS];
extern uint16 gusa_RCMedley_RxOverflowCnts[NUM_RX_OVFLOW_CNTRS];

extern uint16 gusa_RReverb2_TxOverflowCnts[NUM_TX_OVFLOW_CNTRS];
extern uint16 gusa_REct_TxOverflowCnts[NUM_TX_OVFLOW_CNTRS];
extern uint16 gusa_RMedley_TxOverflowCnts[NUM_TX_OVFLOW_CNTRS];

extern int16 gs_RoundCheckByteLite[17];

extern uint16 gus_RS_Overhead; /* in Q1.15 format */

extern int16 gft_RestoreShowtimeBGState;
extern int16 gft_RxinitSwap;

extern int16 gs_zero_cmv;

extern FlagT gft_SnrOrFdqUpdate;

extern int16 * gsa_unpk_PN512;

// Number of loaded tones in TxBat
extern int16 gs_TxNumLoadedTones;

// DMT specific -- Sync frame gain
extern int16 gs_TxSyncFrameGain;
extern int16 gs_RxSyncFrameGain;

// Make the # of iterations for LMS based AEC training a variable
// from the previously fixed NUM_AEC_LMS_ITERATIONS(=16)
// Enables us to finish the AEC training in RCReverb1 when we use a
// 1024 samples per frame by reducing the # of iterations at run time
// Note: This is a short term fix
extern int16 gs_numAecLMSIterations;

// Specifes the Rx Rate Buffer Size to be used for each latency path
// Constant for Socrates where the Deilv and rate buffers are in two separate memory banks
// Variable for Socrates+ since the Deilv and rate buffers share a single memory bank
extern int16 gsa_RxRateBufferSize[NUM_DATA_PATHS];

// Specifies to which CO this CPE simulation is connected...
extern   int16 gs_COChannel;

#ifdef COLLECT_EOCAOCIB_INFO
extern int16 gs_RxOverheadBufferIndex, gs_InitRxOverheadBufferIndex, gs_RxOverHeadSymbolCount;
extern int16 gs_CollectRxOverheadInfoEnable;
#endif

#ifdef COLLECT_SHOWTIME_EVENTS_INFO
extern int16 gs_RxShowtimeEventsInfoBufferIndex, gs_InitRxShowtimeEventsInfoBufferIndex, gs_RxShowtimeEventsInfoEnable;
extern int16 gs_RxShowtimeEventsError_threshold, gs_RxShowtimeEventsInfo_SyncSymbolThreshold;
#endif

//////////////////////////////////////////////////
// Showtime Processing (moved from synsyml_Data.c)
//////////////////////////////////////////////////
extern FdqAdaptStruc_t gt_FdqAdaptInput;  /*  FDQadapt input structure */
extern uint16 gus_ShowtimeSNRFrameCnt;    /*  RX showtime SNR count */
extern uint16 gus_ShowtimeFDQFrameCnt;    /*  FDQ adapt count */
extern uint8 guc_ShowtimeSnrCalcState;
extern uint8 guc_FdqAdaptationState;

/*  LOS Detection Variables */
extern uint8 guc_LOSDetectState;       /*  LOS detection state */

//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
extern int16 gs_LosDefect_state_cnt;   /*  number sync symbols accumulated */
extern int32 gl_AvgPilotPow;        /*  accumulated LOS detection power */
extern int32 gl_AvgPilotPow_Thresh;
extern uint8 guc_LosDefect_state;
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)


/*  SEF detection variables */
extern uint8 guc_SEFDetectState;       /*  SEF detection state */
extern int16 gs_SEF_sframe_cnt;           /*  number of the 2 last sync symbols that did not correlate */
extern FlagT gft_SEF_currentframe;
extern uint16 gus_SEF_totalcount;
extern int16 gs_sef_event_cnt;

///////////////////////////////////////
// Data Directed (DD) Snr/Fdq Updates
///////////////////////////////////////
// Flag to enable data directed snr and fdq updates. Turns of sync frame based snr/fdq updates
extern FlagT gft_doDDSnrFdqUpdate;
extern int16 gs_DD_rxFDQOutput_Buffer_Select;

// All these buffers are allocated on X-Y memory
// Buffer to save Rx data during data symbol for dd snr/fdq update
extern int16 *gsa_DD_rxQAMOutput;      // Required size = (2*DD_MAX_TONES_PER_SYMBOL) words.
extern int16 *gsa_DD_rxFDQOutput[2];   // Required size = (2*DD_MAX_TONES_PER_SYMBOL) words.

// Bufer to store 1/rx_combined_gains to avoid divide operation
extern int16 *gpsa_DD_1byRxCombinedGains;

// Bufer to store # of right shifts in Gain Scale Operation
extern int16 *gpsa_DD_RxGainScaleShifts;

// Bufer to store Noise Error
extern int16 *gpsa_DD_NoiseError;

// Bufer to enable fast Dual Mac based complex multiplication
extern int16 *gpsa_DD_CmplxMultScratchPadX, *gpsa_DD_CmplxMultScratchPadY;

// Bufer to store fdq error correlation
extern int16 *gpsa_DD_rxFDQErrCorrBuf;

// Handles DD state machine processing
extern uint8 guc_ddProcState;
extern int16 gs_DD_RxFirstChannel, gs_DD_RxLastChannel, gs_DD_RxChannelsPerSymbol;
extern int16 gs_DD_MaxRxChannelsPerSymbol;

// Slew (step size) to change fdq coef in SSLMS algorithm used by DD Fdq adaptation
extern int16 gs_DD_FdqAdaptSlew;

// Counters to keep track of rate of fdq adaptation
extern int16 gs_DD_1SecFdqUpdateCount, gs_DD_min1SecFdqUpdateCount;

// Indicates that data frame is to be discarded during DD processing
extern FlagT gfta_DD_discardCurrDataFrame[2];
extern int32 gl_DD_numDiscardedDataFrames;   // total # of data frames discarded

// Bypass XY-Decode (and XY Check) for DD processing
extern int32   gl_XYDec_DD_rxQAMOutput_Y32,
          gl_XYDec_DD_rxQAMOutput_Y16,
          gl_XYDec_DD_rxFDQOutput_X16,
          gl_XYDec_DD_rxFDQOutput0_X16,
          gl_XYDec_DD_rxFDQOutput1_X16,
          gl_XYDec_DD_1byRxCombinedGains_X32,
          gl_XYDec_DD_RxGainScaleShifts_X16,
          gl_XYDec_DD_NoiseError_Y16,
          gl_XYDec_DD_CmplxMultScratchPadX_X16,
          gl_XYDec_DD_CmplxMultScratchPadY_Y16,
          gl_XYDec_DD_rxFDQErrCorrBuf_X16,
          gl_XYDec_RxShowtimeSnrAccumBuf_X32,
          gl_XYDec_RxToneBuf_X32,
          gl_XYDec_FdqCoef_Y16;

/* Disable DD Processing for the duration of these number of frames to avoid instantaneous Mips peaks */
extern int16 gs_DD_NumFramesProcDisable;
///////////////////////////////////////

// PMD frame count of the symbol in fft/fdq buffer (logical buffer 1).
// This counter goes from 0 to 68 like gs_RxPMDFrameCnt */
// Note: gs_RxPMDFrameCnt is the data symbol currently being processed (ie.e in logical buffer 2, QAM buffer)
extern int16 gs_RxPMDFrameCnt_FftFdqBufferSymbol;

// showtime Timer
extern Timer_t gt_Timer, gt_Saved_CO_Timer;
extern FlagT gft_COSetTimer;

// CPE preferred PSD modes/masks shown in CLR
// -1 indicates corresponding Annex not supported
// Different PSD masks in a supported Annex are numbered from 0, 1, ..., NUM_G992_xx_PSDMASK_SUPPORTED
extern int16   gs_Preferred_PSDMask_G9923x[NUM_G992_3_ANNEX_SUPPORTED];
extern int16   gs_Preferred_PSDMask_G9925x[NUM_G992_5_ANNEX_SUPPORTED];

extern uint32  gul_ModeControl;

extern int16 gs_InitFailCauseFarEnd;
extern int16 gs_InitFailCauseNearEnd;

extern int16 gs_min_pga_setting, gs_max_pga_setting;  /* in Q8.8 format */
extern int16 gs_pgaStepDownValue;                  /* in Q8.8 format */
extern int16 gs_min_pga_setting_RefPCB;

extern FlagT gft_fdqState; //FDQ_DISABLED or FDQ_ENABLED, updated in DisableFDQ() and LoqdFDQ()

/* Used by DetectTone Algorithm for REVERB/C-TREF Detection in presence of strong echo */
extern int32 gl_DetectTone_RevRefPwr;
#ifdef HERCULES_ADSL_CPE
extern FlagT gft_PilotPowerOK;
// AFE HW configuration
extern AFEConfig_t gt_AFEConfig;
extern uint16 gus_la1_ll_lu;
extern uint16 gus_la2_ll_lu;
#endif
extern int16 gs_DetectTone_PwrCalcShifts;

extern int32 gl_PilotTone_PwrThresh;
extern FlagT gft_PilotPowerOK;
extern int16 gs_DetectMicroInterrupt_PhaseErrThresh;

extern int16 gs_FrameBufferSize[2]; //0: Rx; 1:Tx
//XDSLRTFW-2893
extern uint32 gul_fe_G994VendorID;
extern uint8 guc_ClrControl;
extern FlagT gft_GotoFailStateOnTimeOut_FromHandshake;
extern int16 gs_cl_bonding;
extern int16 gs_clr_bonding;

//bitswap trigger variables
extern int16 gs_BITSWAP_TRIGGER_DELTA;
extern int16 gs_Bitswap_Accept_Delta;
extern int16 gs_MinTargetSnrMargin;

extern int16 gs_BitSwapLogIndex;
extern int16 gs_DMT_USBitSwapErrorCode;

// Temp Multi-purpose Array to store RxFineGains
extern int16 *gsa_TempRxFineGains;

/* Variable(s) used for RX-TX frame alignment. */
extern FlagT gft_TxFrameAlignEnable;
extern FlagT gft_RxFrameSynchDoneFlag;

/* Variable(s) used for outband signal insertion for DEC adaptation. */
// XDSLRTFW-3479(Start)
extern FlagT gft_BlockOOBSignal_BecauseOf_OngoingUSOLR;
// XDSLRTFW-3479(End)
extern FlagT gft_TxOutBandSignalEnable;
extern int16 gs_TxOutBandGain;
extern uint16 gus_NumOutBandTones_right;
extern uint16 gus_NumOutBandTones_left;


extern uint8 guc_Iridia_Revision_Number;     // Iridia revision number. = 0x20 corresponds to 3.0 iridia BM
// = 0x21 corresponds to 3.1 iridia BM

extern uint8 guc_Zephyr_Revision_Number;     // Zephyr revision number. = 0x30 corresponds to 3.0 zephyr BM
// = 0x31 corresponds to 3.1 zephyr BM

extern uint8 guc_Strymon_Revision_Number;    // Strymon revision number. = 0x32 corresponds to 3.2 Strymon BM

// IOP_ALL_BISPLus_CNXT_1bitConstellation (Start_End)
extern int16 gs_ChIdx_1bitTo2bit;   // Cnxt TI AR8
extern Params_t gt_NearEndParam; //near end test parameter structure variable
extern Params_t gt_FarEndParam;  //far end test parameter structure variable

extern MeasurementPeriod_t gt_DS_MeasurementPeriod;


extern uint8 guc_5T1_NOISE_THRESHOLD1;
extern uint8 guc_5T1_NOISE_THRESHOLD2;
extern uint8 guc_24HDSL_NOISE_THRESHOLD;
// Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(Start)
extern uint8 guc_24DSL_NOISE_THRESHOLD;
extern uint8 guc_24DSL_NOISE_THRESHOLD1;
// Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(End)
extern uint8 guc_M140WHITE_NOISE_THRESHOLD;

extern uint8 guc_ISDN_DISTURB_NOISE_THRESHOLD;
extern FlagT gft_ISDN_DISTURBER_Noise;
// IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz (Start_End)
extern uint8 guc_M130WHITE_NOISE_THRESHOLD;
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(Start)
extern uint8 guc_M140WHITE_NOISE_THRESHOLDS_shortLoop;
extern uint8 guc_FSNB_NOISE_THRESHOLDS_shortLoop;
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(End)
extern FlagT gft_5T1Noise;
extern FlagT gft_24HDSLNoise;
// Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(Start_End)
extern FlagT gft_M140WhiteNoise;
// IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz (Start_End)
extern FlagT gft_M130WhiteNoise;
extern FlagT gft_FBnoise;
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(Start)
extern FlagT gft_M140WhiteNoise_ShortLoop;
extern FlagT gft_FBnoise_ShortLoop;
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(End)
//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
#ifndef ISDN
extern FlagT gft_Adtran_GMX_DMT;
#endif
//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)
//XDSLRTFW-957 VR9_VRX318_ADSL_FW_PPE_MISMATCH
extern uint16 gus_TcModeUsed_PPE;

//grep for XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg (start)
extern int32 gla_RxPilotSum[2];
extern int16 gs_ClkCount1;
extern uint32 gul_ClkCount2;
extern int16 gsa_RxPilotAvg[2];
extern int16 gs_ClkAvgFact;
extern int16 gs_LogClkAvgFact;
//grep for XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg (end)

#if defined(INFINEON) && defined(ISDN)
extern FlagT gft_LowAvgNoise; // strong noise, if AveragenoisePSD (in dBMper Hz) < -135
#endif

extern int16   gs_Tcm_Oh;

extern int16 gs_PN_US_LEN;
extern int16 gs_PN_US_Step;

extern int16 gs_MpFileControl;

extern RxClearEocBuf_t gt_RxClearEocBuf_CMV;    // Rx Clear EOC

extern ME_HDLC_Params_t gt_ME_HDLC_Params;
extern FineGainInfo_t gt_FineGainInfo;
extern uint8 *guca_Tx_ME_HDLCMsgBuffer;
extern uint8 *guca_Rx_ME_HDLCMsgBuffer;

extern uint8 *guca_rx_hdlc_msg_buffer;
extern uint16 gus_rx_msg_index;
extern HDLCMsgStruct_t gt_TxHDLCMsg;
extern FlagT gft_escape_octet_received;
extern int16 gs_ResidualGain;

/* Variable(s) used during programable hybrid training. */
extern uint8 guc_HybTssiOff;
extern uint8 guc_HybNumHybrids;
extern int16 gs_HybIndex;
extern int16 gs_LoadHybIndex;
extern int16 gs_BgHybIndex;
extern int16 gs_HybridAccumCnt;
extern int16 gs_Log2HybridAccumCnt;
extern int16 gs_BgHybAccumShift;
extern int16 gs_HybMaxMetric;
extern int16 gs_HybMaxIndex;
extern int16 gs_HybSecondBestMetric;
extern int16 gs_HybSecondBestIndex;
extern int16 gs_HybZeroMetric;
extern int16 gs_HpfEqPowerBoost;
extern int32 gl_HybMetricSum;
extern int32 *gpla_BgHybAccumBuf;
extern int32 *gpla_HybRevRefPwr;
extern int16 *gpsa_SignalPSD;
#ifdef AMAZON_AFE
#ifdef HYB_REG_POINTERS
extern uint16 *gpusa_HybridReg0;
#ifdef DANUBE_AFE
extern uint16 *gpusa_HybridReg1;
#endif
extern uint16 *gpusa_HpfEqReg;
#else
extern uint16 gpusa_HybridReg0[];
#ifdef DANUBE_AFE
extern uint16 gpusa_HybridReg1[];
#endif
extern uint16 gpusa_HpfEqReg[];
#endif
extern int16 *gpsa_PGARegTable;
extern int16 *gpsa_PGARequiredTable;
extern FlagT gft_VDSL2OOB_Noise;
#endif

#if defined(INFINEON) && defined(ISDN)

// VDSL2OOB detection
extern int16 gs_SignalPowerVDSL2OOB;
extern int16 gs_Dec6SignalPowerVDSL2OOB;  //Added for debug purpose
extern uint8 guc_PGAmarginForVDSL2OOB;
#endif

extern FlagT gft_SetPGADisable;
extern FlagT gft_AFEBypassMode;

extern FlagT gft_AC_CLK_NotEnabled;

extern int16 gs_NE_LPR_indication; //Near End LPR indication
extern int16 gs_GPIO_PowerOn;    //value of GPIO_DyingGasp_Pin during power-on

extern int16 *gpsa_MedleyUnityTDQSnr;

extern SelfTestResult_t gt_SelfTestResult;  //Hook up with INFO 66

extern int16 gs_dbgMaxPhErrRev, gs_dbgMaxPhErrRevEcho, gs_dbgMaxPhErrMed;
extern int16 gs_dbgChoosePilot, gs_dbgChoosePilotCD;  // Set this to override pilot chosen by below code

extern FuncPtr_t gt_TaskFuncPtr; //Task function pointer structure

extern volatile int32* gl_StackMem;   //memory address of stack top

#ifndef ISDN
extern uint8 guc_AnnexMCarSet_Detect;
#endif

extern int32 gl_ShowTimeEventTrig; // used to by logShowtimeEvent to remember that it has triggered.

extern FlagT gft_extrap;   //Flag to indicate whether we want to do channel estimation extrapolation

/* cyclic prefix insertion control */
extern int32 gl_CyclicPrefixInsertCnt;
extern int16 gs_FRCyclicPrefixInsertCnt;

extern int16 *gpsa_NoiseSeparationSnrAdj;
extern int16 gs_ReverbNoiseMarginReduction;
extern int16 gs_EchoNoiseMargin;
extern int16 gs_ISIMargin;
#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
extern int16 gs_AlcatelReverbReductionAdj;
#endif   /* End of #ifdef AMAZON_AFE */

extern int16 gs_UnityTDQExp;
extern int16 gs_UnityTDQScalingRMS;
extern int16 gs_UnityTDQScalingFD;
extern int16 gs_UnityTDQScalingDCRatio;

extern DerivedFrameProp_t gt_DerivedFrameProperties_DS;
extern DerivedFrameProp_t gt_DerivedFrameProperties_US;

#ifdef DANUBE
//Danube Tx Pseudo Rate Buffer
extern int16 gt_Tx_PseudoRBWRCont[2],gt_Tx_PseudoRBRDCont[2];

#ifdef AMAZON_SE
extern uint8 guc_postL2_fastpll_sframe;
extern FlagT gft_postL2_fastpll;
#endif
#endif

#ifdef HERCULES_ADSL_CPE

// used for ILVB/DILVB FIFO management RAM initialization
extern uint8 guc_ConfigZephyrIlvTxIFMState;
extern uint8 guc_ConfigZephyrIlvRxDFMState;

// # bytes to transfer from RxDTB buffer to DILVB buffer per a given frame
extern int16 gsa_RxDTSize[NUM_DATA_PATHS];
extern int16 gsa_RxDTSize_Memory[NUM_DATA_PATHS];

extern int16 gs_RxBitsInFifo;
extern int16 gs_RxBitsInFifo_numfailures;

extern FlagT gft_L2_Detect;
extern int32 gl_DO_17MHZ;
#endif // HERCULES_ADSL_CPE

#ifdef VINAX_ADSL_AFE
extern int32 gl_DO_17MHZ;
#endif



#ifdef PCM_INTERFACE_SUPPORT
extern MessageOvhdFifo_t gt_PCMInterface[]; //0: TxChannel; 1: RxChannel
extern uint8 guc_PCMState;    /* 0 -- off, 1 -- on, 2 -- start, 3 -- active */
extern int16 gsa_PCMInfo[];      /* hooked up with PCM INFO CMV */
extern uint8 guca_PCMSWFIFO[];
#endif

extern FlagT gft_useRxWin;
extern INFX_CMV gt_INFX_CMV;           //Infx specific cmv

extern int16 gsa_Alt_Co_POTSHPF_1[];

// GPIO
#ifdef TARGET_HW
extern Gpio_t gt_Gpio;
extern uint32 gul_GPIO_Data;  // contains the value of GPIO_DATA register
extern int gl_AdslProgFlashLedCtr;
extern uint16 gus_ProgFlashState;
extern int gl_AdslProgFlashLedCtrMax;
#endif


//AUTO_SRA related
extern FlagT gft_Poll_SRACond;
extern FlagT gft_DownShiftFlag;
extern FlagT gft_UpShiftFlag;
extern FlagT gft_AutoSRA_ErrorCondition;
extern FlagT gft_Auto_SRA_Completed;
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
extern FlagT gft_enable_new_adaptation;
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)
extern uint16 gus_ra_Interval_Timer;

//OLR/PM counters
extern OLRPMCntInfo_t gt_DSOLRPMCnt;
extern OLRPMCntInfo_t gt_USOLRPMCnt;

#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
#ifdef ISDN
extern uint16 gus_AnnexMHybridReg0;
#ifdef DANUBE_AFE
extern uint16 gus_AnnexMHybridReg1;
#endif
#endif
#endif   /* End of #ifdef AMAZON_AFE */

extern uint16 gusa_AnnexBMJInterp1_3[];
extern int16 gs_AnnexBMJPSDMaskIdx;

extern FlagT gft_XtraIfftCutback;



extern FlagT gft_NonLinMgnCorrEnable;
extern int16 gs_NonLinMgnCorr;

#ifdef INFINEON   /* Infineon only feature */
extern int16 gs_PGAatEstLoopLength;

#endif   /* End of #ifdef INFINEON */
extern int16 gs_pga_margin_AnxL_BTLoops; // Extra PGA margin hack required for AnxL bridge tap loops
extern FlagT gft_TrainFdqIfMultiTdqDisabled;

extern FlagT gft_AltInterp1TxLPF;

//Flag to indicate whether or not we should update the SW Rev/Seg Detector tones
extern FlagT gft_ChangeRSBin;
//Pre-computed Rev/Seg Detector tones before reaching showtime or OLR/PM during showtime
extern int16 gsa_PreSel_RSDetectBins[NUM_REVERB_SEGUE_BIN_CHECKS];

extern FlagT gft_Tones1To32SupportCO ;
extern FlagT gft_Tones1To32SupportRT ;
extern int16 gs_C_ACT_flag;
extern int16 gs_DetectCACT_State;
extern int16 gs_DetectCACT_AccumCount;
extern uint8 guc_ibits[4];
#ifdef DANUBE
//Danube (D)ILV Initialization
extern volatile uint8 guc_TxIlvInitState;       /* Danube ILV initialization status flag */
extern volatile uint8 guc_RxDilvInitState;      /* Danube DILV initialization status flag */
#ifdef  AMAZON_SE
extern FlagT  gft_Fixadma;
#endif  //#ifdef  AMAZON_SE
#endif  //#ifdef DANUBE

//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
/*************************************PTM CHANGES*************************************************/
#ifdef DANUBE_PTM_SUPPORT
extern uint8  guc_PtmOctet;
extern uint8 guc_PtmOctet_DS_BC0;
extern uint8 guc_PtmOctet_US_BC0;
extern FlagT gft_ForcePTM;
extern FlagT gft_DisByteFlip;
#endif//if defined DANUBE_PTM_SUPPORT
/*********************************PTM CHANGES*************************************/
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)

#if defined (DANUBE_WB) || defined (VR9_ERASURE)
//Erasure Feature
//extern int16 gs_erasure_set; //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
extern int16 gs_wb_maxscore;
extern FlagT gft_erasure_on;
extern FlagT gft_allow_reset_erasure;


//Erasure metrics to calculate the threshold to discard frames for DD
extern FlagT gft_frame_with_lowmetric, gft_cal_discard_metric_threshold;
extern uint8 guc_metric_discard_threshold;
extern uint16 gus_metric_eval_cnt, gus_metric_eval_period;
extern uint8 guc_max_metric;
extern uint8 guc_min_metric;
extern uint32 gul_num_frame_lowmetric;
extern uint16 gus_lowmetric_discard_cnt, gus_lowmetric_discard_max;
extern uint16 gus_lowmetric_detect_cnt, gus_lowmetric_detect_period;
extern FlagT gft_frame_with_lowmetric;
#endif //#if defined (DANUBE_WB) || defined (VR9_ERASURE)


//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
extern uint8  guc_s_44k_owner;
extern uint16 gus_Zep_Tx_DelayCnt;
extern uint16 gus_LinkDownState_SymCount;
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

extern uint16 gus_nFunctionCalls_InitGlobalVariables; // Number of function call: InitGlobalVariables()

extern uint8 guc_CL_minINP;
extern FlagT gft_CL_Message_Once;
#ifdef HERC_API
extern HercADSL_RateCMV_t               gt_HercADSL_USRateCMV;
extern HercADSL_RateCMV_t               gt_HercADSL_DSRateCMV;

extern Params_t                         gt_HercADSL_NearEndParam;   //near end test parameter structure variable

extern HercADSL_AINFCMV_PCB_t           gt_HercADSL_PCB;
extern HercADSL_AINFCMV_Framing_t       gt_HercADSL_Framing;
//Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
extern HercADSL_TPS_TC_BearerChannel_t  gt_HercADSL_TPS_TC_Params[4];

//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (Start_End)
extern HercADSL_OPTN_MarginControl_t    gt_HercADSL_OPTNMap_MarginControl;
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead
extern HercADSL_OPTN_EocPollControl_t   gt_HercADSL_OPTNMap_EocPollControl;

extern HercADSL_OPTN_ModeControl_t      gt_HercADSL_OPTNMap_ModeControl;
extern HercADSL_OPTN_AlgControl_t       gt_HercADSL_OPTNMap_AlgControl;
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start_end)
extern HercADSL_OPTN_OlrControl_t          gt_HercADSL_OPTNMap_OlrControl;

extern HercADSL_INFO_ChanMeasParams_t   gt_HercADSL_INFOMap_ChanMeasParamsDS;
extern HercADSL_INFO_ChanMeasParams_t   gt_HercADSL_INFOMap_ChanMeasParamsUS;
extern HercADSL_STAT_MacroState_t       gt_HercADSL_STATMap_MacroState;
extern HercADSL_STAT_ModeSelect_t       gt_HercADSL_STATMap_ModeSelect;
extern HercADSL_FailStateInfo_t         gt_FailStateInfo_Prev;
extern HercADSL_g997_LinePerfCount_t   gt_HercADSL_CNTRMap_g997_NE_LinePerfCount; // Failstate structure is in persistent memory
extern HercADSL_g997_LinePerfCount_t   gt_HercADSL_CNTRMap_g997_FE_LinePerfCount;

// XDSLRTFW-575: Counter Write back in ADSL mode (Start)
extern HercADSL_g997_ChPerf_CRCStats_t     gt_HercADSL_CNTRMap_g997_NE_ChPerf_CRCStats;
extern HercADSL_g997_ChPerf_FECStats_t     gt_HercADSL_CNTRMap_g997_NE_ChPerf_FECStats;

extern HercADSL_g997_ChPerf_CRCStats_t     gt_HercADSL_CNTRMap_g997_FE_ChPerf_CRCStats;
extern HercADSL_g997_ChPerf_FECStats_t     gt_HercADSL_CNTRMap_g997_FE_ChPerf_FECStats;
// XDSLRTFW-575: Counter Write back in ADSL mode (End)

//Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (start)
extern HercADSL_g997_NE_FE_PtmPerf_t      gt_HercADSL_CNTRMap_g997_PtmPerf_NE;
//extern HercADSL_g997_NE_FE_PtmPerf_t       gt_HercADSL_CNTRMap_g997_PtmPerf_FE;
//Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (end)

extern HercADSL_g997_DataPathPerfCount_t   gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount;
//XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start_End)

//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start_End)
extern HercADSL_g997_DataPathPerfCount_t   gt_HercADSL_CNTRMap_g997_FE_DataPathPerfCount;

//XDSLRTFW-1481 (Start_End)
extern HercADSL_g997_DataPathFailureStatus_t gt_HercADSL_PLAMMap_g997_DataPathFailureStatus;

// ADSL_BONDING
//------------------
#ifdef ADSL_BONDING
// data structures to provide control and status of
// for GHs bonding negotiation
extern Bonding_DiscAggr_Control_t   gt_Bonding_DiscAggr_Control;
extern Bonding_DiscAggr_Status_t gt_Bonding_DiscAggr_Status;
extern Bonding_Continue_t           gt_Bonding_Continue;
extern uint16   gus_Bonding_PME_ID;     // XDSLRTFW-2382 (Start_End)
extern int16 gs_DsMinDelayDeltaForBonding; // Delta between DS max delay and DS min delay in msec (not used)
extern FlagT gft_EnableBondingExchangeOnly;// flag to enable GHS only exchange for bonding
extern FlagT gft_FE_Not_Bondable;
extern uint8 guc_ID_SPar1;
extern uint8 guc_ID_SPar1_02;

#endif

extern HercADSL_g997_NE_AtmPerf_TxCell_t  gt_g997_AtmPerf_TX_UICELL;
extern HercADSL_MONI_EventConfigure_t   gt_HercADSL_MONIMap_EventConfigure;
extern int16                            gsa_HercADSL_MONIMap_AlarmCnfg[2];
extern uint16                           gusa_HercADSL_MONIMap_Curr[4];
extern uint16                           gusa_HercADSL_MONIMap_Prev[4];
extern int16                            gsa_HercADSL_MONIMap_StateMachineConfig;
//Feature_ALL_ALL_FT_ReInit_Triggers (Start_End)
extern HercADSL_ReInit_Config_t         gsa_HercADSL_MONIMap_ShowFailConditions[2];
extern int16                            gs_AutoMsgHandlerState;
extern int16                            gs_showtime_tc_sync_first_time;

extern int16                            gs_Fw_ImageInfoGet;
extern int16                            gs_En_RxFG_MaptoHerc;
#endif // #ifdef HERC_API

#ifdef IFX_XTC
extern XtcIfConfigInput_t gt_RxXtcIfConfigInput;
extern XtcIfConfigInput_t gt_TxXtcIfConfigInput;
#endif

//Flags
extern int16 gft_indEnable ;
extern FlagT gft_Choose ;
extern int16 jg_pause;

// accumulation interval
extern int16  gs_IndTime16;
extern int16  gs_IndTimeTestSnr ;
extern int16  gs_indTimeRevSnr ;

// metric scales based on accumulation time
extern uint8  guc_indScaleTestSnr ;
extern uint8  guc_indScaleRevFdq ;
extern uint8  guc_indScale1 ;
extern int16  gs_KT ;

//indication tones
extern int16 gs_NumIndTones;
extern int16 gs_chooseStep ;
extern int16 gsa_indTones[8];
extern int16 gsa_RxToneAvg[8];

//counter for dropped frames due to impulse
extern int16 gs_droppedMedley ;
extern int16 gs_droppedMedleyFdq;
extern int16 gs_droppedMedleyTest ;
extern int16 gs_droppedReverbSnr;

// metric threshold related varibales
extern int16 gs_numSymbolsIgnored;
extern int16 gsa_indMax[MAX_IMP_WIDTH+3]  ;
extern int32 gl_indThresh;
extern int32 gl_ind_metric_acc;

extern int16 gs_mode;
extern int16 gs_statesToWait;

extern int16 xLimScale ; // range from .875 to 1.125
extern int16 iWatch ;



extern int32 *pl_XDumpAddr ;
extern int32 *pl_XDumpStart ;
extern int32 *pl_XDumpEnd  ;
extern int16 gs_bis_Adjust_LATN ; //2dB
extern int16 gs_plus_Adjust_LATN ; //1dB


//non-erasure based platform
//below are variables for non-erasure platform
extern int16 gs_pilot_snir_threshold; //Signal to noise plus impulse ratio for pilot tone
extern int16 gs_DD_imp_pwr_allowed; // the noise+impulse threshold for performing data directed snr and fdq
extern uint16 gus_frame_discard_cnt, gus_frame_discard_max ;
extern uint16 gus_frame_detect_cnt, gus_frame_detect_period ;
extern FlagT gft_frame_with_noisypilot;
extern int16 gs_instant_snir;
extern int16 gs_pilot_STsnr_avg;//SMS00838915:DS_PERF_ALL_PllSnrThresshold
// Variable to indicate whether retrain is intentional or not
//XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (Start_End)
extern uint8  guc_Forced_Retrain;
//impulse characterization
extern uint8  guc_impulse_noise_present;
extern FlagT  gft_HighREIN_NOISE;
extern uint8  guc_pwr_accu_shift_bits;
extern uint16  gus_impulse_coarse_detect;
extern int16  gs_power_up_cnt, gs_power_down_cnt;
extern int16  gus_max_imp_symbol, gus_max_noimp_symbol;
extern int32  gl_ave_imp_power;

//SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (Start)
#ifdef ADSL_62

//XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL (Start)
 // Variables Mapped to DSL cmvs
extern uint16 gus_PpeClockControl;  //[DSL_PPE_CLOCK_CONTROL]
extern uint16 gus_PPEClockConfigure;
//XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL (End)

//XDSLRTFW-2442 (Start)
//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [Start]
extern int16 gs_InitFreqOffsetDelta_ppm;
//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [End]
extern int16 gs_lowOscOffset_ppm;
//XDSLRTFW-2442 (End)

extern FlagT gft_Ilv_Buf24k;
extern int32 gl_DS_Intlv_buf_size;
#endif
//SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory(End)

// PERF_DS_PLUS_ALL_GeneralizedPcb (Start)
extern int16 gs_PGAforLoopLengthEstimation;
extern FlagT gft_StrongNoiseForDsPcb;
// PERF_DS_PLUS_ALL_GeneralizedPcb (End)

extern RdyOvfUdf_t  gt_RdyOvfUdfStatus;
extern uint16 gus_HybridType;
extern uint16 gus_LD_Mode;
// XDSLRTFW-1630 (Start_End)
extern uint16 gus_Choosen_LD_Mode;

// XDSLRTFW-201 Feature_US_ALL_ALL_LPR(start_end)
extern uint16 gus_Set_LPR;
//impulse charaterization
extern int16  gs_sliding_idx;
extern int32  gl_accu_pwr_old ;
extern int32  gl_accu_pwr_new ;
extern int32  gl_window_pwr_lb ;
extern int32  gl_window_pwr_ub ;
extern int32  gla_sym_pwr[18]; //Sriram : Moved from bulk_data_ram to dilv2
extern int32  gl_imp_power;
extern int32  l_imp_detect_threshold;
extern int16  s_imp_cnt, s_noimp_cnt;
extern int16  gs_num_impulse,gs_imp_period;


//XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (Start_End)
extern int16 gs_GhsCarSetCfg;    // E.g. A43, B43, J43 etc.

// XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start_End)
extern US_Interleave_Depth_t gt_Optional_US_InlvDepth;
//SMS00966303 SMS00954738 Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep (START)
//SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (Start)
extern FlagT gft_SRAUpShift_process;
extern FlagT gft_SRADnShift_process;
//SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix(End)
//SMS00966303 SMS00954738 Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep (END)
extern int16 gsa_RxPilotToneInCReverb34[];//XDSLRTFW-1633 SMS01261908 SMS001231692 PERF_DS_ADSL1_AB_Ciena_PLL_TRACKING_REVERB3(Start_End)

#ifdef ADSL_62
//==============================================================================
// active/inactive pointers to HW Ping-Pong tables
//==============================================================================


extern uint8 *ghpuca_TxBat_Active; // HW pointer to active TX bit allocation table (BAT)
extern uint8 *ghpuca_RxBat_Active; // HW pointer to active RX bit allocation table (BAT)
extern int16 *ghpsa_TxFineGains_Active; // HW pointer to active TX fine gain table (GST)
extern int16 *ghpsa_RxFineGains_Active; // HW pointer to active RX fine gain table (GST)
extern uint8 *ghpuca_TxExtGains_Active; // HW pointer to active TX extended gain table (EGT)
extern uint8 *ghpuca_RxExtGains_Active; // HW pointer to active RX extended gain table (EGT)
extern int16 *ghpsa_TxToneOrder_Active; // HW pointer to active TX tone ordering table (TRT)
extern int16 *ghpsa_RxToneOrder_Active; // HW pointer to active RX tone ordering table (TRT)

extern uint8 *ghpuca_TxBat_Inactive; // HW pointer to inactive TX bit allocation table (BAT)
extern uint8 *ghpuca_RxBat_Inactive; // HW pointer to inactive RX bit allocation table (BAT)
extern int16 *ghpsa_TxFineGains_Inactive; // HW pointer to inactive TX fine gain table (GST)
extern int16 *ghpsa_RxFineGains_Inactive; // HW pointer to inactive RX fine gain table (GST)
extern uint8 *ghpuca_TxExtGains_Inactive; // HW pointer to inactive TX extended gain table (EGT)
extern uint8 *ghpuca_RxExtGains_Inactive; // HW pointer to inactive RX extended gain table (EGT)
extern int16 *ghpsa_TxToneOrder_Inactive; // HW pointer to inactive TX tone ordering table (TRT)
extern int16 *ghpsa_RxToneOrder_Inactive; // HW pointer to inactive RX tone ordering table (TRT)

extern int16 *ghpsa_SFDQMantissa;
extern uint8 *ghpuca_SFDQExponet;

extern int16 gs_RtvSelect;
extern uint8 guc_num_ports;
extern uint8 guc_ch_id;
extern uint8 guc_PortMode;
extern uint16 gus_segment_size;
extern uint8 guc_TxQtInactiveTblSeg;
extern uint8 guc_QtActiveTblSeg;
extern uint8 guc_RxQtInactiveTblSeg;
extern uint8 guc_RxQtActiveTblSeg;
extern int16 gs_TxIIRFilterSelect;
extern int16 gs_RxIIRFilterSelect;
extern FlagT gft_fw_pilot_fdq;
extern int16 gs_td_fd_pwr_offset;

extern uint32 gul_FD_RNG0Shadow;
extern uint32 gul_FD_RNG0CNTShadow;
extern uint32 gul_RX_MISC_Shadow;


extern FlagT gft_V14;
extern FlagT gft_interpdec_phase_align;
extern FlagT gft_DECAdaptDisable;
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): already declared later
// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start_End)
//extern int32 gl_Rx_QLN_Power;
// XDSLRTFW-576: IOP_DS_BisPlus_ALL_LinkDropADMAError (start_end)
extern FlagT gft_Dec_Init;

#ifdef HW_VECPOW_ACCUM
extern int16  gs_NPR_GuardBits;
extern int32  gl_Pa_VecPow;
#endif //HW_VECPOW_ACCUM

extern FlagT gft_StrymonLpbkMode;   //configure strymon lookback mode
#endif
#ifdef PPE_ENGINE

//PPE configuration variables
extern uint32 gula_DREG_AT_CFG_Cnfg[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CFG_Cnfg[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CELL_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_IDLE_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_AIIDLE_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_BE_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_HEC_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CD_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AT_CELL_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AT_IDLE_CNT_Shadow[NUM_BEARER_CHANNELS];
#endif //#ifdef PPE_ENGINE

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (START - END)
#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)

//Data used for capture the scrambler input and output data
extern int16 gs_TxScamNumBytesPerSym;  //the estimated number of bytes per symbol to going to TX scrambler
extern int16 gs_CapturedTxScamSyms; //the captured TX number of symbols
extern int16 gs_TxCapBufFullness;      //the number of bytes left in TX capture buffer
extern int16 gs_TxPreWRPTR;         //the previous TX FIFO3 write pointer

extern int16 gs_RxScamNumBytesPerSym;  //the estimated number of bytes per symbol to going to RX scrambler
extern int16 gs_CapturedRxScamSyms; //the captured RX number of symbols
extern int16 gs_RxCapBufFullness;      //the number of bytes left in RX capture buffer
extern int16 gs_RxPreWRPTR;         //the previous RX FIFO3 write pointer

extern FlagT gft_TxFifo3Capture;    //TX FIFO3 capture flag: TRUE, FALSE or -1 (indicating the wrap around occurs)
extern FlagT gft_RxFifo3Capture;    //RX FIFO3 capture flag: TRUE, FALSE or -1 (indicating the wrap around occurs)
extern FlagT gft_EnableFifo3Capture;

#ifndef TARGET_HW
extern   uint8 guca_TxFifo3CapBuf[4096];
extern   uint8 guca_RxFifo3CapBuf[4096];
#endif //#ifdef TARGET_COCOMO
#endif //#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)

//#ifdef VR9_HYB_TRAIN_DEBUG
#if 0
/* Sriram : Commented out  for data memory free -up */
extern int16 gs_dbg_count;
extern int16 gs_dbg_type;
extern int16 gs_dbg_hybindex;
#endif
//#endif //VR9_HYB_TRAIN_DEBUG
extern int16 gs_dbg_DecimPoints;
extern int16 gs_force_Decimpoints;
extern int16  gs_HybStartTone;
extern int16  gs_HybEndTone;
//Debug
extern int16 gs_Set_Pause;
//#ifdef VR9_HYB_TRAIN_DEBUG
extern int32 gl_HYbPGATrain_SymCount;
extern int32 gl_HybTrainSigPSD_SymCount;
//#endif //VR9_HYB_TRAIN_DEBUG

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
extern uint8 guc_NLNF_Enable;

//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
extern FlagT gft_NLNF_HybridTraining;

// XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (START_END)
extern int16 gs_NLNF_avg_snr;
#endif
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start)
//SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate (START)
extern LooplengthEst_t gt_LoopLength_ft;
//SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate (END)
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start_end)
extern HybridInfo_t gt_HybridInfo;
extern ApiOptions_t gt_ApiOptions;
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (end)

extern uint16 gus_DSL_FW_InternalControl;

extern Dsl_Operator_Select_t gt_Dsl_Operator_Select; // SDSLRTFW-1792 (Start_End)

//XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (Start_End)
extern InteropOptions_t gt_InteropOptions;

//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start)
extern uint16 gus_Cnfg_Misc;

//XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (Start_End)
extern uint16 gus_DsmCtrlCmv;

extern uint8 guc_temp_vdsl2_mode1;
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(Start_End)
extern uint16 gs_Add_minPCB_NVLT;
extern uint32 gul_T1413_ACT_TimeOUT_Cnt;
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (End)
//Enhance_DM_Optimisation (start)
extern FlagT gft_LinkStartFlag;
// IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (START)
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start)
//FlagT gft_EnableAutoSRA = TRUE;
//FlagT gft_EnableUSSRA  = TRUE;
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (end)
extern FlagT gft_EnableL2Mode;
extern FlagT gft_EnableL3Mode;
// IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (END)
//uint8 guc_temp_vdsl2_mode[3] = {0}; //not used
extern uint8 guc_temp_vdsl2_mode1;
//Enhance_DM_Optimisation (end)

extern FlagT gft_Amd4_L2_Entry;
//XDSLRTFW-1727
extern FlagT gft_FineGainShaping;
extern int16 gs_DeltaPcb;
extern int16 gsa_OffsetSnrBuf[512];
//extern int16 gsa_NewGains[512];
//extern FlagT gft_isL2_LpGtL0_LpBy2_Ena;
extern FlagT gft_pwr_limit;

#if 0
extern int16 gs_pcbDsL2SymAfterAtprCheck_dbg;
extern int16 gs_pcbDsL2SymBefAtprCheck_dbg;
extern int16 gs_RMSGI_L2_Log_dbg;
extern int16 gs_xs_power_cut_dbg;
#endif

extern int16 gs_ATPR_L2;
extern int16 gs_Offset_L2rmsFG_power;
extern int32 gl_Offset_Gi_power_lin;
extern int16 gs_L2ActualDeltaSumLp;
        //extern int16 gs_ATPR_L2;
extern int16 gs_Offset_L2rmsFG_power_prv;
extern int16 gs_gi_power_change_dB;
extern int16 gs_L2ActualDeltaSumLp;
extern int16 gs_gi_power_change_dB_prv;

//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
extern RxToneFlags guca_TimeVaryNoise_Ind_sav;
extern FlagT gft_TonesWithStrongNoise;
extern int16 gs_BITSWAP_TRIGGER;
extern int16 gs_bitswap_evacuation_thrd;
//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start)
//#ifndef ISDN // PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (Start)
//extern int16 gs_RixedRfiNotchFilterCMVControl;
extern int16 gs_NotchFilterEnable;

extern QLNInfo_t *p_QLNInfo;
extern uint32 cordic_ctab[24];
extern int16 gs_activefilterfreq, gs_activefilterfreq2;
extern uint8 guc_numDisturber;
extern int16 gs_EstimatedLoopLength;

extern uint8 guc_numNotchedDisturber;

extern int16 gs_FORCEactivefilterfreq, gs_FORCEactivefilterfreq2;
//Enhance_DS_ADSL1_ANNEXAB_512Tone_QLN (Start_End)
extern int16 gs_active_Power;
extern int32 gl_Rx_QLN_Power;
//Enhance_DS_Bis_plus_DEC_Adapt_SlowDown (start_end)
extern uint8 guc_NoOfNotchFilters;
//ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS (START_END)
extern FlagT gft_CTNW_Shorten_GHS;
extern int16 gs_DSL_AlgControl4; // PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (Start_End)
//#endif // PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (End)
extern uint8 guca_QLN[RX_NUM_TONES];
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)
//extern int16 gs_v1,gs_v2,gs_v3,gs_v4,gs_v5,gs_v6,gs_v7;
//XDSLRTFW-541: Platform_VR9_VRX318 (START)
extern int16 gs_Zep_Tx_DelayCnt;
//XDSLRTFW-541: Platform_VR9_VRX318 (END)

//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
extern ModemFeatureMap_t gt_AdslFeatureMap;
extern ModemFeatureMap_t gt_VdslFeatureMap;
//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)
extern int16 gs_OlrReq;
extern uint16 gs_TX_IMAGE_NYQ;
extern FlagT gft_erasure_hw_on;
//XDSLRTFW-1086 / ADSLRTFW-1611 IOP_DS_ADSL2p_CNXT_RFITest_BitSwap (start_end)
extern FlagT gft_CNXT_RFI_BS; //debugVar
extern FlagT gft_CNXT_ANNEXL_ADSL2;
extern FlagT gft_CNXT_A_LongLoops;
extern FlagT gft_CNXT_ANNEXL_BTLoops;
extern DebugCutBack_t DebugCutBack; // XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN(Start_End)
extern uint16 gus_DacTrimVal;
extern uint32 gl_HybTrSymcnt_end;
extern uint32 gl_HybTrSymcnt_start;
extern uint32 gl_HybTrSymcnt[5];

extern int16 gsa_NMS_Force[512];
//extern int16 gsa_sum_dB_lookup[21];

extern uint8 guca_NMS_dbg[6*1024]; // 2K memory;

extern   int16 *gpsa_RCReverb_Quiet_Snr;
extern   int16 *gpsa_RCReverb_Silence_Snr;
extern   int16 *gpsa_PGA_Snr;
extern   int16 *gpsa_deltaPGA_Snr;
extern   int16 *gpsa_Medley_Vector;
extern   int16 *gpsa_New_NMS_Vector;
extern int16  *gpsa_EchoLog            ; //overlay with gpsa_Medley_Vector
extern int16  *gpsa_NMS_Vector     ; // Pointer to old NMS vector
extern uint8 *gpuca_NMSPilotLog; //pointer to ping/pong buffer of size 2k
extern uint32 guca_bhadra_Rev2_SymLog[20];
extern uint8 guca_bhadra_Rev2_subState[20];
extern int16 gs_brk_dbg;
extern int16 gsa_NMS_Vector[RX_NUM_TONES];
#ifdef DEBUG_STREAMING
extern uint8 guca_DSH_R_PARAMS_debug[2500];
#endif
extern uint32 gsa_RxBitSwap_Before[16];
extern uint32 gsa_RxBitSwap_After[16];
extern uint16 gsa_SNR_update_cnt[16];


extern ReInit_Thresholds_t gt_ReInit_Threshold;
extern FlagT gft_flag_explicitrate;
extern FlagT gft_Flag_limitCause;
extern FlagT gft_ErasureGainForRate;
extern int16 gs_INP_erasure;
extern int16 gs_INP_no_erasure;

// TC switchover
extern uint16 gus_Required_TC_Info;
extern FlagT gft_TC_autonomous_msg;
extern FlagT gft_bonding_TC_autonomous_sent;
extern uint16 gus_ctune_poco_bin;
extern int16 gs_ctune_poco_bin_force;
#ifdef DEBUG_TRACES
// XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
// XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
extern uint16 gusa_DebugBuf[];
extern uint16 gus_PrevMsg_Length;
extern uint16 *gpusa_debugBuff;

extern DebugTrailCollectControl_t gt_debugBufStatus;
extern DebugBufferStatus_t gt_DebugBufferStatus; //Debug buffer status CMV updating
extern DebugBufferControl_t gt_DebugBuffControl;
extern DebugShowTimeBuffSymbol_t gt_DebugBuffSymbol;
extern DebugShowTimeBuffSuperframe_t gt_DebugBuffSuperframe;
extern DebugShowTimeBuffSuperframeReTxEnabled_t gt_DebugBuffSuperframeReTxEnabled;

extern uint32 gul_DMA_Busy_Error;
extern uint16 gus_LenDebugBuff;
extern uint8* gpuca_debugBuff;
extern uint8 guc_StLengthFlag;
extern uint8 guc_ShowtimeEnter;
//XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
// XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
#endif // #ifdef DEBUG_TRACES

extern uint32 gul_Preamble_CMSG1;
//XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85 (Start_End)
extern uint8 guca_SNRBuf_NE[];      //the buffer storing near end SNR per subcarrier (reporting format, as per standard)

// XDSLRTFW-1481 (Start)
extern DsStPilotDescriptorTable_t gt_DS_StPilotDescriptorTable;
// XDSLRTFW-1481 (End)

//XDSLRTFW-1634 (Start)
#ifdef ENABLE_RETX_DS_DEBUG
extern uint16 gus_ReTxDebugBufIdx;
extern uint8  guc_ReTxDebugBufWrEnable;
extern uint8  guca_ReTxDebugBuf[];
#endif
//XDSLRTFW-1634 (End)

//XDSLRTFW-2033 (Start)
extern uint32 gul_PGAResetSec;
extern uint32 gul_ToneDetectSymbCount;
//XDSLRTFW-2033 (End)
extern int16 gs_hsk_power_dB_Comp;
extern int16 gs_hsk_power_dB_VendorComp;
extern int16 gs_PGA_required_In_RCComb1_Comp;
extern uint32 gul_MedleySymbCount;
extern uint32 gul_TotMedpRev4SymbCount;
extern uint32 gul_MedleyToRCRatesSymbCount;
extern FlagT  gft_MedleyCntUpdate;
extern FlagT  gft_HlogMeasurement; //XDSLRTFW_3753 Hlog measurement indication

extern int16 gsa_NMS_ResetPllRefToneInput_Save[2];
extern int16 gs_NMS_AGC1_Gain_Save;
extern int16 gs_PGA_required_Save;

extern uint8 guc_NMS_AlgHandler;
//XDSLRTFW-1983
extern FlagT gft_DisabledVDSL2InCLR;
//XDSLRTFW-3603 (start)
extern uint8 guc_NoTones_Qln;
extern uint8 guc_NoTones_Qln_Force;
extern uint8 guc_NOISE_THRESHOLD_138;
extern uint16 gus_XtalkLowerThan_m138dBmHz;

extern vrx5afe_dsl_config_t gt_vrx5afe_dsl_config;
extern vrx5dfe_dsl_config_t gt_vrx5dfe_dsl_config;


 //XDSLRTFW-3603 (End)

#endif /*  _GDATA_H */
