/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _GHS_H
#define _GHS_H

/**********************************************************************
*
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:        781.276.4000
* FAX:              781.276.4001
* WEB:              http://www.aware.com
*
* FILE:             ghs.h
* DESCRIPTION:      Defines constants, typedefs, and variables used
*                   in handshaking.
*
**********************************************************************/
// ******************************************************************
// ghs.h
//
// History
//
// 05/08/2010 Nihar : Added a constant to indicated Erasure deocoding reporting. Extended the size to
//                      Two Octet for NPar2 Level which is to Incorporate the support for Erasure decoding Trust me bit.
//                      Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 10/08/2010 Nihar: Send IFFT size in NPar3 message for ADSL2/2+ against all COs
//                   Grep for IOP_ALL_BisPlus_ALL_SendIFFTSizeInNPar3
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 26/08/2011 Sriram Shastry : Added Handshake code pointers to support ADSL Bonding.In the CLR-CL message added support for
// PME aggregation discovery, PME aggregation which is cmv controlled. Bonding is support for PTM TPS-TC function type .
// By default this is disabled. This is controlled via CMV DSL 12 0 & CNFG 17 0
//      Grep for XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING
//
// 30/12/2011 Sriram Shastry : Indicate VDSL2 annex bit and the corresponding Full CLR code points in handshake  during Full CLR message
//              Grep for XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg
//
// 23/12/2011 Sabrina Y/Balabath: To improve US performance, retrain and switch to Aware VID
//            for IKNS DSLAMs.
//            Grep for XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE
// 13/03/2012 Kannan: 06/04/2010 Bhadra: Added code for uinversal ReTx(G.inp section A.2.2) as per Amd5 of G.HS.
//                              Code was added under the  CMV info 110 0 (0x100) =>CMV_BIT_INDICATE_RETX
//                    Grep for SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod to see changes.
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 07/06/2012: Vinjam/Sriram: Added "VIRTUAL_NOISE" constant while adding virtual noise
//              support code points to CLR message.
//              Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 07/02/2013 Vinjam: Added support for "CMV CNFG 45" to select "G.Hs Toneset" as per VRx Msg Spec.
//            Grep for XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection
//
// 07/02/2013 Vinjam: Send "Vector" code pointer in "VDSL2 code pointers" in ADSL G.Hs Short CLR Message.
//            Vector feature is enabled using "CMV CNFG 82". If enabled, then set "SPAR2 OCTET2 Bit-3(0x8)" & NPAR3 OCTET1 Bit-0(0x1).
//            Grep for XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs
//
// 13/09/2013 Prashant : Fix for XDSLRTFW-1228 - G.Hs code pointer for upstream vectoring support is not transmitted in ADSL mode.
//                     Grep for XDSLRTFW-1228 Feature_AB_All_All_All_SendUSVectorCodePointerInGHs
//
// 06/02/2015 Vinay : Added CMV DSL 0 Bit#3 (Mask:0x0008) to enable octet 2 of NPar2 of G993.2 in GHs and is enabled by default
//                    Grep for XDSLRTFW-1624
//
// 25/03/2014 Sriram Shastry: Changes done for "SMS01261908:Link drop issue during on-hook/off-hook in G.dmt with Catena/Ciena CNX-5 DSLAMs"
//                                                        Changed the name of the global variable gsa_RxPilotToneInCReverb4 to gsa_RxPilotToneInCReverb34.
//        Grep for XDSLRTFW-1633 ADSLRTFW-1412 IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
//
// 25/03/2014 Hanyu: Ported ADSLRTFW-1392: Marconi MX QDC-1 sends out an undefined G.994.1
//            Vendor ID in CL standard field and "ALCB" only in non-standard
//            field. FW has to link this CO to ALCB and apply a special sync
//            symbol scaling to avoid link drop.
//            Grep for XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4
//
// 10/04/2014 Sriram Shastry: Added G.hs and T1.413 CO vendor IDs for ECI Pulsecom DSLAM at AT&T lab.
//                   Grep for ADSLRTFW-1412 IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
// 12/10/2015 Vinay: Added code to support G.Fast in ADSL G.Hs session.
//            Grep for XDSLRTFW-2298
// 13/1/2017 Shriram Shastry : The CPE could not link up in G.DMT mode with 4.17.18.7 UGW7.1.1 [PPA API driver info: 96.32.7.3.0.0.4]
//          When  FW makes transition from VDSL to ADSL and CO is configued in ADSL1 Mode,
//          FW is 'NOT' communicating the required TC-Mode and  autonomous message to DSL API. Moved the  function call common for  all hndshk mode and T1413
//          Grep for XDSLRTFW-3068
// ******************************************************************

#include "typedef.h"
#include "const_bis.h"

/**********************************************************************
* CONSTANTS
**********************************************************************/
/* ------- indicate which side send MS message ---------- */
#define ATU_R                                   (0)
#define ATU_C                                   (1)

// Size of the GHS msg exchange trail
#define RX_HS_MSGEXCH_TRAIL_SIZE                200
#define MAX_NUM_PREFFERED_MODES         3

/* ---- background functions status constants (for gt_hsc.s_DecodeResult) ---- */
#define HS_DECODE_MSG_INITIAL   (0)
#define HS_DECODE_MSG_START     (1)
#define HS_DECODE_MSG_DONE      (2)

#define HS_MSG_HANDLER_INITIAL  (0)
#define HS_MSG_HANDLER_START    (1)
#define HS_MSG_HANDLER_DONE     (2)

/* ---- Decoding result constants (for gt_hsc.s_DecodeResult) ---- */
#define DECODE_SUCCESS                  (0)
#define INVALID_MESSAGE                 (1)
#define FCS_ERROR                               (2)
#define INCOMPLETE_STANDARD             (3)
#define INCOMPLETE_NON_STANDARD (4)
#define GHS_MESSAGE_OVERFLOW    (5)
#define TSSI_BreakPoint_OVERFLOW (6)

/* ---- selected mode code (for gt_hsc.l_SelectedMode) ---- */
#define NOT_SELECTED                    (0x0000)                                        /*  no mode selected yet */
#define NO_COMMON_MODE                  (0x0100)                                        /*  no common mode selected */
#define SILENCE                                 (0x0200)                                        /*  silence mode (silence for about 1min) */
#define RESTART_HS                              (0x0400)                                        /*  restart a handshake session (due to either timeout or errored frame) */
#define RESTART_VIA_CLEARDOWN   (0X0800)                                        /*  restart a handshake vis cleardown (mostly due to NAK-CD) */
#define ESC_TO_FR                               (0x1000)                                        /*  escape to fast retrain */
#define FULL_INIT                               (0x2000)                                        /*  normal exit to tranceiver training (full initialization) */
#define HS_CHECK_2ND_32BITS     (0x4000)                    /*  Indicating check the second 32 bits variable for selected mode*/
#define RESTART_HS_FarEnd       (0X8000)

#define G992_2_AB_ESC_TO_FR             (ESC_TO_FR | G992_2_AB)
#define G992_2_AB_FULL_INIT             (FULL_INIT | G992_2_AB)
#define G992_3_A_FULL_INIT              (FULL_INIT | G992_3_A)
#define G992_3_B_FULL_INIT              (FULL_INIT | G992_3_B)
#define G992_3_L_FULL_INIT      (G992_3_A_FULL_INIT | G992_3_L) /* G992_3_L is a subset of G992_3_A */

#define G992_2_C_ESC_TO_FR              (ESC_TO_FR | G992_2_C)
#define G992_2_C_FULL_INIT              (FULL_INIT | G992_2_C)

/* ---- start-up message code (for gt_hsc.s_InitialMsg) ---- */
#define START_WITH_CLR                  (1)
#define START_WITH_MS                   (2)
#define START_WITH_MR                   (3)
#define START_WITH_MP                   (4)

/* ---- host command constants ----  */
#define NO_COMMAND                              (0)                                     /*  no host command */
#define START_GHS                               (1)                                     /*  host command to start G.hs */
#define START_FAST_RETRAIN              (2)                                     /*  host command to start Fast Retrain */

#define LSB_MASK                                (0x01)                                  /*  mask to extract only the lab of an octet */
#define MODULO_BY_8_MASK                (0x07)                                  /*  mask to take modulo by 8 ( 3 LSBs ) */
#define MODULO_BY_64_MASK               (0x3F)                                  /*  mask to take modulo by 64 ( 5 LSBs ) */

#define NUM_UNIQUE_DS_GHS_CARRIERS_SETS (4)                             /*  Number of unique DS GHS carrier sets currently supported by firmware */
#define DS_GHS_CARRIER_SET_A43                  (0)
#define DS_GHS_CARRIER_SET_B43_J43              (1)
#define DS_GHS_CARRIER_SET_C43                  (2)
#define DS_GHS_CARRIER_SET_A43c                 (3)
#define GHSCARRIERSET_LOG2_NUM_ACCUM_SYMBOLS    (8)

// XDSLRTFW-3511(Start) C-Comb based loop length estimation with considering PCB for ISDN
#define NO_CToneDetected           -1
#define A43_CTonesDetected          0
#define B43_CTonesDetected          1
#define A43C_B43C_CTonesDetected    2
// XDSLRTFW-3511 (End)

//XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (Start)
//Masks added for CNFG 45
#define US_GHS_CARRIER_SET_A43  (0x0001)
#define US_GHS_CARRIER_SET_A43C (0x0002)
#define US_GHS_CARRIER_SET_B43  (0x0004)
#define US_GHS_CARRIER_SET_B43C (0x0008)
#define US_GHS_CARRIER_SET_C43  (0x0010)
#define US_GHS_CARRIER_SET_J43  (0x0020)
#define US_GHS_CARRIER_SET_V43  (0x0040)
#define US_GHS_CARRIER_SET_V43P (0x0080)
#define US_GHS_CARRIER_SET_V43I (0x0100)
#define US_GHS_CARRIER_SET_B43_B43C_J43 (US_GHS_CARRIER_SET_B43 | US_GHS_CARRIER_SET_B43C | US_GHS_CARRIER_SET_V43)
//XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (End)

#define NUM_CARRIERS_IN_SET     (3)                                             /*  Number of subcarriers in the A43 carrier set in the */
/*  4.3125 kHz signalling family. */
/*  Note that it is 3 except for C43, for which it is 2. */
/*  Leave it as 3 for now since only C43 is not implemented. */
#define NUM_CARRIERS_REQUIRED   (2)                                             /*  Number of subcarriers in 4.3125kHz signalling family */
/*  that must be detected by the receiver in order for */
/*  the tones to be considered present. */
/*  Should be 0<=NUM_CARRIERS_REQUIRED<=NUM_CARRIERS_IN_SET. */
#define RX_SYMBOL_BUF_SIZE      (8)                                             /*  DMT symbol memory size (used for a circular buffer for moving average) */

#define NUM_PREFIX_FLAG         (3)                                             /*  Number of mandatory FLAGs at the head of a message */
#define NUM_POSTFIX_FLAG        (2)                                             /*  Number of mandatory FLAGs at the tail of a message */

#define NUM_CLEARDOWN_GALF      (4)                                             /*  Number of GALFs needed when exiting G.hs session */
#define NUM_CLEARDOWN_FLAG      (20)                                            /* Number of FLAGs transmitted after GALF characters are received before silencing */
/*  (20 octets = 64 DMT symbols = 29.7 ms < 500ms ) */

#define TX_NEG165DBM            (ENCGAIN2)                              /*  Power level/carrier of -1.65dBm for two-bit constellation */
#define HALF_DETECT_BAND        (4)                                             /*  The presence of a tone is checked over the range of */
/*  [ desired tone - HALF_DETECT_BAND, desired tone + HALF_DETECT_BAND ] */

#define MIN_MESSAGE_LEN         (4)                                             /*  minimum number of information octets in a message (see 10.4) */
#define MAX_MESSAGE_LEN         (64)                                            /*  maximum number of information octets in a message (see 10.4) */
#define MAX_COMPLETE_MESSAGE_LEN   (256)                                        /*  max number of the complete message */
#define MAX_COMPLETE_CLR_MESSAGE_LEN    384

#define MAX_NUM_NS_BLOCK        (5)                                                     /*  maximum number of Non-Standard Blocks: Vendor Specific */
#define MAX_NS_VENDOR_INFO_LEN  (MAX_COMPLETE_MESSAGE_LEN - 7)          /*  max length of Non-Standard vendor specific information */
#define MESSAGE_BUF_LEN         (2*MAX_COMPLETE_MESSAGE_LEN)/*  length of gpuca_RxMsgBuf and gpuca_TxMsgBuf */
/*  It is double the size of maximum message length to  */
/*  account for possible octet transparency octets. */
#define DECODE_BUF_LEN          (4*MAX_COMPLETE_MESSAGE_LEN)/*  length of gpuca_MsgDecodeBuf.  */
/*  Caution: DECODE_BUF_LEN must be set long enough to hold the longest message including */
/*  all non-standard information fields that the HSTU wants to decode, i.e. */
/*  (total length of standard info + total length of nonstandard info + FCS_LEN). */
/*  For G.994.1 revision 1, the maximum standard message length is 81 octets when all */
/*  the standard info in table 5 - 78 is used. */
#define MAX_REQ_RTX_NUMBER      (3)                                                     /*  Limit of REQ_RTX msg number */

#define SYMBOLS_PER_BIT         (8)                                                     /*  Number of DMT symbols in a bit, 8 for G.994.1 Rev. 1 */
#define LOG2_SYMBOLS_PER_BIT    (3)
#define SYMBOLS_PER_OCTET       (64)                                            /*  Number of DMT symbols in an octet, naturally, 64 */
#define LOG2_SYMBOLS_PER_OCTET  (6)

#define TIME_16MS               (69)                                            /*  number of DMT symbols per 16ms */
#define SILENCE_BURST_CNT       (10)                                            /*  number of consecutive silent symbols to detect silence */
#define R_C_TONES_BURST_CNT     (32)                                            /*  minimum length of C_Tones to be detected (50ms) */
#define R_C_TONES_DETECTION_FAILURE_CNT     (4)
#define MAX_NUM_REPEAT_MS_MSG   (3)                         /* Maximum number of times an MS message is repeated on reception of ACK2 */
#define MAX_NUM_REPEAT_CLR_MSG  (3)                         /* Maximum number of times a CLR message is repeated on reception of ACK2 */

#define HS_TONE_TIMEOUT         (TIME_500MS*2)                          /*  timeout (tau_1 = 500ms) + some margin (500ms) */
#define HS_MSG_TIMEOUT          (TIME_500MS*8)                          /*  timeout for messages = 4sec */
#define REQUESTED_SILENCE       (258750L)                                       /*  length of the silence period requested by an MS message */

#define GALF                                    (0x81)                                          /*  GALF character */
#define FLAG                                    (0x7E)                                          /*  FLAG character */

#define FCS_LEN                                 (2)                                                     /*  length of FCS octets */
#define FCS_GEN_POLY                    (0x8408)                                        /*  generator polynomial for an FCS */
#define MAGIC_FCS_CHECK                 (0xF0B8)                                        /*  Magic number for FCS check */

#define DELIMIT_1                               ((uint8) 0x80)                          /*  delimitting bit of level 1 parameters */
#define DELIMIT_2                               ((uint8) 0x40)                          /*  delimitting bit of level 2 parameters */
#define NEG_DELIMIT_1                   ((uint8) ~DELIMIT_1)
#define NEG_DELIMIT_2                   ((uint8) ~(DELIMIT_1 | DELIMIT_2))

/* ==== Message type (see Table 3) ==== */
#define GHS_MAX_HS_MSG_TYPES    (0x40)

#define M_MS                                    (0x00)
#define M_MR                                    (0x01)
#define M_CL                                    (0x02)
#define M_CLR                                   (0x03)
#define M_MP                                    (0x04) //new msg type defined in Revision2
#define M_ACK1                                  (0x10)
#define M_ACK2                                  (0x11)
#define M_NAK_EF                                (0x20)
#define M_NAK_NR                                (0x21)
#define M_NAK_NS                                (0x22)
#define M_NAK_CD                                (0x23)
#define M_REQ_MS                                (0x34)
#define M_REQ_MR                                (0x35)
#define M_REQ_CLR                               (0x37)
#define M_REQ_RTX               (0x38) //new msg type defined in Revision3

/* ----  g.hs message exchange states CPE ---- */
#define R_HS_INITIAL                    (100)
#define R_HS_SEND_MR                    (101)
#define R_HS_SEND_MS                    (102)
#define R_HS_SEND_CLR                   (103)
#define R_HS_MS_OK                              (104)
#define R_HS_CL_OK                              (105)
#define R_HS_PARTIAL_MS         (106)
#define R_HS_PARTIAL_CL         (107)
#define R_HS_NOT_READY          (108)
#define R_HS_NOT_SUPPORTED      (109)
#define R_HS_NOT_UNDERSTOOD     (110)
#define R_HS_RESTART            (111)
#define R_HS_EXIT               (112)
#define R_HS_SEND_MP                    (113)  // new state in Revision 2
#define R_HS_RETRANSMIT                 (114)  // new state in Revision 3

/* ----  Annexs' Supported in each modes ---- */
#ifdef ISDN

/* G992.3: B/J */
#define NUM_G992_3_ANNEX_SUPPORTED      3
#define G992_3_ANNEX_B  0
#define G992_3_ANNEX_J  1
#define G992_3_ANNEX_M  2

/* G992.5: B/J */
#define NUM_G992_5_ANNEX_SUPPORTED      3

#define G992_5_ANNEX_B  0
#define G992_5_ANNEX_J  1
#define G992_5_ANNEX_M  2

#else//ISDN

/* G992.3: A/M/I */
#define NUM_G992_3_ANNEX_SUPPORTED      3

#define G992_3_ANNEX_A  0
#define G992_3_ANNEX_I  1
#define G992_3_ANNEX_M  2

/* G992.5: A/M/I */
#define NUM_G992_5_ANNEX_SUPPORTED      3

#define G992_5_ANNEX_A  0
#define G992_5_ANNEX_I  1
#define G992_5_ANNEX_M  2

#endif//ISDN


/* ----  Submodes, PSD Masks Supported in each modes ---- */
//annex-A
#define NUM_G992_3A_PSDMASK_SUPPORTED   3
#define DEFAULT_G992_3A_PSDMASK                 0
#define REACHEXT_G992_3L_USPSDMASK1             1
#define REACHEXT_G992_3L_USPSDMASK2             2
#define NUM_G992_5A_PSDMASK_SUPPORTED   1
#define DEFAULT_G992_5A_PSDMASK                 0

//annex-B
#define NUM_G992_3B_PSDMASK_SUPPORTED   1
#define DEFAULT_G992_3B_PSDMASK                 0
#define NUM_G992_5B_PSDMASK_SUPPORTED   1
#define DEFAULT_G992_5B_PSDMASK                 0

#define NUM_PSDMASK_SUPPORTED                   9
//Note the following constants are index to address the table.
#define EU32_PSDMASK                    0
#define EU36_PSDMASK                    1
#define EU40_PSDMASK                    2
#define EU44_PSDMASK                    3
#define EU48_PSDMASK                    4
#define EU52_PSDMASK                    5
#define EU56_PSDMASK                    6
#define EU60_PSDMASK                    7
#define EU64_PSDMASK                    8

//annex-M
#define NUM_ANNEX_M_PSDMASK_SUPPORTED   NUM_PSDMASK_SUPPORTED
//Note the following constants are index to address the table.
#define EU32_ANNEX_M_PSDMASK                    EU32_PSDMASK
#define EU36_ANNEX_M_PSDMASK                    EU36_PSDMASK
#define EU40_ANNEX_M_PSDMASK                    EU40_PSDMASK
#define EU44_ANNEX_M_PSDMASK                    EU44_PSDMASK
#define EU48_ANNEX_M_PSDMASK                    EU48_PSDMASK
#define EU52_ANNEX_M_PSDMASK                    EU52_PSDMASK
#define EU56_ANNEX_M_PSDMASK                    EU56_PSDMASK
#define EU60_ANNEX_M_PSDMASK                    EU60_PSDMASK
#define EU64_ANNEX_M_PSDMASK                    EU64_PSDMASK
#define DEFAULT_G992_5M_PSDMASK                 EU64_ANNEX_M_PSDMASK
#define DEFAULT_G992_3M_PSDMASK                 EU64_ANNEX_M_PSDMASK

//annex-J
#define NUM_ANNEX_J_PSDMASK_SUPPORTED   NUM_PSDMASK_SUPPORTED
#define EU32_ANNEX_J_PSDMASK                    EU32_PSDMASK
#define EU36_ANNEX_J_PSDMASK                    EU36_PSDMASK
#define EU40_ANNEX_J_PSDMASK                    EU40_PSDMASK
#define EU44_ANNEX_J_PSDMASK                    EU44_PSDMASK
#define EU48_ANNEX_J_PSDMASK                    EU48_PSDMASK
#define EU52_ANNEX_J_PSDMASK                    EU52_PSDMASK
#define EU56_ANNEX_J_PSDMASK                    EU56_PSDMASK
#define EU60_ANNEX_J_PSDMASK                    EU60_PSDMASK
#define EU64_ANNEX_J_PSDMASK                    EU64_PSDMASK
#define DEFAULT_G992_5J_PSDMASK                 EU64_ANNEX_J_PSDMASK
#define DEFAULT_G992_3J_PSDMASK                 EU64_ANNEX_J_PSDMASK

//annex-I
#define NUM_ANNEX_I_PSDMASK_SUPPORTED   1
#define DEFAULT_G992_5I_PSDMASK                 0
#define DEFAULT_G992_3I_PSDMASK                 0

/* ==== constants for message parameters ==== */

#define REVISION                                (3)                                     /*  revision number of G.hs */
/* ---- Identification field Vendor ID ---- */
#define G9941_COUNTRY_CODE_BYTE0                        (0xB5)                  //  T.35 country code (2 octets)
#define G9941_COUNTRY_CODE_BYTE1                        (0x00)          //  The 2nd octet is only used if the first octet holds the
// escape code '0xff'.

#define G9941_PROVIDER_CODE_BYTE0                       (0x41)                  // 'A'
#define G9941_PROVIDER_CODE_BYTE1                       (0x57)                  // 'W'
#define G9941_PROVIDER_CODE_BYTE2                       (0x52)                  // 'R'
#define G9941_PROVIDER_CODE_BYTE3                       (0x45)                  // 'E'

#define G9941_VENDOR_INFO_BYTE0                         (0x00)                  //
#define G9941_VENDOR_INFO_BYTE1                         (0x06)                  //

/* ----  Identification field NPar1 ---- */
#define NON_STANDARD                    (0x40)                                  /*  non-standard field */
#define NUM_ID_SPAR1_OCTETS     (4)
/* ---- Identification field SPar1, octet 1 ---- */
#define NDR_UP                                  (0x01)                                  /*  net data rate upstream */
#define NDR_DN                                  (0x02)                                  /*  net data rate downstream */
#define DFC_UP                                  (0x04)                                  /*  data flow characteristics upstream */
#define DFC_DN                                  (0x08)                                  /*  data flow characteristics downstream */
#define R_SPLITTER                              (0x10)                                  /*  xTU-R splitter information */
#define C_SPLITTER                              (0x20)                                  /*  xTU-C splitter information */

/* ---- Identification field SPar1, octet 2 ---- */
#define RELATIVE_POWER_LEVEL_UP_A43     (0x01)                                  /* relative power level/carrier for upstream carrier set A43 */
#define RELATIVE_POWER_LEVEL_DN_A43     (0x02)                                  /* relative power level/carrier for downstream carrier set A43 */
#define RELATIVE_POWER_LEVEL_UP_B43     (0x04)                                  /* relative power level/carrier for upstream carrier set B43 */
#define RELATIVE_POWER_LEVEL_DN_B43     (0x08)                                  /* relative power level/carrier for downstream carrier set B43 */
#define RELATIVE_POWER_LEVEL_UP_C43     (0x10)                                  /* relative power level/carrier for upstream carrier set C43 */
#define RELATIVE_POWER_LEVEL_DN_C43     (0x20)                                  /* relative power level/carrier for downstream carrier set C43 */
#define RELATIVE_POWER_LEVEL_RESERVED   (0x40)

/* ---- Identification field SPar1, octet 3 ---- */
#define RELATIVE_POWER_LEVEL_UP_A4     (0x01)                           /* relative power level/carrier for upstream carrier set A4 */
#define RELATIVE_POWER_LEVEL_DN_A4     (0x02)                           /* relative power level/carrier for downstream carrier set A4 */
#define RELATIVE_POWER_LEVEL_UP_A43c   (0x04)                           /* relative power level/carrier for upstream carrier set A43c */
#define RELATIVE_POWER_LEVEL_DN_A43c   (0x08)                           /* relative power level/carrier for downstream carrier set A43c */
#define BONDING                                          (0x10)                         /* Bonding */
#define RELATIVE_POWER_LEVEL_UP_J43    (0x20)                           /* relative power level/carrier for upstream carrier set J43 */
#define RELATIVE_POWER_LEVEL_DN_J43    (0x40)                           /* relative power level/carrier for downstream carrier set J43 */

#define RELATIVE_POWER_LEVEL_UP_B43c   (0x01)                           /* relative power level/carrier for upstream carrier set A4 */
#define RELATIVE_POWER_LEVEL_DN_B43c   (0x02)                           /* relative power level/carrier for downstream carrier set A4 */

/* ---- Identification field NPar2 Octets 7 through 10 ---- */
#define LATENCY_BITS                    ((uint8) 0x1F)                          /*  mask for bits 5 to 1, which contain latency information */
#define LARGE_LATENCY                   ((uint8) 0x20)                          /*  bit that indicates whether latency is given by the */
/*  formula [(4 + LATENCY_BITS) x 10 ms] or the formula */
/*  [LATENCY_BITS x 1 ms] */

#define NDR_BITS            ((uint8) 0x1F)                  /*  mask for bits 5 to 1, which contain net data rate information */
#define LARGE_NDR           ((uint8) 0x20)                  /*  bit that indicates whether net data rate is given by the */
/*  formula [NDR_BITS x 2Mbps] or the formula */
/*  [NDR_BITS x 64kbps] */

/* ---- Identification field NPar2 Octet 11 ---- */
#define LPF_VOICE                               (0x01)                                  /*  LPF is voice */
#define LPF_UISDN                               (0x02)                                  /*  LPF is USA ISDN */
#define LPF_EISDN                               (0x04)                                  /*  LPF is European ISDN */
#define LPF_NS                                  (0x20)                                  /*  non-standard LPF */

/* ---- Identification field NPar2 Octet 12 ---- */
#define HPF_VOICE                               (0x01)                                  /*  HPF is voice */
#define HPF_UISDN                               (0x02)                                  /*  HPF is USA ISDN */
#define HPF_EISDN                               (0x04)                                  /*  HPF is European ISDN */
#define HPF_VDSL                                (0x08)                                  /*  HPF is VDSL */
#define HPF_NS                                  (0x20)                                  /*  non-standard HPF */
/* Table 11.30.0.2 Standard information field G.992.3 Annexes A/L SPar(2) coding */
/* XDSLRTFW-3068 */
#define STM_TC_MODE        (0x08)
#define ATM_TC_MODE        (0x10)
#define PTM_TC_MODE        (0x20)
/* XDSLRTFW-3068 */

//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start)
#ifdef ADSL_BONDING
//---- Bonding NPar2/Spar2 level ----
//---- NPar2 ----
#define BONDING_ETHERNET   (0x01)
#define BONDING_TDIM       (0x02)
#define BONDING_ATM        (0x04)
#define BONDING_BACP       (0x08)

//---- SPar2 ----
#define BONDING_PME_DISCOVERY       (0x01)
#define BONDING_PME_AGGREGATION     (0x02)
#define BONDING_PME_IDENTIFICATION  (0x04)

#define BONDING_PME_READY               (0x1)
#define BONDING_PME_SET                 (0x0)
#define BONDING_PME_CLEAR               (0x3)
#define BONDING_PME_GET                 (0x2)
#define BONDING_PME_MASK                (0x3)
#endif
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (End)
/* ---- standard info NPar1 ---- */
#define VB_V8                                   (0x01)                                  /*  voiceband V.8 */
#define VB_V8BIS                                (0x02)                                  /*  voiceband V.8bis */
#define SILENT_PERIOD                   (0x04)                                  /*  silent period request */

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START_END)
#define VIRTUAL_NOISE                   (0x10)                                          /*Virtual Noise request */

#define G997_1                  (0x08)                      /* G.997.1 */

/* ---- standard info SPar1 ---- */
#define NUM_SI_SPAR1_OCTETS     (5)

/* SI Spar1 octet 1 */
#define G992_1_A                                (0x01)                                  /*  G.992.1 Annex A */
#define G992_1_B                                (0x02)                                          /* ISDN */ /*  G.992.1 Annex B */
#define G992_1_C                                (0x04)                                  /*  G.992.1 Annex C */
#define G992_2_AB                               (0x08)                                  /*  G.992.2 Annex A/B */
#define G992_2_C                                (0x10)                                  /*  G.992.2 Annex C */
#define G992_1_H                                (0x20)                                  /*  G.992.1 Annex H */

/* SI Spar1 octet 2 */
#define G991_2_A                                ((0x01)<<8)                                     /* G.991.2 Annex A functionality */
#define G991_2_B                                ((0x02)<<8)                                     /* G.991.2 Annex B functionality */
#define T1_MCM_VDSL                             ((0x04)<<8)                                     /* Committee T1 MCM VDSL */
#define T1_SCM_VDSL                             ((0x08)<<8)                                     /* Committee T1 SCM VDSL */
#define ETSI_MCM_VDSL                   ((0x10)<<8)                                     /* ETSI MCM VDSL */
#define ETSI_SCM_VDSL                   ((0x20)<<8)                                     /* ETSI SCM VDSL */

/* SI Spar1 octet 3 */
#define G992_3_A                                ((uint32)(0x01)<<16)            /* G.992.3 g.dmt.bis Annex A functionality */
#define G992_3_B                                ((uint32)(0x02)<<16)            /* G.992.3 g.dmt.bis Annex B functionality */
#define G992_3_I                                ((uint32)(0x04)<<16)            /* G.992.3 g.dmt.bis Annex I functionality */
#define G992_3_J                                ((uint32)(0x08)<<16)            /* G.992.3 g.dmt.bis Annex J functionality */
#define G992_4_A                                ((uint32)(0x10)<<16)            /* G.992.4 g.lite.bis Annex A functionality */
#define G992_4_I                                ((uint32)(0x20)<<16)            /* G.992.4 g.lite.bis Annex I functionality */

// we use the reserved bit to indicate G.992.3 AnnexL
#define G992_3_L                ((uint32)(0x40)<<16)        /* G.992.3 g.dmt.bis Annex L functionality */

/* SI Spar1 octet 4 */
#define G992_5_A                                ((uint32)(0x01)<<24)            /* G.992.5 g.dmt.bis Annex A functionality */
#define G992_5_B                                ((uint32)(0x02)<<24)            /* G.992.5 g.dmt.bis Annex B functionality */
#define G992_5_I                                ((uint32)(0x04)<<24)            /* G.992.5 g.dmt.bis Annex I functionality */
#define G992_3_M                                ((uint32)(0x08)<<24)            /* G.992.3 g.dmt.bis Annex M functionality */

#define G992_5_J                ((uint32)(0x10)<<24)        /* G.992.5 g.dmt.plus AnnexJ functionality */

/* SI Spar1 octet 5 */
//Note: Following the G.HS CPE code convention, the 4 octets defined by
//g.hs standard is directly translated into a 32 bits variable. As the 5-th
//byte is defined, we start to use an additional 32 bits variable.
//Without changing gt_hsc structure, we can also re-use one bit in the
//octet-2(which is somehow assumed "never happen" in our code) to indicate using
//the second 32 bits variable is nevessary.
#define G992_5_M                ((uint32)(0x01))             /* G.992.5 g.dmt.plus AnnexM functionality */
#define G993_1_ANSI_T1_424              (0x02)                  // G.993.1 ANSI_T1.424
#define G993_1_ANNEXI         (0x04)         // G.993.1 ANNEX I
#define G993_2                                          (0x20)                  // G.993.2 Annex I
#define G9701                 (0x40)         // G.9701 G.Fast

#define NUM_KNOWN_ADSL2_SPAR1_BITS              15                                      /* Octet 3, 4, and bit 0x01 of octet 5 */


/* ---- standard info NPar2 ---- */
#define UPSTREAM_1_32_DMT               (0x04)                                  /*  Upstream tones 1 to 32 for DMT (Annex B specific) */
#define FAST_RETRAIN                    (0x08)                                  /*  Fast Retrain */
#define RS16                                    (0x10)                                  /*  RS16 */
#define CLEAR_EOC_G997_1                (0x20)
#define REPORT_ED                       (0x1)   /*Erasure decoding reporting*/


//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
#define PTM_TC_MODE                     (0x20)
#define ATM_TC_MODE                     (0x10)
#define PTM_ATM_TC_MODE                 (0xFF)
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)


#define NTR                                             (0x01)                                          /* Network timing reference */
#define SHORT_INIT                              (0x02)                                          /* G.bis PMD short initialization */
#define DIAGNOSTICS_MODE                (0x04)                                          /* G.bis PMD diagnostics mode */
#define UPSTREAM_1_32_BIS               (0x08)                                  /* Upstream tones 1 to 32 for BIS (Annex B specific) */
//XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(Start)
/* ---- standard G.993.1 info NPar2 ---- */
#define G9931_OPTUP                                     (0x01)                                  /*   */
#define G9931_OPTDOWN                           (0x02)                                  /*   */
#define G9931_PSDRED                               (0x04)                               /*   */
#define G9931_PTM                                          (0x08)

#define G9931_ATM                                          (0x10)                                               /*  */
#define G9931_CLEAREOC                          (0x20)                                          /*  */

/* ---- standard G.993.2 info NPar2 ---- */
#define G9932_ALL_DIGITAL                       (0x01)                                  /*   */
#define G9932_DS_VIRT_NOISE             (0x02)                                  /*   */
#define G9932_LINEPROBE                         (0x04)                                  /*   */
#define G9932_LOOPDIAG                          (0x08)
//XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(End)

// XDSLRTFW-1624 (Start)
/* G9932_SI_Npar2_Octet2 bit fields*/
#define G9932_VECTORING_FRIENDLY    (0x01)  // G.993.5 friendly G.993.2 operation in the downstream direction.
                                            //     Note: If set to ONE, the bits "Full G.993.5 friendly G.993.2 operation"
#define G9932_AELEM_SUPPORT         (0x02)
#define G9932_VECTOR_FULL_FRIENDLY  (0x04) //Full G.993.5-friendly G.993.2 operation  //XDSLRTFW-2490 (Start_End)
// XDSLRTFW-1624 (End)


/* ---- standard info SPar2 ---- */
#define SUBCH_INFO                              (0x01)                                  /*  subchannel information */
#define SPECTRUM_UP                             (0x02)                                  /*  spectrum frequency upstream */
#define SPECTRUM_DN                             (0x04)                                          /*  spectrum frequency downstream */


/* spar2 octet 1 */
#define SPECTRUM_BOUNDS_UP              (0x01)          /* G.bis PMD spectrum bounds upstream */
#define SPECTRUM_SHAPE_UP               (0x02)          /* G.bis PMD spectrum shaping upstream */
#define SPECTRUM_BOUNDS_DN              (0x04)          /* G.bis PMD spectrum bounds downstream */
#define SPECTRUM_SHAPE_DN               (0x08)          /* G.bis PMD spectrum shaping downstream */
#define TX_IMAGE_NYQ                    (0x10)          /* G.bis PMD transmit signal images above the Nyquist frequency */
// We changed the reserved bit to indicate whether we will provide AnnexL PSD Mask info
#define PSD_MASK                                (0x20)          // ADSL2 AnnexL PSD Mask

/* spar2 octet 2 */
#define OH_DATARATE_DN                                  (0x01)          /* G.bis PMS-TC overhead data rate downstream */
#define OH_DATARATE_UP                                  (0x02)          /* G.bis PMS-TC overhead data rate upstream     */
#define MAX_NUM_DS_TPSTC_FUNC_OF_EACH_TYPE      (0x04)  /* G.bis max number of downstream TPS-TC functions of each type */
#define MAX_NUM_US_TPSTC_FUNC_OF_EACH_TYPE      (0x08)  /* G.bis max number of upstream TPS-TC functions of each type */

/* spar2 octet 3 */
#define TPSTC_FUNC_STM_DN               (0x01)          /* G.bis TPS-TC function#0 STM downstream */
#define TPSTC_FUNC_STM_US               (0x02)          /* G.bis TPS-TC function#0 STM upstream */
#define TPSTC_FUNC_ATM_DN               (0x04)          /* G.bis TPS-TC function#0 ATM downstream */
#define TPSTC_FUNC_ATM_US               (0x08)          /* G.bis TPS-TC function#0 ATM upstream */
#define TPSTC_FUNC_PTM_DN               (0x10)          /* G.bis TPS-TC function#0 PTM downstream */
#define TPSTC_FUNC_PTM_US               (0x20)          /* G.bis TPS-TC function#0 PTM upstream */
#define TPSTC_FUNC_PTM        (TPSTC_FUNC_PTM_US|TPSTC_FUNC_PTM_DN)
#define TPSTC_FUNC_ATM        (TPSTC_FUNC_ATM_US|TPSTC_FUNC_ATM_DN)


/* spar2 octet 4 */
#define LATENCY_PATH_DN         (0x01)          /* G.bis PMS-TC downstream latency path#0 supported */
#define LATENCY_PATH_UP         (0x02)          /* G.bis PMS-TC upstream latency path#0 supported */
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
// SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
#ifdef UNV_RETX_GHS
#define  TPSTC_RETX_ATM_DN    (0x04)   /* G.bis ATM TPS-TC #0 RETX in downstream supported */
#define  TPSTC_RETX_PTM_DN    (0x08)   /* G.bis PTM TPS-TC #0 RETX in downstream supported */
/* Mask for G.bis ATM and PTM TPS-TC #0 RETX in downstream supported */
#define  TPSTC_RETX_ATM_PTM_DN  (TPSTC_RETX_ATM_DN|TPSTC_RETX_PTM_DN)
#endif
 //SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
 //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
/* ---- subchannel information ---- */
#define AS0_DN                                  (0x01)
#define AS1_DN                                  (0x02)
#define AS2_DN                                  (0x04)
#define AS3_DN                                  (0x08)
#define LS0_DN                                  (0x10)
#define LS1_DN                                  (0x01)
#define LS2_DN                                  (0x02)
#define LS0_UP                                  (0x04)
#define LS1_UP                                  (0x08)
#define LS2_UP                                  (0x10)

#define TPSTC_TYPE_STM                  0
#define TPSTC_TYPE_ATM                  1
#define TPSTC_TYPE_PTM                  2
// Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (start_End)
#define NUM_SI_NPAR2_OCTETS   2
#define NUM_SI_SPAR2_OCTETS     10

#define MAX_TPSTC_FUNC_UP               4
#define MAX_TPSTC_FUNC_DN               4

/* gs_CurrentCoChipset */
#define GENERIC_CO_CHIPSET  (0x00)
#define ADI_CO_CHIPSET      (0x10)              // 930 and older ADI chipsets
#define ANCDA_CO_CHIPSET        (0x11)          // Anaconda (i.e. ver 4.0 and newer)
#define ALA_CO_CHIPSET      (0x20)
//XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (START)
//Marconi MX QDC-1 sends 0x80000 vender ID and GHS_ALA_ID in NSIF
#define ALA2_CO_CHIPSET     (0x21)  // if GHS-VendorID==0 and NSIF = GHS_ALA_ID
//SMS01261911 SMS01246527 IOP_A_DS_ADSL1_ALA3_CheckAuxPilot_Medley (START)
//Litespan 2k DSLAM sends 0xFF00 vender ID and GHS_ALA_ID in NSIF
#define ALA3_CO_CHIPSET     (0x22)              // if GHS-VendorID==0xff00
//SMS01261911 SMS01246527 IOP_A_DS_ADSL1_ALA3_CheckAuxPilot_Medley (END)

#define ALA4_CO_CHIPSET     (0x23)
//XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (END)

//XDSLRTFW-1633 ADSLRTFW-1412 IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (START_END)
#define ECI_PLSE_CO_CHIPSET     (0x24)
#define AWRE_CO_CHIPSET         (0x30)
#define BDCM_CO_CHIPSET         (0x40)
#define CTLM_CO_CHIPSET         (0x50)
#define GSI_CO_CHIPSET      (0x60)
#define IFTN_CO_CHIPSET         (0x70)
#define TI_CO_CHIPSET       (0x80)
#define CTNW_CO_CHIPSET         (0x90)
#define AVINAX_PLATFORM_8    (0xD0)
//XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (START_END)
#define IKNS_CO_CHIPSET    (0xA0)
/* CO Provider*/

#define GHS_0000_ID  (0x00000000)               // '0'-vendor ID. If we see '0'-vendor ID we assume a Centillium CO.
#define GHS_FF00_ID  (uint32)(0x0000FF00)       // SMS01261911 SMS01246527 IOP_A_DS_ADSL1_ALA3_CheckAuxPilot_Medley (START) //Litespan 2k DSLAM sends 0xFF00 vender ID and GHS_ALA_ID in NSIF
#define GHS_80000_ID (0x00080000)               // XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (START) //Marconi MX QDC-1 sends 0x80000 vender ID and GHS_ALA_ID in NSIF
#define GHS_ECI_ID   (0x504C5345)               // "PLSE" ECI Pulsecomm ID //XDSLRTFW-1633 ADSLRTFW-1412 IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (START_END)
#define GHS_ADI_ID   (0x414E4456)               // "ANDV"
#define GHS_ALA_ID   (0x414C4342)               // "ALCB"
#define GHS_AWRE_ID  (0x41575245)               // "AWRE"
#define GHS_BDCM_ID  (0x4244434D)               // "BDCM"
#define GHS_CTLM_ID  (0x50000000)               // This looks weird - maybe the Centillium CO was not sending a valid ID.
#define GHS_CTLM_ID2 (0x43454E54)               // "CENT" in ASCII. Marconi Centillium CO sending us such Vendor ID.
#define GHS_GSI_ID   (0x4753504E)               // "GSPN"
#define GHS_IFTN_ID  (0x4946544E)               // "IFTN"
#define GHS_TI_ID    (0x54535443)               // "TSTC"
#define GHS_OPTI_ID  (0x4F505449)               // "OPTI"
#define GHS_CTNW_ID  (0x43544E57)               // "CTNW"
#define GHS_IKNS_ID  (0x494B4E53)               // "IKNS"   //XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (START_END)
#define GHS_TI4000C  (0x43535443)               // "CSTC"   added V.ID for TI4000C which transmits CSTC
#define GHS_CXSY_ID  (0x43585359)               // "CXSY"  //XDSLRTFW-2893// CXSY (e.g. Audiocodes: Argentina)


#define AVINAX_PLATFORM          (13)
#define VINAX_REV_2_L_PLATFORM   (12)  //XDSLRTFW-1639 (start_end)
#define VINAX_REV_2_M_PLATFORM   (11)
#define VINAX_REV_1_4_PLATFORM   (10)
#define VINAX_REV_1_PLATFORM     (9)

/* gl_SelectedMode */
#define MODE_G992_1                     (0x1)
#define MODE_G992_2                     (0x2)
#define MODE_G992_3                     (0x4)
#define MODE_G992_4                     (0x8)
#define MODE_G992_5                     (0x10)
#define MODE_ADSL1                      (MODE_G992_1 | MODE_G992_2)
#define MODE_ADSL2                      (MODE_G992_3 | MODE_G992_4 | MODE_G992_5)

#define LINK_DIAG                       (0x20)
#define LINK_SHORTINIT          (0x40)

#define ANNEX_A                         (0x1<<16)
#define ANNEX_B                         (0x2<<16)
#define ANNEX_C                         (0x4<<16)
#define ANNEX_I                         (0x8<<16)
#define ANNEX_J                         (0x10<<16)
#define ANNEX_L                         (0x20<<16)
#define ANNEX_M                         (0x40<<16)
#define ANNEX_AL                        (ANNEX_A | ANNEX_L)
#define ANNEX_BM                        (ANNEX_B | ANNEX_M)
#define ANNEX_JM                        (ANNEX_J | ANNEX_M)
/*------------NSIF Block Const----------------*/
#define T35_COUNTRY_1            (0x6D)   /* NSIF : Country Code for T.35 standard */
#define T35_COUNTRY_2            (0x66)   /* NSIF : Country Code for T.35 standard */

/*****************************************Anantha**************************************/
#ifdef DANUBE_PTM_SUPPORT
#define PTM_ONLY (0x1000)
#define PTM_ATM  (0x3000)
#define ATM_ONLY (0x2000)
#define SEL_TPS_TC (0x8000)
#define TPS_TC_MASK (0x3000)
#define DEFAULT_PTM_OPTIONS (0x0820) //NPar3 Octet 10 PTM options(64/65-octet encapsulation supported for both US & DS)

#define PTM_MASK (0x0020)
#define DIS_ATM (0xDFFF)
#endif//if defined DANUBE_PTM_SUPPORT

#define DEFAULT_NUM_DS_STM_TPS_TC       (1)
#define DEFAULT_NUM_DS_ATM_TPS_TC       (1)
#define DEFAULT_NUM_DS_PTM_TPS_TC       (1)
#define DEFAULT_NUM_US_STM_TPS_TC       (1)
#define DEFAULT_NUM_US_ATM_TPS_TC       (1)
#define DEFAULT_NUM_US_PTM_TPS_TC       (1)

/*********************************PTM CHANGES*************************************/
#ifdef DANUBE
#define NSIF_INFINEON                           (1)                     /*Sriram  : NSIF enable country code & Vendor ID octets  */
#endif
/*********************************ROUGH LOOP ESTIMATION IN HSK ***************************/
#ifdef DANUBE_AFE
#ifndef ISDN
#define HSK_TONE_PWR_THRESHOLD_1_KFT    (83<<8)         //AVG HSK TONE PWR for loop length < 1kft
#define HSK_TONE_PWR_THRESHOLD_3_KFT    (74<<8)         //AVG HSK TONE PWR for loop length < 3kft
#define HSK_TONE_PWR_THRESHOLD_5_KFT    (61<<8)         //AVG HSK TONE PWR for loop length < 5kft
#define HSK_TONE_PWR_THRESHOLD_7_KFT    (53<<8)         //AVG HSK TONE PWR for loop length < 7kft
#define HSK_TONE_PWR_THRESHOLD_9_KFT    (44<<8)         //AVG HSK TONE PWR for loop length < 9kft
#define HSK_TONE_PWR_THRESHOLD_11_KFT   (35<<8)         //AVG HSK TONE PWR for loop length < 11kft
#define HSK_TONE_PWR_THRESHOLD_13_KFT   (27<<8)         //AVG HSK TONE PWR for loop length < 13kft
#define HSK_TONE_PWR_THRESHOLD_15_KFT   (19<<8)         //AVG HSK TONE PWR for loop length < 15kft
#endif
#endif
//SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory(Start)
#ifdef ADSL_62
#define IlV_MEMSIZE_BYTES24KB         (0x20)      // Indicate Suprt for 24Kdilv Memory size
#endif
//SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (End)

// IOP_ALL_BisPlus_ALL_SendIFFTSizeInNPar3 (Start)
#ifndef ISDN   // Only for Anx-A
#define  IFFT64_CMPLX_CONJ_BB_SIGNAL  (0x19)
#define  IFFT128_ZERO_FILLED          (0x1E)
// XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_UsPerf(START)
#define  IFFT512_CMPLX_CONJ_BB_SIGNAL (0x25)
// XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_USPerf(End)
#endif // ifndef ISDN
// IOP_ALL_BisPlus_ALL_SendIFFTSizeInNPar3 (End)

// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(Start)
#ifdef HERC_API
//---- standard info SPar2 octet 1 for VDSL2 ------------
#define All_DIGITAL_MODE                (0x1)
#define V2_PROFILES                     (0x1)           // Profiles selection
#define V2_RFI_BANDS                    (0x8)           // RFI bands
#define V2_DFT_SIZE                     (0x10)          // Initial_IDFT_size_(2N)
#define V2_CE_LENGTH                    (0x20)          // CE lengths

//---- standard info SPar2 octet 2 for VDSL2 ------------
// Table 11.68.0.1 of G.994.1
#define ANNEX_A_US0                     (0x1)
#define ANNEX_B_US0                     (0x2)
#define ANNEX_C_US0                     (0x4)
//XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (Start)
#define G9935_G_VECTOR_MASK             (0x8)       // Table 11.68.0.1 of G.994.1

//---- standard info NPar3 octet 1 for VDSL2 ------------
//G.994.1 Table 11.68.10 of G.994.1
#define G9935_DS_VECTORING_ENABLED   (0x1)
// XDSLRTFW-1228 Feature_AB_All_All_All_SendUSVectorCodePointerInGHs (Start)
#define G9935_US_VECTORING_ENABLED   (0x2)
// XDSLRTFW-1228 Feature_AB_All_All_All_SendUSVectorCodePointerInGHs (End)
//XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (End)
#endif
// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(End)
//XDSLRTFW-2893
// Defines for variable "guc_ClrControl", i.e. GHS Clr control flag bitmap
#define CLR_SEND_NOT_ADSL_MODES      (0x01)
#define CLR_SEND_NOT_TRANCSEIVER_ID  (0x02)
#define CLR_SEND_NOT_BONDING_INFO    (0x04)
#define CLR_SEND_ONE_OCTET_ID_SPAR1  (0x08)
#define CLR_SEND_ONE_OCTET_SI_SPAR1  (0x10)
#define CLR_SEND_BONDING_PME_ID      (0x20)

//---- standard info NPar3 octet 1 for VDSL2 ------------
#define V2_PROFILE_8A                           (0x01)
#define V2_PROFILE_8B                           (0x02)
#define V2_PROFILE_8C                           (0x04)
#define V2_PROFILE_8D                           (0x08)
#define V2_PROFILE_12A                          (0x10)
#define V2_PROFILE_12B                          (0x20)

//---- standard info NPar3 octet 2 for VDSL2 ------------
#define V2_PROFILE_17A                          (0x1)
#define V2_PROFILE_30A                          (0x2)
#define V2_PROFILE_35B                          (0x4)

// XDSLRTFW - 2298 (Start)
// --------------- G.Fast  ---------------
//---- standard info NPar2 for G.Fast ------------
// Table 11.69 of G994.1 (added in the Ammendment4)
#define G_Fast_Special_Probe_Sequence     (0x04)
#define G_Fast_Default_CE_Length     (0x08)
#define G_Fast_Default_Symbol_Periods_TDD_Frame     (0x10)

//---- standard info SPar2 octet 1 for G.Fast ------------
// Table 11.70 of G994.1 (added in the Ammendment4)
#define G_Fast_Profiles     (0x01)
#define G_Fast_Transmission_Band     (0x02)
#define G_Fast_Symbol_Position_TDD_Frame     (0x04)
#define G_Fast_RFI_Band     (0x08)
#define G_Fast_Duration_Channel_Discovery     (0x10)
#define G_Fast_CE_Length     (0x20)

//---- standard info SPar2 octet 2 for G.Fast ------------
// Table 11.70.0.1 of G994.1 (added in the Ammendment4)
#define G_Fast_Symbol_Period_TDD_Frame     (0x01)
#define G_Fast_International_Amateur_Radio_Band     (0x02)
#define G_Fast_Scrambler_Seed     (0x04)
#define G_Fast_Special_Probe_Sequence_Length     (0x08)
#define G_Fast_IDS     (0x10)
#define G_Fast_SOC_Symbol_Repitition     (0x20)

//---- standard info SPar2 octet 3 for G.Fast ------------
// Table 11.70.0.2 of G994.1 (added in the Ammendment4)
#define G_Fast_DS_Initialzation_Data_Symbols     (0x01)
#define G_Fast_RMC_Offset     (0x02)

//---- standard info NPar3 octet 1 for G.Fast ------------
// Table 11.70.1 of G994.1 (added in the Ammendment4)
#define G_Fast_Profile_106     (0x01)
#define G_Fast_Profile_212     (0x02)
// XDSLRTFW - 2298 (End)

/**********************************************************************
* TYPEDEFS
**********************************************************************/
/* ---- HandShake Control structure ---- */
typedef struct {
    int16 s_State;                                                                      /*  current handshake message exchange state */
    int16 s_NextState;                                                                  /*  next handshake message exchange state */
    int16 s_DecodeResult;                                                               /*  Decoding Result of a received message */
    int16 s_InitialMsg;                                                                 /*  CPE message to initiate a transaction. */
    int32 l_SelectedMode;
    int16 s_CL_Exchanged;                                                               /*  flag indicating if capability lists have been exchanged */
    int16 s_TxMsgComplete;                                                              /*  flag indicating if message xmission is completed */
    int16 s_RxMsgComplete;                                                              /*  flag indicating if message reception is completed */
    int16 s_TxNSBCnt;                                                                   /*  number of transmitted non-standard information blocks */
    int16 s_RxNSBCnt;                                                                   /*  number of received non-standard information blocks */
}   HandShakeControl_t;

/* ---- complex value ---- */
typedef struct {
    int16   s_X;                                                                                /*  real part */
    int16   s_Y;                                                                                /*  imaginary part */
}   Complex_t;

typedef struct {

    int16 s_NOMPSD;             /* G.bis nominal transmit PSD level 2 octets */
    int16 s_MAXNOMPSD;          /* G.bis maximum nominal transmit PSD level 2 octets */
    int16 s_MAXNOMATP;          /* G.bis maximum nominal aggregate transmit power 2 octets */
    uint16 *pus_BreakFreq;      /* G.bis spectrum shaping breakpoint frequency for pair#1 2 octets */
    FlagT  *pf_InSprtSet;    /* G.bis spectrum shaping indication bit */
    uint8 *puc_tssi;            /* G.bis spectrum shaping tssi value for pair#1 2 octets */
}       PMD_Type_t;

typedef struct {
    int16 s_DSMSGOvhdMinRate;
    int16 s_USMSGOvhdMinRate;
}       PMS_HDLC_Ovhd_t;


typedef struct {
    int16 s_MaxDataRate;
    int16 s_MaxRandD;
    int16 s_OneOverS0min;
    int16 s_D0Mask;
}       PMS_TC_LatencyPath_t;

typedef struct {
    int16 s_MinNetDataRate;
    int16 s_MaxNetDataRate;
    int16 s_MinResNetDataRate;
    int16 s_MaxLatency;
    uint8 uc_MaxBER;
        uint8 uc_TPSTCoptions;
    int16 s_IMAxINP;  //IMA flag + INP_min
//  XDSLRTFW-1481 (Start_End) TPSTCoptions is part of paramater 7 as per message spec,
//      so s_MaxBER is used as (uc_TPSTCoptions + uc_MaxBER)
//      int16 s_TPSTCoptions;   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start_End)
}       TPS_TC_Type_t;

typedef struct {
    int16 s_Control;
    TPS_TC_Type_t       ta_TpsTcType[MAX_TPS_TC_TYPE];

}       TPS_TC_BearerChannel_t;


#if 0
/* ----Bonding---- */
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start)

typedef struct{
        uint8 uc_ID_Clear_if_same;
        uint8 uc_Remote_discovery_register_bits_47_to_42;
        uint8 uc_Remote_discovery_register_bits_41_to_36;
        uint8 uc_Remote_discovery_register_bits_35_to_30;
        uint8 uc_Remote_discovery_register_bits_29_to_24;
        uint8 uc_Remote_discovery_register_bits_23_to_18;
        uint8 uc_Remote_discovery_register_bits_17_to_12;
        uint8 uc_Remote_discovery_register_bits_11_to_6;
        uint8 uc_Remote_discovery_register_bits_5_to_0;
}       PTM_TC_PME_AGRE_DISC_Bonding_t;


typedef struct{
        uint8 uc_PME_Aggregate_register_bits_31_to_30;  // Only two bit are allowed to set
        uint8 uc_PME_Aggregate_register_bits_29_to_24;
        uint8 uc_PME_Aggregate_register_bits_23_to_18;
        uint8 uc_PME_Aggregate_register_bits_17_to_12;
        uint8 uc_PME_Aggregate_register_bits_11_to_6;
        uint8 uc_PME_Aggregate_register_bits_5_to_0;
}PTM_TC_PME_AGRE_Bonding_t;


typedef struct{
        uint8 uc_Max_Ds_delay_ATM_Bonding_Group;
}PTM_TC_PHY_TRN_param_t;
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(End)
#endif


typedef struct {
    FlagT ft_DiagMode;
    FlagT ft_ShortInit;
}       PMD_params_t;

/* ---- Non-Standard Block structure ---- */
typedef struct {
    uint8 uc_NSLen;
    /*  length of non-standard information */
//#ifdef DANUBE //XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (START_END)
    uint16  NSIF_SpecialPattern;
    uint32  NSIF_VendorID;
//#endif //XDSLRTFW-1597 IOP_A_DS_DMT_VID_ALA4 (START_END)
    /*  country code and provider ID shall be reused from InforField_t */
    uint8 *puca_NSVendorSpec;  //size: MAX_NS_VENDOR_INFO_LEN                   /*  vendor specific information array */
} NonStandardBlock_t;



/* ---- BIS Information Field structure ---- */
typedef struct {

    /*---- ADSL2ALL Annexs' specific Par2 and Par3 ---- */

    // Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (start_End)
    uint8 uc_SI_NPar2[NUM_SI_NPAR2_OCTETS];      /* Two Octet are used now NPar2,Inc.support for Erasure decoding Trust me bit*/
    uint8 uc_SI_SPar2[NUM_SI_SPAR2_OCTETS];             /* octet 1 for PMD parameters */
    /* octet 2, 3,4, 5, 6, 7 for TPS-TC and PMS-TCparameters */

    PMD_params_t t_PMD_Npar2;
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   //SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
#ifdef UNV_RETX_GHS
   // This byte is reserved for ATM TPS-TC #0 RTX Npar3
   // Added here because of the availability of the byte here(due to non alignment).
   uint8 uc_Atm_ReTx0_DS;
#endif
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
    //---- ADSL2ALL Annexs' PMD NPar3 ----
    PMD_Type_t t_PMD_NPar3_DS;
    PMD_Type_t t_PMD_NPar3_US;
    uint8 uc_TxSignalNyq;                       /* PMD parameter: G.bis type of transmit images above Nyquist 1 octet */

    //---- G.992.3 L/M PSD Mask NPar3 ----
    uint8 uca_PSD_Mask[2];
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   //SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
#ifdef UNV_RETX_GHS
   // This byte is  for PTM TPS-TC #0 RTX Npar3
   // Added here because of the availability of the byte here(due to non alignment).
   uint8 uc_Ptm_ReTx0_DS;
#endif
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
    /*---- ADSL2ALL Annexs' PMS_TC NPar3 ----  */
    PMS_HDLC_Ovhd_t              t_Overhead;
    PMS_TC_LatencyPath_t ta_DSLatencyPath[NUM_DS_LATENCY_PATHS];
    PMS_TC_LatencyPath_t ta_USLatencyPath[NUM_DS_LATENCY_PATHS];

    /*---- ADSL2ALL Annexs' TPS_TC NPar3 ---- */
    TPS_TC_BearerChannel_t      ta_DSBearerChannel[MAX_BEARER_CHANNEL];
    TPS_TC_BearerChannel_t      ta_USBearerChannel[MAX_BEARER_CHANNEL];

    uint8 uc_DS_Max_Num_STM_TPS_TC;                     /* number of downstream bearer channels of STM type */
    uint8 uc_DS_Max_Num_ATM_TPS_TC;                     /* number of downstream bearer channels of ATM type */
    uint8 uc_DS_Max_Num_PTM_TPS_TC;                     /* number of downstream bearer channels of PTM type */

    uint8 uc_US_Max_Num_STM_TPS_TC;                     /* number of upstream bearer channels of STM type */
    uint8 uc_US_Max_Num_ATM_TPS_TC;                     /* number of upstream bearer channels of ATM type */
    uint8 uc_US_Max_Num_PTM_TPS_TC;                     /* number of upstream bearer channels of PTM type */
    /*****************************************Anantha**************************************/
#ifdef DANUBE_PTM_SUPPORT
    uint8 uc_PtmOctet_DS_BC0;
    uint8 uc_PtmOctet_US_BC0;
#endif//if defined DANUBE_PTM_SUPPORT
    /*********************************PTM CHANGES*************************************/

} Adsl2AllInfo_t;

// XDSLRTFW-2298 (Start)
/* ---- G.Fast Information Field structure ---- */
typedef struct{
   //SI - NPar2
   uint8 uc_SI_NPar2;

   //SI - SPar2
   uint8 uc_SI_SPar2_01;
   uint8 uc_SI_SPar2_02;
   uint8 uc_SI_SPar2_03;

   //----------------- SI NPar3 ----------------------------
   uint8 uc_Profiles;

   // Duration of Channel discovery 1-1
   uint8 uc_duration_channel_discovery;

   // Number of symbol periods in TDD frame
   uint8 uc_symbol_period_TDD_frame;
}G_Fast_Type_t;
// XDSLRTFW-2298 (End)

/* ---- Information Field structure ---- */
typedef struct {
    uint8 uc_Type;                                                                      /*  message type field */
    uint8 uc_Rev;                                                                       /*  revision number field */

    /* ==== Vendor ID field ==== */
    uint16 us_Country;                                                                          /*  T.35 country code (2 octets) */
    uint32 ul_Provider;                                                                         /*  provider code (Vendor ID, 4 octets) */
    uint16 us_VendorInfo;                                                                       /*  vendor specific information (2 octets) */

    /* ==== Parameter field ==== */

    uint8 uc_ID_NPar1;
    uint8 uc_ID_SPar1[NUM_ID_SPAR1_OCTETS];
    uint8 uc_ID_SPar1_ExtraBits;                                                        /* Bits in subsequent ID_SPar1 octets */

    /* ---- Npar2 ---- */
    uint8 uc_UpMaxNDR;                                                                  /*  maximum net data rate upstream */
    uint8 uc_UpMinNDR;                                                                  /*  minimum net data rate upstream */
    uint8 uc_UpAvgNDR;                                                                  /*  average net data rate upstream  */

    uint8 uc_DnMaxNDR;                                                                  /*  maximum net data rate downstream */
    uint8 uc_DnMinNDR;                                                                  /*  minimum net data rate downstream */
    uint8 uc_DnAvgNDR;                                                                  /*  average net data rate downstream   */

    uint8 uc_UpMaxLat;                                                                  /*  maximum latency upstream (units given by formula in Table 16 of G.hs) */
    uint8 uc_UpAvgLat;                                                                  /*  average latency upstream (units given by formula in Table 17 of G.hs) */

    uint8 uc_DnMaxLat;                                                                  /*  maximum latency downstream (units given by formula in Table 18 of G.hs) */
    uint8 uc_DnAvgLat;                                                                  /*  average latency downstream  (units given by formula in Table 19 of G.hs) */

    /* ---- splitter information ---- */
    uint8 uc_ID_NPar2_O11;                                                              /*  Parameter field NPar2 Octet 11 */
    uint8 uc_ID_NPar2_O12;                                                              /*  Parameter field NPar2 Octet 12 */

    /* relative power level information */
    uint8 uc_UpA43Attenuation;                        /* relative power level/carrier for upstream carrier set A43 */
    uint8 uc_DnA43Attenuation;                        /* relative power level/carrier for downstream carrier set A43 */
    uint8 uc_UpB43Attenuation;                        /* relative power level/carrier for upstream carrier set B43 */
    uint8 uc_DnB43Attenuation;                        /* relative power level/carrier for downstream carrier set B43 */
    uint8 uc_UpC43Attenuation;                        /* relative power level/carrier for upstream carrier set C43 */
    uint8 uc_DnC43Attenuation;                        /* relative power level/carrier for downstream carrier set C43 */
    uint8 uc_UpA4Attenuation;                         /* relative power level/carrier for upstream carrier set A4 */
    uint8 uc_DnA4Attenuation;                         /* relative power level/carrier for downstream carrier set A4 */
    uint8 uc_UpA43cAttenuation;                       /* relative power level/carrier for upstream carrier set A43c */
    uint8 uc_DnA43cAttenuation;                       /* relative power level/carrier for downstream carrier set A43c */
#ifdef ADSL_BONDING
    uint8 uc_BondingNP2;                              // Bonding type (Ethernet, TDIM, ATM, BACP)
    uint8 uc_BondingSP2;                              //
    uint8 uca_BondingDisc[9];                         // ClearIfSame bit and Disc register
    uint8 uca_BondingAggr[6];                         // PME Aggr register
    uint8 uc_BondingId;                               // PME Identification info
#endif
    uint8 uc_UpJ43Attenuation;                                                          /* relative power level/carrier for upstream carrier set J43 */
    uint8 uc_DnJ43Attenuation;                                                          /* relative power level/carrier for downstream carrier set J43 */
    uint8 uc_UpB43cAttenuation;                                                         /* relative power level/carrier for upstream carrier set B43c */
    uint8 uc_DnB43cAttenuation;                                                         /* relative power level/carrier for downstream carrier set B43c */

    /* ==== Standard Information Field ==== */

    uint8 uc_SI_NPar1;
    uint8 uc_SI_SPar1[NUM_SI_SPAR1_OCTETS];
    uint8 uc_SI_SPar1_ExtraBits;                                                        /* Bits in subsequent SI_SPar1 octets  */

    /* ---- G.992.1 Annex A specific Par2 and Par3 ---- */

    uint8 uc_SI_1A_NPar2;
    uint8 uc_SI_1A_SPar2;

    /* ---- NPar3 ----  */
    uint8 uc_1A_SubChan1;                                                               /*  subchannel information octet 1 */
    uint8 uc_1A_SubChan2;                                                               /*  subchannel information octet 2 */
    uint8 uc_1A_UpMinSpect;                                                             /*  spectrum minimum frequency upstream */
    uint8 uc_1A_UpMaxSpect;                                                             /*  spectrum maximum frequency upstream */
    uint8 uc_1A_DnMinSpect;                                                             /*  spectrum minimum frequency downstream */
    uint8 uc_1A_DnMaxSpect;                                                             /*  spectrum maximum frequency downstream */


    /* ---- G.992.1 Annex B specific Par2 and Par3 ---- */

    uint8 uc_SI_1B_NPar2;
    uint8 uc_SI_1B_SPar2;

    /* ---- NPar3 ----  */
    uint8 uc_1B_SubChan1;                                                               /*  subchannel information octet 1 */
    uint8 uc_1B_SubChan2;                                                               /*  subchannel information octet 2 */
    uint8 uc_1B_UpMinSpect;                                                             /*  spectrum minimum frequency upstream */
    uint8 uc_1B_UpMaxSpect;                                                             /*  spectrum maximum frequency upstream */
    uint8 uc_1B_DnMinSpect;                                                             /*  spectrum minimum frequency downstream */
    uint8 uc_1B_DnMaxSpect;                                                             /*  spectrum maximum frequency downstream */


    /* ---- G.992.1 Annex C specific Par2 and Par3 ---- */

    uint8 uc_SI_1C_NPar2;
    uint8 uc_SI_1C_SPar2;

    /* ---- NPar3 ----  */
    uint8 uc_1C_SubChan1;                                                               /*  subchannel information octet 1 */
    uint8 uc_1C_SubChan2;                                                               /*  subchannel information octet 2 */
    uint8 uc_1C_UpMinSpect;                                                             /*  spectrum minimum frequency upstream */
    uint8 uc_1C_UpMaxSpect;                                                             /*  spectrum maximum frequency upstream */
    uint8 uc_1C_DnMinSpect;                                                             /*  spectrum minimum frequency downstream */
    uint8 uc_1C_DnMaxSpect;                                                             /*  spectrum maximum frequency downstream */


    /* ---- G.992.2 Annex A/B specific Par2 and Par3 ---- */

    uint8 uc_SI_2AB_NPar2;
    uint8 uc_SI_2AB_SPar2;

    /* ---- NPar3 ----  */
    uint8 uc_2AB_UpMinSpect;                                                            /*  spectrum minimum frequency upstream */
    uint8 uc_2AB_UpMaxSpect;                                                            /*  spectrum maximum frequency upstream */
    uint8 uc_2AB_DnMinSpect;                                                            /*  spectrum minimum frequency downstream */
    uint8 uc_2AB_DnMaxSpect;                                                            /*  spectrum maximum frequency downstream */


    /* ---- G.992.2 Annex C specific Par2 and Par3 ---- */

    uint8 uc_SI_2C_NPar2;
    uint8 uc_SI_2C_SPar2;

    /* ---- NPar3 ----  */
    uint8 uc_2C_UpMinSpect;                                                     /*  spectrum minimum frequency upstream */
    uint8 uc_2C_UpMaxSpect;                                                     /*  spectrum maximum frequency upstream */
    uint8 uc_2C_DnMinSpect;                                                     /*  spectrum minimum frequency downstream */
    uint8 uc_2C_DnMaxSpect;                                                             /*  spectrum maximum frequency downstream */

    /*---- G.992.3x specific  ---- */

    Adsl2AllInfo_t *pta_G9923xInfo[NUM_G992_3_ANNEX_SUPPORTED];           /* substructure of BIS info */

    /*---- G.992.5x specific  ---- */

    Adsl2AllInfo_t *pta_G9925xInfo[NUM_G992_5_ANNEX_SUPPORTED];                 /* substructure of BIS info */
   //XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(Start)
   /* ---- G.993.1 / T1.424 specific NPar2 ---- */

   uint8 uc_SI_G993_1_NPar2;

   /* ---- G.993.2 specific NPar2 ---- */

   uint8 uc_SI_G993_2_NPar2_01;
   //XDSLRTFW-1624(START_END)
   uint8 uc_SI_G993_2_NPar2_02;
   //XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(End)

   // G.Fast specific
   G_Fast_Type_t G_Fast_Info; // XDSLRTFW-2298 (Start_End)

        // XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg (Start)
        uint8 uc_SI_SPar2_01;
        uint8 uc_SI_SPar2_02;
#ifdef VDSL2_HNDSHK
        uint8 uca_RFIBands[16*6];
#endif
        // XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg (End)
    /* ==== Non-Standard Information Field ==== */
    /* ==== country code and vendor ID shall be reused. ==== */
    uint8 uc_NumBlock;                                                                          /*  number of non-standard blocks */
    NonStandardBlock_t ta_NS_Info[MAX_NUM_NS_BLOCK];        /*  array of non-standard blocks */

    /* ==== Retransmission infomation block ==== */
    uint8 uc_last_received_msg_type;                                            /* REQ_RTX LCRM octet */
    uint8 uc_request_msg_segment_index;                                         /* REQ_RTX MSFN octet */

} InfoField_t;

#endif  /* _GHS_H */

