/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _GPERSISTENT_H
#define _GPERSISTENT_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1313 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  gpersistent.h
;
;  Header file for global variable declarations.
;
*****************************************************************************/
// ******************************************************************
// gpersistent.h
//
// History
//
// 16/04/2010 Nihar: Workaround for false configuration of VINAX 10.6 based SAG5630 DSLAM
//                    In DTAG lab SAG5630 shows very low DS rate because of CO-requested -16dB nomPSD
//                    Grep for IOP_DS_ALL_VINAX_ClearNomPSDRequirement
//
//
// 20/08/2010  Sriram Shastry: Added gft_disableAnnexL flag to disable
//                       AnnexL in mid loops against BRCM
//                      Grep for SMS00790593 IOP_DS_BRCM_BisPlus_DisableAnxL
//
// 19/04/2010 Nihar: For debugging purposes it's very helpfull to have information
//            about the previous exception state/code available. So, put previous
//            Exc.Code/State into persistent memory and map it to CMVs
//            cr STAT 22 0 -> Prev. Exception State
//            cr STAT 23 0 -> Prev. Exception Code
//            Grep for Feature_ALL_ALL_ALL_PrevExceptionsCMV
//
// 26/07/2010 Bhadra: Added "gft_USPerf_CNXT" variable.
//
// 20/08/2010  Sriram Shastry: Added flag and counter for CNXT D57 shortloop Tx cutpower
//                       Grep for SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut
//
//       Grep for SMS00881702 IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop
//
// 27/07/2010 Nihar/Bhadra: Send TI (TSTC) vendor-id along with TI's non-standard information
//                   when connecting against TI-AC7 and send Aware (AWRE) vend-id when
//                   connecting against CNXT in ADSL2/2+ mode after a reboot for better US performance.
//                   Grep for IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid
// 10/08/2010 Nihar: Added Persistent Memory Bit field variable while retraining reduce
//               the DS rate option in G.dmt/T1413 mode. This is done to avoid link hole.
//              Grep for PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions
//
// 19/08/2010 AdeelJ/Palaksh/Veena: Fix for ADSL2+ low US rates against Intracom CNXT DSLAM.
//               declare persistent memory flag gft_USPerf_Intracom_Gspn. This flag, when set, enables
//               the functionality of the US performance fix, including transmitting a wide REVERB signal
//               and applying half the PCBus requested by CO.
//               Grep for SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 09/02/2011 Sriram: Use the special TSSI set from SMS00910375 in the range of
//            2100m to 4200m to improve the US rates against CNXT DSLAMs with FW
//            version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 18/04/2011 Sriram: Use the special TSSI set to improve the US rates against CNXT DSLAMs with FW version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 9/09/2011 Anantha Ramu: Added feature to try GHS MAX_ALLOWED_GHS_FAILS times before trying T1413
//                         if T1413 is one of the configured modes in CPE.
//                         Grep for  XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL
//
// 21/11/2011 Hanyu: Ported MFD code to VRx. Declared NLNF CMV INFO 121 0/1/2 structure in persistent memory.
//            This feature is triggered by "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additinally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 23/12/2011 Sabrina Y/Balabath : To improve US performance, retrain and switch to Aware VID
//            for IKNS DSLAMs.
//            Grep for XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE
//
// 02/01/2012 Kannan: 25/08/2008 Sabrina Y.: Added flag gft_T1413_ACK_boost.
//                        In T1413 mode, R-ACK power level is boosted by 6 dB by default since some IFX
//                        CO has problem in detecting R-ACK at long loops with high noise. However,
//                        some STM COs are sensitive to this signal power and fail to detect R-Reverb1.
//                        So we have to toggle the level till C-Pilot1 off is detected.
//                        grep for SMS00801603 IOP_DS_ALL_T1413_PwrBoostPingPong
//
// 12/01/2012 Kannan: Added variable to enable
//            64pt IFFT emulation for TI & CNXT in T1413 mode.
//            Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
//
// 10/01/2012 ChihWen/Balabath: To improve the US/DS rate against NVLT-C in T1413 mode, the solutions are below.
//          1. When preparing the parameters in R-MsgsRA, search the best R which will achieve highest K (best net rate),
//                then set the parameters in R-MsgsRA accordingly.
//          After receiving R-MsgsRA, NVLT-C will send C-RatesRA with the first option of the R and K,
//                which are provided by CPE in R-MsgsRA.
//          Then CPE will select the first option from the C-RatesRA.
//          2. The channel response (HLin) on tone 33~38 could be (0,0), which will make channel extrapolation (DoFDExtrap)
//       incorrect because the extrapolation needs to convert the channel response on tone 33~38 to dB scale (ConvertToDB).
//       Then output will be saturated value (-31768, -32768). The saturated response (-32768, -32768) will make
//       frame sync and TDQ calculation incorrect.
//       The fix is to shift the indices of the reference tones in (DoFDExtrap) from tone 33~38 to tone 40~45, and also check the
//       zero response for the reference tones.
//          3. Change near-end vendor ID to "AWARE" to improve US rate.
//          4. NVLT-C will take about 550 symbols to transit from C-Pilot1 state to C-REVERB1 state after receiving R-REVERB1,
//       so adding 32 more symbols (512+16+32) for the transition from C-Pilot1 state to C-REVERB1 state.
//          Grep for XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement.
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 02/May/2013 Ram: Added variable/marker for persistent memory. Persistent memory will be cleared if the marker is corrupted/modified.
//                  Grep for XDSLRTFW-241: FIX_ALL_ALL_ALL_Clear_Persistent_Memory
//
// 29/08/2013 Prashant: Merged the fix for XDSLRTFW-772.
// Author of code changes: Hanyu
//    Added code to workaround CO tone detection issue on ECI M41 Vinax DSLAM in Annex B by boosting Tx power level:
//    (1) Boosting 4dB Tx tone power in G.hs when it fails at R_C_GALF1_RX state for loops > 3.5km with PAG setting > 0x1A00dB.
//    (2) Restoring it back to the original power level after G.hs for ADSL2/2+ and ADSL1.
//    (3) Fine-tuned the workaround code (ADSLRTFW-1253) to boost training Tx signal power level by 1.5dB on loops > 3.7km and
//        by 2.5dB on loops > 3.9km when previous exception code is E_CODE_GHS_TONE_LOSS_OR_TIME_OUT or E_CODE_RCReverb3Rx_bis_SignalEnd_Failure.
//    (4) Calibrated the loop length estimation based on the PGA setting in R_C_GALF1_RX state.
//        Above changes are not controlled by CMV bit on DTAG FW branch. Suggest adding a new CMV bit in mainline code to narrow down side effect.
//        Grep for  XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower
//
// 18/11/2014 : Vinay : Added a new CMV (INFO 241) to capture the configuration of ADSL as a debug feature.
//       Grep for XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES
//
// 24/03/14 Hanyu: Ported ADSLRTFW-745 (SMS00778928): Retrain for CTLM VID so that we can send the TI VID
//                 Grep for: XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID
//
// 10/04/2014 Sriram Shastry: To avoid showtime link drop and long training time against ECI/Pulsecom DSLAM
//      at AT&T lab with AT&T capped US/DS lower data rates profiles, the following changes are introduced:
//      (1) US Tx powercutback by 4dB on all loops to avoid US linkdrop.
//      (2) Preferred to select pilot tone #48 and reduced the pilot power threshold
//          to avoid US/DS link drop due to polit tone corruption.
//      (3) Limited US max bits/bin to 8.
//      The above changes are protected by PLSE CO vendor ID and CMV
//      info 103 26 0x0800 with default value 0 (Disabled).
//      Enabling the CMV bit may introduce side-effects for both US and DS performance.
//      It is only recommended for AT&T profiles with the capped US/DS lower data rates
//      attached in the Jira entry.
//         Grep for ADSLRTFW-1412 IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
// 10/04/2014 Sriram Shastry: To avoid showtime link drop and long training time against ECI/Pulsecom DSLAM
//      at AT&T lab with AT&T capped US/DS lower data rates profiles, the following changes are introduced:
//      (1) US Tx powercutback by 4dB on all loops to avoid US linkdrop.
//      (2) Preferred to select pilot tone #48 and reduced the pilot power threshold
//          to avoid US/DS link drop due to polit tone corruption.
//      (3) Limited US max bits/bin to 8.
//      The above changes are protected by PLSE CO vendor ID and CMV
//      info 103 26 0x0800 with default value 0 (Disabled).
//      Enabling the CMV bit may introduce side-effects for both US and DS performance.
//      It is only recommended for AT&T profiles with the capped US/DS lower data rates
//      attached in the Jira entry.
//         Grep for ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
//  30/3/2015 Sriram Shastry:Jira XDSLRTFW-1843 :CPE  is unable to  link in ADSL2/ADSL2P under Multi-mode configuration.
//  Solution is force CPE  to  G.DMT  mode after 3 fails attempts during  training in ADSL2/ASDL2P mode.
//    Grep for  XDSLRTFW-1843
//
// 20/12/2017 Stefan Krause:  XDSLRTFW-3665 : Previous Failstate / Previous Exception Code
// - complete Failstate info is available in the following link in gt_FailStateInfo_Prev
// - gt_FailStateInfo_Prev is mapped to DSL_PREV_FAILSTATE (DSL_37)
// - the failstate history of the last 5 exceptions is mapped to DSL_PREV_EXCEPTION_CODES (DSL_38)
//     Grep for XDSLRTFW-3665
//
// ******************************************************************

#include <stdio.h>
#include "common.h"
#include "rt_state.h"
#include "ifft_fix.h"
#include "typedef.h"
#include "typedef_bis.h"
#include "aoc.h"
#include "eoc.h"
#include "ib.h"
#include "const_bis.h"
#include "rt_tones.h"
#include "ghs.h"

//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
#ifndef  ISDN  // Only for Annex - A
extern uint8 guc_Ghs_fails_count;
extern uint8 guc_T1413_links_before_try_GHS;
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop  (START_END)
extern FlagT gft_workaround_ECI_PLSE;
extern FlagT gft_pAnnexLBTLoops_CNXT;
#endif // #ifndef ISDN
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)
// Selected Mode
extern int32 gl_SelectedMode;

//XDSLRTFW-241: FIX_ALL_ALL_ALL_Clear_Persistent_Memory (Start - End)
extern int32 gl_Test_Persistmem;
extern int32 gl_Test_Persistmem_Vdsl;
extern int32 gl_Test_Persistmem_Common;
extern HercADSL_FailStateInfo_t         gt_HercADSL_STATMap_FailureState;
//XDSLRTFW-2191(Start)
extern int32 gl_ADSL_Annex_Mode;
#ifndef ISDN
extern FlagT gft_hsk_tone_power_dB_12KftADSL_Above;
#endif
extern FlagT gft_showtime_tc_sync__ADSL_Mode;
// XDSLRTFW-2191(End)
// XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (START)
extern uint16 gus_workaround_bits;     // this variable is intended to indicate whether a specific workaround is enabled or not
                                      // this saves memory / cycles when the decision is made in a stack of if clauses
// XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (END)

// HANDSHAKE PARAMETERS
// Variables associated with CO identification.
// We may add new CO vendors here (if they require some kind of FW customization from our part),
// or add multiple variants of an existing CO vendor (newer versions etc., if they populate
// such fields in G.hs or C_Msgs1)
extern int16 gs_CurrentCoChipset ;  // set of values to be used defined below:
extern int16 gs_CurrentCoVendorID ; // Co vendor ID
//XDSLRTFW-1843(Start)
extern uint8 guc_IFTN_CRC_MISMATCH_ERR_cnt;
extern uint8 guc_IFTN_DMT_T1413_Train_Cnt;
//XDSLRTFW-1843(End)
extern int8 gc_GhsDS_PCB;        // DS PCB used by CO during G.hs, or at least for CL (carrier set A43).  Format is 5.1 (dB).
// The G9941 vendor ID is received during G.hs.
extern uint8 guca_fe_G9941_VendorID[VENDOR_ID_LENGTH];
extern FlagT gft_NoVDSL_CLR;     //XDSLRTFW-1080 : IOP_GHS_WorkAround (start_end)
// Bis Info for post handshake
#ifdef ENABLE_ALL_HDLC_OVHD
extern Adsl2AllInfo_t gt_BisInfoSave;
#endif
// Flag indicating use of tones 1 to 32 in Annex B
extern FlagT gft_Tones1To32Support;
extern FlagT gft_EnterL3afterNextReboot;
// PMS variables
extern uint8 guca_DS_TransferMode_bis[NUM_DS_BEARER_CHANNELS_SUPPORTED];
extern uint8 guca_US_TransferMode_bis[NUM_US_BEARER_CHANNELS_SUPPORTED];
extern HandshakeBis_t gt_HandshakeBis ;

extern OffsetInfo_t gt_StructureSizeInfo;

// PMD variables
extern PMDControl_t gt_TxPMDControl;

// TRAIN PARAMETERS
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): Increase QLN points to 512
extern int32 gl_HsPLLFreqOffset;
#ifdef ISDN     // Only for Annex-B
// IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (Start_End)
//  - US-PCB starting from G.Hs signal
extern int16 gs_Persis_CurrGHsTxPCB;
// IOP_US_ALL_ADI930_AddNoiseToTxMedley (Start_End)
extern int16 gs_Persis_CurrTxNoiseLevel;
// IOP_DS_DMT_ADI_SendNcloadedEqualToZero (Start_End)
extern int16 gs_Persis_TargetSNRMrg;
// IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (Start_End)
extern int16 gs_Persis_CurrReverbTxPCB;
// XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (START_END)
extern FlagT gft_workaround_ECIM41_VNX;

#else       // Only for Annex-A
// PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions (Start)
#define REDUCE_BMAX_IN_RMSGRA_FOR_ADSL1    (0x0001)
extern uint16 gus_Persistent_UserDefBits;
// PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions (End)
#endif      // ifndef ISDN
#ifndef ISDN   // Only for Annex-A
// AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid (Start)
//IOP_DS_ALL_CNXT_BoostGhsToneDetectScale_ForceDmtT1413inLongLoop (Start_End)
extern FlagT gft_USPerf_CNXT;
extern uint8 guc_T1413_relink_count;
extern FlagT gft_USPerf_AC7;
extern FlagT gft_DSPerf_CNXT;
// AR8_TF: IOP_US_BisPlus_TI&CNXT_Send-TSTC-or-AWRE-vendid(End)
//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
extern FlagT gft_USPerf_Intracom_Gspn;
//XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (Start_End)
// extern FlagT gft_USPerf_Midloop_Gspn;
// SMS00805497 IOP_DS_BisPlus_CNXT_SRAFailGhsNonStandard (Start_End)
extern FlagT gft_SRAIop_CNXT;
// SMS00868975 BugFix_DS_BisPlus_CNXT_SRA (START_END)
extern FlagT gft_StartDMT_CNXT;
//SMS00801603 IOP_DS_ALL_T1413_PwrBoostPingPong (START_END)
// flag to boost R-ACK level by 6dB in T1413 mode, default is 1
extern FlagT gft_T1413_ACK_boost;
// R3_P1: AR8_TF: PERF_US_T1413_T1&CNXT_64ptIFFT (START - END)
extern FlagT gft_Enable_IFFT64_T1413;
#endif

// Feature_ALL_ALL_ALL_PrevExceptionsCMV (Start_End)
extern uint16 gus_ExceptionCode_Persis, gus_ExceptionState_Persis;

// G.HS Tssi Info
extern GHS_USTssiInfo_t gt_GHS_USTssiInfo;
extern GHS_DSTssiInfo_t gt_GHS_DSTssiInfo;
// IOP_DS_ALL_VINAX_ClearNomPSDRequirement (Start_End)
//SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut (START)
//SMS00822444 IOP_DS_ADSL1_CTLM_ShortLoopTxPowercut (START_END)
//Renamed flag as this is applied to other CO
extern uint16 gus_shortloop_cutpower;
extern FlagT gft_shortloop_cutpower_counter;
extern FlagT gft_RemotePAF_Enable;
//SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut (END)
extern int16 gs_Persis_PrevDSNomPSD;

extern FlagT gft_WorkAround_CTLM_chipset; //Sriram : Flag for Debug Purpose
//XDSLRTFW-243 IOP_A_US_ALL_IKNS_SwitchToAWRE (START_END)
extern FlagT gft_WorkAround_IKNS_US_Perf;
//XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START_END)
extern FlagT gft_NVLTC_T1413_fix;
//XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (START_END)
extern FlagT gft_USCRC_CTLM;
// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
extern Debug_ProfileInfo_t gt_Decoded_ProfileInfo_t;
// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

// IOP_DS_BRCM_BisPlus_DisableAnxL (START_END)
// Sriram flag to disable AnnexL in mid loops against BRCM
#ifndef ISDN
extern FlagT gft_disableAnnexL;
#endif


// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
extern NlnfInfo_t gt_nlnf_metrics_ibs;
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)

//XDSLRTFW-1983
extern FlagT gft_ATM_PTM_MisMatch_TTNet;
extern uint16 gus_VendorSpecific_Info;
//XDSLRTFW-1983

extern uint32 gul_DSH_SymCount;
extern uint32 gula_FailStateHistory[5];       //XDSLRTFW-3665
#endif /*  _GPERSISTENT_H */


