/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _HNDSHK_DATA_H
#define _HNDSHK_DATA_H

/**********************************************************************
*
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:        781.276.4000
* FAX:              781.276.4001
* WEB:              http://www.aware.com
*
* FILE:             hndshk_Data.h
* DESCRIPTION:      Header file for hndshk_Data.c.
*
**********************************************************************/
// ******************************************************************
// hndshk_Data.h
//
// History
// 15/07/2011 Kannan: T1413 bring up and T1413 mode loop length estimation.
//           Grep for XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup
//
// 9/09/2011 Anantha Ramu: Added feature to try GHS MAX_ALLOWED_GHS_FAILS times before trying T1413
//                         if T1413 is one of the configured modes in CPE.
//                         Grep for  XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL
//
//
// 20/08/2010 Sriram Shastry: Fix for disabling the detection of B43 and J43 carrier set with OPTN 25, bitmask 0x4000.
//    By default, this cmv bit is one (enable the detection). Besides the fix, in addition to the B43 detection in C-TONES,
//    which is based on power difference between B43 tones and its neighboring tones, we also use B43
//    carrier set to decode C-GLAF1 and C-FLAG1 to double confirm if B43 tones are really transmitted from CO site.
//    Only if B43 carrier set are detected in C-TONES, and C-GLAF1 and C-FLAG1 are correctly decoded, then we think
//    B43 are really transmitted from CO site. It also means CO may support AnnexM mode.
//    Grep for SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection
//
// 30/12/2011 Sriram Shastry : Indicate VDSL2 annex bit and the corresponding Full CLR code points in handshake  during Full CLR message
//    Grep for XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg
// 13/03/2012 Kannan: 06/04/2010 Bhadra:   Added code for uinversal ReTx(G.inp section A.2.2) as per Amd5 of G.HS.
//                      Added variables gft_ReTx_ATM_PTM,gft_ReTx_MS_incorrect for validity of MS message in UnivReTx.
//                      Grep for SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod to see changes.
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 29/08/2013 Prashant: Merged the fix for XDSLRTFW-772.
// Author of code changes: Hanyu
//    Added code to workaround CO tone detection issue on ECI M41 Vinax DSLAM in Annex B by boosting Tx power level:
//    (1) Boosting 4dB Tx tone power in G.hs when it fails at R_C_GALF1_RX state for loops > 3.5km with PAG setting > 0x1A00dB.
//    (2) Restoring it back to the original power level after G.hs for ADSL2/2+ and ADSL1.
//    (3) Fine-tuned the workaround code (ADSLRTFW-1253) to boost training Tx signal power level by 1.5dB on loops > 3.7km and
//        by 2.5dB on loops > 3.9km when previous exception code is E_CODE_GHS_TONE_LOSS_OR_TIME_OUT or E_CODE_RCReverb3Rx_bis_SignalEnd_Failure.
//    (4) Calibrated the loop length estimation based on the PGA setting in R_C_GALF1_RX state.
//        Above changes are not controlled by CMV bit on DTAG FW branch. Suggest adding a new CMV bit in mainline code to narrow down side effect.
//        Grep for  XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower
//
// 10/25/2016 Abu Rahman: XDSLRTFW-2882 : Wrong HS tone selection in case of DPBO (ADSL)
//          A new CTone Detection algorithm is developed which uses Average power of the CTones and their neighboring tones
//            instead of Average constellations of those tones (used in previous implementation).
//            New Tone Detection algorithm is described in GhsCToneDetectionAlgorithm() section.
//            Grep for XDSLRTFW-2882
//
// ******************************************************************
#include "typedef.h"
#include "ghs.h"
#include "data_alloc.h" /*** For Socrates ***/
#include "typedef_bis.h"

int16 MapInputtoINP_CLR(int16 s_inputMinINP);




/**********************************************************************
* VARIABLES
**********************************************************************/
extern HandShakeControl_t  gt_hsc;     /*  handshake control structure */
// Flag indicate the reason code that cause CLR resend
extern FlagT  gft_SendShortCLR;
// Flag indicate the first CL message or not
extern FlagT gft_FirstCL;
// Flag indicate the VDSL modes are set in CL
extern FlagT gft_VDSL_set;


// Used for online detection of GHS carrier set
extern int16 gs_DetectGhsCarrierSet_State, gs_DetectGhsCarrierSet_AccumCount;
extern int16 gft_DetectGhsCarrierSet_TonesDetected;
extern int16 gsa_DetectGhsCarrierSet_DetectCount[NUM_UNIQUE_DS_GHS_CARRIERS_SETS];
extern const int16 gsa_UpCarSetA43_J43_A43c[];  /*  subcarriers in the A43/J43/A43c upstream carrier set of the 4.3125 kHz signalling family */
extern const int16 gsa_UpCarSetB43[];        /*  subcarriers in the B43 upstream upstream carrier set of the 4.3125 kHz signalling family */
extern const int16 gsa_DnCarSetA43[];        /*  subcarriers in the A43 downstream carrier set of the 4.3125 kHz signalling family */
extern const int16 gsa_DnCarSetB43_J43[];    /*  subcarriers in the B43/J43 downstream upstream carrier set of the 4.3125 kHz signalling family */
extern const int16 gsa_DnCarSetA43c[];       /*  subcarriers in the A43c downstream carrier set of the 4.3125 kHz signalling family */
extern const int16 gsa_UpCarSetC43[];        /*  subcarriers in the C43 upstream carrier set of the 4.3125 kHz signalling family */
extern const int16 gsa_DnCarSetC43[];        /*  subcarriers in the C43 downstream upstream carrier set of the 4.3125 kHz signalling family */
extern const int16 *gsa_DnCarSet;

//XDSLRTFW-2882 : Wrong HS tone selection (Start)
extern uint32 gula_GhsTonePower[];
extern uint32 gula_GhsToneNoisePower[];
extern GhsCToneInfo_t gt_GhsCToneInfo[];
//XDSLRTFW-2882 : Wrong HS tone selection (End)
extern int16 gs_DetectedCTones;
extern int16 gsa_ChannelEstimateBkp[1024];
//XDSLRTFW-3706 VRx518 R4 ADSL AnnexA compilation problem (Start)
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
extern Complex_t gt_RxCurrentSymbol_B43[NUM_CARRIERS_IN_SET];  /* current bit symbol for RX */
extern Complex_t gt_RxLastSymbol_B43[NUM_CARRIERS_IN_SET]; /* last bit symbol for RX */
extern Complex_t gta_RxSymbolBuf_B43[NUM_CARRIERS_IN_SET][RX_SYMBOL_BUF_SIZE];
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (End)
//XDSLRTFW-3706 VRx518 R4 ADSL AnnexA compilation problem (End)


extern Complex_t gt_RxCurrentSymbol[]; /*  current bit symbol for RX */
extern Complex_t gt_RxLastSymbol[];    /*  last bit symbol for RX */
extern int16 gs_TxAn_Prev;          /*  last bit symbol for xceiver */
extern uint8 guc_TxOctet;           /*  Octet buffers for Tx */
extern uint8 guc_RxOctet;           /*  Octet buffers for Rx */
//SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START_End)
#ifndef ISDN
extern uint8 guc_RxOctet_B43;
#endif

extern int16 gs_ReAlignSubState;    /*  substate variable */
extern int16 gs_RxSymCnt;           /*  RX symbol count */
extern FlagT gft_SymbolReAlignRequired; /*  flag indicating symbol re-alignment is required */
extern int16 gs_TxOctetCnt;            /*  counts number of octets in a given TxSubState */
extern int16 gs_RxOctetCnt;            /*  counts number of octets in a given RxSubState */
extern uint8 guc_RxGalfCnt;            // counts the number of C_GALF2 octets

// Flag to indicate to set up or not to set up the Spar1 bit of ID field with Relative power
// levels of A43c and J43 carriers
extern FlagT gft_SkipSetUpOfA43cJ43_InIDField;

/* ---- message arrays ---- */
extern uint8* gpuca_RxMsgBuf; /*  received octets are first stored in this buffer */
extern uint8* gpuca_DecodeBuf;   /*  message decoding is performed on this buffer */
extern uint8* gpuca_TxMsgBuf; /*  current message segment being transmitted */
extern int16 gs_TxMsgBufCnt;  /*  number of octets in a message to be transmitted */
extern int16 gs_RxMsgBufCnt;  /*  number of octets of a received message frame segment */
extern int16 gs_DecodeBufCnt; /*  number of octets in a total message being decoded */

/* ---- structures containing information fields ---- */
extern InfoField_t* gpt_RxInfo;     /*  received information structure */
extern InfoField_t* gpt_RxInfoSave; /*  to save a RxInfo for monitoring purpose */
extern InfoField_t* gpt_TxInfo;     /*  information structure to be transmitted */
extern InfoField_t* gpt_TxInfoSave; /*  to save a TxInfo for monitoring purpose */

/* ---- Buffer that contains all the necessary global data memory in handshake ---- */
/* It includes RxMsgBuf, DecodeBuf, TxMsgBuf, RxInfo, RxInfoSave, TxInfo, TxInfoSave */
/* and the Vendor Spec contained in each InfoField_t structure */
extern uint8 guca_HndshkBuf[8600];  // Assign 8KB for now. The maximum size of handshake buffer is 6,344bytes
extern uint8 gft_WholeTxMsgComplete; /* flag indicate that we have whole tx msg complete or not. TRUE: complete */
extern int16 gs_MsgOctetCnt;         /* the actual msg octet count in transmision */
extern int16 gs_MsgOffset; // msg segment offset, we have to record the offset of each msg segment in the actual complete msg
extern int16 gs_MaxMsgLen; /*  maximum message length */
extern uint8 guc_TxHSMsg_SegmentCnt;  // Tx Msg Segment counter
extern uint8 guc_RxHSMsg_SegmentCnt;  // Rx Msg Segment counter
extern FlagT gft_TxRetransmit_Msg;     // Flag indicate we are requested to retransmit last msg segment
extern FlagT gft_RxRetransmit_Msg;     // Flag indicate we received the retransmitted msg segment we ask for
extern uint8 guc_RxHSReqRtx_cnt;    // The received HS REQ_RTX msg counter
extern uint8 guc_TxHSReqRtx_cnt;    // The transmitted HS REQ_RTX msg counter

//Mode capabilities contained in CO's first  CL message.
extern uint8 guca_FE_ModeCapabilities[6];

#ifdef   ISDN

//      WN --> -140dBm/Hz white noise
//      hsk_tone_power_dB
//
//      loop(m)      | WN_Splitter,BRCM MUC     |  WN_no_Splitter,gmx MUC     |
//      ---------------|--------------------------------------|------------------------------------------|
//                   |   gs_hsk_tone_power_dB   |    gs_hsk_tone_power_dB        |
//-------------------//--------------------------------------//-----------------------------------------//
//      0  ------------|------------ 0x5453---------------|----- 0x5626---------------|
//      100 ---------|-------------- 0x52A2---------------|----- 0x54C0---------------|
//      200    --------|-------------- 0x51B8---------------|----- 0x5338---------------|
//      300    --------|-------------- 0x5025---------------|----- 0x525F---------------|
//      400    --------|-------------- 0x4DDA---------------|----- 0x4E7F---------------|
//      500    --------|-------------- 0x4C72---------------|----- 0x464D---------------|
//      600 ---------|-------------- 0x4AF9---------------|----- 0x4220---------------|
//      700 ---------|-------------- 0x4908---------------|----- 0x3DCF---------------|
//      800 ---------|-------------- 0x478B---------------|----- 0x39ED---------------|
//      900 ---------|-------------- 0x45F6---------------|----- 0x35C7---------------|
//      1000 -------|--------------- 0x447A---------------|----- 0x320D---------------|
//      1100 -------|--------------- 0x4297---------------|----- 0x2E0D---------------|
//      1200 -------|--------------- 0x4130---------------|----- 0x2A31---------------|
//      1300 -------|--------------- 0x3FAE---------------|----- 0x2614---------------|
//      1400 -------|--------------- 0x3DE5---------------|----- 0x2233---------------|
//      1500 -------|--------------- 0x3C83---------------|----- 0x1E0A---------------|
//      1600 -------|--------------- 0x3AC7---------------|----- 0x1E0A---------------|
//      1700 -------|--------------- 0x395E---------------|----- 0x1694---------------|
//      1800 -------|--------------- 0x37DC---------------|----- 0x1344---------------|
//      1900 -------|--------------- 0x3626---------------|----- 0x1344---------------|
//      2000 -------|--------------- 0x34AC---------------|----- 0x1344---------------|
//      2100 -------|--------------- 0x3344---------------|----- 0x1344---------------|
//      2200 -------|--------------- 0x3166---------------|----- 0x1344---------------|
//      2300 -------|--------------- 0x2FE2---------------|----- 0x1344---------------|
//      2400 -------|--------------- 0x2E38---------------|----- 0x1344---------------|
//      2500 -------|--------------- 0x2CCB---------------|----- 0x1344---------------|
//      2600 -------|--------------- 0x2AF6---------------|----- 0x1344---------------|
//      2700 -------|--------------- 0x299A---------------|----- 0x1344---------------|
//      2800 -------|--------------- 0x2817---------------|----- 0x1344---------------|
//      2900 -------|--------------- 0x2661---------------|----- 0x1344---------------|
//      3000 -------|--------------- 0x24BE---------------|----- 0x1344---------------|
//      3100 -------|--------------- 0x233F---------------|----- 0x1344---------------|
//      3200 -------|--------------- 0x21A4---------------|----- 0x1344---------------|
//      ---------------------------------------------------------------------------------------------
//
//      Based on this data some loop lenghts are defined
//
#define MINIMUM_GHS_TONE_PWR_AT_0M      0x5453
#define MINIMUM_GHS_TONE_PWR_AT_100M    0x52A2
#define MINIMUM_GHS_TONE_PWR_AT_200M    0x51B8
#define MINIMUM_GHS_TONE_PWR_AT_300M    0x5025
#define MINIMUM_GHS_TONE_PWR_AT_400M    0x4DDA
#define MINIMUM_GHS_TONE_PWR_AT_500M    0x4C72
#define MINIMUM_GHS_TONE_PWR_AT_600M    0x4AF9        // 19193       74.97 dB
#define MINIMUM_GHS_TONE_PWR_AT_700M    0x4908
#define MINIMUM_GHS_TONE_PWR_AT_800M    0x478B
#define MINIMUM_GHS_TONE_PWR_AT_900M    0x45F6
#define MINIMUM_GHS_TONE_PWR_AT_1000M  0x447A
#define MINIMUM_GHS_TONE_PWR_AT_1100M  0x4297
#define MINIMUM_GHS_TONE_PWR_AT_1200M  0x4130         // 16688       65.19 dB
#define MINIMUM_GHS_TONE_PWR_AT_1300M  0x3FAE
#define MINIMUM_GHS_TONE_PWR_AT_1400M  0x3DE5
#define MINIMUM_GHS_TONE_PWR_AT_1500M  0x3C83
#define MINIMUM_GHS_TONE_PWR_AT_1600M  0x3AC7
#define MINIMUM_GHS_TONE_PWR_AT_1700M  0x395E
#define MINIMUM_GHS_TONE_PWR_AT_1800M  0x37DC
#define MINIMUM_GHS_TONE_PWR_AT_1900M  0x3626
#define MINIMUM_GHS_TONE_PWR_AT_2000M  0x34AC         // 13484       52.67 dB
#define MINIMUM_GHS_TONE_PWR_AT_2100M  0x3344
#define MINIMUM_GHS_TONE_PWR_AT_2200M  0x3166
#define MINIMUM_GHS_TONE_PWR_AT_2300M  0x2FE2
#define MINIMUM_GHS_TONE_PWR_AT_2400M  0x2E38
#define MINIMUM_GHS_TONE_PWR_AT_2500M  0x2CCB
#define MINIMUM_GHS_TONE_PWR_AT_2600M  0x2AF6
#define MINIMUM_GHS_TONE_PWR_AT_2700M  0x299A
#define MINIMUM_GHS_TONE_PWR_AT_2800M  0x2817
#define MINIMUM_GHS_TONE_PWR_AT_2900M  0x2661
#define MINIMUM_GHS_TONE_PWR_AT_3000M  0x24BE
#define MINIMUM_GHS_TONE_PWR_AT_3100M  0x233F
#define MINIMUM_GHS_TONE_PWR_AT_3200M  0x21A4
#define MINIMUM_GHS_TONE_PWR_AT_3300M  0x1D7A
#define MINIMUM_GHS_TONE_PWR_AT_3400M  0x1BE0
#define MINIMUM_GHS_TONE_PWR_AT_3500M  0x1A4A
#define MINIMUM_GHS_TONE_PWR_AT_3600M  0x1889
#define MINIMUM_GHS_TONE_PWR_AT_3700M  0x1712
#define MINIMUM_GHS_TONE_PWR_AT_3800M  0x167D
#define MINIMUM_GHS_TONE_PWR_AT_3900M  0x1496
#define MINIMUM_GHS_TONE_PWR_AT_4000M  0x1373

#define HSK_TONE_PWR_TO_FORCE_0_HYB  MINIMUM_GHS_TONE_PWR_AT_300M
// XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (Start)
//      WN --> -140dBm/Hz white noise
//      hsk_tone_power_dB
//
//      loop(m)         | WN_Splitter?,ECI/M41/VinaxV1.4 MUC   | WN_Splitter?, GMX MUC TBD
//      ---------------|--------------------------------------|-----------------------|
//                      |   gs_hsk_tone_power_dB            |    gs_hsk_tone_power_dB     |
//-------------------//-----------------------------------//--------------------------//
//      50 ----------|-------------- 0x593F---------------|----- 0x5626---------------|
//      100 ---------|-------------- 0x---------------|----- 0x54C0---------------|
//      200    --------|-------------- 0x---------------|----- 0x5338---------------|
//      300    --------|-------------- 0x---------------|----- 0x525F---------------|
//      400    --------|-------------- 0x---------------|----- 0x4E7F---------------|
//      500    --------|-------------- 0x---------------|----- 0x464D---------------|
//      600 ---------|-------------- 0x---------------|----- 0x4220---------------|
//      700 ---------|-------------- 0x---------------|----- 0x3DCF---------------|
//      800 ---------|-------------- 0x---------------|----- 0x39ED---------------|
//      900 ---------|-------------- 0x---------------|----- 0x35C7---------------|
//      1000 -------|--------------- 0x49DE---------------|----- 0x320D---------------|
//      1100 -------|--------------- 0x---------------|----- 0x2E0D---------------|
//      1200 -------|--------------- 0x---------------|----- 0x2A31---------------|
//      1300 -------|--------------- 0x---------------|----- 0x2614---------------|
//      1400 -------|--------------- 0x---------------|----- 0x2233---------------|
//      1500 -------|--------------- 0x---------------|----- 0x1E0A---------------|
//      1600 -------|--------------- 0x---------------|----- 0x1E0A---------------|
//      1700 -------|--------------- 0x---------------|----- 0x1694---------------|
//      1800 -------|--------------- 0x---------------|----- 0x1344---------------|
//      1900 -------|--------------- 0x---------------|----- 0x1344---------------|
//      2000 -------|--------------- 0x399C---------------|----- 0x1344---------------|
//      3500 -------|--------------- 0x21A6---------------|----- 0x1344---------------|
//      3600 -------|--------------- 0x1FDB---------------|----- 0x1344---------------|
//      3700 -------|--------------- 0x1E62---------------|----- 0x1344---------------|
//      3800 -------|--------------- 0x1CDA---------------|----- 0x1344---------------|
//      3900 -------|--------------- 0x1B58---------------|----- 0x1344---------------|
//      4000 -------|--------------- 0x19B9---------------|----- 0x1344---------------|
//      4100 -------|--------------- 0x1850---------------|----- 0x1344---------------|
//      4200 -------|--------------- 0x1601---------------|----- 0x1344---------------|
//      2900 -------|--------------- 0x---------------|----- 0x1344---------------|
//      3000 -------|--------------- 0x---------------|----- 0x1344---------------|
//      3100 -------|--------------- 0x---------------|----- 0x1344---------------|
//      3200 -------|--------------- 0x---------------|----- 0x1344---------------|
//      --------------------------------------------------------------------------------------------
//
//      Based on this data some loop lenghts are defined
//
#define MINIMUM_GHS_TONE_PWR_AT_50M_ECIM41      0x593F
#define MINIMUM_GHS_TONE_PWR_AT_1000M_ECIM41    0x49DE
#define MINIMUM_GHS_TONE_PWR_AT_2000M_ECIM41    0x399C
#define MINIMUM_GHS_TONE_PWR_AT_3500M_ECIM41    0x21A6
#define MINIMUM_GHS_TONE_PWR_AT_3600M_ECIM41    0x1FDB
#define MINIMUM_GHS_TONE_PWR_AT_3700M_ECIM41    0x1E62
#define MINIMUM_GHS_TONE_PWR_AT_3800M_ECIM41    0x1CDA
#define MINIMUM_GHS_TONE_PWR_AT_3900M_ECIM41    0x1B58
#define MINIMUM_GHS_TONE_PWR_AT_4000M_ECIM41    0x19B9
#define MINIMUM_GHS_TONE_PWR_AT_4100M_ECIM41    0x1850
#define MINIMUM_GHS_TONE_PWR_AT_4200M_ECIM41    0x1601
// XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (End)

#else
/*
      ADSL AnxA: Measurement was done with PLUS Mode, 26AWG at BLRW0529 Test Setup
      WN --> -140dBm/Hz white noise
      hsk_tone_power_dB

                     WN, 26AWG  GMX BLR     |
      loop(ft)    | gs_hsk_tone_power_dB
      ------------|----------------------
      0   --------| 22469
      250 --------| 22200
      500 --------| 21920
      750 --------| 21661
      1000 -------| 21389
      1250 -------| 21120
      1500 -------| 20826
      1750 -------| 20561
      2000 -------| 20110
      2250 -------| 19843
      2500 -------| 19574
      2750 -------| 19341
      3000 -------| 19072
      3250 -------| 18613
      3500 -------| 18338
      3750 -------| 17966
      4000 -------| 17695
      4250 -------| 17210
      4500 -------| 16925
      4750 -------| 16654
      5000 -------| 16102
      5250 -------| 15836
      5500 -------| 15560
      5750 -------| 15287
      6000 -------| 15013
      6250 -------| 14771
      6500 -------| 14506
      6750 -------| 14220
      7000 -------| 13993
      7250 -------| 13720
      7500 -------| 13448
      7750 -------| 13190
      8000 -------| 13043
      8250 -------| 12784
      8500 -------| 12513
      8750 -------| 12224
      9000 -------| 11967
      9250 -------| 11689
      9500 -------| 11409
      9750 -------| 11142
      10000 ------| 10892
      10250 ------| 10598
      10500 ------| 10317
      10750 ------| 10066
      11000 ------| 9789
      11250 ------| 9520
      11500 ------| 9252
      11750 ------| 9005
      12000 ------| 8726
      12250 ------| 8699
      12500 ------| 8422
      12750 ------| 8157
      13000 ------| 8015
      13250 ------| 7736
      13500 ------| 7616
      13750 ------| 7353
      14000 ------| 7083
      14250 ------| 6807
      14500 ------| 6540
      14750 ------| 6261
      15000 ------| 6018
      15250 ------| 5742
      15500 ------| 5473
      15750 ------| 5200
      16000 ------| 4930
      16250 ------| 4657
      16500 ------| 4374
      16750 ------| 4106
      17000 ------| 3845
      17250 ------| 3564
      17500 ------| 3308
      17750 ------| 3043
      18000 ------| 2789
*/
/*
//XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup  (START)
In T1413 mode loop length estimation was done on the CReveille tone (Index 56) alone,
but in the case of ghs, loop length estimation is based on the avg power estimated across
A43 tones(40,56,64). T1413 Measurement was done in the same setup
'BLRW0529' = BLRW0479(Test PC changes) as it was done in Ghs mode.
Observation: 1 to 3.5 dB difference was observed < 4kft, beyond 4kft, T1413 loop length
estimation is as close to G.hs. Hence T1413 mode reuse the variable  "gs_hsk_tone_power_dB"
for training and showtime.
i.e gs_hsk_tone_power_dB = gs_t1413_crevelle_tone_power_dB;
Feet     Ghs Tone Pwr         T1413-CReveille(Tone 56)
===== ===================        ========================
      dB(Q8.8) dB          dB(Q8.8) dB          diff_dB(Ghs - T1413)
0        22469 87.77       22194 86.7        1.07
250         22200 86.72       21889 85.5        1.22
500         21920 85.63       21579 84.29       1.34
750         21661 84.61       21366 83.46       1.15
1000     21389 83.55       21041 82.19       1.36
1250     21120 82.5        20760 81.09       1.41
1500     20826 81.35       20446 79.87       1.48
1750     20561 80.32       20034 78.26       2.06
2000     20110 78.55       19727 77.06       1.49
2250     19843 77.51       19295 75.37       2.14
2500     19574 76.46       18861 73.68       2.78
2750     19341 75.55       18591 72.62       2.93
3000     19072 74.5        18154 70.91       3.59
3250     18613 72.71       17898 69.91       2.8
3500     18338 71.63       17630 68.87       2.76
3750     17966 70.18       17360 67.81       2.37
4000     17695 69.12       17088 66.75       2.37
4250     17210 67.23       16820 65.7        1.53
4500     16925 66.11       16569 64.72       1.39
4750     16654 65.05       16362 63.91       1.14
5000     16102 62.9        16091 62.86       0.04
5250     15836 61.86       15833 61.85       0.01
5500     15560 60.78       15564 60.8        -0.02
5750     15287 59.71       15297 59.75       -0.04
6000     15013 58.64       15025 58.69       -0.05
6250     14771 57.7        14763 57.67       0.03
6500     14506 56.66       14505 56.66       0
6750     14220 55.55       14225 55.57       -0.02
7000     13993 54.66       13974 54.59       0.07
7250     13720 53.59       13709 53.55       0.04
7500     13448 52.53       13440 52.5        0.03
7750     13190 51.52       13189 51.52       0
8000     13043 50.95       12913 50.44       0.51
8250     12784 49.94       12655 49.43       0.51
8500     12513 48.88       12389 48.39       0.49
8750     12224 47.75       12105 47.29       0.46
9000     11967 46.75       11851 46.29       0.46
9250     11689 45.66       11582 45.24       0.42
9500     11409 44.57       11307 44.17       0.4
9750     11142 43.52       11045 43.14       0.38
10000    10892 42.55       10800 42.19       0.36
10250    10598 41.4        10515 41.07       0.33
10500    10317 40.3        10245 40.02       0.28
10750    10066 39.32       9996  39.05       0.27
11000    9789  38.24       9722  37.98       0.26
11250    9520  37.19       9445  36.89       0.3
11500    9252  36.14       9179  35.86       0.28
11750    9005  35.18       8935  34.9        0.28
12000    8726  34.09       8656  33.81       0.28
12250    8699  33.98       8516  33.27       0.71
12500    8422  32.9        8244  32.2        0.7
12750    8157  31.86       7984  31.19       0.67
13000    8015  31.31       7846  30.65       0.66
13250    7736  30.22       7574  29.59       0.63
13500    7616  29.75       7338  28.66       1.09
13750    7353  28.72       7054  27.55       1.17
14000    7083  27.67       6937  27.1        0.57
14250    6807  26.59       6670  26.05       0.54
14500    6540  25.55       6377  24.91       0.64
14750    6261  24.46       6128  23.94       0.52
15000    6018  23.51       5863  22.9        0.61
15250    5742  22.43       5621  21.96       0.47
15500    5473  21.38       5336  20.84       0.54
15750    5200  20.31       5045  19.71       0.6
16000    4930  19.26       4786  18.7        0.56
16250    4657  18.19       4514  17.63       0.56
16500    4374  17.09       4235  16.54       0.55
16750    4106  16.04       3902  15.24       0.8
17000    3845  15.02       3724  14.55       0.47
17250    3564  13.92       3443  13.45       0.47
17500    3308  12.92       3252  12.7        0.22
17750    3043  11.89       2889  11.29       0.6
18000    2789  10.89       2608  10.19       0.7
//XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup  (END)
*/

#define MINIMUM_GHS_TONE_PWR_AT_0F     22469
#define MINIMUM_GHS_TONE_PWR_AT_250F   22200
#define MINIMUM_GHS_TONE_PWR_AT_500F   21920
#define MINIMUM_GHS_TONE_PWR_AT_750F   21661
#define MINIMUM_GHS_TONE_PWR_AT_1000F  21389
#define MINIMUM_GHS_TONE_PWR_AT_1250F  21120
#define MINIMUM_GHS_TONE_PWR_AT_1500F  20826
#define MINIMUM_GHS_TONE_PWR_AT_1750F  20561
#define MINIMUM_GHS_TONE_PWR_AT_2000F  20110
#define MINIMUM_GHS_TONE_PWR_AT_2250F  19843
#define MINIMUM_GHS_TONE_PWR_AT_2500F  19574
#define MINIMUM_GHS_TONE_PWR_AT_2750F  19341
#define MINIMUM_GHS_TONE_PWR_AT_3000F  19072
#define MINIMUM_GHS_TONE_PWR_AT_3250F  18613
#define MINIMUM_GHS_TONE_PWR_AT_3500F  18338
#define MINIMUM_GHS_TONE_PWR_AT_3750F  17966
#define MINIMUM_GHS_TONE_PWR_AT_4000F  17695
#define MINIMUM_GHS_TONE_PWR_AT_4250F  17210
#define MINIMUM_GHS_TONE_PWR_AT_4500F  16925
#define MINIMUM_GHS_TONE_PWR_AT_4750F  16654
#define MINIMUM_GHS_TONE_PWR_AT_5000F  16102
#define MINIMUM_GHS_TONE_PWR_AT_5250F  15836
#define MINIMUM_GHS_TONE_PWR_AT_5500F  15560
#define MINIMUM_GHS_TONE_PWR_AT_5750F  15287
#define MINIMUM_GHS_TONE_PWR_AT_6000F  15013
#define MINIMUM_GHS_TONE_PWR_AT_6250F  14771
#define MINIMUM_GHS_TONE_PWR_AT_6500F  14506
#define MINIMUM_GHS_TONE_PWR_AT_6750F  14220
#define MINIMUM_GHS_TONE_PWR_AT_7000F  13993
#define MINIMUM_GHS_TONE_PWR_AT_7250F  13720
#define MINIMUM_GHS_TONE_PWR_AT_7500F  13448
#define MINIMUM_GHS_TONE_PWR_AT_7750F  13190
#define MINIMUM_GHS_TONE_PWR_AT_8000F  13043
#define MINIMUM_GHS_TONE_PWR_AT_8250F  12784
#define MINIMUM_GHS_TONE_PWR_AT_8500F  12513
#define MINIMUM_GHS_TONE_PWR_AT_8750F  12224
#define MINIMUM_GHS_TONE_PWR_AT_9000F  11967
#define MINIMUM_GHS_TONE_PWR_AT_9250F  11689
#define MINIMUM_GHS_TONE_PWR_AT_9500F  11409
#define MINIMUM_GHS_TONE_PWR_AT_9750F  11142
#define MINIMUM_GHS_TONE_PWR_AT_10000F 10892
#define MINIMUM_GHS_TONE_PWR_AT_10250F 10598
#define MINIMUM_GHS_TONE_PWR_AT_10500F 10317
#define MINIMUM_GHS_TONE_PWR_AT_10750F 10066
#define MINIMUM_GHS_TONE_PWR_AT_11000F 9789
#define MINIMUM_GHS_TONE_PWR_AT_11250F 9520
#define MINIMUM_GHS_TONE_PWR_AT_11500F 9252
#define MINIMUM_GHS_TONE_PWR_AT_11750F 9005
#define MINIMUM_GHS_TONE_PWR_AT_12000F 8726
#define MINIMUM_GHS_TONE_PWR_AT_12250F 8699
#define MINIMUM_GHS_TONE_PWR_AT_12500F 8422
#define MINIMUM_GHS_TONE_PWR_AT_12750F 8157
#define MINIMUM_GHS_TONE_PWR_AT_13000F 8015
#define MINIMUM_GHS_TONE_PWR_AT_13250F 7736
#define MINIMUM_GHS_TONE_PWR_AT_13500F 7616
#define MINIMUM_GHS_TONE_PWR_AT_13750F 7353
#define MINIMUM_GHS_TONE_PWR_AT_14000F 7083
#define MINIMUM_GHS_TONE_PWR_AT_14250F 6807
#define MINIMUM_GHS_TONE_PWR_AT_14500F 6540
#define MINIMUM_GHS_TONE_PWR_AT_14750F 6261
#define MINIMUM_GHS_TONE_PWR_AT_15000F 6018
#define MINIMUM_GHS_TONE_PWR_AT_15250F 5742
#define MINIMUM_GHS_TONE_PWR_AT_15500F 5473
#define MINIMUM_GHS_TONE_PWR_AT_15750F 5200
#define MINIMUM_GHS_TONE_PWR_AT_16000F 4930
#define MINIMUM_GHS_TONE_PWR_AT_16250F 4657
#define MINIMUM_GHS_TONE_PWR_AT_16500F 4374
#define MINIMUM_GHS_TONE_PWR_AT_16750F 4106
#define MINIMUM_GHS_TONE_PWR_AT_17000F 3845
#define MINIMUM_GHS_TONE_PWR_AT_17250F 3564
#define MINIMUM_GHS_TONE_PWR_AT_17500F 3308
#define MINIMUM_GHS_TONE_PWR_AT_17750F 3043
#define MINIMUM_GHS_TONE_PWR_AT_18000F 2789
#define HSK_TONE_PWR_TO_FORCE_0_HYB  MINIMUM_GHS_TONE_PWR_AT_750F //XDSLRTFW-3260
// For AnnexM PCB (measured with NDLT-G)
#define MINIMUM_GHS_TONE_PWR_AT_600M   21000
#define MINIMUM_GHS_TONE_PWR_AT_1200M  20000
#define MINIMUM_GHS_TONE_PWR_AT_1900M  16000
#define MINIMUM_GHS_TONE_PWR_AT_2500M  13500
#endif

#define MINIMUM_GHS_TONE_PWR_CTune12   8600  // above 12kft swtich Ctune 12
#define MINIMUM_GHS_TONE_PWR_CTune14   3000  // above 17kft swtich Ctune 14
#define MINIMUM_GHS_TONE_PWR_FINETUNE_CTune14   9000  // For IOPs change loop length to use Ctune 14
#define MINIMUM_GHS_TONE_PWR_CNXT_3A_BT_CTune14 7500  // For IOPs change loop length to use Ctune 14 for CNXT BT
#define MINIMUM_GHS_TONE_PWR_12kft_THR_LLAPI    9100  //for changing to LLAPI changes.
#define MINIMUM_GHS_TONE_PWR_6kft_THR_ADSL2p_LLAPI    14000  //LLAPI changes helps in passing INTLV TR100A cases




#define MINIMUM_GHS_TONE_PWR_CTune14_5A   8600  // Test to pass 12kft 750 Tap cases
                                                // 11900 to pass 9kft BT200 case
#define MINIMUM_GHS_TONE_PWR_24HDSL_NMS_Add   14000  // To pass 24HDSL BT cases derived experimentally
#define MAXIMUM_GHS_TONE_PWR_24HDSL_NMS_Add   16500  // To pass 24HDSL BT cases derived experimentally



#ifdef LEAVE_TRAIL
extern InfoField_t  gt_TrailRxInfoSave;                        /* RxInfo saved */
extern InfoField_t  gt_TrailTxInfoSave;                        /* TxInfo saved */
extern InfoField_t  gt_TrailMSInfo;                             /* MS Info */

/* The global variables below are the actual buffers to save the Vendor Spec in Rx, Tx Info */
/* Note: in InfoField_t, there is a phantom pointer to a buffer, trying to save Vendor Spec. But */
/* it does't have actual address until it is initialized to the address below. */
extern uint8 guca_RxSaveNSVendorSpec[MAX_NUM_NS_BLOCK][MAX_NS_VENDOR_INFO_LEN];/* RxInfo saved */
extern uint8 guca_TxSaveNSVendorSpec[MAX_NS_VENDOR_INFO_LEN];              /* TxInfo saved */

extern Adsl2AllInfo_t gta_TrailRxSaveG9923xInfo[NUM_G992_3_ANNEX_SUPPORTED];          /* substructure of BIS info */
extern Adsl2AllInfo_t gta_TrailRxSaveG9925xInfo[NUM_G992_5_ANNEX_SUPPORTED];        /* substructure of BIS info */
extern Adsl2AllInfo_t gta_TrailTxSaveG9923xInfo[NUM_G992_3_ANNEX_SUPPORTED];          /* substructure of BIS info */
extern Adsl2AllInfo_t gta_TrailTxSaveG9925xInfo[NUM_G992_5_ANNEX_SUPPORTED];        /* substructure of BIS info */
extern Adsl2AllInfo_t gta_TrailMSInfoG9923xInfo[NUM_G992_3_ANNEX_SUPPORTED];          /* substructure of BIS info */
extern Adsl2AllInfo_t gta_TrailMSInfoG9925xInfo[NUM_G992_5_ANNEX_SUPPORTED];        /* substructure of BIS info */
#endif


extern int16   gs_MS_source;                          /* Flag to indicate who send MS */

extern void TerminateHandshake(void);
extern void PrepareCLR(void);
extern int32 SelectMode( InfoField_t *pt_MS_Info );
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start_End)
#ifdef ADSL_BONDING
extern void PrepareCLR_BONDING(void);
#endif
extern Complex_t gta_RxSymbolBuf[NUM_CARRIERS_IN_SET][RX_SYMBOL_BUF_SIZE]; /*  memory of complex valued DMT symbols */
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
extern void Activation_T1413_StateMachine();
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)
// XDSLRTFW-321 Feature_Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(Start_End)
extern void GLite_PrepareCLR();

/*  for designated carrier bins in Rx */
extern uint16 gus_GhsPgaSetDown;  /* indicates how many times pga was reduced from its initial value in handshake */
extern int16 gs_MaxFreqDomainValue;
extern uint8 guc_PgaState;
extern int16 gs_SetPgaForTones_State;
extern int16* gpsa_RxToneBuf_sav;


extern int16 gs_US_PwrCutback_EchoLoop;
extern int16 gs_us_cutback;
extern int16 gs_Initial_PGA_AnnexL;
extern FlagT gft_EchoLoop;

// variables for LATN estimation in GHS
extern int32 gl_hsk_tone_power;
extern int16 gs_hsk_tone_power_dB;
extern int16 gs_hsk_tone_power_dB_PCB; // CTones power with considering power cutback used by CO during G.hs.

//XDSLRTFW-3487(Start)
extern int16 gs_hsk_tone_power_threshold;
extern uint8 guca_dbg_BlackOutTones[4];
//XDSLRTFW-3487(End)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Begin
#ifdef UNV_RETX_GHS
extern FlagT gft_ReTx_ATM_PTM;
extern FlagT gft_ReTx_MS_incorrect;
#endif
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

// Number of cleardown flags before the GALFs are sent (in the usual Rt initiated cleardown)
extern int16 gs_num_cleardown_flags ;
extern int16 gs_num_cleardown_flags_short ;           // triggered with BDCM

/* These variables are used in handshake to indicate if the co modem on the other side */
/* implements older handshake spec or not. The new spec transmits >1 octets in the  */
/* SPar1 of identification field where as the old on transmits only 1 octet */
extern uint8 guc_Received_Only_One_Octet_In_ID_Field;
extern uint8 guc_Received_Only_One_Octet_In_SI_Field;

extern uint8 guc_DecodeMsgState;  /* global variable to indicate the status of bkgd DecodeMessage */
extern uint8 guc_MsgHandlerState; /* global variable to indicate the status of bkgd HSMsgHandler */

#endif /* _HNDSHK_DATA_H */

#ifndef _HNDSHK_DATA_H1
#define _HNDSHK_DATA_H1
//structure used to save handshake code memory
typedef struct {
    uint8 SI_SPar1_idx;     //index of the SI-SPar1 octet
    uint8 SI_Spar1_anx_bit; //bit in idx octet for specific annex
    uint8 anx;              //annex-index(num-annex)
    uint8 bis_plus;         //bis -- 0; plus -- 1
    uint32 smode;           //selected mode
    uint32 cfgmode;         //config mode bitmap
} HS_Encode_ADSL2_t;

//Attenuation-related (ID_Spar1/Npar2 fields) structure
typedef struct {
    uint8 ID_SPar1_idx;     //index of the ID-SPar1 octet
    uint8 ID_Spar1_bit;    //bit in idx octet for specific attenuation field
    uint8 *puc_Atten;              //annex-index(num-annex)
} HS_ID_Atten_t ;
#endif//_HNDSHK_DATA_H1
