/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _IB_H
#define _IB_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             ib.h
 * DESCRIPTION:      Header file for implementing Indicator Bits.
 *
 **********************************************************************/

// ******************************************************************
// ib.h
//
// History
//
// 10/08/2011 Vinjam: Added a new element to the structure "TxIbDataStruct_t" detecting "LOM" (Loss Of Margin) defect.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//////16/07/2012 Anantha: removed unused variables  for implementation of LCD and NCD defect
// ******************************************************************





/**********************************************************************
 * CONSTANTS
 **********************************************************************/
#define TERMINATED          (0)         /* Anomaly or Defect terminated */
#define PRESENT             (1)         /* Anomaly or Defect present */

#define NO_INDICATIONS      (0xFF)      /* Default value for indicator bits (no indications) */
#define FEBE_I_IB           (0xFE)      /* Indicate febe-i */
#define FFEC_I_IB           (0xFD)      /* Indicate ffec-i */
#define FEBE_F_IB           (0xFB)      /* Indicate febe-f */
#define FFEC_F_IB           (0xF7)      /* Indicate ffec-f */
#define FLOS_IB             (0xEF)      /* Indicate flos-i */
#define FRDI_IB             (0xDF)      /* Indicate frdi-i */
#define FNCD_I_IB           (0xBF)      /* Indicate fncd-i */
#define FNCD_F_IB           (0x7F)      /* Indicate fncd-f */
#define FHEC_I_IB           (0xFE)      /* Indicate fhec-i */
#define FHEC_F_IB           (0xFD)      /* Indicate fhec-f */

#define LOS_SUPERFRAMES     (6)         /* Number of consecutive superframes to report LOS */
#define LCD_SUPERFRAMES     (4)         /* Number of consecutive ncd-i before declaring lcd defect */

#define NO_LOS_INDICATIONS  (0x00)
#define NO_NCD_INDICATIONS  (0x00)

/*  =========== LOS Parameters =============== */

#define NUM_LOS_TONES           (1)     /*  number of consecutive tones on which power is  */
                                        /*  measured for LOS detection */
#define LOS_ACCUM_GUARD_BITS    (4)     /*  guard bits required to prevent overflow of  */
                                        /*  accumulated power during LOS detection */
#define LOS_ACCUM_SFRAMES       (6)     /*  6 Sframes = .102 sec */

#define LOS_DETECT_DISABLED             (0)
#define LOS_DETECT_ENABLED          (1)

/* =============== SEF Parameters =============== */
#define SEF_DETECT_DISABLED (0)
#define SEF_DETECT_ENABLED  (1)

#define SEF_FIRST_CHANNEL       (75)    /*  first tone used in SEF detection */
#define SEF_LAST_CHANNEL        (82)    /*  last tone used in SEF detection */

#define SEF_NUM_TONES           (SEF_LAST_CHANNEL - SEF_FIRST_CHANNEL + 1)
#define SEF_AVG_SNR_DROP        (10)
#define NUM_FRAMES_SEF_PRESENT  (2)


/**********************************************************************
 * TYPEDEFS
 **********************************************************************/
/*  Structure containing RX Indicator Bits variables */
typedef struct
{
   /* received indicator bits 8-17, 20-23 */
    uint8   uc_febe_i;      /* Far-End Block Error Interleaved Indicator Bit (febe-i) */
    uint8   uc_febe_f;      /* Far-End Block Error FastIndicator Bit (febe-f) */
    uint8   uc_ffec_i;      /* Far-End Forward Error Correction Interleaved Indicator Bit (ffec-i) */
    uint8   uc_ffec_f;      /* Far-End Forward Error Correction Fast Indicator Bit (ffec-f) */
    uint8   uc_flos;        /* Far-End Loss of Synchronization Indicator Bit (los) */
    uint8   uc_frdi;        /* Far-End Remote Defect Indicator Bit (rdi) */

    uint8   uc_fncd_i;      /* Far-End No Cell Delineation Interleaved Indicator Bit (ncd-i) */
    uint8   uc_fncd_f;      /* Far-End No Cell Delineation Fast Indicator Bit (ncd-f) */
    uint8   uc_fhec_i;      /* Far-End HEC Indicator Bit (fhec-i) */
    uint8   uc_fhec_f;      /* Far-End HEC Interleaved Indicator Bit (fhec-i) */

    int8    s_fntr;         /* Far-End NTR Indicator bits */

   /* counters needed in the PLAM */
    int16   s_febe_i_cnt;   /* febe-i Counter  */
    int16   s_febe_f_cnt;   /* febe-f Counter  */
    int16   s_ffec_i_cnt;   /* ffec-i Counter */
    int16   s_ffec_f_cnt;   /* ffec-f Counter */
    int16   s_fhec_i_cnt;   /* fhec-i Counter  */
    int16   s_fhec_f_cnt;   /* fhec-f Counter  */

   /* intermediate variables needed to compute PLAM failure bits on NCD and LCD-defect */
    uint8   uc_fncd_i_anom; /* Far-End No Cell Delineation interleaved anomaly flag */
    uint8   uc_fncd_f_anom; /* Far-End No Cell Delineation fast anomaly flag */
    uint8   uc_focd_i_anom; /* Far-End Out of Cell Delineation interleaved anomaly flag */
    uint8   uc_focd_f_anom; /* Far-End Out of Cell Delineation fast anomaly flag */
    uint8   uc_fncd_i_hist; /* History of last 4 received ncd-i indications */
    uint8   uc_fncd_f_hist; /* History of last 4 received ncd-f indications */
    uint8   uc_flcd_i_def;  /* Far-End Loss of Cell Delineation Interleaved Defect flag */
    uint8   uc_flcd_f_def;  /* Far-End Loss of Cell Delineation Fast Defect flag */

} RxIbDataStruct_t;

/* structure containing TX Indicator Bits variables */
typedef struct
{
    uint8   uc_febe_i_anom;         /* CRC-I Anomaly flag */
    uint8   uc_febe_f_anom;         /* CRC-F Anomaly flag */
    uint8   uc_ffec_i_anom;         /* FEC-I Anomaly flag */
    uint8   uc_ffec_f_anom;         /* FEC-F Anomaly flag */
    uint8   uc_flos_def;            /* LOS Defect flag */

    //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
    uint8   uc_flom_def;            /* LOM Defect flag */

    uint8   uc_fsef_def;            /* Severly Errored Frame (SEF) Defect flag */

    uint8   uc_fncd_i_anom;         /* No Cell Delineation interleaved (NCD-I) Anomaly flag */
    uint8   uc_fncd_f_anom;         /* No Cell Delineation fast (NCD-F) Anomaly flag */
    uint8   uc_focd_i_anom;         /* Out of Cell Delineation interleaved (OCD-I) Anomaly flag */
    uint8   uc_focd_f_anom;         /* Out of Cell Delineation fast (OCD-I) Anomaly flag */
    uint8   uc_flcd_i_def;          /* Loss of Cell Delineation interleaved (LCD-I) Defect flag */
    uint8   uc_flcd_f_def;          /* Loss of Cell Delineation fast (LCD-I) Defect flag */

    uint8   uc_ffec_i_anom_hist;    /* Indicates if at least one FEC-I has been detected in  */
                                    /* the current superframe */
    uint8   uc_ffec_i_anom_prev;    /* Indicates that at least one FEC-I was detected in the  */
                                    /* previous superframe */
    uint8   uc_ffec_f_anom_hist;    /* Indicates if at least one FEC-F has been detected in  */
                                    /* the current superframe */
    uint8   uc_ffec_f_anom_prev;    /* Indicates if at least one FEC-F was detected in the  */
                                    /* previous superframe */
    //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start)
    uint16   us_prev_CRCi_err_count;  /* CRCi error count from previous superframe */
    uint16   us_prev_CRCf_err_count;  /* CRCf error count from previous superframe */
    //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (End)
    int16   s_los_cnt;              /* count of LOS indications remaining to be sent */

    int16   s_ocd_i_cnt;            /* Count of consecutive ncd-i indications sent */
    int16   s_ocd_f_cnt;            /* Count of consecutive ncd-f indications sent */

    uint8   uc_fhec_i_anom_prev;    /* Header Error Check interleaved (HEC-I)  */
                                    /* Anomaly flag from previous superframe */
    uint8   uc_fhec_f_anom_prev;    /* Header Error Check fast (HEC-I)  */
                                    /* Anomaly flag from previous superframe */

    /* ===================================================================================== */
    /*  NOTE: The following members must be maintained external to the modem by  */
    /*  the TC Layer */

    /*  uc_cd_i_flag     --  current status of cell delineation for cells on the  */
    /*                       interleaved latency path.  Should be set to TRUE  */
    /*                       when cell delineation process is in the SYNC state  */
    /*                       and should be set to FALSE when the cell  */
    /*                       delineation process is in the HUNT or PRESYNC state */

    /*  uc_cd_f_flag     --  current status of cell delineation for cells on the  */
    /*                       fast latency path.  Should be set to TRUE  */
    /*                       when cell delineation process is in the SYNC state  */
    /*                       and should be set to FALSE when the cell  */
    /*                       delineation process is in the HUNT or PRESYNC state */

    /*  uc_cd_i_flag_hist -- cell delineation history for previous superframe for cells  */
    /*                       on the interleaved path.  Should be set to FALSE  */
    /*                       when the cell delineation process is in the HUNT  */
    /*                       or PRESYNC state.  Modem will monitor and reset  */
    /*                       this member once per superframe. */

    /*  uc_cd_f_flag_hist -- cell delineation history for previous superframe for cells  */
    /*                       on the fast path.  Should be set to FALSE  */
    /*                       when the cell delineation process is in the HUNT  */
    /*                       or PRESYNC state.  Modem will monitor and reset  */
    /*                       this member once per superframe. */

    /*  uc_fhec_i_anom   --  current status Header Error Check interleaved  */
    /*                       (HEC-I) Anomaly.  Should be set to PRESENT when a  */
    /*                       header error check fails on the interleaved data.   */
    /*                       Should be set to TERMINATED when the header error  */
    /*                       check does not fail. */

    /*  uc_fhec_f_anom   --  current status Header Error Check fast  */
    /*                       (HEC-F) Anomaly.  Should be set to PRESENT when a  */
    /*                       header error check fails on the fast data.   */
    /*                       Should be set to TERMINATED when the header error  */
    /*                       check does not fail.;          */

    /*  uc_fhec_i_anom_hist --   History of HEC-I anomalies for the previous  */
    /*                       superframe.  Should be set to PRESENT whena header  */
    /*                       error check fails on the interleaved data.  Modem  */
    /*                       will monitor and reset this member once per superframe. */
    /*  uc_fhec_f_anom_hist --   History of HEC-F anomalies for the previous  */
    /*                       superframe.  Should be set to PRESENT whena header  */
    /*                       error check fails on the fast data.  Modem  */
    /*                       will monitor and reset this member once per superframe. */

    /* ===================================================================================== */

    uint8   uc_cd_i_flag;           /* Cell Delineation interleaved Flag (TRUE or FALSE) */
    uint8   uc_cd_f_flag;           /* Cell Delineation fast Flag (TRUE or FALSE) */
    uint8   uc_cd_i_flag_hist;      /* Cell Delineation interleaved Flag (TRUE or FALSE) */
    uint8   uc_cd_f_flag_hist;      /* Cell Delineation fast Flag (TRUE or FALSE) */

    uint8   uc_fhec_i_anom;         /* Header Error Check interleaved (HEC-I) Anomaly flag */
    uint8   uc_fhec_f_anom;         /* Header Error Check fast (HEC-I) Anomaly flag */
    uint8   uc_fhec_i_anom_hist;    /* Header Error Check interleaved (HEC-I) Anomaly flag */
    uint8   uc_fhec_f_anom_hist;    /* Header Error Check fast (HEC-I) Anomaly flag */

   uint8 uc_hec_i_flag;
   uint8 uc_hec_f_flag;

} TxIbDataStruct_t;

#endif /*  #ifndef _IB_H */

