/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _IFFT_FIX_H
#define _IFFT_FIX_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             ifft_fix.h
 * DESCRIPTION:      This file is header file used for fixed-point
 *                   implementation of the Inverse Fast Fourier Transform (IFFT)
 *
 **********************************************************************/

#include "common.h"

/* CONSTANTS */
/*  extra number of array elements that must be provided in the FFT/IFFT */
/*  output buffer because of peculiarities in the implementation */
#define FFT_IMPLEMENTATION_OVERHEAD 2


/* FUNCTIONS */
void IfftReal(int16* ps_inbuf, int16* ps_outbuf, int16 s_fftn, int16 s_log2n);
void BitReverse(int16 *psa_inbuf, int16 *psa_outbuf, int16 s_fftn, int16 s_nbits,
            int16 *psa_bit_reverse_idx);

#endif   /* _IFFT_FIX_H */

