/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _MATRIX_H
#define _MATRIX_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             matrix.h
 * DESCRIPTION:      Header file for matrix utility functions.
 *
 **********************************************************************/

#include "typedef.h"

/**********************************************************************
 * MACROS
 **********************************************************************/

/*
 * LMat macro: Because the correlation matrices are symmetric, only the lower triangular region, plus
 * the diagonal is required for the Cholesky computation.  As a result, only this portion will be stored
 * in memory.  This macro will be used to perform the storage.
 * LMat(Arr, i, j, M) - store data in the (i,j)th element of Arr, dimensioned MXM.
 */
#define LMat(Arr,i,j,M)     (Arr[(j)-(i)+((2*(M)-(i)+1)*(i))/2])

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/

#ifdef FLOAT_IN_SW

    void MatrixMult(Float32 *pfa_x, Float32 *pfa_y, Float32 *pfa_z,
               int16 s_xdim, int16 s_ydim, int16 s_xydim, int16 s_transpose);
    void Cholesky(Float32 *pfa_R, int16 s_len);
    void BackSubstitution(Float32 *pfa_L, Float32 *pfa_result, int16 s_len);
    Float32 RdLMat(Float32 *pfa_L, int16 i, int16 j, int16 s_M);
   void FloatConvolve(Float32 *pfa_input, Float32 *pfa_filter, Float32 *pfa_output, int16 s_inputlen,
               int16 s_CPLen, int16 s_filterlen);

#else /*  NOT FLOAT_IN_SW */

    void MatrixMult(float *x, float *y, float *z,
               int16 xdim, int16 ydim, int16 xydim, int transpose);
    void Cholesky(float R[], int len);
    void BackSubstitution(float L[], float result[], int len);
    float RdLMat(float *L, int i, int j, int M);
   void FloatConvolve(short *psa_input, float *pfa_filter, float *pfa_output, int16 s_inputlen,
                  int16 s_CPLen, int16 s_filterlen);
#endif /*  FLOAT_IN_SW */

#endif /* _MATRIX_H */

