/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _MINMAXMARGIN_H
#define _MINMAXMARGIN_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             minmaxmargin.h
 * DESCRIPTION:      Header file for minmaxmargin.c.
 *
 **********************************************************************/

#include "typedef.h"
//******************************************************************
// minmaxmargin.h
//
// History
//08/11/2012 Anantha: Added a function prototype
//          grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
//******************************************************************
/**********************************************************************
 * VARIABLES
 **********************************************************************/

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/

extern FlagT FindToneWithExtremeMargin (int16 s_SearchType, uint8 *puca_RxBat, int16 *psa_RxFineGains,
                           int16 *psa_SNRBuffer, RxToneFlags p_ActiveTones,
                           int16 s_MinBitsPerTone, int16 s_MaxBitsPerTone, int16 *ps_ch, int16 *ps_Margin);
//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start)
void getBinsHavingMargnBtwenMinAndPlusDelta(uint8 *puca_RxBat,
                              int16 *psa_RxFineGains,
                              int16 *psa_RxShowtimeSnrBuf,
                              RxToneFlags p_ActiveTones,
                              int16 s_MinMarginBeforeSwap,
                              int16 s_Bitswap_Accept_Delta,
                              int16 s_MinBitsPerTone,
                              int16 s_MaxBitsPerTone);

void getPerBandAvgMargin(uint8 *puca_RxBat,
                        int16 *psa_RxFineGains,
                        int16 *psa_SNRBuffer,
                        RxToneFlags p_ActiveTones);
//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(end)

#endif /* _MINMAXMARGIN_H */


