/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2010 Lantiq N.A. Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _NLNF_H
#define _NLNF_H
/*
*-------------------------------------------------------------------------
*
*   Latiq DMT Technology. Proprietary and Confidential.
*
*   640 N. McCarthy Blvd. Milpitas, CA 95035 USA
*
*   nlnf.h
*
*  This file declares Tx and Rx state functions for NLNF echo measurement
*  to detect missing filters at CPE side.
*  This is done before modem handshake/activation in sleep codeswap page.
*
*-------------------------------------------------------------------------
*/
// ******************************************************************************
//   File Name: nlnf.h
//
// History
//
// 01/10/2010 Hanyu: Declared NLNF Tx/Rx state functions for NLNF measurement.
//            This feature is triggered by "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additinally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// **********************************************************************************************************

#include "compiler.h"

//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
void NLNF_QuietTxF(void);
void NLNF_SyncRxF(void);
void NLNF_ReverbTxF(void);
void NLNF_HybPgaTrainRxF(void);
void NLNF_NopRxF(void);
void NLNF_HighParTxF(void);
void NLNF_MeasureQlnRxF(void);
void BGNLNFPostAccum(void);

#define CMV_TEST60_TX_NLNF_QUIET              0x6FD1
#define CMV_TEST60_TX_NLNF_REVERB_64TONES     0x6FD2
#define CMV_TEST60_TX_NLNF_REVERB_32TONES     0x6FD3
#define CMV_TEST60_TX_NLNF_HIGH_PAR           0x6FD4
// CMV test 7 0 to trigger NLNF without SW API support.
#define CMV_TEST70_RX_NLNF_TRIGGERED          0x7FD0
#endif //#ifndef ISDN
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)

#endif /* _NLNF_H */
