/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2006 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       One Oak Park, Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       nmp.h
*
*       Messaage Protocol Defines and Prototypes
*
*-------------------------------------------------------------------
*/

#ifdef USE_HMP_MSG
   #include "hmp.h"
   #include "hmp_data.h"
   #include "hmp_funcs.h"
#else

   #ifndef NMP_H
   #define NMP_H

   #include "typedef.h"
   #include <stdio.h>

   /*****               *****/
   /*****               *****/
   /*****      constant definitions *****/
   /*****               *****/
   /*****         *****/

   //==============================================================================
   // Function OP code definition
   //==============================================================================

   // Host-to-DSP messages (CMV mode)
   #define H2D_CMV_READ                0x00 /* 0000 0000b */
   #define H2D_CMV_WRITE                  0x04 /* 0000 0100b */
   #define H2D_CMV_WRITE_MASKED           0x08 /* 0000 1000b */
   #define H2D_CMV_INDICATE_REPLY            0x10 /* 0001 0000b */

   #define H2D_ERROR_OPCODE_UNKNOWN       0x20 /* 0010 0000b */
   #define H2D_ERROR_CMV_UNKNOWN          0x30 /* 0011 0000b */

   // DSP-to-Host messages (CMV mode)
   #define D2H_CMV_READ_REPLY             0x01 /* 0000 0001b */
   #define D2H_CMV_WRITE_REPLY               0x05 /* 0000 0101b */
   #define D2H_CMV_INDICATE               0x11 /* 0001 0001b */

   #define D2H_ERROR_OPCODE_UNKNOWN       0x21 /* 0010 0001b */
   #define D2H_ERROR_CMV_UNKNOWN          0x31 /* 0011 0001b */
   #define D2H_ERROR_CMV_READ_NOT_AVAILABLE  0x41 /* 0100 0001b */
   #define D2H_ERROR_CMV_WRITE_ONLY       0x51 /* 0101 0001b */
   #define D2H_ERROR_CMV_READ_ONLY           0x61 /* 0110 0001b */
   #define D2H_ERROR_CMV_UNINITIALIZED_ENTRY 0x71 /* 0111 0001b */
   #define D2H_AUTONOMOUS_MODEM_READY_MSG    0xF1 /* 1111 0001b */


   // Host-to-DSP messages (Debug mode)
   #define H2D_DEBUG_READ_DM              0x02 /* 0000 0010b */
   #define H2D_DEBUG_READ_PM              0x06 /* 0000 0110b */
   #define H2D_DEBUG_WRITE_DM             0x0A /* 0000 1010b */
   #define H2D_DEBUG_WRITE_PM             0x0E /* 0000 1110b */
   #define H2D_DEBUG_READ_EXT_DM          0x12 /* 0001 0010b */
   #define H2D_DEBUG_READ_EXT_PM          0x16 /* 0001 0110b */
   #define H2D_DEBUG_WRITE_EXT_DM            0x1A /* 0001 1010b */
   #define H2D_DEBUG_WRITE_EXT_PM            0x1E /* 0001 1110b */

   // DSP-to-Host messages (Debug mode)
   #define D2H_DEBUG_READ_DM_REPLY           0x03 /* 0000 0011b */
   #define D2H_DEBUG_READ_PM_REPLY           0x07 /* 0000 0111b */
   #define D2H_DEBUG_WRITE_DM_REPLY       0x0B /* 0000 1011b */
   #define D2H_DEBUG_WRITE_PM_REPLY       0x0F /* 0000 1111b */
   #define D2H_DEBUG_READ_EXT_DM_REPLY       0x13 /* 0001 0011b */
   #define D2H_DEBUG_READ_EXT_PM_REPLY       0x17 /* 0001 0111b */
   #define D2H_DEBUG_WRITE_EXT_DM_REPLY         0x1B /* 0001 1011b */
   #define D2H_DEBUG_WRITE_EXT_PM_REPLY         0x1F /* 0001 1111b */

   #define D2H_ERROR_ADDR_UNKNOWN            0x33 /* 0011 0011b */

   #define D2H_CS_REQUEST                 0xEA
   #define H2D_CS_COMPLETE                0xEC
   #define D2H_CS_COMPLETE                0xED

   #define BOOT_COMMAND_MASK   0x0000FFF0
   #define PAYLOAD_LEN_MASK    0x0000000F

   /* Our repertoire of commands...
   */
   #define H2D_CS_PM_WR              0xef
   #define H2D_CS_PM_RD    0xef
   #define H2D_CS_DM_WR              0xee
   #define H2D_CS_DM_RD              0xee

   #define READ_MASK             0xa000

   #define READ_WRITE_ACCESS  0
   #define READ_ACCESS        1
   #define WRITE_ACCESS       2
   #define UNKNOWN_ADDRESS           0x1

   #define CNTLGroup   1
   #define STATGroup   2
   #define iNFOGroup   3
   #define TESTGroup   4
   #define OPTNGroup   5
   #define RATEGroup   6
   #define PLAMGroup 7
   #define CNFGGroup 8
   #ifdef HERC_API
   #define MONIGroup   9
   #define CNTRGroup   10
   #define ALGSGroup   11
   #define DBUGGroup   12
   #define ACFGGroup   13
   #define AINFGroup   14
   #define AOPTGroup   15
   #endif

   #ifdef CUSTOMER_TASKS
   #define CUST_CMV_GROUP_BIT_MASK 0x10
   #endif

   #if defined(HERCULES_ADSL_CPE) && defined(TARGET_HW)
   // Use only for HWE5.0 target HW
   // Note these definitions are currently duplicated in hmp.h.
   // Difference between these defs and the ones for Socrates are compensated
   // for in the hmp code, i.e. there is no difference in actual MP format.
   #define NewCNTLType (0)
   #define NewSTAT_0_Type_HERC      ((int16)(INDIRECT_CMV_TYPE_MASK | 1))
   #define NewSTAT_1_Type_HERC      ((int16)(INDIRECT_CMV_TYPE_MASK | 2))
   #define NewSTAT_5_Type_HERC      ((int16)(INDIRECT_CMV_TYPE_MASK | 3))
   #define NewSTATType_HERC (4)

   #define NewINFOType_74_HLOG      ((int16)(INDIRECT_CMV_TYPE_MASK | 5))
   #define NewINFOType_76_QLN       ((int16)(INDIRECT_CMV_TYPE_MASK | 6))

   #define NewINFO_203_Type_HERC    ((int16)(INDIRECT_CMV_TYPE_MASK | 7))
   #define NewINFO_209_Type_HERC    ((int16)(INDIRECT_CMV_TYPE_MASK | 8))
   #define NewINFO_211_Type_HERC    ((int16)(INDIRECT_CMV_TYPE_MASK | 9))
   #define NewINFO_212_Type_HERC    ((int16)(INDIRECT_CMV_TYPE_MASK | 10))
   #define NewINFOType_HERC         ((int16)(INDIRECT_CMV_TYPE_MASK | 11))

   #define NewTESTType_HERC (12)

   #define NewOPTN_0_Type_HERC      ((int16)(INDIRECT_CMV_TYPE_MASK | 13))
   #define NewOPTN_2_Type_HERC      ((int16)(INDIRECT_CMV_TYPE_MASK | 14))
   #define NewOPTNType_HERC 15

   #define  NewRATEType_HERC     ((int16)(INDIRECT_CMV_TYPE_MASK | 16))
   #define  NewPLAMType_HERC 17

   #define NewCNFG_0_Type_HERC   ((int16)(INDIRECT_CMV_TYPE_MASK | 18))
   #define NewCNFG_1_Type_HERC   ((int16)(INDIRECT_CMV_TYPE_MASK | 19))
   #define NewCNFG_2_Type_HERC   ((int16)(INDIRECT_CMV_TYPE_MASK | 20))
   #define NewCNFG_3_Type_HERC   ((int16)(INDIRECT_CMV_TYPE_MASK | 21))


   #define NewCNFGType_HERC ((int16)(INDIRECT_CMV_TYPE_MASK | 22))




   #ifdef HERC_API
      #define NewMONIType ((int16)(INDIRECT_CMV_TYPE_MASK | 23))
      #define NewCNTRType     ((int16)(INDIRECT_CMV_TYPE_MASK | 24))
      #define NewALGSType 25
      #define NewDBUGType 26
      #define NewACFGType 27
      #define NewAINFType  ((int16)(INDIRECT_CMV_TYPE_MASK | 28))
      #define NewAOPTType 29
   #endif   // HERC_API



   #else

   // Use these for Socrates and all Cocomo (including HWE5.0)
   #define NewCNTLType (CNTLGroup)
   #define NewSTATType (STATGroup)
   #define NewINFOType (iNFOGroup)
   #define NewTESTType (TESTGroup)
   #define NewOPTNType (OPTNGroup)
   #define  NewRATEType (RATEGroup)
   #define  NewPLAMType (PLAMGroup)
   #define NewCNFGType  (CNFGGroup)

   #endif


   #define NEW_DICT_ENTRY_LENGTH   7
   #ifndef HERC_API
   #define NEW_NUM_DICT_ENTRIES_SOC    9
   #else
   #define NEW_NUM_DICT_ENTRIES_HERC    30
   #endif

   #define NEW_DICT_SIZE_HERC            NEW_DICT_ENTRY_LENGTH * NEW_NUM_DICT_ENTRIES_HERC
   #define NEW_DICT_SIZE_SOC            NEW_DICT_ENTRY_LENGTH * NEW_NUM_DICT_ENTRIES_SOC

   #define NEWMP_SIZE      (16)

   #define NEWMP_PAYLOAD_SIZE      (12)

   // code set in the group field of MP structure to indicate that the network processor has not enabled AC_CLK
   #define  AC_CLK_NOT_ENABLED_MSG 0x101 /* 0001 0000 0001b */

   extern int16   *INFOMap[];

   #ifdef HERC_API

   extern int16 *INFO_74_Map[];
   extern int16 *INFO_76_Map[];

   extern int16   *INFO_203_Map[];
   extern int16   *INFO_209_Map[];
   extern int16   *INFO_211_Map[];
   extern int16   *INFO_212_Map[];
   #endif

   extern int16    *RATEMap[];
   extern int16    *PLAMMap[];
   extern int16    *CNFGMap[];
   #ifdef HERC_API
   extern int16    *CNFG_0_Map[];
   extern int16    *CNFG_1_Map[];
   extern int16    *CNFG_2_Map[];
   extern int16    *CNFG_3_Map[];
   #endif

   #ifdef HERC_API
   extern int16 *STAT_0_Map[];
   extern int16 *STAT_1_Map[];
   extern int16 *STAT_5_Map[];
   extern int16 *OPTN_0_Map[];
   extern int16 *OPTN_2_Map[];
   extern int16    *MONIMap[];
   extern int16    *CNTRMap[];
   extern int16    *ALGSMap[];
   extern int16    *DBUGMap[];
   extern int16    *ACFGMap[];
   extern int16    *AINFMap[];
   extern int16    *AOPTMap[];
   #endif // HERC_API

   /* Message Types */

   typedef struct {
      int16 FunctionOpcodeAndSize;
      int16 GroupField;
      int16 AddrField;
      int16 IndexField;
      int16 PayLoad[NEWMP_PAYLOAD_SIZE];
   } NewMPStruct;

   /*****               *****/
   /*****               *****/
   /*****      function prototypes  *****/
   /*****               *****/
   /*****               *****/

   int16 NewDecodeCMVBlockName(int16 *, int16 *);

   extern NewMPStruct NewMPRxBuffer;   /* Highest Level RX buffer */
   extern NewMPStruct NewMPTxBuffer;      /* Highest Level TX buffer */

   extern int16 *NewBlockNameArrayPtr;

   extern int16 *NewCMVBlockNamePtr_SOC[];
   extern int16 *NewCMVBlockNamePtr_HERC[];
   extern int16 *NewCMVBlockNamePtr[];

   extern int16 gs_ADSLPrevMsgPending, gs_VBMPrevMsgPending;
   #endif
#endif
