/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       One Oak Park, Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       NMP_PLFM.H
*
*       Messaage Protocol Defines and Prototypes
*
*-------------------------------------------------------------------
*/
#ifdef USE_HMP_MSG
   #include "hmp.h"
   #include "hmp_data.h"
   #include "hmp_funcs.h"
   #define VBM_MAILBOX          (0)
   #define ADSL_MAILBOX         (1)
#else

   #ifndef _NMP_PLFM_H
   #define _NMP_PLFM_H

   #include "typedef.h"

   #define VBM_MAILBOX          (0)
   #define ADSL_MAILBOX         (1)

   /* codes used by coordinate MP, Codeswap, and FastRead messages to ME */

   #define TX_MAILBOX_MP_MSG_REQ          (0x01)
   #define TX_MAILBOX_CODESWAP_REQ           (0x02)
   #define TX_MAILBOX_FASTREAD_REQ           (0x04)

   //==============================================================================
   // Function prototypes
   //==============================================================================

   int16 NewMPCheckMessage(int16);
   int16 NewMPInitialize(void);
// void SetupModemReadyMessage(void);
   void NewMPSendMessage(int16, int16, int16 );
   void ReadMem(int16, int16 , int16 , int16 *);
   void WriteMem(int16, int16, int16, int16 *);
   void ReadExtMem(int16, int16 , int16 , int16 *);
   void WriteExtMem(int16, int16, int16, int16 *);
   int16 NewMPHandleMessage(int16);
   void SendCodeSwapRequest(void);
   void QueueInterruptRequest(int16 s_InterruptCode);
   void SendInterruptRequest(int16 s_InterruptCode);

#ifdef DEBUG_STREAMING
   /// Handle host mailbox in the background
   /**
       If the DSP to host mailbox is available the next pending messages will be processed by it's priority. Priorities are:

       * Debug messages

       @param ptStatics pointer to port's persistent data structure
       @param Event the event that caused the background handler to be called

       @return A non zero value will tell the background thread to schedule the service again.
    */
   void NMP_BgService(void);


   /// Test for pending debug message
   uint16 NMP_IsDebugMsgPending(void);

   /// Set a debug message chunk to be sent asap.
   /**
       All information is stored locally until the message could be sent

       @param StreamId     the stream id (1st payload word)
       @param SymCount     the global symbol counter value when registering the stream
       @param Crc16        a CRC16 over the stream data
       @param StreamStatus the stream's status field (2nd payload word)
       @param Length       debug stream message length in number of bytes
       @param pPayload     pointer to debug stream message payload data

       @return The function will return 0 if the message could be scheduled for transmission. A value < 0 idicates an error.
    */
   int32 NMP_SendDebugMsg(uint16 StreamId, uint32 SymCount, uint16 Crc16, uint16 StreamStatus, uint16 Length, uint16 * pPayload);
#endif

   //==============================================================================
   // External Variables
   //==============================================================================

   extern int16 *NewMPRxArray;   /* RX buffer pointer */
   extern int16 *NewMPTxArray;   /* TX buffer pointer */

   /* variables used by coordinate MP, Codeswap, and FastRead messages to ME */
   extern int16 gs_TxMailboxState;
   extern int16 gs_MPReturnOpcode;
   /* variable used to move MP mr/mw access to TC Task */
   extern int16 gs_MPFunctionOpcode;

   #endif /* _NMP_PLFM_H */
#endif
