/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _NOISEACC_H
#define _NOISEACC_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  noiseacc.h
;
;  Header file for functions in noiseacc.c
;
*****************************************************************************/

#include "typedef.h"

/**********************************************************************
 * CONSTANTS
 **********************************************************************/

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/

void NoiseAcc(int32 *pla_NoisePower, int16 s_doffset, int16 *psa_recv_tones, int16 s_offset,
            int16 s_modulo, int16 s_fft_length, int16 *psa_ref_tones,int16 s_first_chan, int16 s_last_chan);

#ifdef NOISEACC_COMB2
void NoiseAccComb2(int32 *pla_NoisePower, int16 *psa_recv_tones,  int16 *psa_ref_tones);
#endif //NOISEACC_COMB2
void NoiseAccShowtime(int16 s_num_chans);

void RoundNoiseAccum(int32 *pla_in, int32 *pla_round, int16 s_first_chan, int16 s_last_chan, int16 s_bit_position);
void RoundNoiseAccum2(int32 *pla_in, int32 *pla_round, int16 s_first_chan, int16 s_last_chan, int16 s_bit_position);
/**********************************************************************
 * MACROS
 **********************************************************************/
#define mAddInt32ToNoiseAccumulator(l_int32, pl_accLO, pl_accHI) {   \
   *(pl_accLO) += ((l_int32) & 0xFFFF);   \
   *(pl_accHI) += ((l_int32) >> 16);   \
}

#endif /* _NOISEACC_H */
