/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _PGA_SET_H
#define _PGA_SET_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             pga_set.c
 * DESCRIPTION:      Header file containing the constants and function
 *                   prototype for pga_set.c
 *
 **********************************************************************/

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
#define PGA_ACCUM_SYMBOLS       (4)        /*  number of symbols to compute average */
#define LOG2_PGA_ACCUM_SYMBOLS   (2)         /*  log2(PGA_ACCUM_SYMBOLS) */
                                            /*  received power, used for PGA adjustment */
//VR9_AFE ADSL modes crest factor is 6.3
//VRX518AFE_OPEN
#define PD_DB                   (0x4a52)    /*  desired power of input signal  */
                                            /*  == 10log10((2^15/6.3)^2) Q8.8 format */

#define PGA_DEFAULT_MARGIN      (0x0100)    /*  default PGA margin of 1 dB, Q8.8 format */

/*  note: the following values should be set to match the target hardware */
/*        default values are provided for test purposes only */
//PGA1 = 21dB PGA2 = 12
#define MAX_PGA                 (0x2100)    /*  maximum gain that PGA can apply (33 dB in Q8.8) */
//PGA1 -9 PGA2 -8
#define MIN_PGA                 (0xEF00)    /*  minimum gain that PGA can apply (-17 dB in Q8.8) */

#define GHS_MAX_FREQ_DOMAIN_VALUE_REF (0x2000)

#define SETPGATONES_CHECKLEVEL  (0)
#define SETPGATONES_WAIT1       (1)
#define SETPGATONES_STEPDOWN    (2)
#define SETPGATONES_WAIT2     (3)
#define SETPGATONES_LEVEL_OK  (4)

#endif  /* _PGA_SET_H */

