/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _PLAM_H
#define _PLAM_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: plam.h
;
;  Header file for constants and data types in PLAM computations
;
*****************************************************************************/

#ifdef DO_PLAM
#include "typedef.h"

/* NOTE: The ATM variables are per latency path for DMT and per bearer channel for BIS */
/* Since we are using same variables for both, we have the max possible size for them */
#define MAX_ATM_SIZE    4
#define NUM_SFRAMES_20SEC  1180     //number of superframes in 20sec
#define NUM_SFRAMES_10SEC  590         //number of superframes in 10sec
#define NUM_SFRAMES_2P5SEC 150         // number of superframes in 2.5sec
#define NUM_SFRAMES_1SEC   59       //number of superframes in 1sec
#define NUM_CONTIGUOUS_SES_FOR_UASL 10 //number of contiguous SES to declare ADSL line unavailable

typedef struct {
   uint16 s_present;
   uint16 s_absent;
} FailureCount_t;

// XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (Start)
typedef struct {
   int16 s_SESx_ReInit_Threshold;
   int16 s_LOM_ReInit_Threshold;
   int16 s_ESx_ReInit_Threshold;
} ReInit_Thresholds_t;
// XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (End)

/* functions implemented in plam.c */
void UpdateFailureInfo(uint8 uc_cond, FailureCount_t *FailureCount, int16 *pFailure,
                  uint16 us_failureBit);
void Map_BCLP_Failures_bis(int16 *pFailure);

void UpdateFailureCounts(uint8 uc_cond, FailureCount_t *FailureCount);
void InitializeFailureCountPresent(FailureCount_t *FailureCount, int16 s_presentNumber);
void TerminateFailureBit(FailureCount_t *FailureCount, int16 *pFailure, uint16 us_failureBit,
                  int16 s_terminateNumber);
void UpdateRxSnrBufGet(void); //XDSLRTFW-2443 / XDSLRTFW-2462

#endif /* DO_PLAM */
#endif /* _PLAM_H_ */
