/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _PLL_H
#define _PLL_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             pll.h
 * DESCRIPTION:      Header file for PLL functions.
 *
 **********************************************************************/
// ******************************************************************
// pll.h
//
// History
//
//  2/12/2015 Sriram Shastry : Observed Quartz instabilities with  AVM  fritzbox[7490]. Added Detection algorithm for frequency drift and  phase drift
//  such that PLL adapt's to  fast setting  instead of  showtime setting .It helps to avoid showtime link drops in field
//
// Grep for : XDSLRTFW-2464
// ******************************************************************

#include "rt_state.h"

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
/*  states of DD pilot processing, which are assigned to variable gft_DDPilot */
#define DD_PILOT_OFF       (0)
#define DD_PILOT_ON           (1)

/*  states of Aux pilot processing, which are assigned to variable gft_AuxPilot */
#define AUX_PILOT_DISABLE     (0)
#define AUX_PILOT_ENABLE      (1)
#define AUX_PILOT_ACTIVE      (2)

#define PLL_NOT_LOCKED              (0) /* PLL in acquisition mode */
#define PLL_LOCKED               (1) /* PLL in tracking mode   */
#define PLL_PI_RADIANS        (25736) /* 25736 = pi radians */
#define PLL_HALF_PI_RADIANS      (12868) /* 12868 = pi/2 radians */
#define PLL_QUARTER_PI_RADIANS   (6434) /* 6434 = pi/4 radians */
#define PLL_SHOWTIME_FAST_PLL_RADIANS    (8192) /* XDSLRTFW-2464 */
#define PLL_SHOWTIME_DEFAULT_PLL_RADIANS    (8192) /* XDSLRTFW-2464 */

#define LF_COEF_RSH_CNT    (14)

/* Ki0 and Kp0 are fast-converge parameters */
#define LF_KI0          ((int16)((0.024*(1<<LF_COEF_RSH_CNT))+0.5))
#define LF_KP0          ((int16)((1.22*(1<<LF_COEF_RSH_CNT))+0.5))

/* Ki1 and Kp1 are slow-converge parameters */
#define LF_KI1          ((int16)((0.00049*(1<<LF_COEF_RSH_CNT))+0.5))
#define LF_KP1          ((int16)((0.03125*(1<<LF_COEF_RSH_CNT))+0.5))

#define UNITY_PLL_SCALING  (1<<14)     /* in Q2.14 format */

#define PLL_STATE_UNLOCK   (0)                           /* PLL unlock state */
#define PLL_STATE_LOCK     (1)                         /* PLL lock state */

// XDSLRTFW-2579
#define SHOWTIME_FAST_PLL        (104858) // >0.4 ppm(0.4*2^18 = 104858) /*  If Frequency was drifting more than +/-0.4 ppm / second:    switch to "fast PLL settings" */
#define SHOWTIME_DEFAULT_PLL     (8292) // < 0.03 ppm  /*  If Frequency was drifting less than 0.030 ppm / second:    switch back to "default PLL settings" */
#define SIZE_PLL_FREQ_OFFSET_BUFFER  (32) /* XDSLRTFW-2464 */
/**********************************************************************
 * VARIABLES
 **********************************************************************/
// DD Pilot
extern FlagT gft_DDPilot;        /* 0 -- Decision Directed Pilot Off, 1 -- Decision Directed Pilot On */

// Aux Pilot Tone
extern FlagT gft_AuxPilot;       /* 0 -- Aux Pilot Disable, 1 -- Aux Pilot Enable, 2 -- Aux Pilot Active */
extern int16 gs_MinAuxPilotToneIdx ;
extern int16 gs_MaxAuxPilotToneIdx ;

// Pilot Tone Indexes
extern int16 gs_PilotToneIdx;          /* pilot tone index */
extern int16 gs_AuxPilotToneIdx;       /* aux pilot tone index */
extern int16 gs_CPilotTone;   /* cpilot tone index */

// Pll Scaling Coefficients
extern int16 gs_Kp;                 /* Kp parameter in the loop filter */
extern int16 gs_Ki;                 /* Ki parameter in the loop filter */                          /* Exponent in Ki parameter */
extern int16 gs_Kp_Fast;
extern int16 gs_Ki_Fast;
extern int16 gs_Kp_Slow;
extern int16 gs_Ki_Slow;
extern int16 gs_Kp_Showtime;
extern int16 gs_Ki_Showtime;
/* XDSLRTFW-2464 */
extern int16 gs_Kp_Showtime_default;
extern int16 gs_Ki_Showtime_default;
extern int16 gs_MaxPhaseErrorThreshold_default;
extern int16 gs_Kp_Showtime_FallBack;
extern int16 gs_Ki_Showtime_FallBack;
extern int16 gs_MaxPhaseErrorThreshold_Fallback;
/* XDSLRTFW-2464 */
extern int16 gs_Kp_After_CECT;
extern int16 gs_Ki_After_CECT;
extern int16 gs_PllScaling;

// Pilot Tone Signal Buffer
extern int16 gsa_RxPilotTone[2];       /* received Pilot Tone */
extern int16 gsa_PllRefTone[2];           /* reference Pilot Tone */
extern int16 gsa_NewRefTone[2];

// Phase Error
extern FlagT gft_EnablePLL;
extern int16 gs_PhaseError;
extern int16 gs_MaxPhaseErrorThreshold;

// XDSLRTFW-2579 (Start)
extern int16 gs_PhaseErrorThresholdDuringMI;
extern int16 gs_PhaseErrorThresholdDuringExtNoise;
extern int16 gs_PhaseErrorThreshold;

extern uint8 guc_MaxEDMetric;
extern uint8 guc_EDMetricThreshold;
// XDSLRTFW-2579 (End)

extern int16 gs_PLL_Mode;  /*XDSLRTFW-2464*/

// H/W Timing Recovery variables
extern int16 gs_UpdateTimingRecoveryHWEnable;
extern FlagT gft_EnableNoiseShaping ;
extern int32 gl_pll_loopfilter_out;    /* Output of PLL loop filter */
// PLL Frquency Offset
extern int32 gl_initfreqoffset;     /* value is based on clock freq used for PLL
                           35.328/36.66 = 2^22/(2^22 + gl_initfreqoffset)*/
extern int32 gl_pll_freq_offset;
extern int32 gl_pll_loopfilter_out;  /* Output of PLL loop filter */
extern int32 gl_pll_freq_offset_avg;   // XDSLRTFW-2923 , used for averaging gl_pll_freq_offset value for 4096 symbol

extern int32 gl_PilotTonePower;  /* XDSLRTFW-2464 */
extern uint8 guc_metric_value;  // XDSLRTFW-2579 (Start_End)


/* G992x specific */
extern uint8 guc_CommandedPllState;                /* if == PLL_DISABLE, PLL should not be run in GetRxTones() */
                                          /* if == PLL_RESET_REFERENCE_TONE, PLL reference tone should be reset */
                                          /* if == PLL_PERFORM_PHASE_LOCK, PLL should be run in GetRxTones() */
extern int16 gs_RotationIdx;

//XDSLRTFW-2579 (Start)
//extern uint16 gusa_EDMetricLog[16];           // for debugging only
extern uint16 gus_MicroInterruptionDetectionCnt;
extern uint16 gus_SymbolWithLowEdMetricCnt;

extern uint32 gul_PpmDriftCnt;
extern int16 gs_ExtraDelayBeforeChangingPllLF;
//XDSLRTFW-2579 (End)

extern int16 gsa_RotationX[8];
extern int16 gsa_RotationY[8];

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
void ResetPLL(int16 s_Kp, int16 s_Ki, int16 s_PhaseErrThreshold);
void ResetPllRefTone(int16 s_RefTone_Real, int16 s_RefTone_Imag);
void RotatePilotRef(int16 s_OldRefX, int16 s_OldRefY, int16 X, int16 Y, int16 *ps_NewRefX, int16 *ps_NewRefY);
void PLL(int16 *psa_InPilotTone);
void ScalePLL(int16 s_scaling);
void ConvertDataToPllRef(int16 *sa_DataTone);

void PllScalingCalc(int16 s_pilotTone, int16 *ps_scaling);

void do_showtime_pilot_processing(FlagT ft_isSyncFrame);
//#ifdef ISDN
void UpdatePLLAdaption(int16 *psa_InputPilotTone); /* XDSLRTFW-2464 */
//#endif
int32 sumsq(int16 s_x, int16 s_y);

#endif /* _PLL_H */

