/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _RCMEDLEY_DATA_H
#define _RCMEDLEY_DATA_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             rcmedley_Data.h
 * DESCRIPTION:      Header file for rcmedley_Data.c
 *
 **********************************************************************/
// ******************************************************************
// rcmedley_Data.h
//
// History
//
// 26/07/10  Bhadra/Kannan: Added a flag to enable Noise Margin Separation Calculation
//           while Forcing Unity TDQ.This is done to improve the DS Data Rate in ADSL2
//           Mode against Connexant D57 DSLAM.
//                    Grep for "PERF_DS_Bis_CNXT_ForceUnityTDQ" to check the changes.
// ******************************************************************

/* =============================================== */
/* global variable declarations */
/* =============================================== */

extern int16 * gsa_unpk_PN512;       /* DMT tones generated using PN512 */
extern int16 gs_MedleySyncOffset;   /* offset from pre-sync offset for a given TDQ */
extern int16 *gps_TdqFilter;     /* pointer to current set of Multi-TDQ coeffs */

/* =============================================== */
/* global variables used by CRMedleyRxF() */
/* ===============================================    */
//int16 gs_MaxPostSync; /* Max number we can store */
extern int16 gs_MaxPostSync;                    /* Max number we can complete during C-MEDLEY-TX */
extern int16 gs_TdqIdx;                   /* index pointer for current TDQ */
extern int16 gs_last_tdq_idx;                /* number of TDQ cases that will be tested. */
extern int16 gs_TdqOffIdx;                   /* index pointer for TDQ off case. */
extern int16 gft_OfflinePreSyncs;         /* flag to allow setting multi-tdq synch points offline */
extern int16 gs_MultiTdqTrainingState;
extern int16 gs_NumMultiTdq;              /* Max number we can complete during C-MEDLEY-TX */
extern int16 gsa_Best[4];                    /* stores synch point and capacity for best TDQ */
extern int16 gsa_Chosen[4];
extern int16 gs_dbgChosen;
extern int16 gs_UnpackPNState;
extern FlagT gft_SkipOneFrame;
extern int16 gsa_FDQ_coef_pilot_UnityTdq[2];
extern uint8 guc_FDQ_exp_pilot_UnityTdq;
// AR8_TF: PERF_DS_Bis_CNXT_ForceUnityTDQ (Start_End)
extern FlagT gft_ForceUnityTDQ; /* To enable Noise Margin Separation while Forcing Unity TDQ */


#define SYNCH     (0)                  /* SYNCH offset stored in gsa_Best array*/
#define CAPACITY  (1)                  /* CAPACITY stored in gsa_Best array */
#define TDQIDX    (2)                  /* TDQ index stored in gsa_Best array */
#define DEVIATION (3)                     /* Deviation among post-sync capacities */

#endif /* _RCMEDLEY_DATA_H */

