/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _RINFOTBL_H
#define _RINFOTBL_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             rinfotbl.h
 * DESCRIPTION:      Header file containing message tables during the
 *                   Exchange stage of Initialization.
 *
 **********************************************************************/

#include "typedef.h"
#include "const.h"

/**********************************************************************
 * VARIABLES
 **********************************************************************/
extern uint8 guca_PreAmbleField[4];

/* ======================================================================== */
/*  guca_RRates1Tab[] contains the configuration options sent during */
/*  R_RATES1_TX.   */
/* ======================================================================== */
extern uint8 guca_RRates1Tab[R_RATES1_NUM_BYTES];

/* ======================================================================== */
/*  guca_RMsgs1Tab[] contains the R_MSGS1 data */
/* ======================================================================== */
extern uint8 guca_RMsgs1Tab[R_MSG1_NUM_BYTES];

/* ======================================================================== */
/*  Four downstream rate options */
/*  Table entries must be arranged such that the lowest entry has */
/*  the maximum number of bits per symbol and the highest entry number */
/*  has the minimum number of bits per symbol. */
/* ======================================================================== */
/* payload bytes, checkbytes, S, D */
extern Option_t gta_DS_options[NUM_DS_RATE_OPTIONS];

/* ======================================================================== */
/*  Four upstream rate options */
/*  the maximum number of bits per symbol and the highest entry number */
/*  has the minimum number of bits per symbol. */
/* ======================================================================== */
/* payload bytes, checkbytes, S, D */
extern Option_t gta_US_options[NUM_US_RATE_OPTIONS];

/* ======================================================================== */
/*  Structure for R_MSGS1 */
/* ======================================================================== */
extern RMsgs1_t gt_RMsgs1;


/* ======================================================================== */
/*  Received R_C_RATES1 config options */
/* ======================================================================== */
extern uint8  guca_R_C_Rates1[R_C_RATES1_NUM_BYTES];

/* ======================================================================== */
/*  Received R_C_MSGS1 information */
/* ======================================================================== */
extern uint8  guca_R_C_Msgs1[R_C_MSGS1_NUM_BYTES];

extern CMsgs1_t gt_RCMsgs1;

#endif /* _RINFOTBL_H */

