/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RT_STATE.H
*
*   Header file for STATES.C (state machine functions).
*  These represent CPE (RT) states for both RX and TX
*
*-------------------------------------------------------------------------
*/
// **********************************************************************************************************
// rt_state.h
//
// History
//
// 11/08/2010 Hanyu/Bhadra: Defined constant values for C-Pilot1 detection to fix
//                    a xtalk issue with UT900CNXT/D57/Rev7 DSLAM at Netcom.
//                    By default, this fix is disabled. To enable it cw INFO 103 20 0x0004
//                    Grep for SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det
//
// 15/09/2011 Kannan: DEC coefficient download sub state definition
//      Grep for XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining
//
// 21/11/2011 Hanyu: Ported MFD code to VRx. Defined NLNF Tx/Rx states for NLNF measurement state machines.
//            This feature is triggered by "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additinally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 20/03/2015 ChihWen: Switch to FW SNR FDQ update in REIN cases in order to sustain DS margin.
//            Grep for XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN
// **********************************************************************************************************

#include "xrtstate.h"   /* include the fast retrain state definitions even if they are not used */

#ifndef _RT_STATE_H
#define _RT_STATE_H

#include "rt_state_bis.h"

/*  general states */
#define UNKNOWN                        (0)
#define FAIL_TX                        (1)
#define FAIL_RX                        (2)

/*  temporary states to terminate processing */
#define DONE_TX                        (3)
#define DONE_RX                        (4)
#define STOP_TX                        (5)
#define STOP_RX                        (6)

/* Do nothing */
#define SLEEP_TX                            (7)
#define SLEEP_RX                            (8)

/* =============================================================== */
/*  TX states  */
/* =============================================================== */

/*  CPE TX Transceiver Training states */
#define R_QUIET2_TX                    (10)
#define R_REVERB1_TX                (11)
#define R_QUIET3_TX                    (12)
#define R_ECT_TX                    (13)
#define R_REVERB2_TX                (14)

// CPE TX T1.413 Activation States
#define R_QUIET1_TX                    (17)
#define R_ACT_REQ_TX                (18)
#define R_ACK_TX                    (19)

/*  CPE TX Channel Analysis states        */
#define R_SEGUE1_TX                    (20)
#define R_REVERB3_TX                (21)
#define R_SEGUE2_TX                    (22)
#define R_RATES1_TX                    (23)
#define R_CRC1_TX                   (24)
#define R_MSGS1_TX                     (25)
#define R_CRC2_TX                   (26)
#define R_MEDLEY_TX                    (27)
#define R_REVERB4_TX                (28)

/*  CPE TX Exchange states */
#define R_SEGUE3_TX                    (30)
#define R_MSG_RA_TX                    (31)
#define R_CRC_RA1_TX                   (32)
#define R_RATES_RA_TX                  (33)
#define R_CRC_RA2_TX                   (34)
#define R_REVERB_RA_TX                 (35)           // RReverbRATxF               check gft_RCExchRARcvFlag
#define R_SEGUE_RA_TX                  (36)           // RSegueRATxF

#define R_MSGS2_TX                     (37)           // RMsgs2TxF
#define R_CRC3_TX                      (38)           // RCrc3TxF
#define R_RATES2_TX                    (39)           // RMsgs2TxF
#define R_CRC4_TX                      (40)           // RCrc3TxF
#define R_REVERB5_TX                   (41)           // RReverb5TxF          * fail      gpft2_RCExchRcvFlag/gft_RCExch2RcvFlag
#define R_SEGUE4_TX                    (42)
#define R_BG_TX                        (43)
#define R_CRC5_TX                      (44)
#define R_REVERB6_TX                   (45)
#define R_SEGUE5_TX                    (46)

#define R_SHOWTIME_TX                  (47)

/* =============================================================== */
/*  RX states */
/* =============================================================== */

/*  CPE RX T1.413 Activation states */
#define  R_C_ACT_RX              (58)
#define R_C_REVEILLE_RX          (59)


/*  CPE RX Transceiver Training states */
#define R_C_QUIET2_RX                  (60)
#define R_C_PILOT1_RX                  (61)
#define R_C_REVERB1_RX                 (62)
#define R_C_REVERB2_RX                 (63)
#define R_C_PILOT3_RX                  (64)
#define R_C_REVERB3_RX                 (65)

/*  CPE RX Channel Analysis states */
#define R_C_RATES1_RX                  (70)
#define R_C_CRC1_RX                    (71)
#define R_C_MSGS1_RX                   (72)
#define R_C_CRC2_RX                    (73)
#define R_C_MEDLEY_RX                  (74)

/*  CPE RX Exchange states */
#define R_C_RATES_RA_RX                (80)           // RCRatesRARxF
#define R_C_CRC_RA1_RX                 (81)           // RCCrcRARxF
#define R_C_MSG_RA_RX                  (82)           // RCRatesRARxF
#define R_C_CRC_RA2_RX                 (83)           // RCCrcRARxF        set gft_RCExchRARcvFlag=RECEIVE_OK1
#define R_C_REVERB_RA_RX               (84)           // RCReverbRARxF     * fail

#define R_C_MSG2_RX                    (85)
#define R_C_CRC3_RX                    (86)
#define R_C_RATES2_RX                  (87)
#define R_C_CRC4_RX                    (88)
#define R_C_BG_RX                      (89)
#define R_C_CRC5_RX                    (90)
#define R_C_REVERB5_RX                 (91)

#define R_C_SHOWTIME_RX                (94)
#define R_C_SHOW_TO_FR_PAUSE_RX             (95)

#define R_C_ECT_RX                     (97)

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#define NLNF_QUIET_TX                   (120)
#define NLNF_REVERB_TX                  (121)
#define NLNF_QUIET1_TX                  (122)
#define NLNF_HPAR_TX                    (123)

#define NLNF_SYNC_RX                    (125)
#define NLNF_HYBPGA_RX                  (126)
#define NLNF_NOP_RX                     (127)
#define NLNF_QLN_RX                     (128)
#define NLNF_NOP1_RX                    (129)
#define NLNF_ECHO_RX                    (130)
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)

/*  CPE TX Handshake states */
#define R_SILENT0_TX                (150)
#define R_TONES_REQ_TX                    (151)
#define R_SILENT1_TX                (152)
#define R_TONE1_TX                        (153)
#define R_FLAG1_TX                        (154)
#define R_HS_MSG_TX                       (155)
#define R_GALF2_TX                        (156)
#define R_FLAG2_TX                        (157)
#define R_QUIET_EF1_TX                    (158)

/*  CPE RX Handshake states */
#define R_C_SILENT1_RX                    (160)
#define R_C_TONES_RX                   (161)
#define R_C_GALF1_RX                   (162)
#define R_C_FLAG1_RX                      (163)
#define R_C_HS_MSG_RX                     (164)
#define R_C_FLAG2_RX                      (165)
#define R_C_GALF2_RX                      (166)
#define R_C_QUIET_EF1_RX                  (167)


/*  EOC states */
#define  EOC_IDLE_STATE_RX             (200)
#define  EOC_DATA_WRITE_ODD_STATE_RX         (201)
#define  EOC_DATA_WRITE_EVEN_STATE_RX     (202)
#define  EOC_DATA_READ_ODD_STATE_RX       (203)
#define  EOC_DATA_READ_EVEN_STATE_RX         (204)
#define  EOC_CRC_NOTCOR_STATE_RX          (205)
#define  EOC_CRC_REQCOR_STATE_RX          (206)

/*  Maximum number of states */
#define MAX_STATES               (BIS_STATES_START + 210)
#define GHS_MAX_STATES                                  (20)



/* =============================================================== */
/*  TX state length */
/* =============================================================== */

/*  CPE TX Handshake states length */
#define R_SILENT1_TX_LEN               (862)       /*  200ms (should be 50ms ~ 500ms) */

/*  CPE TX Transceiver Training states length */
#define R_QUIET2_TX_LEN                (128)
#define R_REVERB1_TX_LEN                     (4096)
#define R_QUIET3_TX_LEN                      (2048)
#define R_ECT_TX_LEN                         (512)
#define R_REVERB2_TX_LEN                     (1024)
#define R_ECT_WT_TX_LEN                (16+8+6)    /* 16=R_C_PILOT3_WT_LEN */
/* require DELAY_CONNECTIVITY_ALIGNMENT >=2, here, DELAY_CONNECTIVITY_ALIGNMENT = 6, */

/*  CPE TX Channel Analysis states length    */
#define R_SEGUE1_TX_LEN                   (10)
#define R_REVERB3_TX_LEN               (1092)
#define R_REVERB3_TX_TIMEOUT           (4000)
#define MIN_R_REVERB3_TX_CONT_LEN         (20)
#define R_SEGUE2_TX_LEN                   (10)
#define R_RATES1_PRFX_LEN              (32)
#define R_RATES1_TX_LEN                (384)
#define R_CRC1_TX_LEN                  (16)
#define R_MSGS1_TX_LEN                 (48)
#define R_MEDLEY_TX_LEN                (16384)
#define R_REVERB4_TX_LEN               (128)

/*  CPE TX Exchange states length      */
#define R_MSG_RA_TX_LEN                (10)
#define R_CRC3_TX_LEN                  (2)
#define R_RATES_RA_TX_LEN              (1)
#define R_REVERB_RA_TX_TIMEOUT            (4000)
#define R_MSG2_TX_LEN                  (4)
#define R_RATES2_TX_LEN                (1)
#define R_REVERB5_TX_TIMEOUT           (4000)
#define R_BG_TX_LEN                    (510)
#define R_REVERB6_TX_TIMEOUT           (4000)

/* =============================================================== */
/*  RX state length */
/* =============================================================== */

/*  CPE RX Handshake states length */
#define R_C_RECOV_MIN_COUNT                  (32)
#define R_C_QUIET_EF1_RX_MIN_LEN             (128)
#define R_C_QUIET_EF1_RX_MAX_LEN             (8000)

#define TIME_100MS                     (431)
#define TIME_500MS                     (2156)         /*  number of DMT symbols per 500ms (500ms = 2156.25 symbols) */
//XDSLRTFW-2033 (Start_End)
#define TIME_8S                        (8*2*TIME_500MS)

/*  CPE RX Transceiver Training states length */
#define PLL_ACQUISITION_LEN0              (512-4)        /*  this number is picked to match testvector */
                                             /*  but not lose generosity */
#define PLL_FAST_ACQUISITION_LEN            (130)          /* After this number of frames, smaller Ki and Kp values should be used  */
#define PLL_REACQUISITION_LEN               (90)           /* 90 frames are used for PLL reacquisition after C_ECT */
#define PLL_ACQUISITION_LEN0_FR              (378)       /* this number is picked to match testvector
                                             shall be retuned  */

#define R_C_QUIET2_RX_TIMEOUT               (2048)         //Maximum length RCQuiet2Rx can be
#define R_C_PILOT1_WT_LEN                    (8)
#define R_C_PILOT1_THR_LEN                   (128)       /*  should be set < PLL_ACQUISITION_LEN0 */
#define LOG2_R_C_PILOT1_THR_LEN              (7)
#define R_C_PILOT1_THR_OFFSET          (7)            /* accumulate power from gs_RxFirstChannel+R_C_PILOT1_THR_OFFSET */
#define R_C_QUIET3A_MAX_RX_LEN            (512)
#define R_C_REVERB1_WT_LEN                   (16)
#define R_C_REVERB1_RX_LEN                   (512)
#define R_C_PILOT2_RX_LEN                    (3072)
#define R_C_PILOT2_WT_LEN                 (16)
#define R_C_ECT_RX_LEN                       (512)
#define R_C_REVERB2_RX_LEN                   (1536)

#define PGA_SETTLING_TIME              (5)            /* wait length after setting PGA */
#define R_C_REVERB2_WT_LEN             (16)

#define NUM_FRAME_ALIGN_SYMBOLS           (64)
#define LOG2_NUM_FRAME_ALIGN_SYMBOLS      (6)

#define R_C_REVERB2_ACCUM_LEN_CHANEST     (256)
#define LOG2_R_C_REVERB2_ACCUM_LEN_CHANEST   (8)

#define R_C_REVERB2_ACCUM_LEN_HLIN        (64)
#define LOG2_R_C_REVERB2_ACCUM_LEN_HLIN      (6)

// training
#define NUM_FDQ_TRAINING_SYMBOLS_MEDLEY      (128)
#define LOG2_NUM_FDQ_TRAINING_SYMBOLS_MEDLEY (7)
#define NUM_FDQ_TRAINING_SYMBOLS_TEST     (128)
#define LOG2_NUM_FDQ_TRAINING_SYMBOLS_TEST   (7)
//showtime
#define DEFAULT_LOG2_NUM_SHOWTIME_FDQ_TRAINING_SYMBOLS      (8)
// fast retrain
#define NUM_FDQ_TRAINING_SYMBOLS       (256)
#define LOG2_NUM_FDQ_TRAINING_SYMBOLS     (8)

#ifdef ADSL_62
#define MAX_REIM_ACCUM_LENGTH  (256)
#endif

#define TDQ_STABLIZE_LEN               (4)
#define R_C_PILOT3_RX_LEN              (512)
#define R_C_PILOT3_WT_LEN              (16)
#define NUM_PILOT_EST_SYMBOLS          (32)        /*  number of symbols used to estimate pilot tone */
#define LOG2_NUM_PILOT_EST_SYMBOLS        (5)            /*  set to log2(NUM_PILOT_EST_SYMBOLS) */
#define NUM_DEC_TRAINING_SYMBOLS       (128)       /*  number of symbols for DEC training */
#define LOG2_NUM_DEC_TRAINING_SYMBOLS     (7)            /*  set to log2(NUM_DEC_TRAINING_SYMBOLS)          */
#define  DEC_SETTLE_TIME                     (4)
#define R_C_REVERB3_LEN                (1024)
#define R_C_REVERB3_WT_LEN             (16)
#define R_C_SEGUE1_LEN                 (10)

/*  CPE RX Channel Analysis states length */
#define R_C_RATES1_RX_LEN              (992)
#define R_C_RATES1_PRFX_LEN               (32)
#define R_C_CRC1_RX_LEN                (16)
#define R_C_MSGS1_RX_LEN               (48)
#define R_C_MEDLEY_WT_LEN              (8)
#define R_C_MEDLEY_RX_LEN              (16384)
#define R_C_REVERB4_TIMEOUT               (6000)
#define R_C_MEDLEY_TIMEOUT             (R_C_MEDLEY_RX_LEN+R_C_REVERB4_TIMEOUT+10)

/*  CPE RX Exchange states length */
#define R_C_SEGUE2_LEN                 (10)
#define R_C_CRC3_RX_LEN                (2)
#define R_C_MSG_RA_RX_LEN              (6)
#define R_C_RATES_RA_RX_LEN               (120)
#define R_C_REVERB_RA_TIMEOUT          (4000)
#define R_C_MSG2_RX_LEN                (4)
#define R_C_CRC4_RX_LEN                (2)
#define R_C_RATES2_RX_LEN              (1)
#define R_C_BG_RX_LEN                  (2*TX_NUM_TONES-2) // TX_NUM_TONES pair of (bi,gi) excluding DC and one-half of the sampling rate
#define R_C_REVERB5_TIMEOUT               (4000)

#define  R_PRE_SHOWTIME_LEN               (10)  // Same length for Rx, Tx.



/* ============================================================================================ */
/*  States not specified in G.992.2 */
/* ============================================================================================ */

/* macros used in showtime DEC adaptation */
#define DEC_ADAPTATION_DISABLED     (0)
#define DEC_ADAPTATION_INITIALIZE   (1)
#define MEASURE_ALIGNMENT        (2)
#define CALC_CAPTUREOFFSET       (3)
#define AVERAGE_RX_DATA          (4)
#define CAPTURE_TRAINING_DATA    (5)
#define DEC_COEF_UPDATE          (6)
#define DEC_COEF_DOWNLOAD        (7)

#define DEFAULT_LOG_DEC_ADAPT_NUM_FRAME_AVG  (7)

#define WAIT      (1)
#define START     (2)
#define ACTIVE    (3)
#define DONE      (4)
//XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining (START)
//TDQ & DEC coefficient downloading sub states into the DEC adaptation RAM.
#define LOAD_TDQ        (0)
#define LOAD_DEC_PHASE_1   (1)
#define LOAD_DEC_PHASE_0   (2)
#define DEC_COEF_WR_EN     (3)
//XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining (END)
/*  states of SNR calculation carried out in showtime, which are assigned to variable guc_ShowtimeSnrCalcState */
#define SHOWTIME_SNR_CALC_DISABLE         (0)            /*  disable calculation */
#define SHOWTIME_SNR_CALC_INITIALIZE      (1)            /*  Initialize in prep for accumulation */
#define SHOWTIME_SNR_CALC_ACCUMULATE_FRAMES  (2)            /*  start accumulating frames of data */
#define SHOWTIME_SNR_CALC_PERFORM_CALC    (3)            /*  perform SNR calculation */

/*  states of FDQ adaption calculation carried out in showtime, which are assigned to variable guc_FdqAdaptationState */
#define FDQ_ADAPTATION_DISABLE            (0)            /*  disable FDQ adaptation */
#define FDQ_ADAPTATION_INITIALIZE         (1)            /*  initialize FDQ structure */
#define FDQ_ADAPTATION_ACCUMULATE_FRAMES  (2)            /*  accumulate frames for FDQ adaptation */
#define FDQ_ADAPTATION_UPDATE_COEFFICIENTS   (3)            /*  update FDQ coefficients (not loaded yet) */
#define FDQ_ADAPTATION_LOAD_COEFFICIENTS  (4)            /*  load updated FDQ coefficients */
#define FDQ_ADAPTATION_COEFFICIENTS_LOADED   (5)            /*  Loading of coefficients is done */

/*  states of DD processing carried out in showtime, which are assigned to variable gft_doDDSnrFdqUpdate */
#define DD_DISABLE                  0
#define DD_ENABLE                1
#define DD_HALT                     2
/*  states of DD snr/fdq processing state m/c, which are assigned to variable guc_ddProcState */
#define DD_PROC_DISABLE          (0)            /*  disable DD processing */
#define DD_PROC_INITIALIZE       (1)            /*  Initialize and pre-processing in prep for accumulation */
#define DD_PROC_PRE              (2)            /* DD pre-processing, compute 1/gain, shifts etc */
#define DD_PROC_ACCUMULATE_FRAMES   (3)            /*  start accumulating frames of data */
#define DD_PROC_POST          (4)            /*  DD post processing, update counters */
#define DD_PROC_WAIT          (5)            /*  DD processing, wait state */
//XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (START)
#define DD_PROC_DISABLE_HW_SNR_FDQ              (6)
#define DD_PROC_READ_FDQ1                       (7)
#define DD_PROC_READ_FDQ2                       (8)
#define DD_PROC_SETUP_RTV0_RCD_OUT              (9)
#define DD_PROC_SETUP_RTV1_SFDQ_OUT             (10)
#define DD_PROC_WAIT_TO_FW_SNR_FDQ              (11)
//XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (END)

/* The following FDQ adaptation states are used to provide manual control of the coefficients   */
/* and are used for debug and test purposes only.  Note that setting the guc_FdqAdaptationState */
/* to one of these states will force the process to exit from its normal FDQ adaptation         */
/* state machine.  A typical use of this mechanism would be to zero an FDQ coefficient in order */
/* to force FEC/CRC indications.                                              */

#define FDQ_MANUAL_LOAD_COEFFICIENTS      (6)            /*  load manually set FDQ coefficients */
#define FDQ_MANUAL_COEFFICIENTS_LOADED    (7)            /*  Loading of manual coefficients is done */

/*  commanded PLL states, which are assigned to variable guc_CommandedPllState */
#define PLL_DISABLE                         (0)             /*  disable the PLL */
#define PLL_RESET_REFERENCE_TONE            (1)             /*  command the PLL to reset the reference tone */
#define PLL_PERFORM_PHASE_LOCK              (2)             /*  command the PLL to perform phase lock */

/*  training states, which are assigned to guc_TdqTrainingState, guc_FdqTrainingState, and guc_EcTrainingState */
#define TRAINING_WAITING               (0)            /*  indicate the waiting for training to start */
#define TRAINING_IN_PROGRESS           (1)            /*  indicate the training is in process */
#define TRAINING_DONE                  (2)            /*  indicate the training is done */
#define BKGDTASK_WAITING               (0)
#define BKGDTASK_IN_PROGRESS           (1)
#define BKGDTASK_DONE                  (2)
#define RXTONEORDERLOAD_WAITING           (0)
#define RXTONEORDERLOAD_BKGD_IN_PROGRESS  (1)
#define RXTONEORDERLOAD_TC_LOAD           (2)
#define RXTONEORDERLOAD_BKGD_DONE         (3)

#define SILENCE_WAIT                   (0)
#define SILENCE_IN_PROGRESS            (1)            /*  indicate the training is in process */
#define SILENCE_DONE                   (2)            /*  indicate the training is done */


#ifdef DANUBE
#define TXILV_INIT_BKGD_WAITING             (0)
#define TXILV_INIT_BKGD_IN_PROGRESS         (1)
#define TXILV_INIT_BKGD_DONE                (2)
#define RXDILV_INIT_BKGD_WAITING            (0)
#define RXDILV_INIT_BKGD_IN_PROGRESS        (1)
#define RXDILV_INIT_BKGD_DONE               (2)
#endif

/* CPE Pre-showtime (test) state length. Same for Rx and Tx */
#define R_PRE_SHOWTIME_TX              (50)  // Start state for showtime-only tests.
#define R_C_PRE_SHOWTIME_RX               (96)  // Start state for showtime-only tests.

/* single step state definitions used to single step through state machine */

#define SSTEP_OFF             0
#define SSTEP_WAITING_FOR_TRIGGER   1
#define SSTEP_PAUSE              2
#define SSTEP_ONETIME            3

// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
#define PILOT_AV_COUNT (16)
#define PILOT_AV_SHIFT (4)
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)

#endif /*  #ifndef RT_STATE_H */

