/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _RT_TONES_H
#define _RT_TONES_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             rt_tones.h
 * DESCRIPTION:      Header file defining initialization tones.
 *
 **********************************************************************/

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
 // *****************************************************************************
// rt_tones.h
//
// History
//
// 04/12/2013 Sriram Shastry: It  has seen in DTAG lab that due to  Xtalk from neighbouring  line , there is false Ctone detection
//             Fine tuned GHs detection scale factor. cmv OPTN 33 0 bit 13 (0x2000) enabled by default.
//              Grep for :  XDSLRTFW-1402 :IOP_DS_ALL_ALL_BoostGhsToneDetectScale_XtalkForceDmtT1413
//
// *****************************************************************************


/* ======================================================================== */
/*  TX Tones and Tone Power */

/*  Amplitudes provided below assume tone has equal I and Q magnitudes */

/*  Note:  Consider transfer characteristics of AFE here */
/* ======================================================================== */

/* the following carriers are compliance with T1.413 issue 2                           */
#ifdef ISDN
#define NC_MSGS1        75 /* tone 75-78, carriers for C_MSG2 */
#else
#define NC_MSGS1        43 /* tone 43-46, carriers for C_MSG2 */
#endif

#define NC_MSGS2        91 /* tone 91-94, backup carriers */

#define C_RECOV_TONE    68

#define TX_NEG04DBM         ENCGAIN2
/* #define TX_NEG28DBM         (TX_NEG04DBM >> 4) */

#define C_PILOT_POWER_HI    TX_NEG04DBM

#define R_RECOV_POWER       TX_NEG04DBM

#define R_LINEPROBE_POWER   TX_NEG04DBM

/* ======================================================================== */
/*  RX Tones and Detection Parameters */

/*  Amplitudes provided below assume tone has equal I and Q magnitudes */

/*  Note:  Consider transfer characteristics of AFE here */
/* ======================================================================== */

/* the following carriers are compliance with T1.413 issue 2 */
#ifdef ISDN
#define NR_MSGS1        44 /* tone 44-47, carriers for R_MSG2  */
#define NR_MSGS2        49 /* tone 49-52, backup carriers */
#else
#define NR_MSGS1        10 /* tone 10-13, carriers for R_MSG2  */
#define NR_MSGS2        20 /* tone 20-23, backup carriers */
#endif

#define RX_FIRST_PWR_CHN   33 /* tones for compute power cutback */
#define RX_LAST_PWR_CHN    127

#define C_RECOV_TONE_MIN   66 /* minimum tone index used for detection of C_RECOVER_TONE */
#define C_RECOV_TONE_MAX   70 /* maximum tone index used for detection of C_RECOVER_TONE */


#define R_RECOV_TONE    20 /* R recover tone number */
#define R_RECOV_TONE_MIN   15 /* minimum tone index used for detection of R_RECOVER_TONE */
#define R_RECOV_TONE_MAX   25 /* maximum tone index used for detection of R_RECOVER_TONE */

#define NUM_REVERB_SEGUE_BINS   (10)   // Only 8 tones are used for reverb segue detection.               //XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2

#define RXPWR_GUARD_BITS        8
#define DETECT_SCALE_AVDSL      5      /* XDSLRTFW-2191 */
#define DETECT_SCALE_ISDN_HSK   4      //XDSLRTFW-1402 :IOP_DS_ALL_ALL_BoostGhsToneDetectScale_XtalkForceDmtT1413(Start_End)
#define DETECT_SCALE            3

#ifdef ISDN
#define DETECT_MIN              0x0010
#else
#define DETECT_MIN              0x0004
#endif

#define R_C_REVERB_FR1_THR_SCALE   10     /*  10 times above background noise */

#define R_C_REVERB1_DET_CNT     6

#ifdef ISDN
#define R_C_PILOT1_1A_CNT       3
#else
#define R_C_PILOT1_1A_CNT       8
#endif

#define R_C_RECOV_CNT           3

#endif   /* _RT_TONES_H */

