/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _RX_EOC_H
#define _RX_EOC_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             rx_eoc.h
 * DESCRIPTION:      Header file containing functions and variables for
 *                   receiver Embedded Operations Channel (EOC)
 *                   operations.
 *
 **********************************************************************/

#include "typedef.h"
#include "eoc.h"

/**********************************************************************
 * VARIABLES
 **********************************************************************/
extern RxEocDecodStruct_t gt_RxEocDecod;        /* structure containing RX msg decoder variables */
extern RxEocDecodStruct_t *gpt_RxEocDecod;      /* pointer to gt_RxEocDecod */
extern RxEocReadStruct_t gt_EocRxReadBuf;
extern RxEocReadStruct_t *gpt_EocRxReadBuf;     /* pointer to gt_EocRxReadBuf */

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
extern void RxEocInit(void);
extern void InitEocRegisters(void);
extern void RxEocHandler(int16, uint8);

void RxEocProcessor(void);
void RxEocMsgDecod(int16 s_EocMsg, RxEocDecodStruct_t *pt_DecodMsg);
void RxIdleStateHandler(void);
void RxResetVariables(void);
void RxSetStateVariables(uint16 us_rx_state, uint16 us_msg_length);
void RxWriteStateHandler(uint8 uc_par, uint16 us_nextstate, uint16 us_msg_length);
void RxReadStateHandler(uint16 us_rx_acceptable_msg, uint16 us_nextstate, uint16 us_msg_length);

void Rx_DMT_ClearEOC_msg_handler(void);

#endif /* _RX_EOC_H */

