/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _RX_PLAM_H
#define _RX_PLAM_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             rx_plam.h
 * DESCRIPTION:      Header file containing functions and variables for
 *                   Rx PLAM computations.
 *
 **********************************************************************/

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
#include "plam.h"

#ifdef DO_PLAM

/* total counts of CRC, RS, HEC on far-end */
extern int16 gsa_febe_cnt[];
extern int16 gsa_ffec_cnt[];
extern uint32 gla_febe_cnt[];
extern uint32 gla_ffec_cnt[];
extern uint32 gula_fhec_cnt[];

/* counts of problems that lasted 1sec */
extern int16 gs_ecs_fe_cnt;
extern int16 gs_loss_fe_cnt;
extern int16 gs_es_fe_cnt;
extern int16 gs_ses_fe_cnt;
extern int16 gs_uasl_fe_cnt;

/* failure byte */
extern int16 gs_FarEndFailure;

/* total counts for ATM state machine */
extern uint32 gula_tot_cell_cnt[MAX_ATM_SIZE];
extern uint32 gula_tot_hec_cnt[MAX_ATM_SIZE];
extern uint32 gula_idle_cell_cnt[MAX_ATM_SIZE];
extern uint32 gula_non_idle_cell_cnt[MAX_ATM_SIZE];
extern uint32 gula_dropped_cell_cnt[MAX_ATM_SIZE];
extern uint32 gula_dropped_cell_fullbuffer_cnt[MAX_ATM_SIZE];
extern uint32 gula_bit_error_cnt[MAX_ATM_SIZE];

/* functions implemented in rx_plam.c */
void RxPlamProcessor(void);

#endif /* DO_PLAM */

#endif /* _RX_PLAM_H */

