/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _SACH_H
#define _SACH_H

//===============================================================
// This header file declares all functions in the Sachmo API.
//===============================================================

extern int32 SACHMO_RegisterWithChannel(uint8 X);
extern int16 SACHMO_Ready(void);
extern int16 SACHMO_NotReady(void);
extern int16 SACHMO_GetChannelState(uint8 *puc_ChannelState);
extern int16 SACHMO_TerminateChannel(void);
extern int16 SACHMO_WriteUpstreamSamples(int16 *ps_DataBuffer, int16 s_count);
extern int16 SACHMO_WriteDownstreamSamples(int16 *ps_DataBuffer, int16 s_count);
extern int16 SACHMO_ReadUpstreamSamples(int16 *pl_RxSamples, int16 s_count, int16 *s_SamplesRead);
extern int16 SACHMO_ReadDownstreamSamples(int16 *pl_RxSamples, int16 s_count, int16 *s_SamplesRead);



#define SAC_RETCODE_FAILURE                0
#define SAC_RETCODE_SUCCESS                1
#define SAC_RETCODE_UNREGISTERED           2
#define SAC_RETCODE_ALREADY_REGISTERED     3
#define SAC_RETCODE_STATENOTREADY          4
#define SAC_RETCODE_STATEREADY             5
#define SAC_RETCODE_STATETERMINATED        6
#define SAC_RETCODE_NONCAUSAL              7
#define SAC_RETCODE_TIMEOUT                8
#define MAX_SIZE                          1536


// Types recognized by RegisterWithChannel()
#define SAC_TYPE_RT                         0
#define SAC_TYPE_CO                         1
#define SAC_TYPE_MASTER                     2

//Values returned by GetChannelState()
#define SAC_CHANSTATE_NOTREADY              11
#define SAC_CHANSTATE_READY                 12
#define SAC_CHANSTATE_TERMINATED            13
#define SAC_RETCODE_NODATA                  14


#endif
