/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _STATE_M_H
#define _STATE_M_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showtime.h
 * DESCRIPTION:      Header file for functions that implement the
 *                   showtime state.
 *
 **********************************************************************/
//*-------------------------------------------------------------------------------//
// showtime.h
//
// History
//
// 21/11/2012 Kannan:
//          1. Added function declaration to notify PPE that both TX and RX entered showtime.
//             Grep for "XDSLRTFW-541: Platform_VRX318"
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
//*-------------------------------------------------------------------------------//

#include "typedef.h"

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
extern void RShowtimeTxF_DMT(void);
extern void RShowtimeRxF_DMT(void);
//From showtime_rx_b.c
extern void SnrUpdate_PostProcess(void);
extern void detect_LOS(void);
extern void detect_SEF(void);
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)
//XDSLRTFW-541: Platform_VRX318 (START_END)
extern void DFE_PPE_LinkStatus_TxRxShow(void);

#endif /* _STATE_M_H */

