/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _SNR_H
#define _SNR_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             snr.h
 * DESCRIPTION:      Header file for calculating Signal-to-Noise Ratio
 *                   (SNR).
 *
 **********************************************************************/

// *******************************************************************************
//  snr.h
//
// History
//
// 16/01/2009 Vinjam: Added function prototypes to extract VirtualNoise( ) from the received
//          virtual noise break points.
//            Grep for XDSLRTFW-438 XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
// *******************************************************************************


/**********************************************************************
 * CONSTANTS
 **********************************************************************/
//training
#define NUM_SNR_TRAINING_SYMBOLS_FULL_INIT      1024  /* no. of symbols to compute SNR for C_MEDLEY */
#define LOG2_NUM_SNR_TRAINING_SYMBOLS_FULL_INIT 10
#define NUM_SNR_TRAINING_SYMBOLS_REVERB_DMT     128      /* no. of symbols to compute SNR for C_REVERB */
#define NUM_SNR_TRAINING_SYMBOLS_REVERB_ADSL2   1024
#define LOG2_NUM_SNR_TRAINING_SYMBOLS_REVERB_DMT   7
#define LOG2_NUM_SNR_TRAINING_SYMBOLS_REVERB_ADSL2 10
#define NUM_SNR_TRAINING_SYMBOLS_TEST        128
#define LOG2_NUM_SNR_TRAINING_SYMBOLS_TEST      7
#define NUM_SNR_TRAINING_SYMBOLS_ECT         128      /* no. of symbols to compute SNR during R_ECT */
#define LOG2_NUM_SNR_TRAINING_SYMBOLS_ECT    7
//showtime
#define DEFAULT_LOG2_NUM_SNR_TRAINING_SYMBOLS_SHOWT      9     /* default no. of symbols to compute SNR for SHOWTIME */
#define LOG2_NUM_SNR_TRAINING_SYMBOLS_ADCNOISE     8
#define NUM_SNR_TRAINING_SYMBOLS_ADCNOISE          256

// fast retrain
#define NUM_SNR_TRAINING_SYMBOLS_FR          128      /* no. of symbols to compute SNR for C_MEDLEY_FR */
#define LOG2_NUM_SNR_TRAINING_SYMBOLS_FR     7
#define NUM_SNR_TRAINING_SYMBOLS_TEST_FR     128      /* no. of symbols to compute SNR for C_MEDLEY_FR */
#define LOG2_NUM_SNR_TRAINING_SYMBOLS_TEST_FR   7

#define NUM_LINE_ATTENUATION_SYMBOLS_SHOWT      64      // no. of symbols to compute the line attenuation in Showtime
#define LOG2_NUM_LINE_ATTENUATION_SYMBOLS_SHOWT 6
#define NUM_SYMBOLS_NMS_AVG_ADSL1      64      // no. of symbols to compute SNR for NMS
#define LOG2_NUM_SYMBOLS_NMS_AVG_ADSL1 6

#define NUM_SYMBOLS_NMS_AVG_ADSL2      256      // no. of symbols to compute SNR for NMS
#define LOG2_NUM_SYMBOLS_NMS_AVG_ADSL2 8


/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
extern void InitSnr(int32 *pla_NoisePower, int16 s_first_chan, int16 s_last_chan);
extern void SnrCalc(int32 *pla_NoisePower, int16 *psa_snr, int16 s_first_chan, int16 s_last_chan);
extern int16 ConvertToDB(int32 l_xin);

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
//function prototypes added here
int16 GetTonePsd(int16 s_toneIdxIn, DsVnPSDDescriptorTable_t *pt_PSDDescIn);
void GetAdjacentBreakpts(int16 s_brkptIdxIn, int16 s_NumBrkptsIn, PSDRecord_t *pt_PSDRecIn,
                  int16 s_minToneIdxIn, int16 s_maxToneIdxIn, int16 *ps_leftToneIdxOut,
                  int16 *ps_leftToneAttenLevelOut, int16 *ps_rightToneIdxOut,
                  int16 *ps_rightToneAttenLevelOut);
int16 CalcAttenLevel(int16 s_toneIdx, int16 s_leftToneIdx, int16 s_leftToneAttenLevel,
               int16 s_rightToneIdx, int16 s_rightToneAttenLevel);
int32 NormAndDivide_32by16bit_with_rnd(int32 l_numer, int16 s_denom);
void NormAndDivideMantExp_32by16bit(int32 l_numer, int16 s_denom, int16 *ps_mant, int16 *ps_exp);
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)
void MovingAverage( int16 *sa_InBuf,int16 *sa_OutBuf,int16 s_firstCh,int16 s_LastCh,int16 s_WindowLen,int16 s_log2WindowLen);
void FindNoiseMarginSeparation(void);
int16 DecimalGain_24to_M14dB( int16 s_gain_dB);


#endif /* _SNR_H */

