/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _STATEIN1_H
#define _STATEIN1_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             statein1.h
 * DESCRIPTION:      Header file for state machine initialization
 *             functions.
 *
 **********************************************************************/

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
#include "ghs.h"

extern void tcb_init(void);
extern void InitBackground(void);
extern void InitTxLoadingFunctionFifo(void);
extern void InitRxLoadingFunctionFifo(void);
extern void InitStateMachine(void);
extern void InitGlobalVariables(void);
extern void InitGlobalVariables_DMT(void);
extern void InitModemTasks_PreHandshake(void);

extern void InitGlobalVariables_BisInfoTx(Adsl2AllInfo_t *pt_BisInfo);
extern void InitGlobalVariables_BisInfoRx(Adsl2AllInfo_t *pt_BisInfo);
extern void InitGlobalVariables2_BisInfoTx(Adsl2AllInfo_t *pt_BisInfo, int16 s_annex);
extern void InitGlobalVariables2_BisInfoRx(Adsl2AllInfo_t *pt_BisInfo, int16 s_annex);

extern void InitGlobalVariables_BisPlusInfoTx(Adsl2AllInfo_t *pt_BisPlusInfo);
extern void InitGlobalVariables_BisPlusInfoRx(Adsl2AllInfo_t *pt_BisPlusInfo);
extern void InitGlobalVariables2_BisPlusInfoTx(Adsl2AllInfo_t *pt_BisPlusInfo, int16 s_annex);
extern void InitGlobalVariables2_BisPlusInfoRx(Adsl2AllInfo_t *pt_BisPlusInfo, int16 s_annex);

#endif /* _STATEIN1 */
