/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _TDQ_INIT_H
#define _TDQ_INIT_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             tdq_init.h
 * DESCRIPTION:      Header file for the Time Domain Equalizer (TDQ)
 *                   initialization function.
 *
 **********************************************************************/

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
#define R_MAT_SIZE (TDQ_LENGTH + 1)

extern Float32 *fa_Rxx;                // vector that holds X'X
extern Float32 *fa_WFull;     // Fast TDQ.
extern Float32 *fa_A;      // holds A from (**)

extern Float32 *fa_TempBuf;               // temporary buffer to hold outputs of backsub
   // sparse matrix used for Cholesky (holds A and c)
extern Float32 *fa_R;
extern Float32 *fa_Xtz;       // X'z
extern Float32 *fa_Temp;

extern BkgdFunction TdqInit;

extern int32 gl_acc48H_p;
extern int32 gl_acc48H_n;
extern int32 gl_acc48L_p;
extern int32 gl_acc48L_n;

#endif /* _TDQ_INIT_H */

