/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _TRAIL_H
#define _TRAIL_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             trail.h
 * DESCRIPTION:      Header file for functions used for logging trail file.
 *
 **********************************************************************/
// *------------------------------------------------------------------------//
// trail.h
//
// History
//
// 26/08/2011 Sriram Shastry : Added Handshake code pointers to support ADSL Bonding.In the CLR-CL message added support for
// PME aggregation discovery, PME aggregation which is cmv controlled. Bonding is support for PTM TPS-TC function type .
// By default this is disabled. This is controlled via CMV DSL 12 0 & CNFG 17 0
// Grep for XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING
//
//
// 22/03/2013 Ram: Clock speed in VR9/VRX318 is 282.60MHz. Refer to document
//                 'ClkRstInt-CRI_xDSL_CPE_bonded.pdf' for more details
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
// *------------------------------------------------------------------------//


#ifdef LEAVE_TRAIL
#include <stdio.h>
#include "compiler.h"
#include "trail_data_const.h"
#include "ghs.h"
#include "const_bis.h"
#include "DebugBuffer.h"


#endif /*  LEAVE_TRAIL */

/**********************************************************************
 * VARIABLES
 **********************************************************************/

#ifdef LEAVE_TRAIL
extern FlagT gft_ShowtimeStateReached;
extern TRAILFILE trail_fid;
extern TRAILFILE crc_fid;

// BIS OLR specific
extern char OLR_MsgTypeName[MAX_OLR_TYPE][MAX_STATENAME_LEN];
extern char OLR_ResultState[MAX_OLR_RESULTS][MAX_STATENAME_LEN];
extern char OLRPM_ErrorName[MAX_OLRPM_ERROR_TYPE][MAX_STATENAME_LEN];
extern int16 gs_trail_deltaLp[NUM_DATA_PATHS], gs_trail_deltaBpn[NUM_DATA_PATHS];

extern   char StateName[MAX_STATES][MAX_STATENAME_LEN];  // Names of all State Functions. Printed to trail at each state transition.
extern  char HndshkMsgName[GHS_MAX_STATES][MAX_STATENAME_LEN];  // Names of all handshake message states
extern  char HSMsgType[GHS_MAX_HS_MSG_TYPES][MAX_STATENAME_LEN]; // Names of all handshake message types
extern  char PreferredModeName[MAX_NUM_PREFFERED_MODES][MAX_STATENAME_LEN];;// Names of the DSL(BIS AnnexA/L) preferred mode (mode that will decide different PSD mask value)
#endif /*  LEAVE_TRAIL */

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
#ifdef LEAVE_TRAIL
extern int16 OpenTrailFile(void);
extern void LeaveTrail(int32 l_SymbolCount, int16 s_State, int16 s_NextState, char *name);
extern void GhsLeaveTrail(int16 s_State, int16 s_NextState, int16 s_SymbolCount, char* stateDir, int16 msgType, Adsl2AllInfo_t *pt_Adsl2AllInfo);
extern void PrnHeader(void);
#endif   /*  LEAVE_TRAIL */
extern void PrnStatus(void);

extern int16 gs_SyncSymbolCaptureTone;

#ifdef COLLECT_SYNCSYMBOL_INFO
   extern int16 gs_RxSyncSymbolBufferIndex, gs_RxSyncSymbolCount;
   extern void CollectSyncSymbols(void);
#endif /* #ifdef COLLECT_SYNCSYMBOL_INFO */

#ifdef COLLECT_SHOWTIME_EVENTS_INFO
   extern void CollectBadSyncSymbols(void);
#endif

/****************************/
/* SOCRATES DEBUG TRAIL */
/*****************************/
#define DEBUG_TRAIL_SIZE         1024
#define DEBUG_TRAIL_SMALL_SIZE      64

//----------------------------------------
// Bits 1 through 4 are binary rather than unary coded,
// i.e. they specify one of 16 different 4-bit codes.

// Bits 0 and 5-14 are still treated as unary flags, and
// more than one may be set.
//----------------------------------------
// These are 4-bit binary codes
#define DEBUG_LOG_4BITMASK       (0x1e)
#define DEBUG_LOG_GHSCLINFO         (0x2)
#define DEBUG_LOG_PHASEERROR     (0x4)    // #ifdef PROFILE_PHASEERR ... #endif
#define DEBUG_FREEZE_STATE       (0x6)    // Calls Pause() and keeps transmitting current frame.
#define DEBUG_LOG_MIPS           (0x8)    // #ifdef PROFILE_TASKS ... #endif
#define DEBUG_LOG_TIMING         (0x10)      // #ifdef PROFILE_TASKS ... #endif
/*
#define TBD                   (0x0a)
#define TBD                   (0x0c)
#define TBD                   (0x0e)
#define TBD                   (0x12)
#define TBD                   (0x14)
#define TBD                   (0x16)
#define TBD                   (0x18)
#define TBD                   (0x1a)
#define TBD                   (0x1c)
#define TBD                   (0x1e)
*/
//----------------------------------------
// These are bit flags
#define DEBUG_LOG_STATESTRAIL    0x1
#define DEBUG_LOG_RXTONECAPTURE     0x20  // #ifdef PROFILE_TONE ... #endif
#define DEBUG_LOG_REVERBSIGNAL      0x40
#define DEBUG_LOG_CHANNELESTIMATE   0x80
#define DEBUG_LOG_OVHDMESSAGES      0x100
#define DEBUG_LOG_STSIGNALS         0x200
#define DEBUG_LOG_FD_FRAME       0x400
#define DEBUG_LOG_SHOW_EVENT     0x800

#define DEBUG_LOG_TXTONECAPTURE     0x1000   // #ifdef PROFILE_TONE ... #endif
#define DEBUG_LOG_RXMARGINPERTONE   0x2000

#define DEBUG_LOG_GHSMESSAGES    0x4000
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start_End)
#ifdef ADSL_BONDING
#define DEBUG_TRAIL_BONDING_TRAIL_ENABLE  0x8000
#endif


#ifdef DANUBE
#ifdef TARGET_HW
extern int16 gsa_TrainStatesTrail[];
extern int16 gsa_ShowTimeStatesTrail[];
extern int16 *gsa_StatesTrail;
#endif   // #ifdef TARGET_HW
#else
extern int16 gsa_StatesTrail[];
#endif

extern DebugTrailTriggerControl_t gt_debugTrailTriggerControl;
extern DebugTrailCollectControl_t gt_debugTrailCollectControl;
#ifdef DANUBE
extern DebugTrailCollectControl_t gt_TrailXmemCollectControl;
#endif

void isStateTrigger(int16 s_State, int16 s_SubState, int32 l_SymbolCount);

void isRxSubStateTrigger(void);
void isTxSubStateTrigger(void);
void DebugTrail(int16 s_count, ... );
void logShowtimeEventB(uint32 ul_data);
void logShowtimeEventA(uint32 ul_code, int16 s_data);



#define NUM_EVENTS_TO_LOG 2


#ifdef PROFILE_TASKS
/************************************************************/
/* Task Profile Variables for tracking maximum MIPS load */
/* for each TC and NTC task.                       */
/************************************************************/
   #define NUM_TRN_TX_TC_NTC  2  // Num Tx Tc/Ntc Tasks in Training
   #define NUM_TRN_RX_TC_NTC  3  // Num Rx Tc/Ntc Tasks in Training
   #define NUM_TRN_TC_NTC     (NUM_TRN_TX_TC_NTC + NUM_TRN_RX_TC_NTC)
   #define NUM_ST_TX_TC_NTC   4  // Num Tx Tc/Ntc Tasks in Showtime
   #define NUM_ST_RX_TC_NTC   4  // Num Rx Tc/Ntc Tasks in Showtime
   #define NUM_ST_TC_NTC      (NUM_ST_TX_TC_NTC + NUM_ST_RX_TC_NTC)
   #define NUM_TC_NTC         (NUM_TRN_TC_NTC + NUM_ST_TC_NTC)

   #define  TX_TC_FS    0     // Tx Frame Start TC
   #define  TX_NTC         1     // Tx NTC
   #define RX_TC_FS     2     // Rx Frame Start TC
   #define RX_TC_FDQ    3     // Rx FDQ Done TC
   #define RX_NTC       4     // Rx NTC
   #define  ST_TX_TC_FS    5     // Showtime Tx Frame Start TC-A
   #define  ST_TX_TC_DT    6     // Showtime Tx Data Transfer Done TC-B
   #define  ST_TX_TC_IFFT  7     // Showtime Tx Ifft Done TC-B
   #define  ST_TX_NTC      8     // Showtime Tx NTC
   #define ST_RX_TC_QAM 9     // Showtime Rx QAM Done TC-A
   #define ST_RX_TC_FDQ 10    // Showtime Rx FQD Done TC
   #define ST_RX_TC_ALP 11    // Showtime Rx AAI Done TC-B
   #define ST_RX_NTC    12    // Showtime Rx NTC

   #define TC_NTC_START_FLAG  0
   #define TC_NTC_END_FLAG    1

    extern uint16 gsa_LogMips[NUM_TC_NTC];
    extern uint16 gsa_MaxMips[NUM_TC_NTC];
    extern uint16 gsa_MaxMipsState[NUM_TRN_TC_NTC];
    extern uint16 gsa_MaxMipsSubState[NUM_TRN_TC_NTC];

   extern FlagT gft_RxCPInserted;

   /* Changed by kannan for Danube dsp clk of 120Mhz */
   //#define TIME_PER_FRAME_CP       20672   /* DMT_Frame_Time * DSP_Clk == 246MicroSec * 83.904MHz */
   //#define TIME_PER_FRAME_NO_CP    19456   /* DMT_Frame_Time * DSP_Clk == 231MicroSec * 83.904MHz */

   //#define TIME_PER_FRAME_CP       29520   /* DMT_Frame_Time * DSP_Clk == 246MicroSec * 120.00MHz */
   //#define TIME_PER_FRAME_NO_CP    27720   /* DMT_Frame_Time * DSP_Clk == 231MicroSec * 120.00MHz */

   //XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
   // For VR9/VRX-318
   #define TIME_PER_FRAME_CP       (69520)   /* DMT_Frame_Time * DSP_Clk == 246 MicroSec * 282.60 MHz */
   #define TIME_PER_FRAME_NO_CP    (65281)   /* DMT_Frame_Time * DSP_Clk == 231 MicroSec * 282.60 MHz */
   //XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

   void ProfileTaskInit(void);
   void LogMips(int16 s_taskId, int16 s_flag);
   void RxProfileTasks(void);
   void TxProfileTasks(void);
#endif /* #ifdef PROFILE_TASKS */

#ifdef PROFILE_PHASEERR
/************************************************************/
/* Profile Variable for logging phase error per substate.   */
/* Data stored in gsa_StatesTrail.                    */
/************************************************************/
   extern int16  gs_LogPhaseErr, gs_MaxPhaseErr, gs_MaxPhaseErrRxState, gs_MaxPhaseErrRxSubState;

   void ProfilePhaseErrInit(void);
   void LogPhaseError(void);
   void ProfilePhaseErr(void);
#endif  /* PROFILE_PAHSEERR */

#ifdef INSERT_ST_BRKPT
   /************************************************************/
   /* Macros that define breakpoint criteria.               */
   /* One can enable more than one criterias at a time         */
   /************************************************************/
   #define BRKPT_ON_CRC       (0x1)
   #define  BRKPT_ON_MRGN        (0x2)
   #define BRKPT_ON_LOS       (0x4)
   #define BRKPT_ON_LOSSEF_PILOT (0x8)

   extern int16 gs_stBrkpntCriteria;   //can enable more than one criterias @ a time, see trail.h
#endif

#endif /* _TRAIL_H */

