/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _TRAILEND_H
#define _TRAILEND_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             trailend.h
 * DESCRIPTION:      Header file for functions used for logging trail file.
 *
 **********************************************************************/

#include "typedef.h"

#ifdef LEAVE_TRAIL
#include <stdio.h>
#endif /*  LEAVE_TRAIL */

/**********************************************************************
 * VARIABLES
 **********************************************************************/
#ifdef LEAVE_TRAIL

extern FlagT gft_FDQ_PrintedToTrail;
extern FlagT gft_DS_BAT_PrintedToTrail;
extern FlagT gft_DS_FineGains_PrintedToTrail;
extern FlagT gft_US_BAT_PrintedToTrail;
extern FlagT gft_US_FineGains_PrintedToTrail;
extern FlagT gft_USDS_Payloads_PrintedToTrail;

extern char *BearerChannelNames[7];


/**********************************************************************
 * FUNCTIONS
 **********************************************************************/

void PrnResults(void);
void PrnInitialCLR(void);
void PrintFinalFDQ(void);
void PrintFinal_DS_BAT(void);
void PrintFinal_DS_FineGains(void);
void PrintFinal_US_BAT(void);
void PrintFinal_US_FineGains(void);
void OLRPM_PrnShowtimeParams(uint8,uint8, int16);
void OLR_PrnShowtimeParams(uint8, uint8);

#endif   /*  LEAVE_TRAIL */

#endif /* _TRAILEND_H */

