/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _TX_EOC_H
#define _TX_EOC_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             tx_eoc.h
 * DESCRIPTION:      Header file containing functions and variables for
 *                   transmitter Embedded Operations Channel (EOC)
 *                   operations.
 *
 **********************************************************************/

#include "typedef.h"
#include "eoc.h"

/**********************************************************************
 * VARIABLES
 **********************************************************************/
extern TxEocHandlerStruct_t gt_TxEocHandler;       /* structure of the TX EOC handler variables */
extern TxEocHandlerStruct_t *gpt_TxEocHandler;        /* pointer to this structure */
extern TxEocNetworkStruct_t gt_TxEocNetworkHandler;      /* structure of the TX EOC Network variables */
extern TxEocNetworkStruct_t *gpt_TxEocNetworkHandler; /* pointer to this structure */
extern RxEocHandlerStruct_t gt_RxEocHandler;       /* pointer to gt_RxEocHandler */
extern RxEocHandlerStruct_t *gpt_RxEocHandler;        /* pointer to this structure */
extern TxEocDgaspStruct_t gt_TxEocDgasp;
extern TxEocDgaspStruct_t *gpt_TxEocDgasp;            /* pointer to gt_TxEocDgasp */
extern FlagT gft_send_crc_corrupt_bits_flag;       /*  = FALSE, stop sending corrupt crc bits from ATU-R, TRUE otherwise */
extern FlagT gft_receive_crc_corrupt_bits_flag;       /*  = FALSE, stop receiving corrupt crc bits from ATU-C, TRUE otherwise */
extern FlagT gft_no_sync_flag;

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
extern void TxEocInit(void);
extern uint8 TxEocHandler(int16 s_frame_number);
extern void TxFormEocMsg(uint8 uc_address, uint8 uc_dataoropcode, uint8 uc_Parity, uint8 uc_auto_msg, uint8 uc_information, uint8 *uca_txoutbuf);

#endif /* _TX_EOC_H */

