/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef  _TX_PLAM_H
#define _TX_PLAM_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             tx_plam.h
 * DESCRIPTION:      Header file containing functions and variables for
 *                   Tx PLAM computations.
 *
 **********************************************************************/

// ******************************************************************
// tx_plam.h
//
// History
//
// 10/08/2011 Vinjam: Added a prototype for new global structure for detecting "LOM" (Loss Of Margin) defect.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 09/01/2013 Ram: Moved counters related to US Tx ATM processing from rx_plam.c and named them appropriately.
//                 Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
// ******************************************************************


#include "plam.h"

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/

/* Count of errors per second */
extern int16 gs_fec_ecs_cnt;
extern int16 gs_crc_cnt;
extern int16 gs_norm_crc_1sec;
extern int16 gs_los_cnt;
extern int16 gs_sef_cnt;
extern int16 gs_lpr_detect;
extern int16 gs_IB_lpr_cnt;

/* Count of errored seconds */
extern int16 gs_fec_err_sec_cnt;
extern int16 gs_los_err_sec_cnt;
extern int16 gs_sef_err_sec_cnt;
extern int16 gs_err_sec_cnt;
extern int16 gs_sev_err_sec_cnt;
extern int16 gs_unavail_err_sec_cnt;
//Feature_ALL_ALL_FT_ReInit_Triggers (Start)
//SMS01501977 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (Start)
extern uint8 guc_consecutive_sev_err_sec_cnt;
extern uint8 guc_consecutive_err_sec_cnt;
extern uint8 gft_TriggerLOMReInit;
//SMS01501977 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (End)
//Feature_ALL_ALL_FT_ReInit_Triggers (End)

/* Count of contiguous errored seconds  */
extern int16 gs_contiguous_bad_sec_cnt; /* Count of contiguous severely err sec */
extern int16 gs_contiguous_good_sec_cnt;  /* Count of contiguous good seconds */


extern FlagT gft_line_unavailable;
extern int16 gs_NearEndFailure, gs_NearEndFailureReported;
extern uint32 gula_hec_error_cnt[];
extern uint32 gula_fe_tot_cell_cnt[];
extern uint32 gula_fe_tot_hec_cnt[];
extern uint32 gula_fe_bit_error_cnt[];

//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
//extern uint32 gula_fe_idle_cell_cnt[];
//extern uint32 gula_fe_non_idle_cell_cnt[];
extern uint32 gula_tx_idle_cell_cnt[];
extern uint32 gula_tx_non_idle_cell_cnt[];
extern uint32 gula_tx_tot_cell_cnt[];
//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)


extern FailureCount_t gt_LOSneFailureCount, gt_LOFneFailureCount;

//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
extern FailureCount_t gt_LOMneFailureCount;


#ifdef DO_PLAM
   void TxPlamProcessor(void);
#endif /* DO_PLAM */

#endif /* _TX_PLAM_H */

