/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _TYPEDEF_H
#define _TYPEDEF_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: typedef.h
;
;  This file contains type definitions used by different files.
;
*****************************************************************************/
// ******************************************************************
// typedef.h
//
// History
//
// 03/06/2010 Bhadra: CMV INFO 107 is used to know the status of AFE, DFE and 3 GLP interface(VR9)
//                    underflow overflow and not ready condtions.
//                   Grep for "Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status"
//
// 16/07/2010 Sriram/Bhadra:Added new structure to support Amendment 3 to G.994.1 for Optional US interleaver depth.
//             Grep for XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth
//
// 19/07/2010  Bhadra:Added code for mapping of NE Tx counters(Idle Cell /Non Idle cells) to CMV CNTR 53
//             Grep for " XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping "
//
// 22/07/2010 Bhadra/Vinjam Srinivas/Palaksha: Code changes to maximise the  DS SNRM instead of INP protection
//             (Min INP will be anyways will be met).
//             The changes includes changing Dp and Rp loops run from Min value to Max value instead of
//             Max to min values for Fixed and Limited rate cases.
//             Allotted a new CMV "INFO 103 20 0x40" to favour DS Margin over DS INP.
//             This change takes into effect only if Bit #6 in cmv INFO 103 20 is Set to 1
//             Grep for XDSLRTFW-139:SMS00839860 PERF_DS_BisPlus_DSmarginIncrease
//                or code pointer "CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE"
//
// 05/08/2010 Nihar : Added a structure for Erasure decoding reporting
//          Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 06/10/2010 Bhadra: Added element for INFO 103 23
//          Grep for Feature_DS_BisPlus_ALL_DisableTrainingREINDetection
//
// 09/02/2011 Sriram: Use the special TSSI set from SMS00910375 in the range of
//            2100m to 4200m to improve the US rates against CNXT DSLAMs with FW
//            version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 18/04/2011 Sriram: Use the special TSSI set to improve the US rates against CNXT DSLAMs with FW version of 0x10.Added the Structure element for
//       INFO 103 26. Note element's 24,25 are imported from Danube platform so as to maintian Sync.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 26/08/2011 Sriram Shastry : Added Handshake code pointers to support ADSL Bonding.In the CLR-CL message added support for
// PME aggregation discovery, PME aggregation which is cmv controlled. Bonding is support for PTM TPS-TC function type .
// By default this is disabled. This is controlled via CMV DSL 12 0 & CNFG 17 0
// Grep for XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING
//
// 23/09/2011 Kannan: Added an element "us_OperatorSpBits5" in INFX_CMV"
//                    structure for  IOP purpose.
//                   Grep for XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI
//
// 28/09/2001 Raghu XDSLRTFW-316  PLL BW is changed based on SNR during Medley.
//                  This change in the bandwidth helps to reduce the DS CRC
//                  caused glitches introduced by TX SRC.
//  grep for XDSLRTFW-316
//
// 21/11/2011 Hanyu: Ported MFD code to VRx. Defined NLNF CMV INFO 121 structure elements for NLNF metrics and indicatione bits.
//            This feature is triggered by "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additinally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 02/12/2011 Balabath:Added new microstate STATs18D and 19D CMV DSL 16 is used inplace of INFO 121
//       for NLNF measurement.INFO 103 (6:11) are mapped to DSL 18 0 5 (Hybrid information)..
//            Additinally, DSL13 bit2 is used inplace of CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap
//
// 05/12/2011 Balabath/Sabrina: Use LATN to estimate loop length. Conversion values needs to be
//            empirically determined against GMX EVM, E67, D57 and BRCM DSLAMs.
//            They were verified against other chipsets including CTLM, STM in
//            different modes and loop conditions (straight loops and bridgedtaps).
//            Grep for SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate
//
// 04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
// 17/02/2012 Kannan: Aux Pilot SNR threshold is CMV controlled and is reduced from 16dB to
//            10dB to make it work on long 24DSL 16kft and FSAN Class B noise case at 3250m.
//            Grep for Feature_DS_ADSL1_ALL_AuxPilotMinSNR_Threshold
//
//15/03/2012 Kannan: 16/04/2009 Bhadra: Added code for bitload related changes in Universal Retransmission (G.INP)
//                   Added required variables for bitload.
//                     Grep for SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad to see changes.
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 07/06/2012 Vinjam: Added a structure to hold the Transmitter referred Downstream virtual noise break points.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 18/06/2012 Vinjam: Re-named "Params_t" structure's element "ft_TrellisSupported" to "us_VN_TCM_Supported".
//           This is done to convey the "Virtual Noise Selected" status as per VR9 Message Specifications doc (1.6.1).
//           Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 26/06/2012 Ram: Added code for mapping of ReTX Status counters to CMV CNTR 43,44
//                 and CMV RATE 2
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 23/08/2012 Vinjam: Added a structure for Interop bits common to ADSL/VDSL, attached to "CMV DSL 19"
//            Grep for "XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI"
// 26/11/2012 Kannan: Added mask for AFE Power up initialization
//                 grep for "XDSLRTFW-541: Platform_VR9_VRX318"
//03/09/2012 Anantha:  Changed variable name prefix to reflect change in data type
//          Grep pattern XDSLRTFW-496: Feature_T1413_Info
//
// 07/01/2013 Ram: Added fix for JIRA 575, Seperate out and align FW internal counters as per Msg spec
//                 Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
// 16/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by FW
//                 Added a new typedef as required by CMV 'DSL 19'
//                 (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 29/01/2013 ChihWen:
//          1. Modify reported ETR from 16-bit kbps format to 32-bit bps format.
//          2. Fix DS rate calculation when ReTx is on and Tp[1]=-1.
//          Grep for XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr
//
// 04/02/2013 Sooraj: Added a struct to support CMV "OPTN 25" for controlling EOC polling.
//            Grep for XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead
//
// 07/02/2013 Vinjam: Added support for "CMV CNFG 45" to select "G.Hs Toneset" as per VRx Msg Spec.
//            Inturn, "enale/disable" of "optional upstream interleaver depth" feature is moved to "CMV CNFG 46".
//            Grep for XDSLRTFW-699 XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 26/2/2013 Vinjam: Added new element "us_ActualINP" to "Params_t" structure. This is used to store the received far-end reported ActINP
//           Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 22/03/2013 Ram: Added few variables to aid splitting of 'FDQ co-effs computation' (during L2 entry and L2 exit) across symbols
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
//
// 27/05/2013 Varun : Added structures for Debug Buffer operation
//                    Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 19/06/2013 Anantha Ramu: Added member ul_EFTR to ReTX_Stats_t structure.
//                      Grep for XDSLRTFW-974 Fix_DS_DS_BisPlus_All_Reporting_ReTx_Counters
//
// 21/06/2013 Varun : Added strucures and variables needed for the Debug Buffer code of Showtime
//                    grep for "XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 25/06/2013 Kannan: Added sturcture to debug the DEC adaptation
//                    Grep for "XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest"
//
// 14/11/2013 : Sriram Shastry : BroadCom CO goes to indefinite stuck state against VR9 based Arcadyan board.
// It has been observed that Arcardyan board perform the splitter switch during first
// training to configure the splitter during first training.
// CPE is not computing the downstream power cut back based on the C-Comb2 siganl due to internal computaion error.
// The solution is : Apply 3dB DSPCB against Broadcom CO upto 2000M . After 2Km apply 1dB of DSPCB against
// Broadcom CO in Annex-J mode only ( Applicable for 3J and 5J mode)
//       Grep for XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN
//
// 04/01/2015 Anantha Ramu/TV Ram: Added fix for uncorrected DTUs due to Q full condition.
//            Grep for XDSLRTFW-1223.
//
// 18/11/2014 : Vinay : Added a new CMV (INFO 241) to capture the configuration of ADSL as a debug feature.
//       Grep for XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES
//
// 12/10/2015 Vinay: Extended DSL 3 by two more field. It contains the information of Pilot tone constellation. It can be
//                   read from the Winhost (DSL 3 2 for real part and DSL 3 3 for imaginary part)
//            Grep for XDSLRTFW-2419
//
//  2/12/2015 Sriram Shastry : Observed Quartz instabilities with  AVM  fritzbox[7490]. Added Detection algorithm for frequency drift and  phase drift
//  such that PLL adapt's to  fast setting  instead of  showtime setting .It helps to avoid showtime link drops in field
//
// Grep for : XDSLRTFW-2464
//
// 10/25/2016 Abu Rahman: XDSLRTFW-2882 : Wrong HS tone selection in case of DPBO (ADSL)
//          A new CTone Detection algorithm is developed which uses Average power of the CTones and their neighboring tones
//            instead of Average constellations of those tones (used in previous implementation).
//            New Tone Detection algorithm is described in GhsCToneDetectionAlgorithm() section.
//            Grep for XDSLRTFW-2882
// ****************************************************************************************************************************

#include <stdio.h>
#include "config.h"
#include "const.h"
#include "const_bis.h"

#include "typedef_base.h"

typedef void (*PtrToBkgdFunc)(void);
typedef void (BkgdFunction)(void);     // Use for external declarations for all background functions.
typedef void (LoadingFunction)(void);  // Use for external declarations for all loading functions.
typedef LoadingFunction *PtrToLoadingFunction;
typedef PtrToLoadingFunction LoadingFunctionFifo[];   // Use for external declarations for all loading functions.
typedef FILE *TRAILFILE;            // Used for trail file I/O.

typedef uint8 RxToneFlags[(RX_NUM_TONES+7)>>3]; // Array containing one bit per tone.
typedef uint8 TxToneFlags[(TX_NUM_TONES+7)>>3]; // Array containing one bit per tone.

/* ================================================================================== */
/* Structure type define */
/* ================================================================================== */

/* Task Control Block (TCB) */
typedef struct TCB_tag {
    PtrToFunc      TimeCriticalTask;   /* ptr to time-critical portion  */
    PtrToFunc      NonTimeCriticalTask;   /* ptr to non-time-critical portion */
    int16           TaskID;   /* Bit 15 determines if active, Bit14-12 determines Thread */
    struct TCB_tag *Next;  /* ptr to next TCB in Task Queue */

}TCB_t;


/* Structure used for a queue of task control blocks */
typedef struct {
    TCB_t *Front;
    TCB_t *Rear;
}Queue_t;

typedef struct
{
    int16  s_ExcessMarRedDB;                /* Excess Margin Reduction (dB) */
    int16  s_ExcessMarFGReduction;          /* Excess Margin Fine Gain Reduction*/
} FineGainInfo_t;

/* Structure used for rate options */
typedef struct {
    uint16  *pus_ReqBytes;  /*  pointer to number of check bytes per symbol excluding synch byte for different bearer channels  */
    uint8   *puc_CheckBytes;  /*  pointer to number of check bytes per symbol    */
    uint8   uc_S;       /* number of DMT symbols per FEC codeword */
    uint16  us_D;       /* interleave depth  */
} Option_t;


/* Structured used for C_MSG_RA */
typedef struct {
    uint16  us_MinRequiredInitDSSnrMargin;   /* minimum required DS SNR margin at Initialization */
    uint16  us_MinRequiredSSDSSnrMargin;     /* minimum required DS SNR margin in steady state */
    uint16  us_MaxDSSnrMargin;            /* maximum allowed DS SNR margin at Initialization and in steady state (-32 to 31dB) */
} RCMsgRA_t;

/* Structure used for FDQ adaptation routines */
typedef struct {
    int16 *psa_rcvbuf;              /* pointer to received tone buffer */
    int16 *psa_refbuf;              /* pointer to reference tone buffer */
    int16  s_CurrChannel;           /* current channel number */
    int16 *psa_FDQ_coef;            /* pointer to the current FDQ coefficient buffer */
    uint8 *psa_FDQ_exp;             /* pointer to the current FDQ exponent */
} FdqAdaptStruc_t;

/* Structure used for state machine control */
typedef struct {
    int32  l_TXCurrentStateLen;         /* Duration in symbols of current TX state */
    int16  s_TXFollowingState;         /* State to enter when current TX state completes */
    uint16 *pus_TX_CRC;                 /* Pointer to CRC of message being transmitted */
    uint8  *puca_TX_message;            /* Pointer to message being transmitted */
    int16  *psa_RXSNRBuf;               /* Point to SNR Buffer */
    PtrToFunc pF_TxFollowingState;     /* Pointer to the next TX state machine function */

    int32  l_RXCurrentStateLen;         /* Duration in symbols of current RX state */
    int16  s_RXFollowingState;         /* State to enter when current RX state completes */
    int16  s_RxTimeOutLen;              /* Duration for timeout in that particular state */
    uint8  *puc_RXmessage;              /* Pointer to message being received */
    int16  s_RXmessage_len;             /* Length, in bytes, of message being received */
    int16  s_RXmessage_prefix_len;      /* Prefix length, in bytes, of message being received */
    uint16 *pus_RXcomputed_CRC;         /* Pointer to computed CRC of message being received */
    uint16 *pus_RXreceived_CRC;         /* Pointer to received CRC of message being received */
    int16  s_TxSubStateLen;             /* Duration of symbols in the TX Substate */
    PtrToFunc pF_RxFollowingState;     /* Pointer to the next RX state machine function */
} StateMachCntrlStruc_t;

typedef struct{
    int16   s_ReqdBits;                 /*  total number of bits required to support this profile */
    int16   sa_BG[GLITE_DS_NUM_TONES];       /*  bits and gains allocations of profile */
    int16    s_R;                        /*  number of check bytes per symbol */
    int16    s_S;                        /*  number of DMT symbols per FEC codeword */
    int16    s_D;                        /*  interleave depth  */


} RXProfileStruc_t;

typedef struct{
    int16   s_ReqdBits;                 /*  total number of bits required to support this profile */
    uint8   sa_bat[GLITE_US_NUM_TONES];       /*  bit allocations of profile */
    int16   sa_gain[GLITE_US_NUM_TONES];      /*  gains allocations of profile */
    int16    s_R;                        /*  number of check bytes per symbol */
    int16    s_S;                        /*  number of DMT symbols per FEC codeword */
    int16    s_D;                        /*  interleave depth  */


} TXProfileStruc_t;



/* Structure for Message Fifo */
typedef struct {
    uint16 *MessageBuffer; /* pointer to memory for all buffers */
    int16 BufferSize;   /* number of locations in buffer */
    int16 IndexOfOldest;
    int16 NextAvailable;
    int16 PendingMessageCount;
    int16 ErrorCode;
    uint16 us_OvflowCnt;  /* Fifo overflow counter  */
}MessageFifo_t;

/* Structure for OvhdMessage Fifo */
/* Structure for OvhdMessage Fifo */
typedef struct {
    uint16 us_StrucLength; // size of this data structure in 16bit word
    uint16 ErrorCode;      // Indicate fifo over/under flow error
    uint8 *MessageBuffer;  // pointer to memory for all buffers
    uint16 BufferSize;     // Fifo length in bytes
    uint16 IndexOfOldest;  // Read index from the start of the fifo
    uint16 NextAvailable;  // Write index from the start of the fifo
    uint16 us_OvflowCnt;   // # of bytes discarded due to overflow or underflow
}MessageOvhdFifo_t;

/* Structure for Function Fifo */
typedef struct {
    PtrToFunc *FunctionBuffer;   /* pointer to buffer of functions */
    int16 BufferSize;   /* number of locations in buffer */
    int16 IndexOfOldest;
    int16 NextAvailable;
    int16 PendingFunctionCount;
    int16 ErrorCode;
}FunctionFifo_t;

/* Structure used for various ADSL1 controls*/
typedef struct {
    int16 DsRateCap;
} Adsl1_Control_t ;


/* Structure used for C_MSGS1 */
typedef struct {
    uint16  us_MinRequiredSnrMargin;   /* minimum required SNR margin */
    uint16  us_TrellisCoding_Option;    /* Trellis coding option */
    uint16  us_EC_Option;           /* echo canceler option */
    uint16  us_NTR_Option;          /* NTR option; */
    uint16  us_FrameMode;           /* framing mode */
    uint16  us_PSDLevel;            /* transmit PSD during initialization */
    uint16  us_MaxBitsPerTone;         /* maximum numbers of bits per tone supported */
    uint16  us_T1413_Vendor_Id;        /* T1.413 vendor id */
    uint16  us_T1413_RevNo;            /* T1.413 revision number */
    uint16  us_T1413_Vendor_RevNo;     /* T1.413 Vendor revision number */
    uint8   uc_T1413_Ees;           /* T1.413 expanded exchange sequence */
} CMsgs1_t;

/* Structure used for R_MSGS1 */
typedef struct {
    uint16  us_TrellisCoding_Option;    /* Trellis coding option */
    uint16  us_EC_Option;           /* echo canceler option */
    uint16  us_Higher_BitRates;         /* support for Higher bit rates (S=1/2) */
    uint16  us_DS_DualLatency;          /* support for dual latency downstream */
    uint16  us_US_DualLatency;          /* support for dual latency upstream */
    uint16  us_NTR_Option;          /* NTR option; */
    uint16  us_FrameMode;           /* framing mode */
    uint16  us_MaxBitsPerTone;         /* maximum numbers of bits per tone supported */
    uint16  us_T1413_Vendor_Id;        /* T1.413 vendor id */
    uint16  us_T1413_RevNo;            /* T1.413 revision number */
    uint16  us_T1413_Vendor_RevNo;     /* T1.413 Vendor revision number */
    uint8   uc_T1413_Ees;           /* T1.413 expanded exchange sequence */
} RMsgs1_t;

/* Structure used for R_MSG_RA */
typedef struct {
    uint16  us_R;                /* number of RS check bytes per RS codeword (R) */
    uint16  us_K;                /* number of bytes per mux frame (K) */
    uint16  us_ncloaded;            /* no. of tones carrying data */
    uint16  us_AvLoopAttenu;        /* average loop attenuation */
    uint16  us_CodingGain;          /* coding gain used to compute Bmax */
    uint16  us_SnrMargin;           /* performance (SNR) margin with selected rate option */
    uint16  us_MaxInterleaveDepth;      /* Maximum Interleave Depth */
    uint16  us_TotalBitsPerSymbol;     /* total number of bits per DMT symbol, Bmax */

} RMsgRA_t;

/* Structure used for R_MSGS2 */
typedef struct {
    uint16  us_AvLoopAttenu;        /* Average DS Loop Attenuation */
    uint16  us_PerformMargin;       /* DS performance margin with selected rate option (in dB) */
    int16   s_TotalBitsSupported;      /* the maximum number of bits per symbol that the DS supports */
    uint16  us_EraseStoredProfiles;    /* If this bit is set to 1, all stored profiles are erased */
} RMsg2_t;

/* Structure used for R_MSGS2 and C_MSG2 */
typedef struct {
    uint16  us_AvLoopAttenu;        /* Average Loop Attenuation */
    uint16  us_PerformMargin;       /* performance margin with selected rate option (in dB) */
    int16   s_TotalBitsSupported;      /* the maximum number of bits per symbol that the DS supports */
    uint16  us_EraseStoredProfiles;    /* If this bit is set to 1, all stored profiles are erased */
} CMsg2_t;

/* Structure used by showtime TX and RX to do initialization */
typedef struct {

    int16   s_Nbc;               /* number of frame bearers to be supported (Nominal: 1,2)         */
    int16   s_Nlp;               /* number of latency paths to transport (Nominal: 1,2)            */
    /* g.dmt: NUM_DATA_PATHS                                */
    /* 0--Fast Path--LP1, 1--Interleaved Path--LP0                */
    int16   s_Rp[NUM_DATA_PATHS];   /* number of FEC check bytes in path p                      */
    int16   s_Mp[NUM_DATA_PATHS];   /* number of mux frames per FEC data frame in path p           */
    /* g.dmt: Fast--1, Interleaved--S                          */
    int16   s_Lp[NUM_DATA_PATHS];   /* number of bits in latency path p                         */
    /* g.dmt: ((muxframesize + Rp/Mp)*8 bits)                     */
    int16   s_Tp[NUM_DATA_PATHS];   /* ratio of mux data frames to number of overhead octets in path p   */
    /* g.dmt: 1                                          */
    int16   s_Dp[NUM_DATA_PATHS];   /* interleave depth in pth path                          */
    /* g.dmt: Fast--1, Interleaved--D                          */
    int16   sa_Bpn[NUM_DATA_PATHS][NUM_DS_BEARER_CHANNELS];
    /* nominal number of octets from nth frame bearer             */
    /* channel per mux data frame in the latency path p           */

    uint16  s_FramingMode;       /* Framing Mode selected. (Nominal: 0,1,2,3)                      */
    /* g.bis framing mode  : 4                                    */
    /* Bypass mode         : 7                                    */
    int16   s_MSGlp;          /* latency path used to transport the message based   overhead info        */
    /* (Nominal:0,1)                                           */
    int16   s_IBITSlp;           /* latency path used to transport the indicator bits                 */
    /* (Nominal:0,1)                                           */
    int16   s_MSGc;              /* number of octets in the message based portion of the overhead structure */
    /* g.dmt: 62 (MSGc+6 == 68)                                      */
    uint8   *psa_BAT;            /* pointer to bit allocation table                          */
    int16   *psa_FineGains;         /* pointer to fine gain table                               */

    /* BIS OLR AND PM */
    int16   s_currentLp[NUM_DATA_PATHS];  /* number of bits in latency path p                         */
    int16   sa_currentBpn[NUM_DATA_PATHS][NUM_BEARER_CHANNELS];
    /* nominal number of octets from nth frame bearer             */
    /* channel per mux data frame in the latency path p           */
} Config_t;

/* Structure containing data frame parameters (both mux data frame and FEC output data frame) */
/* for a given path */
typedef struct
{
    int16  s_PathType;                          /*  = FAST_DATA_PATH, structure holds fast path info           */
    /*  = INTERLEAVE_DATA_PATH, structure holds interleaved path info   */

    int16 sa_B_alloc[NUM_DS_BEARER_CHANNELS];   /*  number of bytes allocated in channels                */
    /*  {AS0, AS1, AS2, AS3, LS0, LS1, LS2}              */
    int16 sa_B_in[NUM_DS_BEARER_CHANNELS];      /*  number of bytes channels  */
    /*  {AS0, AS1, AS2, AS3, LS0, LS1, LS2} in current frame   */
    int16 s_A;                                  /*  number of AEX bytes                            */
    int16 s_L;                                  /*  number of LEX bytes                            */
    int16 s_R;                                  /*  number of FEC check bytes */
    int16 s_RawFrameSize;                    /*  number of raw (payload only) bytes per frame         */
    int16 s_MuxFrameSize;                    /*  raw bytes + framing overhead bytes (fast/sync, AEX, LEX)*/
    int16 s_FecFrameSize;                    /*  MuxFrameSize + FEC Check Bytes/Symbol             */

    int16 s_CodewordSize;                    /*  FECFrameSize * Symbols/codeword                   */
    int16 s_sHalfCodeWordSize[2];            /*    Odd MuxFrameSize and S = 1/2:                   */
    /*   [0] -- (MuxFrameSize+1)/2 + FEC Check Bytes           */
    /*   [1] -- (MuxFrameSize-1)/2 + FEC Check Bytes           */
    /*   Even MuxFrameSize and S = 1/2:                     */
    /*   [0] -- [1] -- MuxFrameSize/2 + FEC Check Bytes        */
    int16 s_sHalfCntl;                    /*    0 - Odd Odd, 1 - Odd Even, 2 - Even Odd, 3 - Even Even   */
    int16 s_CodewordSize_Odd;             /*    CodewordSize + 1-(s_CodewordSize&1) for S>=1       */
    /*  CodewordSize,CodewordSize+1 or CodewordSize+2 for S=1/2   */

    FlagT ft_sync_flag;                         /*  = SYNC_CONTORL_FRAME, a sync action was performed on the*/
    /*  received data */
    FlagT Ft_C_Chan_Enabled;                    /*  Flag indicating if the 16 kbps C channel is active in   */
    /*  this latency path                             */
} DS_FrameParms_t;

/* Structure containing data frame parameters (both mux data frame and FEC output data frame) */
/* for a given path */
typedef struct
{
    int16  s_PathType;                          /*  = FAST_DATA_PATH, structure holds fast path info           */
    /*  = INTERLEAVE_DATA_PATH, structure holds interleaved path info   */

    int16 sa_B_alloc[NUM_US_BEARER_CHANNELS];   /*  number of bytes allocated in channels                */
    /*  {LS0, LS1, LS2}                               */
    int16 sa_B_out[NUM_US_BEARER_CHANNELS];     /*  number of bytes channels                          */
    /*  {LS0, LS1, LS2} in current frame                 */

    int16 s_L;                                  /*  number of LEX bytes                            */
    int16 s_R;                                  /*  number of FEC check bytes                         */
    int16 s_RawFrameSize;                 /*  number of raw (payload only) bytes per frame         */
    int16 s_MuxFrameSize;                    /*  raw bytes + framing overhead bytes (fast/sync, AEX, LEX)*/
    int16 s_FecFrameSize;                    /*  MuxFrameSize + FEC Check Bytes/Symbol             */

    int16   s_CodewordSize;                     /*  FECFrameSize * Symbols/codeword                   */
    int16   s_CodewordSize_Odd;              /*    CodewordSize + 1-(s_CodewordSize&1)                */

    FlagT Ft_C_Chan_Enabled;                    /*  Flag indicating if the 16 kbps C channel is active in   */
    /*  this latency path                             */
} US_FrameParms_t;


/* Structure containing bearer channel parameters for a given bearer channel*/
typedef struct
{
    int16         sa_BC_Bytes;   /*    nominal number of octets in bearer channels        */
    int16         sa_BC_BytesOut;   /* number of octets in current frame (after stuff/rob)   */
    int16         sa_BC_LPath;   /*    latency path for bearer channel                 */
    int16         sa_BC_LSX;     /*    LS channel mapping for bearer channel           */
    int16         sa_BC_CChan;   /* Flag indicating if this is a 16 kbps C channel     */
}US_BCParms_t;

/* Structure containing bearer channel parameters for a given bearer channel*/
typedef struct
{
    int16         sa_BC_Bytes;   /*    nominal number of octets in bearer channels     */
    int16         sa_BC_BytesIn; /* number of octets in current frame (after stuff/rob)   */
    int16         sa_BC_LPath;   /*    latency path for bearer channel              */
    int16         sa_BC_LSXASX;  /*    LS/AS channel mapping for bearer channel     */
    int16         sa_BC_CChan;   /* Flag indicating if this is a 16 kbps C channel  */
}DS_BCParms_t;

/* Structure used in TX SHOWTIME */
typedef struct {
    US_BCParms_t  t_BCParms[NUM_BEARER_CHANNELS];     /* 0--Bearer Channel 0, 1--Bearer Channel 1     */
    US_FrameParms_t  t_FrameParms[NUM_DATA_PATHS];    /*    0--Fast Path 1--Interleaved Path          */
    Config_t      *pt_Dummy;/*   No longer points to gt_tx_config.  Use gt_tx_config directly */
} TxShowTimeStruc_t;


/* Structure used in RX SHOWTIME */
typedef struct {
    DS_BCParms_t  t_BCParms[NUM_BEARER_CHANNELS];     /* 0--Bearer Channel 0, 1--Bearer Channel 1     */
    DS_FrameParms_t  t_FrameParms[NUM_DATA_PATHS];    /*    0--Fast Path 1--Interleaved Path             */
    Config_t      *pt_Dummy;                    /*    No longer points to gt_rx_config.  Use gt_rx_config directly */
    FlagT         ft_BC1isAS1;                  /*  bearer channel 1 will be considered AS1        */
} RxShowTimeStruc_t;


// Structure containing calibrated factors for converting between Rx digital frequency
// domain values and Rx input power.  See calibrat.c for details.

struct RxPowerCalibration {

    CONSTANT int16   s_RxPowerConvert_Mantissa;
    CONSTANT int16   s_RxPowerConvert_Exponent;
    /*
    s_RxPowerConvert_Mantissa and s_RxPowerConvert_Exp represent the ratio
    TonePower_mW / l_TonePower_Freq_Domain, where:

    1) TonePower_mW is the power received at analog front end input for a single tone (~4kHz bandwidth).
    Units are milliWatts(?).

    2) l_TonePower_Freq_Domain is the power after conversion
    to frequency domain (FFT). Value is a 32-bit
    digital value equal to the squared magnitude of the complex frequency
    amplitude = (Real)^2 + (Imag)^2.

*/

    // Total AFE gain.  Units are dB. Format is Q8.8.
    CONSTANT int16   s_AFE_Gain_dB;

    // Value representing the relative scaling introduced by the FFT.  Can be set to
    // 0dB for the setting defined as "normal" or default.  Units are dB. Format is Q8.8.
    CONSTANT int16   s_FFT_Scalebacks;

};

/* Structure used in L2 Low Power Mode Power Cutback */
typedef struct {
    /* Secifies the DS Power CutBack for L0 Symbols */
    int16   s_pcbDsL0Symbols;       /* 0 to 40 dB in steps of 1dB, Set during training */
    /* Specifies the DS Power CutBack for L2 Symbols */
    int16   s_pcbDsL2Symbols;       /* 0 to 40 dB in steps of 1dB, Set during PM */
    /* Specifies the DS Power CutBack for L2 to L0 Exit Symbols */
    int16   s_pcbDsL2toL0ExitSymbols;  /* 0 to 40 dB in steps of 1dB, Set during PM */
    /* Specifies fine gains (L0/L2) to be used for L2 to L0 Exit Symbols */
    FlagT   ft_isL2Gain;   /* 0 -- L0 gain, 1 -- L2 Gains */
    /* Specifies the gain obtained by removing FFT scalebacks */
    int16   s_L2FFTGaindB; /* Multiples of 6 dB, Set during PM */
    /* Specifies the additional gain (if any) requitred for power cutback realized in FDQ/FineGains block */
    int16   s_L2FdqGaindB; /* After accounting for gain obtained from FFT block (s_L2FFTGain), Set during PM */
    /* Specifies which of the FFT butterfly pass is enabled, a bit value of 1--enabled 0--disabled */
    int16   s_FftScalebackMask;  /* bit0--pass1,bit1--pass2,...,bit7--pass8,bit8--posttwiddle */
    /* Specifies the additional fdq scaling to meet the additional fdq gain */
    int16   s_fdqMultiplier;  /* scaling in Q3.13 format */
    // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
    /* Specifies the additional fdq gain */
    int16   s_additionalFdqGaindB;
    /* Specifies the last channel for which new FDQ co-eff have been computed */
    int16   s_PrevLastChnl;

    /* Backup variables used when 'False reverb is detected during L2 exit' */
    int16   s_Prev_L2FFTGaindB;
    int16   s_Prev_additionalFdqGaindB;
    int16   s_Prev_L2FdqGaindB;

    /* Indicates if FDQ Co-efs computation is split across two symbols*/
    int16   s_SplitFDQCoefsComputation;
    // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
} L2PowerCutBack_t;

/* Structure used in Tx OLR  */
typedef struct {
    /* Specifies the state in TxOLR i.e. LOAD_TABLES, etc */
    uint8   uc_txOLRState;
    // Retransmitted Response Count
    uint16 s_ResponseReXmitCnt;
} TxOLRVars_t;

/* Structure used in Rx OLR  */
typedef struct {
    /* Specifies the events in RxOLR/PM i.e. RECONFIG_Lp etc */
    int16   s_rxOLRPMEvent;
    /* Specifies the state in RxOLR/PM i.e. LOAD_TABLES, etc */
    uint8   uc_rxOLRPMState;
    /* Structure used in L2 Low Power Mode Power Cutback */
    L2PowerCutBack_t t_L2PowerCutBack;
    /* For L2 Reverb Segue Detection Error -- Saves write pointers for previous symbol */
    uint16  usa_rxRateBufWptr[NUM_DATA_PATHS];
    /* For L2 Reverb Segue Detection Error -- Saves bit fifo registers for previous symbol */
    uint16  usa_rxBitFifo[NUM_DATA_PATHS];
    /* For L2 -- Saves L0 mode tones Information */
    uint16  us_rxL0IrMinToneRegVal;
    uint16  us_rxL0IrMaxToneRegVal;
    /* For L2 -- Saves L0 mode Tcm Information */
    uint16  us_rxL0Tcm_1Bit_Index_Val;
    uint16  us_rxL0Tcm_Num1bits_Val;
    /* For L2 processing */
    uint8   uc_l2ProcState;

    uint8 uc_min_PCB_val;
    uint8 uc_max_PCB_val;
    uint16 s_RequestReXmitCnt;

#ifdef DANUBE
    /* Danube Only */
    uint16  usa_PseudoRBWRCont[NUM_DATA_PATHS];
    uint16  usa_PseudoRBRDCont[NUM_DATA_PATHS];
    uint16  usa_ReverbByteCont[NUM_DATA_PATHS];
#endif

} RxOLRPMVars_t;

/* Structure used in FFT Buffer Scenario Transition  */
typedef struct {
    /* Flag to start and control the transition to a new scenario */
    /* uc_scenarioTransitionState == FFT_BUFFER_SCENARIO_TRANSITION_WAITING: Do nothing, wait */
    /* uc_scenarioTransitionState == FFT_BUFFER_SCENARIO_TRANSITION_STEP1: Do step 1, update num buffers to rotate */
    /* uc_scenarioTransitionState == FFT_BUFFER_SCENARIO_TRANSITION_STEP2: Do step 2, update logical proc blocks assigned to logical buffer 1 */
    /* uc_scenarioTransitionState == FFT_BUFFER_SCENARIO_TRANSITION_STEP3: Do step 2, update logical proc blocks assigned to logical buffer 2 */
    /* uc_scenarioTransitionState == FFT_BUFFER_SCENARIO_TRANSITION_DONE: scenario transition done */
    uint8   uc_scenarioTransitionState;
    /* New FFT buffer Scenario to go to */
    int16   s_newScenario;
} RxScenarioTransition_t;


/* an internal timer structure*/
typedef struct {
    uint8 uc_hour;
    uint8 uc_minute;
    uint8 uc_second;
}Timer_t;

#ifdef HERCULES_ADSL_CPE

// Structure used for AFE register access
typedef struct {
    uint16 us_AFERegOp;    //XDSLRTFW-3705 (Start_End)
    uint16 us_AFERegAddr;
    uint16 us_AFERegData;
} AFEConfig_t;
#endif

/* Bitswap Counter structure */
typedef struct {
    uint16 us_SimpleOLRPMReq_Cnt;
    uint16 us_ExtendOLRPMReq_Cnt;
    uint16 us_OLRPMUTCResp_Cnt;
    uint16 us_ActualOLRPMPerform_Cnt;
    uint16 us_RespTimeOut_Cnt;
}OLRPMCnt_t;

typedef struct {
    OLRPMCnt_t t_BitswapCnt;
    OLRPMCnt_t t_DRRCnt;
    OLRPMCnt_t t_SRACnt;
}OLRPMCntInfo_t;

//Structure used for US/DS test PARAMS
typedef struct {
    // PMS-TC Parameters:
    uint16  ft_NTR_Transport;       // Mode to enable NTR Transport

    // PMD Parameters:
    uint16  us_LoopAttenuation;        // US/DS Loop Attenuation
    uint16  us_SignalAttenuation;      // US/DS Signal Attenuation
    int16   s_SnrMargin;            // US/DS SNR Margin
    uint32  ul_AttainableDataRate;     // US/DS Attainable Data Rate
    int16   s_ActualAggregateXmtPwr;   // US/DS Aggregate Actual transmit power
    int16   s_ActualPSD;               // US/DS Actual Power Spectral Density   - Not Currently Populated
   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START_END)
    uint16  us_VN_TCM_Supported;    // US/DS TCM Support + US/DS Virtual Noise Support Status
   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
   uint16  us_ActualINP;               //Actual INP reported by CO
} Params_t;

//Structure used for US/DS Measurement periods
typedef struct {
    uint16 us_Hlogf_measurement_period;   // US/DS Hlogf measurement period
    uint16 us_QLN_measurement_period;  // US/DS QLN measurement period
    uint16 us_snr_measurement_period;  // US/DS SNR measurement period
} MeasurementPeriod_t;

//Structures used for debug trail
typedef struct {
    int16 s_logType;
    int16 s_triggerRxState;
    int16 s_triggerRxSubState;
    int16 s_triggerRxSymbolCount;
    int16 s_toneIndex;
    int16 s_numTones;
    int16 s_cyclicTrailUpdate;

    // Internal variables used for implementation only
    int16 s_prevRxState;
    int16 s_prevRxSubState;
    int16 s_prevTxState;
    int16 s_prevTxSubState;
    FlagT ft_StateTrigger;

} DebugTrailTriggerControl_t;

typedef struct {  // Read only structure, except for the advanced user
    int16 s_debugTrailLen;
    int16 s_debugTrailSize;
} DebugTrailCollectControl_t;

//XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
// XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
// Length of data written to SDRAM using DMA
typedef struct {
   int16 s_debugBuffer_GHS_TO_EXCHANGE_length;
   int16 s_debugBuffer_Showtime_length;
   int16 s_debugBuffer_Showtime_Oldested_data_Start;
   int16 s_debugBuffer_Size_of_Per_Symbol_structure_Bytes;
   int16 s_debugBuffer_Size_of_Super_Frame_structure_Bytes;
}DebugBufferStatus_t;


//structure used for updating the debug buffer status CMV
typedef struct {
   int16 s_debugBuffer_STCaptureXSymbol;
   uint16 us_debugBuffer_StopStartCaptureData;
}DebugBufferControl_t;

// XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)

#pragma Align_members(1)//no padding bytes for alignment

typedef struct {

   int16 s_rx_PilotToneReal;
   int16 s_rx_PilotToneImaginary;

} DebugShowTimeBuffSymbol_t;

//Structure which is used for collection data for every sync symbol in showtime in Debug Buffer
typedef struct {

    int32 l_sync_structure_start_delimiter;
   //Please add any new variables after the above delimiter declaration

    int32 l_symbolCountBuff;
    int16 s_rx_PilotToneReal;
    int16 s_rx_PilotToneImaginary;

    int16 s_dsCrcLP0; //DS CRC LP0
    int16 s_dsCrcLP1; //DS CRC LP1

    uint16 usa_EocNumTimeouts[3];

    struct OLR_PM_CNT_US
    {
        uint16 us_SimpleOLRPMReq_Cnt;
        uint16 us_OLRPMUTCResp_Cnt;
        uint16 us_ActualOLRPMPerform_Cnt;
        uint16 us_RespTimeOut_Cnt;

    } OLR_PM_COUNT_US;

    struct OLR_PM_CNT_DS
    {
        uint16 us_SimpleOLRPMReq_Cnt;
        uint16 us_OLRPMUTCResp_Cnt;
        uint16 us_ActualOLRPMPerform_Cnt;

    } OLR_PM_COUNT_DS;

   //helps to identify Loss of Frame condition
    uint16 us_NeSefDefectCounter;

   //help to idenfify Loss of Margin conditions
    int16 s_SnrMargin;
    int16 s_RxMinMargin;
    int16 s_RxMinMarginTone;

    int16 s_g997_Failure_Flag[2];   //0th index for NE and 1 for FE

} DebugShowTimeBuffSuperframe_t;

//Structure which is used for collection data for every sync symbol in showtime in Debug Buffer
typedef struct {

    int32 l_sync_structure_start_delimiter;

    //Please add any new variables after the above delimiter declaration

    int32 l_symbolCountBuff;
    int16 s_rx_PilotToneReal;
    int16 s_rx_PilotToneImaginary;
    uint16 usa_EocNumTimeouts[3];
    struct OLR_PM_CNT_US_ReTx
    {
        uint16 us_SimpleOLRPMReq_Cnt;
        uint16 us_OLRPMUTCResp_Cnt;
        uint16 us_ActualOLRPMPerform_Cnt;
        uint16 us_RespTimeOut_Cnt;
    } OLR_PM_COUNT_US;

    struct OLR_PM_CNT_DS_ReTx
    {
        uint16 us_SimpleOLRPMReq_Cnt;
        uint16 us_OLRPMUTCResp_Cnt;
        uint16 us_ActualOLRPMPerform_Cnt;
    } OLR_PM_COUNT_DS;

    // helps to identify Loss of Frame condition
    uint16 us_NeSefDefectCounter;

    //help to idenfify Loss of Margin conditions
    int16 s_SnrMargin;
    int16 s_RxMinMargin;
    int16 s_RxMinMarginTone;

    int16 s_g997_Failure_Flag[2]; //0th index for NE and 1 for FE

   struct ReTx_Status_Variables
    {
        int16  s_RetransmittedDtuCnt;
        uint16 us_CorrectedDtuCnt;
        uint16 us_UncorrectedDtuCnt;
        uint16 ul_TotalDtuCnt;
    } ReTx_Status;

} DebugShowTimeBuffSuperframeReTxEnabled_t;

#pragma Align_members(4)
//XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)

typedef struct {
    int16 sa_CPEResult[4];
    int16* ps_NE_LPR;
}SelfTestResult_t;

typedef struct {
    PtrToFunc pf_TCTask;
    PtrToFunc pf_NTCTask;
    PtrToFunc pf_BgTask;
}FuncPtr_t;

typedef struct {
    int16 s_Latency;
    int16 s_INP;
    int16 s_OLR_LMaxNoBpn;
    int16 s_OLR_LMinNoBpn;
    int16 s_OLR_LMaxNoBpn_Cnstrnt;
    int16 s_OLR_LMinNoBpn_Cnstrnt;
    int16 s_OLR_LMaxBpn;
    int16 s_OLR_LMinBpn;
    int16 s_OLR_LMaxBpn_Cnstrnt;
    int16 s_OLR_LMinBpn_Cnstrnt;
    int16 s_L2_LMax;
    int16 s_L2_LMin;
#ifdef HERC_API
    int16 s_Kp;
    int16 s_NFECp;
    int16 s_Sp;     /* Report Sp in 8.8 because it may be a fraction */
#endif
} DerivedFramePropLatencyPath_t;

typedef struct {
    int16 s_sizeofStruct;
    DerivedFramePropLatencyPath_t PropPerLp[NUM_DATA_PATHS];
}DerivedFrameProp_t;

typedef struct {
    uint16 us_OperatorSpBits;  // [0] Operator specific bit patterns.
    int16 s_DFE_Options; // [1] CMV for options [CO_SEL_USBAND,DFE and AFE overflow capture, tiscali
    // workaround]
    int16 s_Extended_D;  // [2] Support signalling of extended D (1 to 15) in US/Lp0 during exchange
    int16 s_Rx20bit;  // [3] Support 20-bit Consellation
    // SMS00855449 CR_DS_ALL_ALL_MoveErasureDecoderControlsToDSLgroup (Start_End)
    int16 s_LATN_PLUS_A;  // [4] Support Soft Erasure Decoding moved to DSL 2 1 (currently used for LATN tweaking)
    int16 s_versionControl; // [5] low 2 bits be reserved for ME to write HW version.
    // CMVforHybridMetric moved to DSL 18 0
    int16 s_ErasureGain; // [6]
    int16 s_FreeLocation2;   // [7]
    int16 s_FreeLocation3;   // [8]
    int16 s_CTUNE_NMSForce_mask; // [9]
    int16 s_HybTablesSwitch;  // [10]  //XDSLRTFW-3674
    int16 s_FreeLocation6;   // [11]
    uint16 us_PTM_Options_Indicated; // [12]
    uint16 us_PTM_Options_Selected;  // [13]
    uint16 us_Ena_Extended_D_IFX; // [14]
    int16 s_med_offset;  // [15]
    int16 s_bis_plus_med_offset;  // [16]
    int16 s_Force_Rp_ReTransmission; // [17]
    // IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (Start)
    //x.14 format, used in RTonesReqTxF.c for GHs-PCB or in RCQuiet2RxF.c (after GHs)
    //for Reverb-PCB To reduce Tx Pwr by 2.5dB, us_TxPwrCutDMTforDSPCB
    //(12286)= 10^(-2.5/20)*(2^14); "-2.5" in dB
    uint16 us_TxPwrCutDMTforDSPCB;   // [18]
    //  x.14 format, To Boost  Tx Pwr by 2.5dB, us_XcvrTxPwrBoostDMTforDSPCB
    //  (21848)= 10^(2.5/20)*(2^14); "2.5" in dB
    uint16 us_XcvrTxPwrBoostDMTforDSPCB;   //[19]
    //XDSLRTFW-139:SMS00839860 PERF_DS_BisPlus_DSmarginIncrease (Start_End)
    uint16 us_OperatorSpBits2; // [20] Operator specific bit batterns - 2
    uint16 us_pll_freq_offset_lowword;          // [21]
    uint16 us_pll_freq_offset_highword;         // [22]
    //Feature_DS_BisPlus_ALL_DisableTrainingREINDetection (Start_End)
    uint16 us_OperatorSpBits3;    //[23]
   //XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (Start)
   uint16 us_adjust_PGA_margin; //[24] Feature_CMV_PGA_control
   uint16 us_Hybrid_LIF_Module; //[25] Feature_CMV_PGA_control
   uint16 us_OperatorSpBits4;   //[26]
   //ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove (END)
   // 27 XDSLRTFW-316 bit12 change PLL BW;
   // 27 XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI
   uint16 us_OperatorSpBits5;   //[27] XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI (START-END)
   uint16 us_OperatorSpBits6;   //[28] Feature_DS_ADSL1_ALL_AuxPilotMinSNR_Threshold (START-END)
   //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (start_end)
   uint16 us_SRA_IOP_Bits;      //[29]
   uint16 us_OperatorSpBits7;   //[30] XDSLRTFW-1815 : IKNS CO4 Fix for TPLink Canada
}INFX_CMV;

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod Start
typedef struct {
   uint16 us_ReTxConfigOptionBits;  // [0]

   uint16 us_ReTxCodingGain;        // [1] Assumed coding gaing by Retransmission in 1/16 dB
   uint16 us_INP_min_rein;          // [2] min. REIN INP in number of destroyed 246us-symbols due to single REIN impulse
   uint16 us_SHINEratio;            // [3] average loss ratio due to SHINE in multiple of 0.1 %; range: 0..255
   uint16 us_s_CO;                  // [4]
   uint16 us_d_CO;                  // [5] half roundtrip (s symbols + d DTUs) of CO side
   uint16 us_SpMinInvers;           // [6] 1/SpMin for latency path 1 connected with bearer channel 0
   uint16 us_ETR_min;               // [7] min. throughput, here called NDReff, in kbit/s
   uint16 us_ETR_max;               // [8] max. ETR in kbit/s with ETR = min(NDReff, ETR_max), only really relevant if Opt_Policy=1 then it means NDReff<=ETR_max
   uint16 us_net_max;               // [9] max net data rate in kbit/s
   uint16 us_MSGmin;                // [10] minimum rate for message based portion of overhead channel realized in latency path 0 - in kbit/s --- debug only
   // Internal ATU-R Inputs; to be configurable at ATU-R side
   uint16 us_s_CPE;                 // [11]
   uint16 us_d_CPE;                 // [12] half roundtrip (s symbols + d DTUs) of CPE side
   uint16 us_QSmax;                 // [13] max. DTU size in symbols (x.2 format)
   uint16 us_QSmin;                 // [14] min. DTU size in symbols (x.2 format)
   uint16 us_RTmemMaxIfx;           // [15] ReTx memory in bytes in case of IFX CO

   // Internal ATU-R Inputs; after SNR measurements
   uint16 us_rr_trellis_inv;        // [16]average symbol number between trellis bursts with the assumption that one burst corrupts one DTU -- depends on coding gain
                                    //  -> 0: no trellis errors
   // Output Parameters
   uint16 us_Q;                     // [17]
   uint16 us_V;                     // [18]
   uint16 us_H;                     // [19]not really required: H = N1-R1
   uint16 us_LpAvailable;           // [20]Debug
   uint16 us_ndr;                   // [21]
   uint16 us_ndr_eff;               // [22]
   uint16 us_etr;                   // [23]
   uint16 us_Qtx;                    // [24]

   //Add_Debug_CMV_for_DTUs_NAKed Begin
   //Debug parameters
   uint16 us_last_DTU_NAKd;         // [25]
   uint16 us_RRC_NAKd_low;          // [26]
   uint16 us_RRC_NAKd_high;         // [27]
   //Modification_R_det_only Begin
   uint16 us_RDetOnly;             // [28]
   //Modification_R_det_only End
   uint16 us_parameter2;             // [29]
   //Add_Debug_CMV_for_DTUs_NAKed End

   uint16  ft_ReTxOn;                // [30] 0: Retransmission OFF; 1: Retransmission enabled

   // Inputs from ATU-C during Initialization
   uint16  ft_ia_rein_flag;          // [31] flag=0 for 100-Hz-REIN and flag=1 for 120-Hz-REIN
   uint16  ft_ifx_co_flag;           // [32] if IFX CO device is detected by CPE in HS CPE shall set this flag to one, else to 0
   uint16  ft_adsl2p_flag;           // [33] shall be set to 1 by CPE if mode select has been done for ADSL2+ in HS, else 0
   uint16  ft_adsl2_flag;            // [34] shall be set to 1 by CPE if mode select has been done for ADSL2 in HS, else 0
                                    //    Note: opt_policy=1 not yet supported
   uint16  us_Lb_val;               //[35]Look back value Any integer between 1 and 31.
                            //Valid configuration shall be such that lb = min(31,Qtx).

   uint16 us_delay_max;             // [36]max. excess delay in ms caused by retransmission (1<=delay_max<=63)
   uint16 us_INP_min;               // [37]min. INP in number of destroyed 246us-symbols due to noise impulse (SHINE/PEIN) (0<=INP_min<=63)
   uint16 us_CIP;                   // [38]channel optimization policy -- currently only 0 or 1: 0 is optimization for throughput (default); 1: ETR <= ETR_max
   uint16 us_delay_min;             // [39]
   uint16 us_leftr_thresh;          // [40]
   //FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications (Start_End)
   uint16 us_CPARAMS_INP_FLAG;      // [41]
   int16  s_delay_offset;           // [42]

   //FEATURE_DS_BisPlus_ALL_Max_Min_delay_log Begin
   int16 s_MaxActTimeDiff_DTU_Begin; // [43]Maximum difference of symbol count & Time stamp at 1st CW of DTU.
   int16 s_MinActTimeDiff_DTU_Begin; // [44]Minimum difference of symbol count & Time stamp at 1st CW of DTU.
   int16 s_MaxActTimeDiff_DTU_End; // [45]Maximum difference of symbol count & Time stamp at last CW of DTU.
   int16 s_MinActTimeDiff_DTU_End; // [46]Maximum difference of symbol count & Time stamp at last CW of DTU.
   //FEATURE_DS_BisPlus_ALL_Max_Min_delay_log End


   //FEATURE_DS_BisPlus_ALL_Force_Q Begin
   int16 us_Force_Q;                //[47] To force Q = 1 set this value to 1
   //FEATURE_DS_BisPlus_ALL_Force_Q End

   //FEATURE_DS_BisPlus_ALL_ForceExplicitFramingForURETX (Start)
   int16 us_Force_Explicit_Framing; //[48]
   //FEATURE_DS_BisPlus_ALL_ForceExplicitFramingForURETX (End)
//FEATURE_DS_BisPlus_ALL_ReTx_CMV_for_EFTR_Min Begin
   uint16 us_EFTR_Min;   //[49] kbps
//FEATURE_DS_BisPlus_ALL_ReTx_CMV_for_EFTR_Min End

   //FEATURE_DS_BisPlus_ALL_ReTxCMSG1_New Start
   int16 s_CMSG1_CI_LeftrThresh;           //[50]
   //FEATURE_DS_BisPlus_ALL_ReTxCMSG1_New End
#ifdef UNV_RETX_MSGS
   uint8 uc_CMSG1_Framing; //[51]
#endif
   //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START_END)
   uint32 ul_etr; //[52][53]

} ReTxConfigInfo_t;

//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod End
typedef struct {
   uint32 ul_PrevRrc;
   uint64 ull_64MostRecentDtuStats;
   FlagT  ft_RrcStatUpdated;
   uint8  uc_AbsDtuNum;
} RRC_Stat_t;

typedef struct {
//
// Begin of CNTR CMV mapping
//
/*    uint32 ul_EFTR;
    uint32 ul_EFTR_Prev;

    //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
*/

   // these are mapped to CNTR[43]
   uint32 ul_ErrorFreeBits;          //[0]
   uint32 ul_ErrorFreeBits_Prev;     //[1]
   uint32 ul_EFTR_min;           //[2]
   uint32 ul_EFTR_min_Prev;      //[3]

   uint32 ul_LEFTR_Cntr;         //[4]
//XDSLRTFW-974 Fix_DS_DS_BisPlus_All_Reporting_ReTx_Counters (Start)
   uint32 ul_EFTR;               //[5]
//XDSLRTFW-974 Fix_DS_DS_BisPlus_All_Reporting_ReTx_Counters (End)

   // these are mapped to RATE[2]
   uint32 ul_ReTX_ReceiverETR;         //  [6] case RETX_RECEIVER_ETR:
   uint16 us_ReTX_ReceiverActualDelay; //  [7] case RETX_RECEIVER_ACTUAL_DELAY:
   uint16 us_FE_InpActShine;           //      case FE_INP_act_SHINE:
   uint16 us_FE_InpActRine;            //  [8] case FE_INP_act_RINE:
   uint16 us_dummy;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

   // these are mapped to CNTR[44]
   //XDSLRTFW-1634 (Start_End)
   uint32 ul_RetransmittedDtuCnt;      //[9]
   uint32 ul_CorrectedDtuCnt;          //[10]
   uint32 ul_UncorrectedDtuCnt;        //[11]

   uint32 ul_UncorrectedDtuCnt_Prev;  //[12]
//
// End of CNTR CMV mapping
//


   // RX side
   uint32 ul_TotalDtuCnt;
   uint32 ul_GoodDtuCnt;                           // good DTUs that are written to ReTX trans table
   uint32 ul_BadDtuCnt;                            // bad DTUs + une
   uint32 ul_LastBadDtus;                        // (SID_N-1 << 24 | TS_N-1 << 16) | (SID_N << 8 | TS_N)
   uint32 ul_LastRetxDtus;                       // (SID_N-1 << 24 | TS_N-1 << 16) | (SID_N << 8 | TS_N)
   uint32 ul_UnexpectedDtuCnt;
   uint32 ul_LastUnexpectedDtus;
   uint32 ul_ErroredBitsPerSec;       //[19]

   // TX side
   uint32 ul_ForwardedDtuCnt;
   uint32 ul_LastUncorrectedDtus;
   uint32 ul_LastRrcs;

   uint16 us_HalfRoundTripTX;
   uint16 us_HalfRoundTripRX;
//        uint16 us_Qtx;
//        uint16 us_Qrx;
} ReTX_Stats_t;

//XDSLRTFW-1223 Qrx Full Fix (Start)
typedef struct {
/*
   RTX_ConfigCMV_t    t_ReTXConfigCMV;

   uint16             us_DtuSize;          // (H*Q)

   uint8              uc_DtuPerFrame;      //(1/(S*Q) in 4.4
 */
/*
   uint8              uc_ReTX_N;           // RS codeword size
   uint8              uc_ReTX_H;           // payload size per codeword

   // contents of O-MSG1
   uint8              uc_OMSG1_DsReTxEnabled;    // negotiated DsReTx capability
                                    // during training this field will be set to:
                                    // CO-DS-CAPABILITY, then RETX_SELECTED or RETX_NOT_SELECTED
   uint8              uc_OMSG1_UsReTxEnabled;

   uint8              uc_OMSG1_DsFramingType;      // 1-4
   uint8              uc_OMSG1_DsHalfRountTripInDTUS;

   uint8              uc_OMSG1_DsHalfRountTripInSyms;

   uint8              uc_OMSG1_UsHalfRountTripInDTUS;
   uint8              uc_OMSG1_UsHalfRountTripInSyms;

   uint8              uc_OMSG1_Ds1overSMax;
   uint8              uc_OMSG1_Us1overSMax;

   // contents of O-TPS
   // contained within t_ReTXConfigCMV

   // contents of RMSG2
   uint8              uc_RMSG2_CpeTxHalfRoundTripDelays;
   uint8              uc_RMSG2_CpeRxHalfRoundTripDelays;
   uint8              uc_RMSG2_Us1overSMax;
   uint8              uc_RMSG2_Ds1overSMax;
   uint16             us_RMSG2_UsNetDataRateMax;

   // contents of R-PMS
   uint8              uc_RPMS_DsLookBackValue;
   uint8              uc_RPMS_Qtx;

   // contents of O-PMS
   uint8              uc_OPMS_UsFramingType;
   uint8              uc_OPMS_UsCodeWordPerDtu_Q;
   uint8              uc_OPMS_UsPaddingPerDtu_V;
   uint8              uc_OPMS_UsQtx;
   uint8              uc_OPMS_UsLookBackValue; */
/*
   union {
      UcodeReTXParam1_t   t_Param1;
      uint32              l_ReTXParam1;
   } Un_UcodeReTXParam1;


   union {
      UcodeReTXParam2_t   t_Param2;
      uint32              l_ReTXParam2;
   } Un_UcodeReTXParam2;
 */

   uint8              uc_NumPaddingBytes;
   uint32             ul_ReTXQueue_BaseAddress;



} ReTX_Params_t;

typedef struct QueueNode {
   //uint8 is sufficient as Max buffers in QRx = (Max_QTx * 3) = 63*3 = 189
   uint8 uc_NextNode;
   uint8 uc_Indx;
} QueueNode_t;

typedef struct QueueStatus {
   //uint8 is sufficient as Max nodes in QRx = (Max_QTx * 3) = 63*3 = 189
   uint8 uc_Head;
   uint8 uc_NumNodes;
} QueueStatus_t;
//XDSLRTFW-1223 Qrx Full Fix (Start)

typedef struct {
   uint8  uc_TS;
   uint8  uc_SID;
   uint8  uc_Stat;
   uint8  uc_DTU_idx;
} QretxTableEntry_t;

//SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad Start
typedef struct {
   uint16 us_ndr_eff;
   uint16 us_ndr;
   uint16 us_Np;
   uint16 us_Q;
   uint16 us_V;
   uint16 us_Qtx;
   //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START_END)
   uint32 ul_ndr_eff;
} RTParam_t;
//SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

typedef struct {
    int16 s_HnshkStructOffset;         //size of Adsl2AllInfo_t in words
    int16 s_OLRPMCntStructOffset;      //size of OLRPMCnt_t in words
} OffsetInfo_t;

typedef struct {
    int16 s_NumBrkptkept;
    int16 s_NumBrkptRcvd;
    int16 s_Reserved;
    int16 s_MaxNumBrkpt;
    uint8 uca_Brkpt[MAX_NUM_US_TSSI_VALUES];
    uint8 uca_Tssi[MAX_NUM_US_TSSI_VALUES];
    uint8 uca_Si[MAX_NUM_US_TSSI_VALUES/8];
}GHS_USTssiInfo_t;


typedef struct {
    int16 s_NumBrkptkept;
    int16 s_NumBrkptRcvd;
    int16 s_Reserved;
    int16 s_MaxNumBrkpt;
    uint16 usa_Brkpt[MAX_NUM_DS_TSSI_VALUES];
    uint8 uca_Tssi[MAX_NUM_DS_TSSI_VALUES];
    uint8 uca_Si[MAX_NUM_DS_TSSI_VALUES/8];
}GHS_DSTssiInfo_t;

// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
typedef struct {
   uint16 s_connection_mode0;
   uint16 us_RA_MODE_DS;
   int32 s_MAX_DATA_RATE_DS;
   int32 s_MIN_DATA_RATE_DS;
   int16 s_MAX_DATA_RATE_US;
   int16 s_MIN_DATA_RATE_US;
   int16 s_TARGET_SNR_MARGIN_DS;
   int16 s_MINIMUM_SNR_MARGIN_DS;
   int16 s_MAXIMUM_SNR_MARGIN_DS;
   int16 s_delay_DS;
   int16 s_INP_erasure_DS;
   int16 s_INP_erasure_US;
   int16 s_MAX_NOMINAL_AGGRE_POWER_US;
   int16 s_MAX_NOMINAL_AGGRE_POWER_DS;
   uint16 s_connection_support[2];
   uint16 us_RA_USNRM_DS;
   uint16 us_RA_DSNRM_DS;
   uint16 us_RA_DTIME_DS;
   uint16 us_RA_UTIME_DS;
   uint16 us_cut_back_C_US;
   uint16 us_cut_back_C_DS;
   uint16 ft_ReTX_enable;
   uint16 us_RETX_ETR_MIN_DS;
   uint16 us_RETX_ETR_MAX_DS;
   uint16 us_RETX_DATARATE_MAX_DS;
   uint16 us_RETX_MIN_INP_DS;
   uint16 us_RETX_SHINE_RATIO_DS;
   uint16 us_RETX_MIN_INP_REIN_DS;
   uint16 us_RETX_MAX_DELAY_DS;
   uint16 us_RETX_MIN_DELAY_DS;
   uint16 us_RETX_LEFTR_THRES_DS;
   GHS_USTssiInfo_t tssi_info_US;
   GHS_DSTssiInfo_t tssi_info_DS;
}Debug_ProfileInfo_t;
// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

// PMD control variables
typedef struct {
    //NOMPSD, MAXNOMPSD and MAXNOMATP exchanged from GHS
    int16 s_NOMPSD_US; //valid for ADSL1 and ADSL2. Relative to the default NOMPSD of different Annex mode.Always 0 for ADSL1. Unit is (10*dB)
    int16 s_NOMPSD_DS; //valid for ADSL1 and ADSL2. Relative to the default NOMPSD of different Annex mode.Always 0 for ADSL1. Unit is (10*dB)

    int16 s_MAXNOMPSD_US; //valid for ADSL2. Unit is (10*dB)
    int16 s_MAXNOMPSD_DS; //valid for ADSL2. Unit is (10*dB)

    int16 s_MAXNOMATP_US; //valid for ADSL2 Unit is (10*dB)
    int16 s_MAXNOMATP_DS; //valid for ADSL2 Unit is (10*dB)

    // power cutback exchanged from MSG_PCB
    uint16 us_pwr_cutback_US;  //valid for ADSL2 only          Unit is (1*dB)
    uint16 us_pwr_cutback_DS;  //valid for ADSL1 and ADSL2.    Unit is (1*dB)

    //derived PMD control, US only here (do we need to derive DS?)
    //REFPSD = NOMPSD - PCB
    int16 s_REFPSD_US;  //Not populated yet. Unit is (10*dB)
    int16 s_REFPSD_DS;  //valid for ADSL1 and ADSL2. relative to the default NOMATP of different Annex mode. Unit is (10*dB)

    //RMSGI
    int16 us_RMSGI_US; // Finegain rms in dB (Q 8.8)
    int16 us_RMSGI_DS; // Finegain rms in dB (Q 8.8)

    //NOMATP
    int16 s_NOMATP_US;  //valid for ADSL1 and ADSL2. relative to the default NOMATP of different Annex mode. Unit is (10*dB)
    int16 s_NOMATP_DS;  //valid for ADSL1 and ADSL2. relative to the default NOMATP of different Annex mode. Unit is (10*dB)

    //Absolute nominal transmit power level
    int16 s_NOMPSD_US_dBmHz;  // Units are (dBm/Hz * 10).  Equal to default value + s_NOMPSD_US.
    int16 s_NOMPSD_DS_dBmHz;  // Units are (dBm/Hz * 10).  Equal to default value + s_NOMPSD_DS.

} PMDControl_t;

// Loop Diag Mode Parameters
typedef struct {
    int16 s_PrevInit_Status;
    int16 s_PrevInit_LastTxState;
    int16 s_Hlin_scale;
    int16 s_HLogReportDelta; // XDSLRTFW-4022 Hlog REPORTING calibration in ADSL in 1/10th of dB
    uint16 us_HlogFlags; // XDSLRTFW-3974 Hlog reporting
}LoopDiagParam_t;

#ifdef ADSL_62
// structure used for adsl_62 iir
typedef struct {
    uint32 n;           // num of coefs
    uint32 cfg_regs[2]; // cfg1 ,cfg2
    uint32 coefs[31]    ; // 31 is max size of 6 biquads.
} iirLoad_Struc_t;
#endif



#ifdef HERC_API

/* Structure used for Hercules Rate CMV */
typedef struct {
    int32 s_DataRate[NUM_DATA_PATHS];
    int32 s_PrevDataRate[NUM_DATA_PATHS];
    int16 s_ActualDelay[NUM_DATA_PATHS];
    int16 s_IntlDepth[NUM_DATA_PATHS];
    int16 s_TCM_Parity[NUM_DATA_PATHS];
    //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start)
   int16 s_ActInpNoErasure[NUM_DATA_PATHS];  // INP with no erausre decoding value
   int16 s_ActInpErasure[NUM_DATA_PATHS];    //INP with erasure decoding value
    //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (End)
} HercADSL_RateCMV_t;

/* XDSLRTFW-2464 */
typedef struct
{
    uint32 ul_SymbolCount;
    int16  s_SectorIdx;
    int16  s_PhaseError;
} Avm_PllRotInfo_t;
/* XDSLRTFW-2464 */
// Fail states information
typedef struct {
    uint32 ul_ExceptionCode;
    int32 l_TxSymbolCount_AtFail;
    int16 s_TxState_AtFail;
    int16 s_TxSubState_AtFail;
    int32 l_RxSymbolCount_AtFail;
    int16 s_RxState_AtFail;
    int16 s_RxSubState_AtFail;
    // kernel exception debug info:
    int16 s_TaskID;
    int16 s_dummy;         //insert for alignment
    int32 l_TxTimerValue;
    int32 l_RxTimerValue;
    uint16 us_BitloadErrorCode;
    int16 s_ToneReorderErrorCode;
    int16 s_RxMsgErrorCode;
} HercADSL_FailStateInfo_t;

/* Structure used for Hercules AINF PCB CMV Offset */
typedef struct {
    uint16 s_PCB_DS;
    uint16 s_PCB_US;
} HercADSL_AINFCMV_PCB_t;

/* Structure used for Hercules AINF Framing CMV Offset */
typedef struct {
    int16 s_Rp;
    int16 s_Sp;
    int16 s_Dp;
    int16 s_Kp;
    int16 s_Mp;
    int16 s_Lp;
    int16 s_Num_TCM_Bits;
    uint16 s_ADSL1_Framing_Mode;
    int16 s_Tp;
    int16 s_SEQp;
    int16 s_MSGc;
} HercADSL_AINFCMV_Framing_t;

/* Structure used for Hercules CNFG Bearer Channel Control */
typedef struct {
    int16 s_MinNetDataRate;
    int16 s_MaxNetDataRate;
    int16 s_MinResNetDataRate;
    int16 s_MaxLatency;
    uint8 uc_MaxBER;
   uint8 uc_TPSTCoptions;
    int16 s_IMAxINP;  //IMA flag + INP_min
//  XDSLRTFW-1481 (Start_End) TPSTCoptions is part of paramater 7 as per message spec,
//    so s_MaxBER is used as (uc_TPSTCoptions + uc_MaxBER)
// int16 s_TPSTCoptions;   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start_End)
}  HercADSL_TPS_TC_Type_t;

typedef struct {
    int16                   s_TPS_TC_Control;
    HercADSL_TPS_TC_Type_t ta_TPS_TC_Type[MAX_TPS_TC_TYPE];

}  HercADSL_TPS_TC_BearerChannel_t;

typedef struct {
    int16                   s_Offset0;
    int16                   s_Offset1;
    int16                   s_Offset2;

}  HercADSL_OPTN_AlgControl_t;

//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start)
typedef struct {
    int16                   s_Offset0;
}  HercADSL_OPTN_OlrControl_t;
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (end)

typedef struct {
    int16                   s_Offset0;
    int16                   s_Offset1;

}  HercADSL_OPTN_ModeControl_t;

//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (Start)
typedef struct {
    int16                   s_deltaTARSNRMds;//0
    uint16                  us_NMS_Ctrl;     //"1"
    int16                   s_NMS_AGC;       //"2"
    int16                   s_deltaTARSNRMus;//"3"
    int16                   s_deltaMarginMax;//"4"
    int16                   s_TxNoise_delta;  // 5 variable to play for IOP
    int16                   s_ADCNoise_delta; // 6 variable to play for IOP
    int16                   s_ISINoise_delta; // 7 variable to play for IOP
    int16                   s_BitSwapThr;     //"8"
    int16                   s_OPTN_margin;    //"9"
    int16                   s_FineGainAdjust; //"10"
    int16                   s_resvd;          //"11"
}  HercADSL_OPTN_MarginControl_t;
//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (End)

// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
typedef struct {
    uint16                  us_EocPollControl;
}HercADSL_OPTN_EocPollControl_t;
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)

typedef struct {
    int16                   s_HLINSC;
    int16                   s_HLING;
    int16                   s_HLOGMT;
    int16                   s_HLOGG;
    int16                   s_QLNMT;
    int16                   s_QLNG;
    int16                   s_SNRMT;
    int16                   s_SNRG;

}  HercADSL_INFO_ChanMeasParams_t;

typedef struct {
    int16                   s_Offset0;
    int16                   s_Offset1;

}  HercADSL_MONI_EventConfigure_t;
typedef struct {
    int16                   s_Offset0;
    int16                   s_Offset1;
    //int16                   s_Offset2;
}  HercADSL_STAT_ModeSelect_t;

typedef struct {
    uint16                   s_Offset0;
    uint16                   s_Offset1;
}  HercADSL_STAT_MacroState_t;

//Feature_ALL_ALL_FT_ReInit_Triggers (Start)
typedef struct {
    int16                   s_Offset0;
    int16                   s_Offset1;

}  HercADSL_ReInit_Config_t;
//Feature_ALL_ALL_FT_ReInit_Triggers (End)
// Fail states information
typedef struct {
    uint32 ul_FECSecCnt;
    uint32 ul_ESCnt;
    uint32 ul_SESCnt;
    uint32 ul_LOSSCnt;
    uint32 ul_UASLCnt;
} HercADSL_g997_LinePerfCount_t;

// XDSLRTFW-575: Counter Write back in ADSL mode (Start)
typedef struct {
   // Refer 7.2.2.1.1/7.2.2.2.1 of Spec G.997.1
   uint32 ula_g997_CRC_RunningCnt[NUM_DATA_PATHS];  // Count of CRC-8 anomalies in bearer channel
} HercADSL_g997_ChPerf_CRCStats_t;

typedef struct {
   // Refer 7.2.2.1.2/7.2.2.2.2 of Spec G.997.1
   uint32   ula_g997_FEC_RunningCnt[NUM_DATA_PATHS];  // Num of Corrected FEC codewords for LP0/ LP1 */
   uint32   ula_FECV_RunningCnt[NUM_DATA_PATHS];         // Lantiq specific - Num of Uncorrected FEC codewords for LP0/ LP1
   uint32   ula_TotalCW_RunningCnt[NUM_DATA_PATHS];      // Lantiq specific - Num of Total codewords for LP0/ LP1
}  HercADSL_g997_ChPerf_FECStats_t;
// XDSLRTFW-575: Counter Write back in ADSL mode (End)


//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (start)
//PTM performance counters
typedef struct {
   uint32 ul_CRC_P_cnt;   //near/far end crc-p
   uint32 ul_CVC_P_cnt;   //near/far end cv-p (coding violation)
   uint32 ul_CRC_NP_cnt;   //near/far end crc-np
   uint32 ul_CVC_NP_cnt;   //near/far end cv-np (coding violation)
} HercADSL_g997_NE_FE_PtmPerf_t;
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (end)
typedef struct {
    int32 l_HECp;//Count of HEC anomalies in the bearer channel
    int32 l_CDp; //Count of delineated cells in the bearer channel
    int32 l_CUp; //Count of cells to user in the bearer channel
    int32 l_IBEp;//Count of idle cell payload bit errors in the BC

} HercADSL_g997_DataPathPerfCount_t;
//XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start)
typedef struct {
    uint32 ul_UCELL_P_count;  //near end Tx User Cell count
    uint32 ul_ICELL_P_count;  //near end Tx Idle Cell count

}HercADSL_g997_NE_AtmPerf_TxCell_t;
//XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping(End)


// XDSLRTFW-1481 (Start)
typedef struct {
      int16 s_OOS_Failure;
   int16 s_LCD_NCD_Failure;
} HercADSL_g997_DataPathFailureStatus_t;
// XDSLRTFW-1481 (End)

#endif  // #ifdef HERC_API

#ifdef ADSL_62

//
// PortModeControl_t
//

// valid values for uc_DualPortModePreferred and uc_DualPortModeCurrent
#define SINGLE_PORT_MODE        0
#define DUAL_PORT_MODE          1

// valid values for uc_XdslModePreferred and uc_XdslModeCurrent
#define VDSL_PORT_MODE          0
#define ADSL_PORT_MODE          1

#define INVALID_MODE            0xFF

// valid values for us_Signature0 and us_Signature1
#define BOOT_SIGNATURE_0        0x2468
#define BOOT_SIGNATURE_1        0xB11D

#define MAX_BG_DURATION         8

// valid values for uc_AfePowerUp
#define AFE_COLD_START                  1
#define AFE_1PORT_STARTED               2
#define AFE_2PORTS_STARTED              3

//XDSLRTFW-541: Platform_VR9_VRX318 (START)
//"uc_AfePowerUp" Bits B1 & B0 are used to indicate AFE Powerup status
#define AFE_POWERUP_MASK            0x3
//XDSLRTFW-541: Platform_VR9_VRX318 (END)


// valid values for uc_AfeInitState
#define NO_AFE_EVENT                    0
#define AFE_PORT1_INIT_REGS             1
#define AFE_PORT1_INIT_REGS_DONE        2
#define AFE_PORT1_INIT_3GLP             3
#define AFE_PORT1_INIT_3GLP_DONE        4
#define AFE_PORT1_FUSE_TUNE_TRIM        5
#define AFE_PORT1_FUSE_TUNE_TRIM_DONE   6
#define AFE_INIT_DONE                   7

// boot errors used by loader_62
#define BOOT_ERROR_INVALID_IMAGE                    0xE1
#define BOOT_ERROR_INVALID_MEMEXT_SEL               0xE2
#define BOOT_ERROR_XDMA_FAILURE                     0xE3



// this structure should be at most 6 long words so that it can
// fit into one entry in the Image Swap Header Table
typedef struct {
    // PM entry
    uint16 us_Signature0;               // offset 0; a hardcode value of 0x2468
    uint8 uc_DualPortModeLock;          // offset 2; true/false that mode is locked by a port at end of  GHS
    uint8 uc_XdslModeLock;              // offset 3; true/false that mode is locked by a port at end of GHS

    uint8 uc_DualPortModePreferred;     // offset 4; power-up default;
    uint8 uc_XdslModePreferred;         // offset 5; power-up default;
    uint8 uc_DualPortModeCurrent;       // offset 6; Being loaded; default - 0xFF
    uint8 uc_XdslModeCurrent;           // offset 7; Being loaded; default - 0xFF
    uint8 uc_BootError;                 // offset 8; this will be used to communicate with driver if errors
    // detected early in the boot process

    uint8 uc_AfePowerUp;                // offset 9; AFE_COLD_START = 0; AFE_WARM_START = 1

    uint16 us_Signature1;               // offset 10; a hardcode value of 0xB11D

    // DM entry
    int32 l_SRAMImageOffset;            // offset 12; set by the BootLoader based on info in .bin file
    int32 ul_BgPortSelRegValue;         // offset 16;
    uint8 uc_BgPort;                    // offset 20;
    uint8 uc_BgDuration;                // offset 21;
    uint8 uc_MaxBgDuration;             // offset 22;
    volatile uint8 uc_AfeInitState;     // offset 23;
} PortModeControl_t;
//XDSLRTFW-699 XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start)
typedef struct {
    uint16 us_US_D0Max_Tx_CLR; // Changed as per CMV req. CMV 46 0
    uint16 us_US_D0Max_Rx_CL;  // Changed as per CMV req. CMV 46 1
} US_Interleave_Depth_t;
//XDSLRTFW-699 XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (End)

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
//SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate (START)
typedef struct {
  uint16 us_loop26awg;
  uint16 us_loop24awg;
} LooplengthEst_t;
//SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate (END)

#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
typedef struct {
  uint16 us_NlnfIbs;     //INFO 121 0
  int16  s_NlnfMetric1;  //INFO 121 1
  int16  s_NlnfMetric2;  //INFO 121 2
} NlnfInfo_t;
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start)
typedef struct
{
   int16 s_HybMaxIndex; // [0]
   int16 s_HybMaxMetric;   // [1]
   int16 s_HybSecondBestIndex;   // [2]
   int16 s_HybSecondBestMetric;  // [3]
   int16 s_HybZeroMetric;  // [4]
   int16 s_LoadHybIndex;   // [5]
} HybridInfo_t;
typedef struct
{
   uint16 us_Opt_Offset0;
} ApiOptions_t;
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (end)

//XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (start)
typedef struct
{
   uint16 us_InterOp_Bits0;
} InteropOptions_t;
//XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (End)

// XDSLRTFW-1792 (Start)
//CMV 21 0
typedef struct {
   uint16 us_Operator_Select;
}Dsl_Operator_Select_t;

// XDSLRTFW-1792 (End)

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
typedef struct {
   uint16   us_IndexOfTone;            // Index of tone being described
   int16 s_PSDLevelOfTone;       // Attenuation below MAXNOMPSD in steps of 0.5 dB
// uint16   us_InSupportedSet;         // Supported Set
} PSDRecord_t;

typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the DS Virtual Noise PSD Descriptor Table
   PSDRecord_t ut_PSDRecord[MAX_NUM_VN_DS_PSD_POINTS];
} DsVnPSDDescriptorTable_t;
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)




// Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (start)
// XDSLRTFW-1502 (start)
typedef struct {
   FlagT ft_Report_ED;                 // Support of Erasure Decoding in MS NPAR2_octet2
   FlagT ft_INP_no_erasure_not_reqd;   // Support of INP_no_erasure_not_reqd in MS NPAR3_octet 8 of PMS_TC
   uint8 uc_Rsrv1;
   uint8 uc_RsRv2;
   uint8 uc_showtime_INP_w_EDR[SIZE_EDR_BUFF];  //  Buffer to Indicate INP#Lp if ED is switch ON
   uint8 uc_showtime_INP_wo_EDR[SIZE_EDR_BUFF];//  Buffer to Indicate INP#Lp if ED is switch OFF
}ReportErasure_t;
// XDSLRTFW-1502 (end)
// Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (End)

//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
typedef struct {
   uint16 us_FW_TC_mode;
   uint16 us_PPE_TC_Mode;  /* XDSLRTFW-3068 */
}Report_Hsk_TCMode_t;
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start)
//----------------------------
// ADSL_BONDING
//----------------------------
#ifdef ADSL_BONDING

typedef struct {
   int16 s_PCS_control;          // Bit [0] = Use PAF (Reg 3.61). Only CO-side: Bit [1] = Use internal/external bonding
   int16 s_Disc_PMEAggr_control; // (CO only use)
                                 // Bit [0] = Exchange Only
                                 // Bit [2:1] = Disc Control      (Reg 6.16)
                                 // Bit [5:4] = PME Aggr Control  (Reg 6.21)
   int16 sa_DiscCode[3];         //(Reg 6.18-6.20 for CO) ;; (Remote_Disc_Reg for CPE)
   int16 sa_PMEAggr_data[2];     //(Reg 6.22-6.23 for CO) ;; (PME_Aggr_Reg for CPE)
} Bonding_DiscAggr_Control_t;

typedef struct {
   int16 s_PAF_status;              // Bit [0] = Remote PAF supported
                              // Bit [1] = Disc operation result (CO only)
                              // Bit [2] = PME Aggr operation result (CO only)
   int16 sa_DiscCode[3];            // Rx-ed Remote_Disc_Reg content
   int16 sa_PMEAggr_data[2];        // Rx-ed PME_Aggr_Reg content (CPE's actual PME_Aggr_Reg Rx-ed at CO, 0/1 Rx-ed at CPE)
} Bonding_DiscAggr_Status_t;


typedef struct {
   int16 s_continue;             // 0: 'CPE FW waiting': The CPE FW clears the LSB bit during CLR exchange
                                        //    to indicate it's waiting for the CPE ME to process any pending
                                        //    bonding commands and return discovery register and aggregate data.
                                        // 1: 'CPE FW continue': The CPE ME sets the LSB bit to indicate to
                                        //    the CPE FW that it has finished writing discovery register and
                                        //    aggregate data and the CPE FW can now continue with the rest of GHS.
   int16 sa_DiscCode[3];            // Disc_Reg populated by the CPE ME.
   int16 sa_PMEAggr_data[2];        // PME_Aggr_Reg populated from the CPE ME.
} Bonding_Continue_t;

#endif // #ifdef ADSL_BONDING
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(End)


//Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status (Start)
// Struct "RdyOvfUdf_t" is defined currently for 3GLP block only status can be extended for DFE,AFE also
typedef struct {
    #ifdef ADSL_62
    // Status of 3GLP block in VR9
    //index 0 =>Macro_0,index 1 Macro_1
    int16 s_DS_GLP_SYNC_ERR[2];        //GLP_TOP_STATUS
    int16 s_DS_GLP_FR_ERR[2];          //GLPM_GLP_FR_ERR_0,GLPM_GLP_FR_ERR_1
    int16 s_DS_GLP_DFE_FIFO_ERR_OVF[2]; //Overflow  of GLP_RX0FIFO_CFG,GLP_RX1FIFO_CFG
    int16 s_DS_GLP_DFE_FIFO_ERR_UDF[2]; //Underflow of GLP_RX0FIFO_CFG,GLP_RX1FIFO_CFG
    int16 s_DS_GLP_AFE_FIFO_ERR[2];

    int16 s_US_GLP_SYNC_ERR[2];
    int16 s_US_GLP_FR_ERR[2];
    int16 s_US_GLP_DFE_FIFO_ERR_OVF[2];  //Overflow of  GLP_TX0FIFO_CFG,GLP_TX1FIFO_CFG
    int16 s_US_GLP_DFE_FIFO_ERR_UDF[2];  //Underflow of GLP_TX0FIFO_CFG,GLP_TX1FIFO_CFG
    int16 s_US_GLP_AFE_FIFO_ERR[2];


    #else // Other than VR9 TBD
    int16 s_dummy_GLP[20];
    #endif

} RdyOvfUdf_t;
#endif // ADSL_62
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start)
typedef struct {
   uint8 guca_RFINotchInQLN[64]; // Indicated Tones effected by RFI
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): Modified to use RX coeffs from Danube
//   int16 gsa_StrymonIir_Filter_DecimHpf_2_with_Notch[RX_IIR_SIZE];   // Notch Filter RX_IIR_SIZE(39)
uint32 gula_StrymonIir_Filter_DecimHpf_2_with_Notch[34];   // Notch Filter RX_IIR_SIZE(39)
   int16 gs_len_qln;             // QLN length
   int16 gsa_pDisturber[8];      // power level in dBm/Hz
   uint16 gusa_fDisturber[8];    // center frequency in kHz - Assumption: f is a multiple of 9 kHz
   uint16 gusa_fNotchedDisturber[8];
   int16 gsa_pNotchedDisturber[8];      /* power level in dBm/Hz */
   int16 gs_b0;
   int16 gs_b1;
   int16 gs_b2;
   int16 gs_a1;
   int16 gs_a2;
   int16 gs_inscale;
   int16 gs_b0_stage2;
} QLNInfo_t;
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)

//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
//Refer to CMV 'DSL 19' in Message Spec ver 3.1
// XDSLRTFW-3636 (Start)
typedef struct {
   uint16 us_Length; // Parameter 2
   uint16 Param[3];  //Parameter 3 to 5
} ModemFeatureMap_t;
// XDSLRTFW-3636 (End)
//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)

//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
typedef struct{
int16 DbgPhaseError;
int16 SefLosPilot;
int16 NoisyPilot;
int16 DecUpdateState;
int16 DecCoefUpdateFlag;
int16 DecCoefDnloadFlag;
int16 DECCoefDnloadState;
int16 frame_with_low_metric;
int16 RxAvgMar;
int16 PmdSymCount;
}DbgDec;
#endif //#ifdef DEBUG_DEC_ADAPT
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)

// XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN(Start)
typedef struct {
   int16 s_DSPCBForce;
   int16 s_LooplengthForce;
}DebugCutBack_t;
// XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN(End)

// XDSLRTFW-1481 (Start)
typedef struct {
      int16 s_NumPilotTones;
   int16 s_PilotTones;
    uint16 usa_PilotTone_Constellation[2]; // XDSLRTFW-2419 (Start_End)
} DsStPilotDescriptorTable_t;

// XDSLRTFW-1481 (End)

//XDSLRTFW-2882 : Wrong HS tone selection (Start)
typedef struct{
   uint16 us_ToneIdx;                  // CTone Idx
   uint16 us_ToneUsability;         // 1 : Usable for detection, 0 : non usable for detection
   int16 s_TonePwr;                 // Average Tone Signal PWR in 8.8 dB Format
   int16 s_NeighboingToneNoisePwr;  // Average Neighboring Tones Noise PWR in 8.8 dB Format
}GhsCToneInfo_t;
//XDSLRTFW-2882 : Wrong HS tone selection (End)

#ifdef DEBUG_STREAMING
// Structures to provide CMV control and filter of Debug Streams
/** Enables/Disables the output of so-called "debug streams" with additional
   debug information (see also EVT_DBG_DebugStream). */
typedef struct{
   /** Parameter0.  */
   uint16 Parameter0;
} DebugStreamControl_t;

// Mask array to enable or disable debug streams (Tracee writes this array when connecting to the device)
typedef struct{
   uint32 Mask[5];
}DebugStreamConfigure_t;

/// Structure of a single debug stream queue entry
typedef struct _DSH_QueueEntry_t{
   /// Stream ID of the Debug Stream
   uint16 us_Id;
   /// debug stream counter
   uint16 us_Status;
   /// the size of the debug data
   uint16 us_Size;
   /// Number of bytes to be left for sending
   uint16 us_Length;
   /// a CRC16 over the stream's data
   uint16 us_Crc;
   /// global time stamp
   uint32 ul_SymCount;
   /// should point to global payload which should exist until msg is actually sent out.
   uint16 * p_Data;
   /// the callback function to be called after the stream has been sent. Might be 0 for "no callback"
   void (*Func)(P_DSH_Statics, P_DSH_QueueEntry);
} DSH_QueueEntry_t;


/// DSH channel statics
typedef struct _DSH_Statics_t
{
   /// The flag indicates the background handler to dispatch the last stream from queue
   FlagT ft_CleanUpLastStream;
   /// Write index into debug stream queue
   int8 c_QueueWrIdx;
   /// Read index into debug stream queue
   int8 c_QueueRdIdx;
   /// Fill level of debug stream queue
   int8 c_QueueFill;
    /// stream counter
   uint8 c_StreamNum;

   /// The debug stream queue
   DSH_QueueEntry_t ta_Queue[DSH_QUEUE_DEPTH];

   FlagT ft_Overflow;
   FlagT ft_BufferFlush;
   uint8 uca_Buffer[DSH_BUFFER_SIZE];
   int16 s_BufferWrIdx;
   int16 s_BufferRdIdx;
   int16 s_BufferFill;

} DSH_Statics_t;


// DSH Background state
typedef struct
{
   uint16 us_Handle;
   uint16 us_TxState;
   uint16 us_RxState;
   uint16 us_QueueDepth;
   uint16 us_SymbolCnt;
   uint16 us_Padding;
   uint32 ul_TotalSymbolCnt;
}DSH_BgState_t;


// Struct to report Fsm State
typedef struct
{
   uint32 ul_FsmState;
   int16 s_MacroState_Offset0;
//   uint16 us_PowerState; can be used to indicate the power states: L0 = show time, L2 = low power mode, L3 = not show time
} DSH_ModemFsmState;

typedef uint32 DSH_MaskEntry_t;
#endif


// Struct to report AFE monitoring
// void vrx5afe_dsl_pofi_gainfc_set(uint16_t mode_set, int16_t gain_pofi_dB, int32_t fc_pofi_lp_kHz)
typedef struct
{
   uint16 us_dsl_pofi_gainfc_mode_set;
   int16  s_dsl_pofi_gainfc_gain_pofi_dB;
   int32  l_dsl_pofi_gainfc_fc_pofi_lp_kHz;

   uint16 us_dsl_dac_conf_mode_set;
   uint16 us_dummy;

   uint16 us_dsl_pga_gainfc_mode_set;
   int16  s_dsl_pga_gainfc_gain_pga_dB;
   int32  l_dsl_pga_gainfc_fc_pga_lp_kHz;

   uint16 us_dsl_prefi_gainfc_mode_set;
   int16  s_dsl_prefi_gainfc_gain_prefi_dB;
   int32  l_dsl_prefi_gainfc_fc_prefi_lp_kHz;

   uint16 us_dsl_prefi_ace_ace_setting;
   uint16 us_dummy_2;
}vrx5afe_dsl_config_t;

// Struct to report DFE Tx-/Rx-path settings
typedef struct
{
   // Tx
   uint32 ul_TxVarGain;
   uint32 ul_TxIFFTScaling;
   uint32 ul_FTB_IFFT_TSIZE;
   uint32 ul_FT_REG_TX_CTRL;
   uint32 ul_QT_REG_TX_CNFG;

   // Rx
   uint32 ul_RxVarGain;
   uint32 ul_QT_REG_RX_NSC;
   uint32 ul_FT_REG_RX_CTRL;
   uint32 ul_FTB_CTRL;
}vrx5dfe_dsl_config_t;

#endif /* _TYPEDEF_H */

