/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   XRTSTATE.H
*
*   Header file for STATES.C (state machine functions).
*  These represent RT (CPE) states for both RX and TX
*
*-------------------------------------------------------------------------
*/

#ifndef XRTSTATE_H
#define XRTSTATE_H

/*  Fast Retrain states */
/*  CPE TX Fast Retrain states */

#define R_RECOV_TX                     (100)
#define R_REVERB_FR1_TX                (101)
#define R_SEGUE_FR1_TX                 (102)
#define R_LINE_PROBE_TX                (103)
#define R_REVERB_FR2_TX                (104)
#define R_SEGUE_FR2_TX                 (105)
#define R_MSG_FR1_TX                (106)
#define R_CRC_FR1_TX                (107)
#define R_QUIET_FR1_TX                 (108)
#define R_REVERB_FR3_TX                (109)
#define R_QUIET_FR2_TX                 (110)
#define R_REVERB_FR4_TX                (111)
#define R_ECT_FR_TX                    (112)
#define R_REVERB_FR5_TX                (113)
#define R_SEGUE_FR3_TX                 (114)
#define R_MEDLEY_FR_TX                 (115)
#define R_REVERB_FR6_TX                (116)
#define R_SEGUE_FR4_TX                 (117)
#define R_MSG_FR2_TX                (118)
#define R_CRC_FR2_TX                (119)
#define R_REVERB_FR7_TX                (120)
#define R_SEGUE_FR5_TX                 (121)

/*  CPE RX Fast Retrain states */
#define R_C_RECOV_RX                (123)
#define R_C_REVERB_FR1_RX              (124)
#define R_C_PILOT_FR1_RX               (125)
#define R_C_REVERB_FR2_RX              (126)
#define R_C_MSG_FR1_RX                 (127)
#define R_C_CRC_FR1_RX                 (128)
#define R_C_REVERB_FR3_RX              (129)
#define R_C_PILOT_FR2_RX               (130)
#define R_C_REVERB_FR4_RX              (131)
#define R_C_ECT_FR_RX                  (132)
#define R_C_REVERB_FR5_RX              (133)
#define R_C_PILOT_FR3_RX               (134)
#define R_C_REVERB_FR6_RX              (135)
#define R_C_SEGUE_FR2_RX               (136)
#define R_C_MEDLEY_FR_RX               (137)
#define R_C_REVERB_FR7_RX              (138)
#define R_C_SEGUE_FR3_RX               (139)
#define R_C_MSG_FR2_RX                 (140)
#define R_C_CRC_FR2_RX                 (141)
#define R_C_REVERB_FR8_RX              (142)
#define R_C_SEGUE_FR4_RX               (143)

/*  CPE Idle Link (L3) states */
#define R_IDLE_LINK_TX                    (170)
#define R_IDLE_LINK_RX                    (171)



/* =============================================================== */
/*  TX state length */
/* =============================================================== */

/*  CPE TX Transceiver Training states length */
#define R_QUIET2_TX_TIMEOUT                  (8000)

/*  CPE TX Fast Retrain states length        */
#define R_RECOV_TX_TIMEOUT             (16384)        /*  timeout period for R-RECOV */
#define R_REVERB_FR1_TX_LEN                  (256)
#define R_LINE_PROBE_TX_LEN                  (512)
#define R_REVERB_FR2_TX_LEN                  (16)
#define R_QUIET_FR1_TX_LEN                   (170)
#define R_MSG_FR1_TX_LEN                     (16)
#define R_QUIET_FR2_TX_LEN                   (1536)
#define R_REVERB_FR3_TX_LEN                  (1216)
#define R_REVERB_FR4_TX_LEN                  (32)
#define R_ECT_FR_TX_LEN                      (512)
#define R_REVERB_FR5_TX_LEN                  (128)
#define R_MEDLEY_FR_TX_LEN                   (1024)
#define R_REVERB_FR6_TX_LEN                  (16)
#define R_MSG_FR2_TX_LEN                     (16)
#define R_REVERB_FR7_TX_LEN                  (518)
#define R_SEGUE_FR5_TX_LEN                   (10)

/* =============================================================== */
/*  RX state length */
/* =============================================================== */

/*  CPE RX Fast Retrain states length */
#define R_C_RECOV_TIMEOUT              (8000)         /* = 2 second = (250*10^(-6))* 8000 */
#define R_C_RECOV_THR_LEN                    (32)
#define LOG2_R_C_RECOV_THR_LEN               (5)
#define R_C_REVERB_FR1_RX_LEN                (256)
#define R_C_REVERB_FR1_AC_LEN                (64)
#define LOG2_R_C_REVERB_FR1_AC_LEN           (6)
#define R_C_REVERB_FR1_TIMEOUT               (32+100)    /*  allow extra 100 symbols before declaring timeout */
#define R_C_PILOT_FR1_WT_LEN                 (8)
#define R_C_PILOT_FR1_TIMEOUT             (256+612+100)  /*  allow extra 100 symbols before declaring timeout */
#define R_C_REVERB_FR2_RX_LEN                (64)
#define R_C_REVERB_FR2_WT_LEN          (4)
#define NUM_FDQ_TRAIN_SYMBOLS_IN_REVER_FR2   (32)
#define LOG2_NUM_FDQ_TRAIN_SYMBOLS_IN_REVER_FR2 (5)
#define R_C_SEGUE_FR1_LEN                    (10)
#define R_C_MSG_FR1_RX_LEN                   (16)
#define R_C_CRC_FR1_RX_LEN                   (16)
#define R_C_REVERB_FR3_WT_LEN             (8)
#define R_C_REVERB_FR3_RX_LEN                (192)
#define R_C_REVERB_FR3_AC_LEN          (32)
#define LOG2_R_C_REVERB_FR3_AC_LEN        (5)
#define R_C_PILOT_FR2_RX_LEN                 (1024)
#define R_C_REVERB_FR4_RX_LEN                (32)
#define R_C_ECT_FR_RX_LEN                    (512)
#define R_C_REVERB_FR5_AC_LEN                (64)
#define LOG2_R_C_REVERB_FR5_AC_LEN           (6)
#define R_C_REVERB_FR5_RX_LEN                (1056)
#define  R_C_REVERB_FR5_WT_LEN               (3)
#define R_C_PILOT_FR3_RX_LEN              (512)
#define R_C_SEGUE_FR2_RX_LEN                 (10)
#define R_C_REVERB_FR6_TIMEOUT            (128+10+10)    /*  extra 10 symbols are used before declaring timeout */
#define R_C_REVERB_FR7_RX_LEN          (134)
#define R_C_REVERB_FR8_TIMEOUT              (400+10+100)    // extra 100 symbols are used before declaring timeout
#define R_C_MEDLEY_FR_RX_LEN           (1024)
#define R_C_MEDLEY_FR_TIMEOUT          (R_C_MEDLEY_FR_RX_LEN+R_C_REVERB_FR7_RX_LEN+20)
#define R_C_MSG_FR2_RX_LEN             (16)
#define R_C_SEGUE_FR4_RX_LEN           (10)



#endif

