/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  rx_ib.c
;
;  This file contains functions for receiving and processing the
;   indicator bits.
;
;***************************************************************************/

#include "common.h"
#include "gdata.h"
#include "ib.h"
#include "rx_ib.h"
#include "plam.h"
#include "rx_plam.h"
#include "trail.h"

/* ====================================================================*/
/*    Variables used for counting the various errors during showtime and is
   used in the PLAM */
/* ====================================================================*/

#ifdef DO_PLAM
/* flags for problems over 1sec intervals (extern in rx_plam.c) */
int16 gs_ffec_cnt;
int16 gs_febe_cnt;
int16 gs_los_fe_cnt;
int16 gs_lpr_fe_cnt; /* where? */
int16 gs_rdi_cnt;
#endif /* DO_PLAM */


/*****************************************************************************
;  Subroutine Name: RxIbProcessor
;
;  Description:
;     This subroutine processes the received sync byte containing indicator
;     bits.
;
;  Prototype:
;     void RxIbProcessor(void);
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;   Global Variables:
;     gul_RxIbInfo         - long word containing all RX Indicator Bits
;     gt_RxIbData       - structure containing Indicator Bit related variables
;
*******************************************************************************/

void RxIbProcessor(void)
{
   uint8 uc_byte;
    int16    i;
    uint16  us_ib_cnt;

   /* ib0 -- ib7: reserved for future use */
   uc_byte = (char) gul_RxIbInfo;

   /* ib8 - ib15: febe-i/f, ffec-i/f, los, rdi, and ncd-i/f */
   uc_byte = (char) (gul_RxIbInfo >> 8);
   /*  --- unpack indicator bits ib8 - ib15 --- */
   gt_RxIbData.uc_febe_i = (~(uc_byte | FEBE_I_IB) & 0xFF);             /* ib8 */
   gt_RxIbData.uc_ffec_i = (uint8)(~(uc_byte | FFEC_I_IB) & 0xFF) >>1; /* ib9 */
   gt_RxIbData.uc_febe_f = (uint8)(~(uc_byte | FEBE_F_IB) & 0xFF)>>2; /* ib10 */
   gt_RxIbData.uc_ffec_f = (uint8)(~(uc_byte | FFEC_F_IB) & 0xFF)>>3; /* ib11 */
   gt_RxIbData.uc_flos   = (uint8)(~(uc_byte | FLOS_IB) & 0xFF)>>4;   /* ib12 */
   gt_RxIbData.uc_frdi   = (uint8)(~(uc_byte | FRDI_IB) & 0xFF)>>5;   /* ib13 */
   gt_RxIbData.uc_fncd_i = (uint8)(~(uc_byte | FNCD_I_IB) & 0xFF)>>6; /* ib14 */
   gt_RxIbData.uc_fncd_f = (uint8)(~(uc_byte | FNCD_F_IB) & 0xFF)>>7; /* ib15 */

#ifdef DO_PLAM
   /*  --- process bits ib8 - ib15 --- */
   gt_RxIbData.s_febe_i_cnt += gt_RxIbData.uc_febe_i;          /*  count febe-i's */
   gt_RxIbData.s_ffec_i_cnt += gt_RxIbData.uc_ffec_i;          /*  count ffec-i's */

   gt_RxIbData.s_febe_f_cnt += gt_RxIbData.uc_febe_f;          /*  count febe-f's */
   gt_RxIbData.s_ffec_f_cnt += gt_RxIbData.uc_ffec_f;          /*  count ffec-f's */

   /* set 1sec flags */
   if ((gt_RxIbData.uc_ffec_f!=0) || (gt_RxIbData.uc_ffec_i!=0))
   {
      gs_ffec_cnt++;

#ifdef COLLECT_SHOWTIME_EVENTS_INFO
   if ((gs_RxShowtimeEventsInfoEnable & 0x8) != 0)
   {
      if (gs_RxShowtimeEventsInfoBufferIndex < (2*MAX_STATES - 20))
      {
         gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) 0xCCCC;       /* delimiter indicating FEC's information */
         gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gl_RxSymbolCount;/* rx symbol count */

#if 0
         if (gt_RxIbData.uc_ffec_f!=0)
            gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gsa_ffec_cnt[FAST_DATA_PATH];   /* fast path fec count */
         else if (gt_RxIbData.uc_ffec_i!=0)
            gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gsa_ffec_cnt[INTERLEAVE_DATA_PATH];   /* interleave path fec count */
#endif
         gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gs_ffec_cnt;  /* fast path fec count */
      }
      else
      {
         gs_RxShowtimeEventsInfoBufferIndex = gs_InitRxShowtimeEventsInfoBufferIndex;
      }
      if (gs_febe_cnt > gs_RxShowtimeEventsError_threshold)
         gs_InitRxShowtimeEventsInfoBufferIndex = 2*MAX_STATES;
   }
#endif //#ifdef COLLECT_SHOWTIME_EVENTS_INFO

   }
   if ((gt_RxIbData.uc_febe_f!=0) || (gt_RxIbData.uc_febe_i!=0))
   {
      gs_febe_cnt++;

#ifdef COLLECT_SHOWTIME_EVENTS_INFO
   if ((gs_RxShowtimeEventsInfoEnable & 0x4) != 0)
   {
      if (gs_RxShowtimeEventsInfoBufferIndex < (2*MAX_STATES - 20))
      {
         gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) 0xDDDD;          /* delimiter indicating crc's information */
         gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gl_RxSymbolCount;   /* rx symbol count */

#if 0
         if (gt_RxIbData.uc_febe_f!=0)
            gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gsa_febe_cnt[FAST_DATA_PATH];   /* fast path CRC count */
         else if (gt_RxIbData.uc_febe_i!=0)
            gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gsa_febe_cnt[INTERLEAVE_DATA_PATH];   /* interleave path CRC count */
#endif
         gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gs_febe_cnt;  /* fast path CRC count */
      }
      else
      {
         gs_RxShowtimeEventsInfoBufferIndex = gs_InitRxShowtimeEventsInfoBufferIndex;
      }
      if (gs_febe_cnt > gs_RxShowtimeEventsError_threshold)
         gs_InitRxShowtimeEventsInfoBufferIndex = 2*MAX_STATES;
   }
#endif //#ifdef COLLECT_SHOWTIME_EVENTS_INFO

   }

   if (gt_RxIbData.uc_flos!=0)
      gs_los_fe_cnt++;

   if (gt_RxIbData.uc_frdi!=0)
      gs_rdi_cnt++;
   /* where is lpr stuff: 1sec/2.5sec? */
   /* what is this? */
   if(gft_response_to_powerdown == GRANTED)
      gs_lpr_fe_cnt ++;

   if (gft_TransferMode == ATM)
   {
      /* ncd processing: map ncd ib into ncd-anom, ocd-anom, lcd-def
      which are essentially 3 mutually exclusive "states" for the ATM state machine
      to be out of the SYNC state. The ncd-anom describes startup behavior,
      ocd-anom intermittently out of sync state, lcd-def being out of sync state
      for several consecutive superframes */
      /* process inlv channel */
      /* NCD anomaly */
      if (gt_RxIbData.uc_fncd_i == TERMINATED)
         gt_RxIbData.uc_fncd_i_anom = TERMINATED;
      /* OCD anomaly */
      if ((gt_RxIbData.uc_fncd_i == PRESENT) && (gt_RxIbData.uc_fncd_i_anom == TERMINATED))
         gt_RxIbData.uc_focd_i_anom = PRESENT;
      if ((gt_RxIbData.uc_fncd_i == TERMINATED) && (gt_RxIbData.uc_flcd_i_def == PRESENT))
         gt_RxIbData.uc_focd_i_anom = TERMINATED;
      /* LCD defect */
      gt_RxIbData.uc_fncd_i_hist = ((gt_RxIbData.uc_fncd_i_hist<<1) | gt_RxIbData.uc_fncd_i) & 0x0F;
      us_ib_cnt = 0;
      for (i = 0; i < LCD_SUPERFRAMES; i++)
         us_ib_cnt += (((gt_RxIbData.uc_fncd_i_hist)>>i) & 0x01);
      if ((gt_RxIbData.uc_focd_i_anom == PRESENT) && (gt_RxIbData.uc_frdi == TERMINATED)&&
         (us_ib_cnt == LCD_SUPERFRAMES))
         gt_RxIbData.uc_flcd_i_def = PRESENT;
      if (us_ib_cnt == 0)
         gt_RxIbData.uc_flcd_i_def = TERMINATED;
      /* process fast channel */
      /* NCD anomaly */
      if (gt_RxIbData.uc_fncd_f == TERMINATED)
         gt_RxIbData.uc_fncd_f_anom = TERMINATED;
      /* OCD anomaly */
      if ((gt_RxIbData.uc_fncd_f == PRESENT) && (gt_RxIbData.uc_fncd_f_anom == TERMINATED)) // second condition is for startup situation
         gt_RxIbData.uc_focd_f_anom = PRESENT;
      if ((gt_RxIbData.uc_fncd_f == TERMINATED) && (gt_RxIbData.uc_flcd_f_def == PRESENT))
         gt_RxIbData.uc_focd_f_anom = TERMINATED;
      /* LCD defect */
      gt_RxIbData.uc_fncd_f_hist = ((gt_RxIbData.uc_fncd_f_hist<<1) | gt_RxIbData.uc_fncd_f) & 0x0F;
      us_ib_cnt = 0;
      for (i = 0; i < LCD_SUPERFRAMES; i++)
         us_ib_cnt += (((gt_RxIbData.uc_fncd_f_hist)>>i) & 0x01);
      if ((gt_RxIbData.uc_focd_f_anom == PRESENT) && (gt_RxIbData.uc_frdi == TERMINATED)&&
         (us_ib_cnt == LCD_SUPERFRAMES))
         gt_RxIbData.uc_flcd_f_def = PRESENT;
      if (us_ib_cnt == 0)
         gt_RxIbData.uc_flcd_f_def = TERMINATED;
   }
#endif /* DO_PLAM */

   /* ib16 - ib24: hec-i/f, ntr0-3, reserved for future use */
   uc_byte = (char) (gul_RxIbInfo >> 16);
   /* unpack indicator bits ib16 - ib23 (ib18 - ib19 are reserved) */
   gt_RxIbData.uc_fhec_i = ~(uc_byte | FHEC_I_IB);             /*  unpack ib16 */
   gt_RxIbData.uc_fhec_f = (uint8)(~(uc_byte | FHEC_F_IB))>>1; /*  unpack ib17 */
   us_ib_cnt = (uc_byte & 0xF0)<<8;
   gt_RxIbData.s_fntr   =  ((int16)us_ib_cnt)>>12;        /* get bits 20-23 */
#ifdef DO_PLAM
   /* process bits ib16 - ib23 */
   if (gft_TransferMode == ATM)
   {
      gt_RxIbData.s_fhec_i_cnt += gt_RxIbData.uc_fhec_i;       /*  count_fhec-i's */
      gt_RxIbData.s_fhec_f_cnt += gt_RxIbData.uc_fhec_f;       /*  count_fhec-f's */
   }
#endif /* DO_PLAM */

   /*  --- process ntr bits --- */
   /*  Note: for implementation on a specific platform, code should be */
   /*  inserted here to adjust the local 8 kHz timing reference by the number */
   /*  of sample clock cycles given by gt_RxIbData.s_fntr. This number is given */
   /*  in 4 bits 2s compliment form. This operation is */
   /*  tightly-coupled with a specific hardware implementation, so it is */
   /*  excluded from this C-model */


}

