/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  rx_ib_ini.c
;
;  This file contains functions for initializing the indicator bits
;
;***************************************************************************/

#include "common.h"
#include "gdata.h"
#include "ib.h"
#include "cmv.h"

/*****************************************************************************
;  Subroutine Name: RxInitIb
;
;  Description:
;     This subroutine initializes the variables and structures requrid for
;     processing the received indicator bits
;
;  Prototype:
;     void RxInitIb(void);
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;   Global Variables:
;     gt_RxIbData       - structure containing RX Indicator Bits variables
;
*******************************************************************************/
void RxInitIb(void)
{

   gt_RxIbData.s_febe_i_cnt = 0;   /* febe-i Counter  */
   gt_RxIbData.s_febe_f_cnt = 0;   /* febe-f Counter  */
   gt_RxIbData.s_ffec_i_cnt = 0;   /* ffec-i Counter */
   gt_RxIbData.s_ffec_f_cnt = 0;   /* ffec-f Counter */
   gt_RxIbData.s_fhec_i_cnt = 0;   /* fhec-i Counter  */
   gt_RxIbData.s_fhec_f_cnt = 0;   /* fhec-f Counter  */

   if (gft_TransferMode == ATM)
   {
      gt_RxIbData.uc_fncd_i_anom = PRESENT;       /* Far-End No Cell Delineation interleaved anomaly flag */
      gt_RxIbData.uc_fncd_f_anom = PRESENT;       /* Far-End No Cell Delineation fast anomaly flag */
   }
   else
   {
      gt_RxIbData.uc_fncd_i_anom = TERMINATED;    /* Far-End No Cell Delineation interleaved anomaly flag */
      gt_RxIbData.uc_fncd_f_anom = TERMINATED;    /* Far-End No Cell Delineation fast anomaly flag */
   }

   gt_RxIbData.uc_focd_i_anom = TERMINATED;  /* Far-End Out of Cell Delineation interleaved anomaly flag */
   gt_RxIbData.uc_focd_f_anom = TERMINATED;  /* Far-End Out of Cell Delineation fast anomaly flag */

   gt_RxIbData.uc_fncd_i_hist = NO_NCD_INDICATIONS;
   gt_RxIbData.uc_fncd_f_hist = NO_NCD_INDICATIONS;
   gt_RxIbData.uc_flcd_i_def  = TERMINATED;
   gt_RxIbData.uc_flcd_f_def  = TERMINATED;
}

