/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;       Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;       Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;       File Name: tx_ib.c
;
;       This file contains functions for transmitting the indidcator bits.
;
;***************************************************************************/
// ******************************************************************
// tx_ib.c
//      History
// 04/07/2012 Anantha: Added code to declare LCD, NCD defects,
//                                        removed old code
//                      grep pattern XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers
// ******************************************************************
#include "common.h"
#include "ib.h"
#include "gdata.h"
#include "xgdata.h"
#include "mp.h"
#include "cmv.h"
#include "tx_plam.h"
#include "trail.h"
/* ====================================================================*/
//    Variables used for counting the various errors during showtime and is
//        used in the PLAM
/* ====================================================================*/



/*****************************************************************************
;       Subroutine Name: TxIbHandler(...)
;
;       This subroutine generates the transmitted sync bytes containing indicator
;   bits.  An indicator bit with a value of 1b indicates that the
;   corresponding anomaly or defect is not present and with a value of 0b
;   indicates that the corresponding anomaly or defect is not present.
;
;       Prototype:
;               uint8 TxIbHandler(uint8 uc_byte, int16 s_frame_number)
;
;       Input Arguments:
;       s_frame_number  -- current frame number within superframe
;
;       Output Arguments:
;               none
;
;       Return:
;               uc_byte         -- current sync byte for this frame
;
;       Global Variables (defined in other files):
;   gusa_CRC_count
;
;   Global Variables (defined in this file):
;   gt_TxIbData
;
*******************************************************************************/
#ifdef DEBUG_BITSWAP
int16 gs_dbg_crccheck = 0;
#endif

uint8 TxIbHandler(int16 s_frame_number)
{
    uint8 uc_byte;

    uc_byte = NO_INDICATIONS;

    switch(s_frame_number)
    {
    case 1:
        /* ============================================ */
        /* ib0 - ib7: reserved by the ITU-T */
        /* ============================================ */
        break;

    case 34:
        /* ============================================ */
        /* ib8:  check for crc-i anomaly, set tx febe-i */
        /* ============================================ */
        if (gusa_CRC_count[INTERLEAVE_DATA_PATH] != gt_TxIbData.us_prev_CRCi_err_count)         //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
        {
            uc_byte &= FEBE_I_IB;
            gt_TxIbData.uc_febe_i_anom = PRESENT;
            gt_TxIbData.us_prev_CRCi_err_count = gusa_CRC_count[INTERLEAVE_DATA_PATH];  //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

                        gs_crc_cnt++;

#if 1
#ifdef COLLECT_SHOWTIME_EVENTS_INFO
                        if ((gs_RxShowtimeEventsInfoEnable & 0x8) != 0)
                        {
                                if (gs_RxShowtimeEventsInfoBufferIndex < (2*MAX_STATES - 20))
                                {
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) 0xFFFF;                 /* delimiter indicating DS CRC's information */
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gl_RxSymbolCount;/* rx symbol count */
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gusa_CRC_count[INTERLEAVE_DATA_PATH];   /* interleave path CRC count */  //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

                                        if (gusa_CRC_count[INTERLEAVE_DATA_PATH] > gs_RxShowtimeEventsError_threshold)  //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
                                        {
                                                gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = gsa_RxToneBuf[2*gs_SyncSymbolCaptureTone];
                                                gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = gsa_RxToneBuf[2*gs_SyncSymbolCaptureTone+1];
                                        }
                                }
                                else
                                {
                                        gs_RxShowtimeEventsInfoBufferIndex = gs_InitRxShowtimeEventsInfoBufferIndex;
                                }
                                if (gusa_CRC_count[INTERLEAVE_DATA_PATH] > gs_RxShowtimeEventsError_threshold)  //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
                                        gs_InitRxShowtimeEventsInfoBufferIndex = 2*MAX_STATES;
                        }
#endif //#ifdef COLLECT_SHOWTIME_EVENTS_INFO
#endif

                }
        else
        {
            gt_TxIbData.uc_febe_i_anom = TERMINATED;
        }

        /* =========================================================== */
        /* ib9:  check for any fec-i anomalies in previous superframe,  */
        /*       set tx ffec-i */
        /* =========================================================== */
        if (gt_TxIbData.uc_ffec_i_anom_prev == PRESENT)
        {
            uc_byte &= FFEC_I_IB;

#if 1
#ifdef COLLECT_SHOWTIME_EVENTS_INFO
                        if ((gs_RxShowtimeEventsInfoEnable & 0x8) != 0)
                        {
                                if (gs_RxShowtimeEventsInfoBufferIndex < (2*MAX_STATES - 20))
                                {
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) 0xEEEE;                 /* delimiter indicating DS FEC's information */
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gl_RxSymbolCount;/* rx symbol count */
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gsa_CorrectedRSErrors[INTERLEAVE_DATA_PATH];    /* interleave path FEC count */
                                }
                                else
                                {
                                        gs_RxShowtimeEventsInfoBufferIndex = gs_InitRxShowtimeEventsInfoBufferIndex;
                                }
                                if (gsa_CorrectedRSErrors[INTERLEAVE_DATA_PATH] > gs_RxShowtimeEventsError_threshold)
                                        gs_InitRxShowtimeEventsInfoBufferIndex = 2*MAX_STATES;
                        }
#endif //#ifdef COLLECT_SHOWTIME_EVENTS_INFO
#endif

        }

        /* ============================================ */
        /* ib10:  check for crc-f anomaly, set tx febe-f */
        /* ============================================ */
        if (gusa_CRC_count[FAST_DATA_PATH] != gt_TxIbData.us_prev_CRCf_err_count)       //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
        {
            uc_byte &= FEBE_F_IB;
            gt_TxIbData.uc_febe_f_anom = PRESENT;
            gt_TxIbData.us_prev_CRCf_err_count = gusa_CRC_count[FAST_DATA_PATH];        //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
                        gs_crc_cnt++;

#if 1
#ifdef COLLECT_SHOWTIME_EVENTS_INFO
                        if ((gs_RxShowtimeEventsInfoEnable & 0x8) != 0)
                        {
                                if (gs_RxShowtimeEventsInfoBufferIndex < (2*MAX_STATES - 20))
                                {
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) 0xFFFF;                 /* delimiter indicating DS CRC's information */
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gl_RxSymbolCount;/* rx symbol count */
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gusa_CRC_count[FAST_DATA_PATH]; /* FAST path CRC count */       //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

                                        if (gusa_CRC_count[FAST_DATA_PATH] > gs_RxShowtimeEventsError_threshold)        //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
                                        {
                                                gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = gsa_RxToneBuf[2*gs_SyncSymbolCaptureTone];
                                                gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = gsa_RxToneBuf[2*gs_SyncSymbolCaptureTone+1];
                                        }
                                }
                                else
                                {
                                        gs_RxShowtimeEventsInfoBufferIndex = gs_InitRxShowtimeEventsInfoBufferIndex;
                                }
                                if (gusa_CRC_count[FAST_DATA_PATH] > gs_RxShowtimeEventsError_threshold)        //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
                                        gs_InitRxShowtimeEventsInfoBufferIndex = 2*MAX_STATES;
                        }
#endif //#ifdef COLLECT_SHOWTIME_EVENTS_INFO
#endif

                        // Log Bitswap info
                        if (gs_BitSwapLogIndex < (2*MAX_STATES - 20))
                        {
                                gsa_StatesTrail[gs_BitSwapLogIndex++] = (int16) 0xFFFF;                 /* delimiter indicating DS Bitswap UTC information */
                                gsa_StatesTrail[gs_BitSwapLogIndex++] = (int16) gus_ShowtimeSNRUpdateCount;     /* rx symbol count */
                                gsa_StatesTrail[gs_BitSwapLogIndex++] = (int16) gusa_CRC_count[FAST_DATA_PATH]; /* fast path CRC count */       //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

#ifdef DEBUG_BITSWAP
                                if (gs_dbg_crccheck && (gusa_CRC_count[1] > gs_dbg_crccheck || gs_RxMinMargin < 0))     //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
                                {
                                        OPTNArray[OPTN_AlgControl] |= OPTN_DSAutoBitSwapDisable;

                                        if (gft_doDDSnrFdqUpdate)
                                        {
                                                guc_ddProcState = DD_PROC_DISABLE;
                                        }
                                        gs_dbg_crccheck = 0;
                                }
#endif
                        }

        }
        else
        {
            gt_TxIbData.uc_febe_f_anom = TERMINATED;
        }

        /* =========================================================== */
        /* ib11:  check for any fec-f anomalies in previous superframe,  */
        /*        set tx ffec-f */
        /* =========================================================== */
        if (gt_TxIbData.uc_ffec_f_anom_prev == PRESENT)
        {
            uc_byte &= FFEC_F_IB;

#ifdef COLLECT_SHOWTIME_EVENTS_INFO
                        if ((gs_RxShowtimeEventsInfoEnable & 0x8) != 0)
                        {
                                if (gs_RxShowtimeEventsInfoBufferIndex < (2*MAX_STATES - 20))
                                {
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) 0xEEEE;                 /* delimiter indicating DS FEC's information */
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gl_RxSymbolCount;/* rx symbol count */
                                        gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gsa_CorrectedRSErrors[FAST_DATA_PATH];  /* fast path FEC count */
                                }
                                else
                                {
                                        gs_RxShowtimeEventsInfoBufferIndex = gs_InitRxShowtimeEventsInfoBufferIndex;
                                }
                                if (gsa_CorrectedRSErrors[FAST_DATA_PATH] > gs_RxShowtimeEventsError_threshold)
                                        gs_InitRxShowtimeEventsInfoBufferIndex = 2*MAX_STATES;
                        }
#endif //#ifdef COLLECT_SHOWTIME_EVENTS_INFO

        }

        /* ============================================ */
        /* ib12:  check for los defect, set tx flos-i */
        /* ============================================ */
        if (gt_TxIbData.uc_flos_def == PRESENT)
        {
            uc_byte &= FLOS_IB;

            if(gt_TxIbData.s_los_cnt != 0)
                gt_TxIbData.s_los_cnt--;
        }

        /*  check to see if sent enough consecutive los */
        else if (gt_TxIbData.s_los_cnt == 0)
        {
            /*  all los have been sent, reset counter */
            gt_TxIbData.s_los_cnt = LOS_SUPERFRAMES;
        }
        else if (gt_TxIbData.s_los_cnt != LOS_SUPERFRAMES)
        {
            /*  all los not sent, continue to send */
            uc_byte &= FLOS_IB;
            gt_TxIbData.s_los_cnt--;
            if(gt_TxIbData.s_los_cnt == 0)
                gt_TxIbData.s_los_cnt = LOS_SUPERFRAMES;
        }

        /* ============================================ */
        /* ib13:  check for sef defect, set tx frdi-i */
        /* ============================================ */
        if (gt_TxIbData.uc_fsef_def == PRESENT)
        {
            uc_byte &= FRDI_IB;
        }

        if (gft_TransferMode == ATM)
        {
        //An ocd-n anomaly occurs when the cell delineation process of receive ATM-TC sub-function #n transitions
        //from the SYNC state to the HUNT state. An ocd-n anomaly terminates when the cell delineation process
        //transitions from PRESYNC state to SYNC state or when the lcd-n defect is asserted.

        //An lcd-n defect occurs when at least one ocd-n anomaly is present in each of four consecutive superframe
        //and no sef-n defect is present. An lcd-n defect terminates when no ocd-n anomaly is present in four
        //consecutive superframes.

        //The following code tries to indicate ocd, lcd and ncd according to the above definition.
        //NCD defect implementation is stright forward if no cell delineation happens after entering
        //show time NCD anamoly is declared.
        //If There is no cell delineation then OCD anamoly is declared
        //Core of the code has a variable which keeps trak of history of four consicutive overhead
        //ocd-anamoly in order using sliding window concept. If at least one over head period out of
        //previous four over head period has ocd-anamoly then LCD defect is declared. If no previous four
        //superframe has ocd-anamoly LCD defect is terminated.
            /* ========================================================= */
            /* ib14:  check for ncd-i and ocd-i anomalies, set tx fncd-i */
            /* ========================================================= */
                        //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
                        if(gt_RxShowTimeVars.t_BCParms[0].sa_BC_LPath == INTERLEAVE_DATA_PATH) {
                                gt_TxIbData.uc_fncd_f_anom  = TERMINATED;
                        //Reset ncd anomaly once cell delineation is achived after entering
                        //showtime. Following code will set uc_fncd_i_anom variable to zero
                        // if at least once cell delineation is acheived after entering show time
                                gt_TxIbData.uc_fncd_i_anom = gt_TxIbData.uc_fncd_i_anom &&
                                                                                                (!gt_TxIbData.uc_cd_i_flag);

                        //Set ocd anomaly after ncd anomaly is terminated and cell delineation
                        //is lost
                                gt_TxIbData.uc_focd_i_anom =  (!gt_TxIbData.uc_cd_i_flag) &&
                                                                                                        (!gt_TxIbData.uc_fncd_i_anom) ;
                                //Keep track of previous four overhead period loss of cell delineation
                                //occured or not Bit0, Bit1, Bit2, Bit3 gives cell deliniation
                                //happend or not in last 4 overhead periods in acending order
                                gca_NEFourOHPeriodLCDInfo[0] = (gca_NEFourOHPeriodLCDInfo[0] << 1)&0xE;
                                gca_NEFourOHPeriodLCDInfo[0] |= gt_TxIbData.uc_focd_i_anom & 0x1;
                                //delare or terminate LCD-defect
                                gt_TxIbData.uc_flcd_i_def = (gca_NEFourOHPeriodLCDInfo[0] > 0) &&
                                                                                                                (!gt_TxIbData.uc_fsef_def);
                                //terminate ocd-anamly if  LCD defect is declared.
                                gt_TxIbData.uc_focd_i_anom  = (gt_TxIbData.uc_focd_i_anom) &&
                                                                                                        (!gt_TxIbData.uc_flcd_i_def);
                                //Set IB bit based on LCD NCD and OCD anamoly/defect
                uc_byte &= ~(((gt_TxIbData.uc_fncd_i_anom |
                                                          gt_TxIbData.uc_focd_i_anom |
                                                          gt_TxIbData.uc_flcd_i_def)&0x1) << 6);
                        } else {
                                gt_TxIbData.uc_fncd_i_anom  = TERMINATED;
                                //delare or terminate NCD anamoly
                        //Reset ncd anomaly once cell delineation is achived after entering
                        //showtime. Following code will set uc_fncd_f_anom variable to zero
                        // if at least once cell delineation is acheived after entering show time
                                gt_TxIbData.uc_fncd_f_anom = gt_TxIbData.uc_fncd_f_anom &&
                                                                                                        (!gt_TxIbData.uc_cd_f_flag);
                        //Set ocd anomaly after ncd anomaly is terminated and cell delineation
                        //is lost
                                gt_TxIbData.uc_focd_f_anom =  (!gt_TxIbData.uc_cd_f_flag) &&
                                                                                                        (!gt_TxIbData.uc_fncd_f_anom);
                                //Keep track of previous four overhead period loss of cell delineation
                                //occured or not Bit0, Bit1, Bit2, Bit3 gives cell deliniation
                                //happend or not in last 4 overhead periods in acending order
                                gca_NEFourOHPeriodLCDInfo[1] = (gca_NEFourOHPeriodLCDInfo[1] << 1)&0xE;
                                gca_NEFourOHPeriodLCDInfo[1] |= (gt_TxIbData.uc_focd_f_anom)&0x1 ;
                                //delare or terminate LCD anamoly
                                gt_TxIbData.uc_flcd_f_def = (gca_NEFourOHPeriodLCDInfo[1] > 0) &&
                                                                                                                (!gt_TxIbData.uc_fsef_def);
                                //terminate ocd-anamly if  LCD defect is declared.
                                gt_TxIbData.uc_focd_f_anom  = (gt_TxIbData.uc_focd_f_anom) &&
                                                                                                                (!gt_TxIbData.uc_flcd_f_def);
                                //Set IB bit based on LCD NCD and OCD anamoly/defect
                uc_byte &= ~(((gt_TxIbData.uc_fncd_f_anom |
                                                          gt_TxIbData.uc_focd_f_anom |
                                                          gt_TxIbData.uc_flcd_f_def)&0x1) << 7);
                        //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
                        }

        }

        break;

    case 35:

        if (gft_TransferMode == ATM)
        {
            /* ============================================= */
            /* ib16:  check for hec-i anomaly, set tx fhec-i */
            /* ============================================= */
            if (gt_TxIbData.uc_fhec_i_anom_prev == PRESENT)
            {
                uc_byte &= FHEC_I_IB;
            }


            /* ============================================= */
            /* ib17:  check for hec-f anomaly, set tx fhec-f */
            /* ============================================= */
            if (gt_TxIbData.uc_fhec_f_anom_prev == PRESENT)
            {
                uc_byte &= FHEC_F_IB;
            }
        }

        /* ============================================= */
        /* ib17-19:  Reserved by ITU-T, so leave set to NO_INDICATIONS */
        /* ============================================= */

        /* ============================================= */
        /* ib20-23:  NTR is not sent by a CPE modem, so leave set to NO_INDICATIONS */
        /* ============================================= */

    default:
        break;

    }

    return(uc_byte);
}

