/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: tx_ib_b.c
;
;  Functions for BG Tasks from tx_ib.c
;
;***************************************************************************/

#include "common.h"
#include "ib.h"
#include "gdata.h"
#include "xgdata.h"
#include "mp.h"
#include "cmv.h"

// ******************************************************************
// tx_ib_b.c
//
// History

////16/07/2012 Anantha: Cleaned up unused LCD NCD related code
//             grep pattern XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Trigger
// ******************************************************************
/*****************************************************************************
;  Subroutine Name: Update_TxIb(...)
;
;  Some of the anomalies that are reported in the TX indicator bits have a
;   duration of less than one super frame.  In these cases the TX indicator
;   bits are used to indicate that at least one a particular type of anomaly
;   existed in the previous superframe.  This subroutine examines the history
;   of the anaomlies over the previous superframe and sets the appropriate flag
;   inidcating the present or absence of the anomaly during the previous.  The
;   anomalies that require this type of monitoring include:
;
;       FFEC-I, FFEC-F, FHEC-I, FHEC-F, FOCD-I, FOCD-F, FNCD-I, FNCD-F
;
;  Prototype:
;       void Update_TxIB(void)
;
;  Input Arguments:
;       none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;   Global Variables
;   gt_TxIbData
;
*******************************************************************************/

void Update_TxIb(void)
{

    /*  prepare ffec-i for transmission next superframe */
    if (gt_TxIbData.uc_ffec_i_anom_hist == PRESENT)
    {
        gt_TxIbData.uc_ffec_i_anom_prev = PRESENT;
    }
    else
    {
        gt_TxIbData.uc_ffec_i_anom_prev = TERMINATED;
    }

    gt_TxIbData.uc_ffec_i_anom_hist = TERMINATED;

    /*  prepare ffec-f for transmission next superframe */
    if (gt_TxIbData.uc_ffec_f_anom_hist == PRESENT)
    {
        gt_TxIbData.uc_ffec_f_anom_prev = PRESENT;
    }
    else
    {
        gt_TxIbData.uc_ffec_f_anom_prev = TERMINATED;
    }

    gt_TxIbData.uc_ffec_f_anom_hist = TERMINATED;
    gt_TxIbData.uc_cd_i_flag_hist = TRUE;


    /*  check cell delineation-f flag history */
   if (((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) == 0) && ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C) == 0)) /* only if g992_1 is enabled */
   {
      gt_TxIbData.uc_cd_f_flag_hist = TRUE;
   }

    /*  check HEC-I anomaly history */
    if (gt_TxIbData.uc_fhec_i_anom_hist == PRESENT)
    {
        gt_TxIbData.uc_fhec_i_anom_prev = PRESENT;
    }
    else
    {
        gt_TxIbData.uc_fhec_i_anom_prev = TERMINATED;
    }
    gt_TxIbData.uc_fhec_i_anom_hist = TERMINATED;

    /*  check HEC-F anomaly history */
    if (gt_TxIbData.uc_fhec_f_anom_hist == PRESENT)
    {
        gt_TxIbData.uc_fhec_f_anom_prev = PRESENT;
    }
    else
    {
        gt_TxIbData.uc_fhec_f_anom_prev = TERMINATED;
    }
    gt_TxIbData.uc_fhec_f_anom_hist = TERMINATED;

}

