/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  tx_ib_ini.c
;
;  This file contains functions for initializing the indicator bits
;
;***************************************************************************/

#include "common.h"
#include "gdata.h"
#include "ib.h"
#include "cmv.h"



/*****************************************************************************
;  Subroutine Name: TxInitIb(...)
;
;  This subroutine initializes the variables and structures required for
;   processing the received indicator bits
;
;  Prototype:
;     void TxInitIb()
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;  Global Variables (defined in other files):
;
;   Global Variables (defined in this file):
;  gt_TxIbData
;
*******************************************************************************/
// ******************************************************************
// tx_ib_ini.c
//
// History
//
// 04/07/2012 Anantha: Added LCD, NCD related initializaion.
//          grep pattern XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers
// ******************************************************************

void TxInitIb()
{

   memset(&gt_TxIbData, 0, sizeof(gt_TxIbData));

   if (gft_TransferMode == ATM)
   {
   //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
   //initialize NCD depending on latency path.
      if(gt_RxShowTimeVars.t_BCParms[0].sa_BC_LPath == FAST_DATA_PATH) {
         gt_TxIbData.uc_fncd_f_anom = PRESENT;
         gt_TxIbData.uc_fncd_i_anom = TERMINATED;
      } else {
         gt_TxIbData.uc_fncd_i_anom = PRESENT;
         gt_TxIbData.uc_fncd_f_anom = TERMINATED;
      }

      //initialize four consicutive LCD defect info
      gca_NEFourOHPeriodLCDInfo[0] = 0;
      gca_NEFourOHPeriodLCDInfo[1] = 0;
   //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
   }

   gt_TxIbData.s_los_cnt = LOS_SUPERFRAMES;
}

