/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2002 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       One Oak Park, Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       mp.c
*
*       ADSL Configuration and Management protocol
*
*-------------------------------------------------------------------
*/

#ifndef MP_C
#define MP_C

#define IN_MP_C

/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include "typedef.h"
#include "const.h"
#include "cmv.h"
#include "mp.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "trail.h"
#include "ghs.h"
#include "rx_eoc.h"
#include "tdq_init.h"
#include "rinfotbl.h"
#include "dec_gain.h"
#include "enc_gain.h"
#include "tone_ord.h"
#include "sach.h" // For Sachmo channel DLL



#include "dli.h"
initDLI_t   fnInitDLI;
processDLI_t   fnProcessDLI;
releaseDLI_t   fnReleaseDLI;
HANDLE inf_dll;


// Local functions
int16 Initialize_DLI_Connectivity(void);
int16 Initialize_Sachmo_Connectivity(void);

/* Link DLI connectivity functions  */

InitiateDLIProcess_f    InitiateDLIProcess;
InitRxADCBufferPtrs_f   InitRxADCBufferPtrs;
DliHandler_f            DliHandler;
ExitRequest_f           ExitRequest;
ReleaseEventHandlers_f  ReleaseEventHandlers;

InitiateDLIProcess_M_f    InitiateDLIProcessM;
InitRxADCBufferPtrs_M_f   InitRxADCBufferPtrsM;
DliHandler_M_f            DliHandlerM;
ExitRequest_M_f           ExitRequestM;
ReleaseEventHandlers_M_f  ReleaseEventHandlersM;

/* MP connectivity functions  */

WriteMPtoModem_f     WriteMPtoModem;
ReadMPtoModem_f         ReadMPtoModem;
WriteModemtoMP_f     WriteModemtoMP;
ReadModemtoMP_f         ReadModemtoMP;
WriteNewMPtoModem_f     WriteNewMPtoModem;
ReadNewMPtoModem_f      ReadNewMPtoModem;
WriteModemtoNewMP_f     WriteModemtoNewMP;
ReadModemtoNewMP_f      ReadModemtoNewMP;
SelectNewMPPort_f    SelectNewMPPort;

/*******************************************************************
*
*       Define Variables
*
*******************************************************************/


/* flags set based on file availability.  initialzed to available state.   */

int16 gs_TxInputFile = 1;
int16 gs_TxOutputFile = 1;
int16 gs_TxConfigFile = 1;
int16 gs_RxInputFile = 1;
int16 gs_RxOutputFile = 1;
int16 gs_RxConfigFile = 1;
int16 gs_TrailFile = 1;

FILE *Mp_infid = NULL;

char Tx_Infile_Name[80];
char Tx_Outfile_Name[80];
char Rx_Infile_Name[80];
char Rx_Outfile_Name[80];
char Taps_Infile_Name[80];

/* assume both File and WINHOST MP control are available.   */
/* clear these variables if control is not found.        */

int16 gs_DLI_TxFftLength;

HINSTANCE Dll, MPDll;



/*****************************************************************************
;  Prototype: int16 ProcCommand(void)
;
;  This subroutine processes the command line arguments of C program.
;
;  Input Arguments:
;     argc  -- number of command line arguments
;     argv[]  -- actual command line arguments
;
;  Output Arguments:
;
;  Return:
;     SECCEED -- input argument valid
;     FAIL  -- one or more input argument is invalid
;
;  Global Variables:
;     gus_tx_config_num -- (O) TX configuration number
;     gus_rx_config_num -- (O) RX configuration number
;     gs_InitialState      -- (o) ID to represent initial state to start with
;
;****************************************************************************/

int16 ProcCommand(int argc, char *argv[])
{
   //==========================================================================
   // Initialize TEST register
   //==========================================================================

   int   argoff = 0; // Argument offset - squeezing in an arg to specify which CO to talk to.

   TESTArray[TEST_TxConfigNum] = 0; // gus_tx_config_num
   TESTArray[TEST_RxConfigNum] = 0; // gus_rx_config_num
   TESTArray[TEST_BertSFCnt] = 140; // gs_bert_sf_cnt

   if (argc == 1)
   {
      fprintf(stderr, "No command line args:\n");
      gs_COChannel = -1;
      gs_MpFileControl = 0;

      if (AttachDLL() == SUCCEED)
      {
         fprintf(stderr, "Assuming connectivity or Winhost control --- \n ");

         /* clear variables to indicate that files are not available */

         gs_TxInputFile = 0;
         gs_TxOutputFile = 0;
         gs_TxConfigFile = 0;
         gs_RxInputFile = 0;
         gs_RxOutputFile = 0;
         gs_RxConfigFile = 0;
      }

#ifdef LEAVE_TRAIL
      if( (OpenTrailFile()) == (int16)FAIL)
         return((int16)FAIL);

#endif

      return((int16)SUCCEED);
   }

   /* ================================================================= */
   /* if arguments are passed, then process them                     */
   /* ================================================================= */

   if (argc > 1)
   {
      if( !strncmp( "/n=", argv[1], strlen("/n=")))
      {
         gs_COChannel = atoi( argv[1] + strlen("/n=") );
         argoff = 1; // what was argv[1] is now argv[2], etc...
         argc--;     // Adjust for tests to follow.
      }
      else
      {
         gs_COChannel = -1;
         argoff = 0;
      }
      strcpy(Tx_Infile_Name, argv[argoff+1]);
      strcpy(Tx_Outfile_Name, argv[argoff+2]);
      strcpy(Rx_Infile_Name, argv[argoff+3]);
      strcpy(Rx_Outfile_Name, argv[argoff+4]);
   }


   if (argc < 5)
   {
      fprintf(stderr, "command line args:\n");
      fprintf(stderr, "main TxInfile TxOutFile RxInFile ");
      fprintf(stderr, "RxOutFile gca_InitialState [TX_Config_Num RX_Config_Num]\n");
      return((int16)FAIL);
   }

   /*  if extra command line arg(s) is present, get config number (defaults to 0) */
   if (argc >= 7)
    {
      TESTArray[TEST_TxConfigNum] = (int16) atoi(argv[argoff+6]);
      if (TESTArray[TEST_TxConfigNum] >= NUM_CONFIG_SETS)
        {
         fprintf(stderr, "TX configuration number is too high\n");
         return((int16)FAIL);;
      }
   }

   if (argc >= 8)
    {
      TESTArray[TEST_RxConfigNum] = (int16) atoi(argv[argoff+7]);
      if (TESTArray[TEST_RxConfigNum] >= NUM_CONFIG_SETS)
        {
         fprintf(stderr, "RX configuration number is too high\n");
         return((int16)FAIL);
      }
   }

   if (argc == 9)
      strcpy(Taps_Infile_Name, argv[argoff+8]);
   else
      strcpy(Taps_Infile_Name, "");

   if (argc == 5)
   {
      fprintf(stderr, "********************************\n\n");
      fprintf(stderr, "Cannot open MP parameter file.\n");
      fprintf(stderr, "Assuming WINHOST control.\n\n");
      fprintf(stderr, "********************************\n\n");
      gs_MpFileControl = 0;

   }
   else if( (Mp_infid = fopen(SetInputDir(argv[argoff+5]), "rt") ) == NULL)
   {
      fprintf(stderr, "********************************\n\n");
      fprintf(stderr, "Cannot open MP parameter file.\n");
      fprintf(stderr, "Assuming WINHOST control.\n\n");
      fprintf(stderr, "********************************\n\n");
      gs_MpFileControl = 0;

   }

   return((int16)SUCCEED);

}

/*****************************************************************************
;  Prototype: void Close_MP(void)
;
;  This subroutine closes the MP input file
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;     Mp_infid    -- (I) MP input file pointer
;****************************************************************************/
void Close_MP(void)
{
    /* close MP command file */
    if (Mp_infid)
      fclose(Mp_infid);
}


/*****************************************************************************
;  Prototype: int16 Mphandler(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;       SUCCEED/FAIL
;
;  Global Variables:

;****************************************************************************/

int16 Mphandler(void)
{

    char uca_temp1[20], uca_temp2[20];
   int32 l_temp3, l_temp4, l_temp5;
   int16 s_temp3, s_temp4, s_temp5;
   int16 *tmpptr;
   int8 ca_junk[300];

   if (fscanf(Mp_infid, "%s %s %d %d %x", uca_temp1, uca_temp2, &l_temp3, &l_temp4, &l_temp5) > 0)
    {
      fscanf(Mp_infid,"%[^\n]",ca_junk); // ignore comments
      s_temp3 = (int16) l_temp3;
      s_temp4 = (int16) l_temp4;
      s_temp5 = (int16) l_temp5;

      if ( !( strcmp(uca_temp2, "OPTN") ) )
      {
         OPTNArray[s_temp3] = s_temp5;
         return((int16)SUCCEED);
      }
      else if ( !( strcmp(uca_temp2, "CNTL") ) )
      {
         CNTLArray[s_temp3] = s_temp5;
         gs_ModemOperationRequired = TRUE;
         return((int16)SUCCEED);
      }
      else if ( !( strcmp(uca_temp2, "TEST") ) )
      {
         TESTArray[s_temp3] = s_temp5;
         return((int16)SUCCEED);
      }
      else if ( !( strcmp(uca_temp2, "INFO") ) )
      {
         if ( !( strcmp(uca_temp1, "CW") ) )
         {
            tmpptr = INFOMap[s_temp3];
            tmpptr = tmpptr + s_temp4;
            (*tmpptr) = s_temp5;
         }
         return((int16)SUCCEED);
      }
      else if ( !( strcmp(uca_temp2, "CNFG") ) )
      {
         if ( !( strcmp(uca_temp1, "CW") ) )
         {
            tmpptr = CNFGMap[s_temp3];
            tmpptr = tmpptr + s_temp4;
            (*tmpptr) = s_temp5;
         }
         return((int16)SUCCEED);
      }
   }
   return((int16)FAIL);

}


/*****************************************************************************
;  Prototype: char * SetInputDir(char * input_string)
;
;     If this function finds an INPUTDIR environment variable,
;     it will return a combination of the INPUTDIR and the
;     input_string.  Otherwise, this function will return an
;     unchanged input_string.
;
;  Input Arguments:
;
;     char * input_string - usually an input filename
;
;  Output Arguments:
;
;     char * - always expected to be a valid char *
;
;  Return:
;
;     Will return either the original character pointer, or a
;     newly formed one.  This function is never expected to
;     return NULL.
;
;  Global Variables:
;
;  Environment Variables:
;
;     INPUTDIR - as input
;
;****************************************************************************/
char * SetInputDir(char * input_string)
{

    char * input_dir;
    char * file_path;
    unsigned int len_input_dir = 0;

    /* Get the INPUTDIR environment variable */
    input_dir = getenv ("INPUTDIR");

    if( input_dir != NULL ) {
        /* Strip any spaces off the end of input_dir */
        len_input_dir = strlen(input_dir);
      while ((len_input_dir > 0) &&
         (input_dir[len_input_dir-1] == ' ')) {
             input_dir[(len_input_dir--)-1] = '\0';
      };

        if (len_input_dir > 0) {
            /* Allocate enough space for both strings, a slash, and a null char */
            file_path = (char *) malloc (len_input_dir + strlen (input_string) + 2);
            strcpy(file_path, input_dir);
            /* Add a slash between, if needed */
            if ((input_dir[len_input_dir-1] != '\\') &&
                (input_dir[len_input_dir-1] != '/'))
                strcat(file_path, "\\");
            strcat(file_path, input_string);
            return(file_path);
        };
    };

    /* Return input_string if there is no input directory */
    /* environment variable or if it is empty.            */
    return (input_string);
};

/*****************************************************************************
;  Prototype: int16 AttachDLL()
;
;     This function load the DLL library and initiate function pointers to
;   the functions defined in the DLL library:
;     InitiateDLIProcess()
;     InitRxADCBufferPtrs()
;     DliHandler()
;     ExitRequest()
;     ReleaseEventHandlers();
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;  Return:
;       SUCCEED/FAIL
;
;  Global Variables:
;
;****************************************************************************/


int InitiateDLIProcessLocal( char *pca_ModemName, int16 s_TxFftLength,
                       int16 s_RxFftLength, FlagT ft_delayedstart, int16 s_delaycount)
{

   return( InitiateDLIProcessM( gs_COChannel, pca_ModemName, s_TxFftLength,
               s_RxFftLength, ft_delayedstart, s_delaycount));
}
void InitRxADCBufferPtrsLocal( int16 *ps_getptr, int16 *ps_putptr, int16 s_size,
                         int16 *psa_Buf, int16 *ps_blocksize)
{
      InitRxADCBufferPtrsM(gs_COChannel, ps_getptr, ps_putptr, s_size,
               psa_Buf, ps_blocksize);
}
int DliHandlerLocal( int16 *ps_TxOutBuf, int16 s_TxDtoABuf_Size, int16 s_Tx_OutBuf_Size,
               FlagT *pft_ResetDMAPtr)
{
   return( DliHandlerM( gs_COChannel, ps_TxOutBuf, s_TxDtoABuf_Size, s_Tx_OutBuf_Size,
         pft_ResetDMAPtr));
}

void ExitRequestLocal(void )
{
   ExitRequestM(gs_COChannel);
}
void ReleaseEventHandlersLocal(void)
{
   ReleaseEventHandlersM(gs_COChannel);
}

/*
** AttachDLL() tries to load the DLI DLL and used GetProcAddress to load pointers to the DLL's function
** entry points.
** The old DLL had entry points like InitiateDLIProcess. The new DLL has these, as well as the multi-port
** version InitiateDLIProcess_M. This load routine checks for the multiport version first. If the multiport
** entry point exists, AND the command line contained a CO Channel specifier (/n=1, i.e.), then a pointer
** to the multiport entry point is stashed. Otherwise, the single-port entry point is checked, and loaded.
**
** Caveat programmer: The bulk of the code always used the pointer to the
** single-port entry point to call the function. To simplify changes, in the multi-port case, that pointer
** is redirected to a local function, which in turn calls the multi-port entry point along with the CO Channel
** number. Yeah, it can be a little daunting, but the internal code is simpler because of it.
**
**
*/
int16 AttachDLL()
{
    char DllName[MAX_PATH];

   if(((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0) &&
      ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) != 0))
   {  // Sample-based DLI
      inf_dll = LoadLibrary(TEXT("inf_dli.dll"));
      fnInitDLI    = (initDLI_t)    GetProcAddress((HMODULE)inf_dll,"initDLI");
      fnProcessDLI = (processDLI_t) GetProcAddress((HMODULE)inf_dll,"processDLI");
      fnReleaseDLI = (releaseDLI_t) GetProcAddress((HMODULE)inf_dll,"releaseDLI");
#ifdef ISDN
      fnInitDLI(cpe, gs_RxFftLength >> 4, 8, "dli");
#else
      if(OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_2_AB)
         fnInitDLI(cpe, 16, 4, "dli");
      else
         fnInitDLI(cpe, gs_RxFftLength >> 4, 4, "dli");
#endif
   }

   if(((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0) &&
      ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0))
   {
      strcpy(DllName, "dli.dll");
      Dll = LoadLibrary(DllName);

      if( !Dll )
      {
         FreeLibrary(Dll);
         fprintf(stderr,"LoadLibrary %s failed\n",DllName);
         return FAIL;
      }
      else
      {
         if ((-1 != gs_COChannel) && (InitiateDLIProcessM  = (InitiateDLIProcess_M_f)(GetProcAddress( Dll, "InitiateDLIProcess_M"))))
         {
            InitiateDLIProcess = (InitiateDLIProcess_f)&InitiateDLIProcessLocal;
         }
         else
         {
            InitiateDLIProcessM = NULL;
            InitiateDLIProcess = (InitiateDLIProcess_f)GetProcAddress(Dll, "InitiateDLIProcess");
            if (!InitiateDLIProcess)
            {
               FreeLibrary(Dll);
               fprintf(stderr,"GetProcAddress() failed for InitiateDLIProcess\n");
               return FAIL;
            }
         }

         if((-1 != gs_COChannel) && (InitRxADCBufferPtrsM = (InitRxADCBufferPtrs_M_f)(GetProcAddress( Dll, "InitRxADCBufferPtrs_M"))))
         {
            InitRxADCBufferPtrs = (InitRxADCBufferPtrs_f)&InitRxADCBufferPtrsLocal;
         }
         else
         {
            InitRxADCBufferPtrsM = NULL;
            InitRxADCBufferPtrs = (InitRxADCBufferPtrs_f)GetProcAddress(Dll, "InitRxADCBufferPtrs");
            if (!InitRxADCBufferPtrs)
            {
               FreeLibrary(Dll);
               fprintf(stderr,"GetProcAddress() failed for InitRxADCBufferPtrs\n");
               return FAIL;
            }
         }

         if((-1 != gs_COChannel) && (DliHandlerM = (DliHandler_M_f)(GetProcAddress( Dll, "DliHandler_M"))))
         {
            DliHandler = (DliHandler_f)&DliHandlerLocal;
         }
         else
         {
            DliHandlerM = NULL;
            DliHandler = (DliHandler_f)GetProcAddress(Dll, "DliHandler");
            if (!DliHandler)
            {
               FreeLibrary(Dll);
               fprintf(stderr,"GetProcAddress() failed for DliHandler\n");
               return FAIL;
            }
         }

         if((-1 != gs_COChannel) && (ExitRequestM = (ExitRequest_M_f)(GetProcAddress(Dll, "ExitRequest_M"))))
         {
            ExitRequest = (ExitRequest_f)&ExitRequestLocal;
         }
         else
         {
            ExitRequestM = NULL;
            ExitRequest = (ExitRequest_f)GetProcAddress(Dll, "ExitRequest");
            if (!ExitRequest)
            {
               FreeLibrary(Dll);
               fprintf(stderr,"GetProcAddress() failed for ExitRequest\n");
               return FAIL;
            }
         }

         if((-1 != gs_COChannel) && (ReleaseEventHandlersM = (ReleaseEventHandlers_M_f)(GetProcAddress( Dll, "ReleaseEventHandlers_M"))))
         {
            ReleaseEventHandlers = (ReleaseEventHandlers_f)ReleaseEventHandlersLocal;
         }
         else
         {
            ReleaseEventHandlersM = NULL;
            ReleaseEventHandlers = (ReleaseEventHandlers_f)GetProcAddress(Dll, "ReleaseEventHandlers");
            if (!ReleaseEventHandlers)
            {
               FreeLibrary(Dll);
               fprintf(stderr,"GetProcAddress() failed for ReleaseEventHandlers\n");
               return FAIL;
            }
         }
      }
   }
    return SUCCEED;
}
/*****************************************************************************
;
;  Prototype: void ReleaseDLL(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

void ReleaseDLL(void)
{
    FreeLibrary(Dll);
}

/*******************************************************************************
*
*  Prototype: int16 AttachMPDLL(void)
*
*  This function loads the MP-DLI library and initiates function pointers to
*   the functions defined in old & New MP connectivity.
*
*  WriteMPtoModem()     WriteNewMPtoModem()        SelectNewMPPort()
*  ReadMPtoModem()         ReadNewMPtoModem()
*  WriteModemtoMP()     WriteModemtoNewMP()
*  ReadModemtoMP()         ReadModemtoNewMP()
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*     SUCCEED/FAIL
*
*  Global Variables:
*
*******************************************************************************/

int16 AttachMPDLL(void)
{
   char DllName[MAX_PATH];

   // Load libraray. Look for 3 locations


   strcpy(DllName, "mpdli.dll");
   MPDll = LoadLibrary(DllName);

   if (!MPDll) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: LoadLibrary %s failed.\n",DllName);
      return (int16)FAIL;
   }

   // Old MP functions

   WriteMPtoModem = (WriteMPtoModem_f)GetProcAddress(MPDll,"WriteMPtoModem");
   if (!WriteMPtoModem) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for WriteMPtoModem.\n");
      return (int16)FAIL;
   }
   ReadMPtoModem = (ReadMPtoModem_f)GetProcAddress(MPDll,"ReadMPtoModem");
   if (!ReadMPtoModem) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for ReadMPtoModem.\n");
      return (int16)FAIL;
   }
   WriteModemtoMP = (WriteModemtoMP_f)GetProcAddress(MPDll,"WriteModemtoMP");
   if (!WriteModemtoMP) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for WriteModemtoMP.\n");
      return (int16)FAIL;
   }
   ReadModemtoMP = (ReadModemtoMP_f)GetProcAddress(MPDll,"ReadModemtoMP");
   if (!ReadModemtoMP) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for ReadModemtoMP.\n");
      return (int16)FAIL;
   }

   // New MP functions

   WriteNewMPtoModem = (WriteNewMPtoModem_f)GetProcAddress(MPDll,"WriteNewMPtoModem");
   if (!WriteNewMPtoModem) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for WriteNewMPtoModem.\n");
      return (int16)FAIL;
   }
   ReadNewMPtoModem = (ReadNewMPtoModem_f)GetProcAddress(MPDll,"ReadNewMPtoModem");
   if (!ReadNewMPtoModem) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for ReadNewMPtoModem.\n");
      return (int16)FAIL;
   }
   WriteModemtoNewMP = (WriteModemtoNewMP_f)GetProcAddress(MPDll,"WriteModemtoNewMP");
   if (!WriteModemtoNewMP) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for WriteModemtoNewMP.\n");
      return (int16)FAIL;
   }
   ReadModemtoNewMP = (ReadModemtoNewMP_f)GetProcAddress(MPDll,"ReadModemtoNewMP");
   if (!ReadModemtoNewMP) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAddress() failed for ReadModemtoNewMP.\n");
      return (int16)FAIL;
   }
   SelectNewMPPort = (SelectNewMPPort_f)GetProcAddress(MPDll,"SelectNewMPPort");
   if (!SelectNewMPPort) {
      FreeLibrary(MPDll);
      fprintf(stderr,"ERROR: GetProcAffress() failed for SelectNewMPPort.\n");
      return (int16)FAIL;
   }

   return (int16)SUCCEED;
}

/*****************************************************************************
;
;  Prototype: void ReleaseMPDLL(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

void ReleaseMPDLL(void)
{
    FreeLibrary(MPDll);
}

/*****************************************************************************
;  Prototype: int16 MPHandler_CONN()
;
;     This function configures the modem in reaction to a CONN(ECTIVITY) MP
;   command.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/

int16 MPHandler_CONN(void)
{
   int16 s_retcode;

   if ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0) // DLI or Sample-based DLI
      s_retcode = Initialize_DLI_Connectivity();
   else
      s_retcode = Initialize_Sachmo_Connectivity();

   return(s_retcode);
}

/*****************************************************************************
;  Prototype: int16 Initialize_DLI_Connectivity()
;
;     This function performs initialization for DLI-based connectivity.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/
int16 Initialize_DLI_Connectivity(void)
{
   int16 s_scale;

   if(AttachDLL() == FAIL)
      exit(-1);

   /*==============================================================*/
   /* Synchronize CO and CPE threads and open shared memory        */
   /*==============================================================*/

   fprintf(stderr, "----- CPE Modem Starts -------\n");


   /* Init AtoD buffer pointers */
   InitAtoDBufPointers();

   /* ====================================================== */
   /* (In order to perform EC properly, we always read in    */
   /*  gs_Tx_OutBuf_Size*gs_DECUpsamplingFactor RX samples   */
   /* =======================================================*/
   gs_AtoDBuf_Size = (int16)(gs_Tx_OutBuf_Size*gs_RxFftLength/gs_TxFftLength);

   /* Set DLI Tx FFT length */
   if (OPTNArray[OPTN_ModeControl] & (OPTN_ConfigMode_G992_1_B | OPTN_ConfigMode_G992_3_B)) {
      gs_DLI_TxFftLength = 128;
   }
   else {

      gs_DLI_TxFftLength = 64;

   }
   if(((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0) &&
      ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0))
   {
      InitRxADCBufferPtrs(&gs_AtoD_GetPtr, &gs_AtoD_PutPtr, RX_ADCBUF_SIZE,
         gsa_RxAtoDBuf, &gs_AtoDBuf_Size);
   }

#ifdef DANUBE
   s_scale = 0 ; // for both plus/dmt can be 1 only if using 1024 pt fft for dmt.
#else
   if (TESTArray[TEST_Control] & TEST_UpsampleControl)
      s_scale = 1;
   else
      s_scale = 0;
#endif

   if(((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0) &&
      ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0))
   {


      if(!InitiateDLIProcess("CPE", gs_DLI_TxFftLength, (int16) (gs_RxFftLength >> s_scale),
         (FlagT)(TESTArray[TEST_InitState] == TEST_ShowtimeInitState),
         gs_TxOutSymbolCount))
      {
         return((int16) FAIL);
      }

   }
   return((int16)SUCCEED);
}

/*****************************************************************************
;  Prototype: int16 Initialize_Sachmo_Connectivity()
;
;     This function performs initialization for Sachmo-based connectivity.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/
int16 Initialize_Sachmo_Connectivity(void)
{
   int16 s_retcode;
   uint8 uc_ModemType, *puca_ModemName, uc_ChannelState;

   uc_ModemType = SAC_TYPE_RT;
   puca_ModemName = "RT";


   s_retcode = (int16) SACHMO_RegisterWithChannel(uc_ModemType);
   if (s_retcode != SAC_RETCODE_SUCCESS){
      fprintf(stderr,"\nError registering %s with Sachmo Channel\n", puca_ModemName);
      return((int16) FAIL);
   }

   fprintf(stderr,"\n --- %s Registered Successfully with Sachmo Channel ---\n", puca_ModemName);

   SACHMO_Ready();

   fprintf(stderr,"\n --- Waiting for channel to be ready ---\n");

   uc_ChannelState=SAC_CHANSTATE_NOTREADY;
    while ((uc_ChannelState!=SAC_CHANSTATE_READY))
                  s_retcode = SACHMO_GetChannelState(&uc_ChannelState);

   fprintf(stderr, "--- Channel is ready.  Both modems are ready. ---\n\n");


   return((int16) SUCCEED);
}
/*****************************************************************************
;  Prototype: int16 MPHandler_TCM()
;
;     This function configures the modem in reaction to a TCM MP
;   command.
;
;  Input Arguments:
;
;        char *setting   -- Currently one of ON/OFF
;
;  Output Arguments:
;
;  Return:
;           Should return FAIL if an unsupported mode is selected.
;
;  Global Variables:
;****************************************************************************/

int16 MPHandler_TCM(void)
{
    int16 i;

   gt_RMsgs1.us_TrellisCoding_Option = TRUE;

    for(i=0; i<4; i++)
      gt_config_set[i].psa_BAT = guca_DS_BAT68_TCM_ON;

    for(i=4; i<12; i++)
      gt_config_set[i].psa_BAT = guca_US_BAT23_TCM_ON;

   gt_config_set[12].psa_BAT = guca_DS_BAT68_TCM_ON;
   gt_config_set[13].psa_BAT = guca_US_BAT23_TCM_ON;
   gt_config_set[14].psa_BAT = guca_US_BAT23_TCM_ON;

    gt_config_set[15].psa_BAT = guca_DS_BAT68_TCM_ON;
   gt_config_set[16].psa_BAT = guca_DS_BAT68_TCM_ON;

    for(i=17; i<21; i++)
      gt_config_set[i].psa_BAT = guca_US_BAT23_TCM_ON;

   if(gft_ModemType == G_DMT_BIS)
   {
      gft_TcmFlag_bis_DS = TRUE;
   }
   else
   {
      gft_TcmFlag = TRUE;
   }


    return((int16)SUCCEED);
}

/*****************************************************************************
;  Prototype: void MPHandler_ModemType()
;
;  selects either G.dmt or G.dmt.bis mode
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;****************************************************************************/
void MPHandler_ModemType(void)
{
   if (OPTNArray[OPTN_ModeControl] & STAT_ConfigMode_ADSL2_ALL) // Bis or plus bit is set
   {
      gft_ModemType = G_DMT_BIS;

        if((OPTNArray[OPTN_AlgControl] & OPTN_MedleyControlMask) != 0) // MedleyTdqOff, MultiTdq, MultiSync or MedleyFdq is on
          gt_RMsgs1_bis.uc_CA_MEDLEYds = guc_R_C_MEDLEY_LENGTH_DIV_512;    // Regular length
      else
          gt_RMsgs1_bis.uc_CA_MEDLEYds = guc_R_C_MEDLEY_LENGTH_DIV_512_DEBUG; // short length

      if ((OPTNArray[OPTN_ModeControl] & STAT_ConfigMode_G992_5_ALL) != 0)
      {
         if ((OPTNArray[OPTN_StateMachineCtrl] & OPTN_G992_5_14thOrderPRBS_Enable) )
            gt_RMsgFmt_bis.uc_MedleyPRBSus = 1; //gt_RMsgs1_bis.uc_MedleyPRBSus =   1;          /* use 14th order medley sequence */
         else
            gt_RMsgFmt_bis.uc_MedleyPRBSus = 0;          /* default use dmt medley sequence */
      }

   }
   else
      gft_ModemType = G_DMT;
}



#endif
