/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995-2003 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       40, Middlesex Turnpike , Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       nmp.c
*
*       ADSL Configuration and Management protocol using the New CMV format
*
*-------------------------------------------------------------------
*/

#ifndef NMP_C
#define NMP_C

#define IN_NMP_C

/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include "gdata.h"
#include "nmp.h"
#include "nmp_plfm.h"
#include "cmv.h"
#include <stdio.h>
#include <stdlib.h>


/*******************************************************************
*
*       Define Variables
*
*******************************************************************/

/* =============================================== */
/* MP Message Structure                      */
/* =============================================== */
/*
**
**              typedef struct {
**                 int16 FunctionOpcode;
**                 int16 PayloadSize;
**                 int16 GroupField;
**                 int16 AddrField;
**                 int16 IndexField;
**                 int16 PayLoad[12];
**             } MPStruct;
**
**
*/

NewMPStruct NewMPRxBuffer;             /* Highest Level RX buffer */
NewMPStruct NewMPTxBuffer;             /* Highest Level TX buffer */
#ifndef HERC_API
int16 NEW_CMV_Dictionary[NEW_DICT_SIZE_SOC] =
{// Groupfield  AddrRange               OffsetRange BlockType       ReadWriteAccess
   CNTLGroup,  0, CNTLARRAY_SIZE-1, 0, 0,    NewCNTLType,   WRITE_ACCESS,
   STATGroup,  0, STATARRAY_SIZE-1, 0, 0,    NewSTATType,   READ_ACCESS,
   iNFOGroup,  0, INFOMAP_SIZE-1,      0, 0x7fff,  NewINFOType,   READ_WRITE_ACCESS,
   TESTGroup,  0, TESTARRAY_SIZE-1, 0, 0,    NewTESTType,   READ_WRITE_ACCESS,
   OPTNGroup,  0, OPTNARRAY_SIZE-1, 0, 0,    NewOPTNType,   READ_WRITE_ACCESS,
   RATEGroup,  0, RATEMAP_SIZE-1,      0, 0x7fff,  NewRATEType,   READ_ACCESS,
   PLAMGroup,  0, PLAMMAP_SIZE-1,      0, 0x7fff,  NewPLAMType,   READ_WRITE_ACCESS,
   CNFGGroup,  0, CNFGMAP_SIZE-1,      0, 0x7fff,  NewCNFGType,   READ_WRITE_ACCESS
};
#else
//  Hercules CMV's ALGS, DBUG, ACFG & AOPT have not been implemented
//  in the StratiPHY code base yet.  These are currently just placeholders.
int16 NEW_CMV_Dictionary[NEW_DICT_SIZE_HERC] =
{// Groupfield  AddrRange               OffsetRange BlockType       ReadWriteAccess
   CNTLGroup,  0, CNTLARRAY_SIZE-1, 0, 0,    NewCNTLType,   WRITE_ACCESS,
   STATGroup,  0, STATMAP_SIZE-1,      0, 0x7fff,  NewSTATType_HERC, READ_ACCESS,
   iNFOGroup,  0, INFOMAP_SIZE-1,      0, 0x7fff,  NewINFOType_HERC, READ_WRITE_ACCESS,
   TESTGroup,  0, TESTARRAY_SIZE-1, 0, 0,    NewTESTType_HERC, READ_WRITE_ACCESS,
   OPTNGroup,  0, OPTNMAP_SIZE-1,      0, 0x7fff,  NewOPTNType_HERC, READ_WRITE_ACCESS,
   RATEGroup,  0, RATEMAP_SIZE-1,      0, 0x7fff,  NewRATEType_HERC, READ_ACCESS,
   PLAMGroup,  0, PLAMMAP_SIZE-1,      0, 0x7fff,  NewPLAMType_HERC, READ_WRITE_ACCESS,
   CNFGGroup,  0, CNFGMAP_SIZE-1,      0, 0x7fff,  NewCNFGType_HERC, READ_WRITE_ACCESS,
    MONIGroup, 0, MONIMAP_SIZE-1,      0, 0x7fff,  NewMONIType,   READ_WRITE_ACCESS,
   CNTRGroup,  0, CNTRMAP_SIZE-1,      0, 0x7fff,  NewCNTRType,   READ_WRITE_ACCESS,
    ALGSGroup, 0, ALGSMAP_SIZE-1,      0, 0x7fff,  NewALGSType,   READ_ACCESS,
   DBUGGroup,  0, DBUGMAP_SIZE-1,      0, 0x7fff,  NewDBUGType,   READ_ACCESS,
    ACFGGroup, 0, ACFGMAP_SIZE-1,      0, 0x7fff,  NewACFGType,   READ_ACCESS,
   AINFGroup,  0, AINFMAP_SIZE-1,      0, 0x7fff,  NewAINFType,   READ_ACCESS,
    AOPTGroup, 0, AOPTMAP_SIZE-1,      0, 0x7fff,  NewAOPTType,   READ_ACCESS
};
#endif

int16 *NewBlockNameArrayPtr;

#ifndef HERC_API

int16 *NewCMVBlockNamePtr[] =
{
   // Note the pointers for the indirect CMV groups
   // are really type (int16 **) rather than (int16 *).
   &CNTLArray[0],
   &STATArray[0],
   (int16 *) &INFOMap[0],
   &TESTArray[0],
   &OPTNArray[0],
   (int16 *) &RATEMap[0],
   (int16 *) &PLAMMap[0],
   (int16 *) &CNFGMap[0]
};
#else

int16 *NewCMVBlockNamePtr[] =
{
   // Note the pointers for the indirect CMV groups
   // are really type (int16 **) rather than (int16 *).
   &CNTLArray[0],
   (int16 *) &STAT_0_Map[0],
   (int16 *) &STAT_1_Map[0],
   (int16 *) &STAT_5_Map[0],
   &STATArray[0],

   (int16 *) &INFO_74_Map[0],
   (int16 *) &INFO_76_Map[0],
   (int16 *) &INFO_203_Map[0],
   (int16 *) &INFO_209_Map[0],
   (int16 *) &INFO_211_Map[0],
   (int16 *) &INFO_212_Map[0],
   (int16 *) &INFO_241_Map[0],
   (int16 *) &INFOMap[0],
   &TESTArray[0],

   (int16 *) &OPTN_0_Map[0],
   (int16 *) &OPTN_2_Map[0],
   &OPTNArray[0],

   (int16 *) &RATEMap[0],
   (int16 *) &PLAMMap[0],

   (int16 *) &CNFG_0_Map[0],
   (int16 *) &CNFG_1_Map[0],
   (int16 *) &CNFG_2_Map[0],
   (int16 *) &CNFG_3_Map[0],

   (int16 *) &CNFGMap[0],
    (int16 *) &MONIMap[0],
   (int16 *) &CNTRMap[0],
    (int16 *) &ALGSMap[0],
    (int16 *) &DBUGMap[0],
    (int16 *) &ACFGMap[0],
    (int16 *) &AINFMap[0],
    (int16 *) &AOPTMap[0]
};
#endif

int16 gs_ADSLPrevMsgPending, gs_VBMPrevMsgPending;


/*^^^
*-------------------------------------------------------------------
*
*       Prototype:
*     int16  NewDecodeCMVBlockName(int16 *, int16 *);
*
*       Abstract:
*     This function reads the message memory access address field,
*     decodes it into a CMV Block Name and Offset, determines if the
*     BlockName. Offset variable is read-only, write-only, or read/write, and
*     determines if the offset is within the allowable range for the Block Name.
*
*       Parameters:
*           int16 BlockNameType:           Function fills in the CMV block name.
*           int16 ReadWriteStatus:         Function fills in the Read/write access of BlockName.Offset.
*
*       Returns:
*           0 if no errors or Memory Access Error Message Subtype number.
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/

int16 NewDecodeCMVBlockName(int16 *BlockNameType, int16 *ReadWriteStatus)
{
   int16 DictIndex;
   int16 CMVGroupName,AddrField, OffsetField;
   int16 MemoryAccessErrorType;

   /* Assume message will be decoded successfully. */

   MemoryAccessErrorType = 0;

   CMVGroupName = NewMPRxArray[1] & 0x7F;

   /* Grab CMV Block Name Offset. */
   AddrField = NewMPRxArray[2];

   OffsetField = NewMPRxArray[3];

   /* Check the CMV "dictionary." */

   for (DictIndex = 0; DictIndex <= NEW_DICT_SIZE_SOC; DictIndex += NEW_DICT_ENTRY_LENGTH )
   {
      /* Compare CMV Block Name word 1 to entry in dictionary. */

      if (CMVGroupName != NEW_CMV_Dictionary[DictIndex])
      {
         MemoryAccessErrorType = UNKNOWN_ADDRESS;        /* Address MAY not be valid. */
         continue;                                       /* Continue search. */
      }

      /* Compare CMV Block Name word 2 to entry in dictionary. */

      if (AddrField < NEW_CMV_Dictionary[DictIndex + 1])
      {
         MemoryAccessErrorType = UNKNOWN_ADDRESS;        /* Address MAY not be valid. */
         continue;                                       /* Continue search. */
      }

      if (AddrField > NEW_CMV_Dictionary[DictIndex + 2])
      {
         MemoryAccessErrorType = UNKNOWN_ADDRESS;        /* Address MAY not be valid. */
         continue;                                       /* Continue search. */
      }

      if (OffsetField < NEW_CMV_Dictionary[DictIndex + 3])
      {
         MemoryAccessErrorType = UNKNOWN_ADDRESS;        /* Address MAY not be valid. */
         continue;                                       /* Continue search. */
      }

      if (OffsetField > NEW_CMV_Dictionary[DictIndex + 4])
      {
         MemoryAccessErrorType = UNKNOWN_ADDRESS;        /* Address MAY not be valid. */
         continue;                                       /* Continue search. */
      }

      /* Set candidate CMV Block Name type. */
      *BlockNameType = NEW_CMV_Dictionary[DictIndex + 5];

    /* CMV dictionary entry matches, set read/write status,
       clear error indicator, and stop search. */

      *ReadWriteStatus = NEW_CMV_Dictionary[DictIndex + 6];
      MemoryAccessErrorType = 0;

      break;
   }

   return(MemoryAccessErrorType);
}  /* DecodeCMVBlockName */



#endif
