/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             plam.c
 * DESCRIPTION:      Functions that simple counting functions used in PLAM
 *
 **********************************************************************/
 /***************************************************************************************/
 //plam.c
 //History
 ////16/07/2012 Anantha: Cleaned up unused LCD NCD related code
//             grep pattern XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Trigger
/***************************************************************************************/
#include "common.h"
#include "gdata.h"
#include "ib.h"
#include "plam.h"
#include "cmv.h"

#ifdef DO_PLAM

/***************************************************************************************
;  Subroutine Name: InitializeFailureCountPresent
;
;  Description:
;     This function resets the counter to prevent counter overflow
;
;  Prototype:
;     void InitializeFailureCountPresent(FailureCount_t FailureCount, int16 s_presentNumber)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/
C_SCOPE void InitializeFailureCountPresent(FailureCount_t *FailureCount, int16 s_presentNumber)
{
   if (FailureCount->s_present >= s_presentNumber)
      FailureCount->s_present = 0;
}

/***************************************************************************************
;  Subroutine Name: TerminateFailureBit
;
;  Description:
;     This function terminates the failue bit if 10s of no failure
;
;  Prototype:
;     void TerminateFailureBit(FailureCount_t FailureCount, int16 *pFailure, uint8 failureBit,
;           int16 s_terminateNumber)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/
C_SCOPE void TerminateFailureBit(FailureCount_t *FailureCount, int16 *pFailure, uint16 failureBit,
                  int16 s_terminateNumber)
{
   if (FailureCount->s_absent >= s_terminateNumber)
   {
      *pFailure &= (~failureBit); // terminate failure bit
      FailureCount->s_absent = 0; // reset to avoid counter overflow, failure bit remains 0
   }
}

/***************************************************************************************
;  Subroutine Name: UpdateFailureCounts
;
;  Description:
;    This function updates the failure count based on failure condition.
;    Used to monitor contiguous periods of the condition being present or not
;
;
;  Prototype:
;     void UpdateFailureCounts(uint8 cond, FailureCount_t * FailureCount)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/

C_SCOPE void UpdateFailureCounts(uint8 uc_cond, FailureCount_t *FailureCount)
{
   if (uc_cond == PRESENT)
   {
      FailureCount->s_present++;
      FailureCount->s_absent = 0;
   }
   else
   {
      FailureCount->s_absent++;
      FailureCount->s_present = 0;
   }
}


/***************************************************************************************
;  Subroutine Name: UpdateFailureCounts
;
;  Description:
;     Updates a counter based on whether failure condition is present or not
;     Set/reset FailureBit in *pFailure if counter reaches corresponding threshold
;     Used to monitor contiguous periods of the condition being present or not
;  Prototype:
;     void UpdateFailureInfo(uint8 uc_cond, FailureCount_t * FailureCount, int16 *pFailure,
;           uint8 uc_failureBit)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/
C_SCOPE void UpdateFailureInfo(uint8 uc_cond, FailureCount_t *FailureCount, int16 *pFailure,
         uint16 us_failureBit)
{
   int16 s_terminateNumber = NUM_SFRAMES_10SEC;
   int16 s_presentNumber = NUM_SFRAMES_2P5SEC;

   //XDSLRTFW-2050: Re-init for LCD is 15 Seconds
     if(us_failureBit == PLAM_LCD_BC0_FailureBit)
      s_presentNumber = NUM_SFRAMES_2P5SEC*6;

   UpdateFailureCounts(uc_cond, FailureCount);
   TerminateFailureBit(FailureCount, pFailure, us_failureBit, s_terminateNumber);

   if (FailureCount->s_present >= s_presentNumber)
   {
      if (us_failureBit == PLAM_LOS_FailureBit)
      {
         // report LOS failure to ME if the cmv is not set
         *pFailure |= us_failureBit; // set failure bit
      }
      else
      {
         *pFailure |= us_failureBit; // set failure bit
      }


      FailureCount->s_present = 0; // reset to avoid counter overflow, failure bit remains 1
   }
}
//XDSLRTFW-2443 / XDSLRTFW-2462
/***************************************************************************************
;  Subroutine Name: UpdateRxSnrBufGet
;
;  Description:
;     Updates SNR buffer for Info 85a and test param SNR based on train phase/ VN / without VN
;  Prototype:
;     void UpdateRxSnrBufGet(void)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/

void UpdateRxSnrBufGet(void )
{
   int16 *psa_RxSnrBuf;
   int16 i;
   uint8 uc_SNR_ReportedValue;

   if( //((STATArray[STAT_MacroState] ==STAT_ShowTimeTCSyncState)
       //    ||(STATArray[STAT_MacroState] == STAT_LoopDiagMode)) &&
          (gt_DS_RefVirtNoiseLevel_ADSL2.us_NumberOfTones > 0)
          && (gl_SelectedMode & (MODE_ADSL2))
      )
   {
      psa_RxSnrBuf = gpsa_RxSnrBufWoVN;
   }
   else
   {
      // Showtime
      if( STATArray[STAT_MacroState] ==STAT_ShowTimeTCSyncState)
      {
            psa_RxSnrBuf = gsa_RxShowtimeSnrBuf;
      }
      else     //Training phase
      {
         psa_RxSnrBuf = &gsa_MedleySnrBuf[0];
      }
   }

   for(i = 0; i < gs_RxNumTones; i++)
   {
      /* Convert SNR array in dB (Q8.8) to proper reperesentation of Test parameter format*/
      //snr(i)=round[2*(32+SNR_dB(i))], Range for SNR_dB is [-32dB, 95dB],
      //snr(i) range is [0, 254], 255 is special value, meaning out of range
      if (i < gs_RxFirstChannel || i > gs_RxLastChannel
             || psa_RxSnrBuf[i] < LOWEST_SNR_VALUE || psa_RxSnrBuf[i] > HIGHEST_SNR_VALUE)
      {
         guca_SNRBuf_NE[i] = OUT_OF_RANGE_SNR;
      }
      else
      {
         uc_SNR_ReportedValue = (uint8)(((psa_RxSnrBuf[i] + (32<<8)) + (1<<6))>> 7)&0xFF;
         guca_SNRBuf_NE[i] = uc_SNR_ReportedValue;
      }
   }

}

// XDSLRTFW-2443 / XDSLRTFW-2462

/***************************************************************************************
;  Subroutine Name: Map_BCLP_Failures_bis
;
;  Description:
;  This function is used to set the NCD/LCD PLAM indicator bits for LP0, LP1 based on
;  the values of the BC0, BC1 indicators and the BC to LP mapping.
;
;  Prototype:
;     void Map_BCLP_Failures_bis(int16 *pFailure)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/
#if 0
C_SCOPE void Map_BCLP_Failures_bis(int16 *pFailure)
{
   int16 s_Failure = *pFailure;
   int16 s_mask,s_shift;

   s_mask = 0x0050 << (guca_rxBCnToLPp[1]);

   s_shift = 5 - guca_rxBCnToLPp[1];
   s_Failure = ((s_Failure >> s_shift) & s_mask) | (s_Failure & (~s_mask)) | ((s_Failure >> 4) & 0x0050);

   *pFailure = s_Failure;

}
#endif
#endif /* DO_PLAM */
