/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             rx_plam.c
 * DESCRIPTION:      Functions that implement Rx PLAM
 *
 **********************************************************************/

/**********************************************************************/
// rx_plam.c
//
// History
//
// 09/01/2013 Ram: Moved counters related to US Tx ATM processing from rx_plam.c and named them appropriately.
//                 Variable 'gula_fe_tot_cell_cnt' was wrongly being used for US Tx Atm processing. It is being
//                 be used to capture FE counter values in func RxPlamProcessor_bis() (File: rx_plam_bis.c)
//                 Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
// ******************************************************************

#include "common.h"
#include "gdata.h"
#include "ib.h"
#include "cmv.h"
#include "plam.h"
#include "rx_plam.h"
#include "rx_ib.h"
#include "gdata_bis.h"

#ifdef DO_PLAM
/* needed outside: cmv.c */
/* counts of problems that lasted 1sec */
int16 gs_ecs_fe_cnt;
int16 gs_loss_fe_cnt;
int16 gs_es_fe_cnt;
int16 gs_ses_fe_cnt;
int16 gs_uasl_fe_cnt;

/* total counts of CRC, RS, HEC on far-end */
int16 gsa_febe_cnt[NUM_DATA_PATHS];
int16 gsa_ffec_cnt[NUM_DATA_PATHS];
uint32 gla_febe_cnt[NUM_DATA_PATHS];
uint32 gla_ffec_cnt[NUM_DATA_PATHS];


/* failure byte */
int16 gs_FarEndFailure;

/* total counts for ATM state machine */
uint32 gula_fhec_cnt[MAX_ATM_SIZE];
uint32 gula_fe_tot_hec_cnt[MAX_ATM_SIZE];
uint32 gula_fe_tot_cell_cnt[MAX_ATM_SIZE];
uint32 gula_fe_bit_error_cnt[MAX_ATM_SIZE];

//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
//These are counters for US Tx direction, Hence Moving them to tx_plam.c and
//will be naming them appropriately.
//uint32 gula_fe_idle_cell_cnt[MAX_ATM_SIZE];
//uint32 gula_fe_non_idle_cell_cnt[MAX_ATM_SIZE];
//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)

//===========================================================================
// [G997.1] 7.2.4.1.3 Near-end User total cell count (CU-P)
// The near-end User_total_cell_count performance parameter is a count of the
// total number of cells in the ATM Data Path delivered at the T-R (for ATU-R) interface.
uint32 gula_tot_cell_cnt[MAX_ATM_SIZE];
//===========================================================================

//===========================================================================
// [G997.1] 7.2.4.1.2 Near-end delineated total cell count (CD-P)
// The near-end delineated_total_cell_count performance parameter is a count of
// the total number of cells passed through the cell delineation and HEC function
// process operating on the ATM Data Path while in the SYNC state.
uint32 gula_tot_hec_cnt[MAX_ATM_SIZE];
//===========================================================================

//===========================================================================
// Counts the number of cells dropped due to: the Rx cell buffer being full only
uint32 gula_dropped_cell_fullbuffer_cnt[MAX_ATM_SIZE];
//===========================================================================

//===========================================================================
// [G997.1] 7.2.4.1.4 Near-end Idle Cell Bit Error Count (IBE-P)
// The near-end idle_bit_error_count performance parameter is a count of the number
// of bit errors in the idle cell payload received in the ATM Data Path at the near-end.
uint32 gula_bit_error_cnt[MAX_ATM_SIZE];
//===========================================================================

//===========================================================================
// Count of all idle cells with good HEC received while in the SYNC state. Includes both user
// cells (RXIDLEKEEP=1) and dropped cells (RXIDLEKEEP=0 or cell buffer full).
uint32 gula_idle_cell_cnt[MAX_ATM_SIZE];
//===========================================================================

//===========================================================================
// Counts the number of user non-idle cells forwarded to the ATM
// layer (i.e. written into the Rx cell buffer).
// This means while in the SYNC state (i.e. after cell delineation has been achieved),
// only non-idle cells with good HEC that are not dropped due to cell buffer full are counted.
uint32 gula_non_idle_cell_cnt[MAX_ATM_SIZE];
//===========================================================================

//===========================================================================
// Counts the number of cells dropped due to: 1) the Rx cell buffer being full,
// 2) HEC errors, or 3) idle cells dropped due to RXIDLEKEEP = 0.
uint32 gula_dropped_cell_cnt[MAX_ATM_SIZE];
//===========================================================================

/* needed only in this module */
int16 gs_fe_line_unavailable;
FailureCount_t gt_UaslFeFailureCount; /* not really a failure bit, but 1sec UASL intermediate */
/* counters to detect contiguous periods of failure-condition being present/absent */
FailureCount_t gt_NCDFfeFailureCount, gt_NCDIfeFailureCount;
FailureCount_t gt_LCDfeFailureCount[MAX_ATM_SIZE];
FailureCount_t gt_LOSfeFailureCount, gt_RDIfeFailureCount, gt_LPRfeFailureCount;

/***************************************************************************************
;  Subroutine Name: void RxPlamProcessor(void)
;
;  Description:
;     This function processes the far end Anomaly/IB information
;
;  Prototype:
;     void RxPlamProcessor(void)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/
void RxPlamProcessor(void)
{
   uint8 sesFlag;

   /* update for-all-time counters */
   gsa_febe_cnt[INTERLEAVE_DATA_PATH] = gt_RxIbData.s_febe_i_cnt;
   gsa_febe_cnt[FAST_DATA_PATH] = gt_RxIbData.s_febe_f_cnt;

   gsa_ffec_cnt[INTERLEAVE_DATA_PATH] = gt_RxIbData.s_ffec_i_cnt;
   gsa_ffec_cnt[FAST_DATA_PATH] = gt_RxIbData.s_ffec_f_cnt;

   gla_febe_cnt[INTERLEAVE_DATA_PATH] = gt_RxIbData.s_febe_i_cnt;
   gla_febe_cnt[FAST_DATA_PATH] = gt_RxIbData.s_febe_f_cnt;

   gla_ffec_cnt[INTERLEAVE_DATA_PATH] = gt_RxIbData.s_ffec_i_cnt;
   gla_ffec_cnt[FAST_DATA_PATH] = gt_RxIbData.s_ffec_f_cnt;

   gula_fhec_cnt[INTERLEAVE_DATA_PATH] = gt_RxIbData.s_fhec_i_cnt;
   gula_fhec_cnt[FAST_DATA_PATH] = gt_RxIbData.s_fhec_f_cnt;

   /* update 1sec counters if any of the 1sec flags are set */
   if (!(gl_rx_sframe_count % 59)) {
      if (gs_ffec_cnt > 0)
      {
         gs_ecs_fe_cnt++;
         gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_FECSecCnt++; // XDSLRTFW-1562
      }
      if(gs_los_fe_cnt >=1)
      {
         gs_loss_fe_cnt++;
         gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_LOSSCnt++; // XDSLRTFW-1562
      }
      if ((gs_febe_cnt > 0) || (gs_los_fe_cnt > 0) || (gs_rdi_cnt > 0) || (gs_lpr_fe_cnt > 0))
      {
         gs_es_fe_cnt++;
         gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_ESCnt++; // XDSLRTFW-1562
      }
      sesFlag = ((gs_febe_cnt >= 18) || (gs_los_fe_cnt > 0) || (gs_rdi_cnt > 0) || (gs_lpr_fe_cnt > 0));
      if (sesFlag)
      {
         gs_ses_fe_cnt++;
         gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_SESCnt++; // XDSLRTFW-1562
      }
      /* UASL is contiguous intervals of SES */
      if (gs_fe_line_unavailable == PRESENT)
      {
         gs_uasl_fe_cnt++;
         gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_UASLCnt++; // XDSLRTFW-1562
      }
      UpdateFailureCounts(sesFlag, &gt_UaslFeFailureCount);
      if (gt_UaslFeFailureCount.s_present == NUM_CONTIGUOUS_SES_FOR_UASL)
      {
         gs_fe_line_unavailable = PRESENT;
         gs_uasl_fe_cnt += NUM_CONTIGUOUS_SES_FOR_UASL; /* include these contiguous SES intervals */
         gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_UASLCnt += NUM_CONTIGUOUS_SES_FOR_UASL; // XDSLRTFW-1562
         gt_UaslFeFailureCount.s_present = 0;
      }
      if (gt_UaslFeFailureCount.s_absent == NUM_CONTIGUOUS_SES_FOR_UASL)
      {
         gs_fe_line_unavailable = TERMINATED;
         if (gs_uasl_fe_cnt >= NUM_CONTIGUOUS_SES_FOR_UASL)
         {
            gs_uasl_fe_cnt -= NUM_CONTIGUOUS_SES_FOR_UASL; /* exclude these contiguous absent SES intervals */
            gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_UASLCnt -= NUM_CONTIGUOUS_SES_FOR_UASL; // XDSLRTFW-1562
         }
         gt_UaslFeFailureCount.s_absent = 0;
      }
      /* reset 1sec-flags for next 1sec window */
      gs_ffec_cnt   = 0;
      gs_febe_cnt   = 0;
      gs_los_fe_cnt = 0;
      gs_lpr_fe_cnt = 0;
      gs_rdi_cnt    = 0;
   }

   /* update failures: present for 2.5sec, absent for 10sec */
   /* cell delineation failures */
   UpdateFailureInfo(gt_RxIbData.uc_fncd_f_anom, &gt_NCDFfeFailureCount, &gs_FarEndFailure,
               PLAM_NCD_LP1_FailureBit);
   UpdateFailureInfo(gt_RxIbData.uc_fncd_i_anom, &gt_NCDIfeFailureCount, &gs_FarEndFailure,
               PLAM_NCD_LP0_FailureBit);
   UpdateFailureInfo(gt_RxIbData.uc_flcd_f_def, &gt_LCDfeFailureCount[LP1_DATA_PATH], &gs_FarEndFailure,
               PLAM_LCD_LP1_FailureBit);
   UpdateFailureInfo(gt_RxIbData.uc_flcd_i_def, &gt_LCDfeFailureCount[LP0_DATA_PATH], &gs_FarEndFailure,
               PLAM_LCD_LP0_FailureBit);

   /* LOS and LOF (i.e. RDI) failure are linked */
   UpdateFailureCounts(gt_RxIbData.uc_flos, &gt_LOSfeFailureCount);
   UpdateFailureCounts(gt_RxIbData.uc_frdi, &gt_RDIfeFailureCount);
   if ((gt_LOSfeFailureCount.s_present == NUM_SFRAMES_2P5SEC) ||
      ((gt_RxIbData.uc_flos == PRESENT) && (gt_RDIfeFailureCount.s_present == NUM_SFRAMES_2P5SEC)))
      gs_FarEndFailure &= PLAM_LOS_FailureBit;
   if ((gt_RDIfeFailureCount.s_present == NUM_SFRAMES_2P5SEC) &&
      (gt_RxIbData.uc_flos != PRESENT) && (!(gs_FarEndFailure & PLAM_LOS_FailureBit)))
      gs_FarEndFailure &= PLAM_LOF_FailureBit;
   InitializeFailureCountPresent(&gt_LOSfeFailureCount, NUM_SFRAMES_2P5SEC);
   InitializeFailureCountPresent(&gt_RDIfeFailureCount, NUM_SFRAMES_2P5SEC);
   TerminateFailureBit(&gt_LOSfeFailureCount, &gs_FarEndFailure, PLAM_LOS_FailureBit, NUM_SFRAMES_10SEC);
   TerminateFailureBit(&gt_RDIfeFailureCount, &gs_FarEndFailure, PLAM_LOF_FailureBit, NUM_SFRAMES_10SEC);
   /* lpr failure */
   if (gft_response_to_powerdown) // use correct name?
   {
      gt_LPRfeFailureCount.s_present = 0; // g.dmt reads LPR primitive followed by ...
      gt_LPRfeFailureCount.s_absent  = 0;
      UpdateFailureInfo(gt_RxIbData.uc_flos, &gt_LPRfeFailureCount, &gs_FarEndFailure,
                  PLAM_LPR_FailureBit);
   }

}

#endif /* DO_PLAM */
