/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             Tx_plam.c
 * DESCRIPTION:      Functions that implement Tx PLAM
 *
 **********************************************************************/

/**********************************************************************/
// tx_plam.c
//
// History
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
//
// 10/08/2011 Vinjam: Added a new global structure for detecting "LOM" (Loss Of Margin) defect.
//                    Added code to declare "LOM" defect after 2.5 seconds.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
// 25/01/2012 Kannan: PLAM counters Eg:"guc_consecutive_sev_err_sec_cnt" is not being updated for every 1secs,
//                    since "gs_bitswap_tx_sframe_count"
//                    is being reset for every 256 super frames, reseting of this counter
//                    will have incorrect update of PLAM counter, i.e not updated for every 1 secs.
//                    For Eg: 0, 59, 118, 177, 236, (256==>0), 59, 118, etc
//                    Grep for BugFix_DS_ADSL1_ALL_SuddenRFI
//12/01/2012: Balabath: Added CMV to trigger LPR in idication.DSL 5 0 1 will trigger this.By default
//                      this bit is set to zero. if LPR is triggered by DSL 5 0 don't set "gs_lpr_detect"
//                      which will increment the error seconds.
//                Grep for XDSLRTFW-201 Feature_US_ALL_ALL_LPR
//
// 04/07/2012 Anantha: guca_DS_TransferMode_bis[0] was not initialized since ADSL1 only uses ATM mode
//                hence removing the condition check for triggering LCD and NCD failure
//                    Grep for XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 09/01/2013 Ram: Moved counters related to US Tx ATM processing from rx_plam.c and named them appropriately.
//                 Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
//
// 11/10/2013 Prashant: Modified the code for declaring LOM failure and triggering ReInit on LOM.
//                      LOM failure is declared after continious presence of LOM defect for 20 Sec.
//                      ReInit triggered after Programmable LOM_ReInit_Threshold i.e. DSL 30 1 (In Sec).
//                      LOM failure is cleared after 10 Sec. of absence of defect.
//                      (Refered MessageSpec VRX_FWMCAT_Rev2.3Internal.PDF)
//          Grep for XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit
//
// 09/02/2018  Abu Rahman
//             XDSLRTFW-3708:Control of GPIO14 to indicate dying gasp for ADSL
//
//             In case of Dying Gasp set VRX518 GPIO pin 14 from high to low.
//             This feature is CMV controlled
//             CMV CNFG 58 Bit 8 (LSB = Bit0) = 1 Enable this feature
//             CMV CNFG 58 Bit 8 (LSB = Bit0) = 0 Disable this feature (default configuration)
//             Preferable configuration method for Enabling this feature: "dmms 3A48 0 1 0100 0100" at "wait for link activation" state
//
//             To control GPIO 14 first below mentioned registers need to be programmed
//             Register GPIO PAD PORTMUXC14(VRX518 address 0x24038) = 0
//             Register GPIO_FUNC DIRSET_0(VRX518 address 0x20048) bit14 value = 1
//             Register GPIO_FUNC OUTSET_0(VRX518 address 0x20040) bit14 value = 1
//
//             After detecting Dying Gasp
//             Register GPIO_FUNC OUTCLR_0(VRX518 address 0x20044) bit14 value = 1 will set
//             GPIO pin 14 voltage level low.
//             Check Jira for more information about register spec
//
//             Note: BAR registers can access only up to 64k from it's base address so that special care needed
//             to be taken while using BAR register to access data.
//
//             Grep pattern:  XDSLRTFW-3708
// ******************************************************************



#include "common.h"
#include "gdata.h"
#include "ib.h"
#include "cmv.h"
#include "plam.h"
#include "tx_plam.h"
#include "const_bis.h"
#include "gdata_bis.h"
#include "dsp_regs_62.h"
#include "codeswap.h"
#ifdef DO_PLAM


/* Count of errors per second */
int16 gs_fec_ecs_cnt;
int16 gs_crc_cnt;
int16 gs_norm_crc_1sec;
int16 gs_los_cnt;
int16 gs_sef_cnt;
int16 gs_lpr_detect;

/* Count of contiguous seconds */
int16 gs_contiguous_bad_sec_cnt; /* Count of contiguous severely err sec */
int16 gs_contiguous_good_sec_cnt;  /* Count of contiguous good seconds */

/* Count of errored seconds */
int16 gs_fec_err_sec_cnt;
int16 gs_los_err_sec_cnt;
int16 gs_sef_err_sec_cnt;
int16 gs_err_sec_cnt;
int16 gs_sev_err_sec_cnt;
int16 gs_unavail_err_sec_cnt;
//Feature_ALL_ALL_FT_ReInit_Triggers (Start)
//SMS01501977 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (Start)
uint8 guc_consecutive_sev_err_sec_cnt;
uint8 guc_consecutive_err_sec_cnt;
FlagT gft_TriggerLOMReInit = FALSE;

//SMS01501977 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (End)
//Feature_ALL_ALL_FT_ReInit_Triggers (End)
FlagT gft_line_unavailable = FALSE;
int16 gs_NearEndFailure=0, gs_NearEndFailureReported;

FailureCount_t gt_LOSneFailureCount, gt_LOFneFailureCount;

//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
FailureCount_t gt_LOMneFailureCount;

FailureCount_t gt_NCD_LP0_neFailureCount,gt_NCD_LP1_neFailureCount;
FailureCount_t gt_LCD_LP0_neFailureCount,gt_LCD_LP1_neFailureCount;

//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
uint32 gula_tx_idle_cell_cnt[MAX_ATM_SIZE];
uint32 gula_tx_non_idle_cell_cnt[MAX_ATM_SIZE];
uint32 gula_tx_tot_cell_cnt[MAX_ATM_SIZE];
//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)

void Map_BCLP_Failures_dmt(int16 *pFailure);

/*****************************************************************************
;  Subroutine Name: void TxPlamProcessor(void)
;
;; Prototype:
;     void TxPlamProcessor(void)
;
;  Input Arguments:
;       none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
*******************************************************************************/
void TxPlamProcessor(void)
{

   int s_los_sef_lpr_tot;

    /* Sum LOS, SEF & LPR into a single variable to save program memory */
    s_los_sef_lpr_tot = gs_los_cnt + gs_sef_cnt + gs_lpr_detect;

   /*===========================================================================*/
   /*Update the various error counts during showtime to populate the PLAM cmv*/
   /*===========================================================================*/

   /*******   1-second counts **********/
   //BugFix_DS_ADSL1_ALL_SuddenRFI (START)
   gus_1sec_tx_sframe_count++; //increment count for every superframe
   //Update the PLAM counters exactly for every 1secs, tx bitswap superframe counter
   //should not be used here, since bitswap super frame counter get reset at every
   //256 super frames which will lead incorrect PLAM counter update, this will causes
   //for link drop in showtime while applying RFI.
   if (gus_1sec_tx_sframe_count == 59)
   {
      gus_1sec_tx_sframe_count = 0;
      //BugFix_DS_ADSL1_ALL_SuddenRFI (END)
      /* Compute FEC errored seconds */
      if (gs_fec_ecs_cnt >=1)
      {
         gs_fec_err_sec_cnt++;
         gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_FECSecCnt++; // XDSLRTFW-1562
      }

      /* Compute errored seconds */
      if(gs_crc_cnt > 0 || s_los_sef_lpr_tot > 0)
      {
         gs_err_sec_cnt++;
         gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_ESCnt++; // XDSLRTFW-1562
            //Feature_ALL_ALL_FT_ReInit_Triggers(Start)
            guc_consecutive_err_sec_cnt++; //SMS01501977 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (Start_End)
      }
      //Feature_ALL_ALL_FT_ReInit_Triggers(Start)
      //SMS01501977 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (Start)
      else
      {
         guc_consecutive_err_sec_cnt=0;
      }
      //SMS01501977 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (End)
      //Feature_ALL_ALL_FT_ReInit_Triggers(End)

      /* Compute LOS errored seconds */
      if(gs_los_cnt > 0)
      {
         gs_los_err_sec_cnt++;
         gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_LOSSCnt++; // XDSLRTFW-1562
      }

      /* Compute SEF errored seconds */
      if(gs_sef_cnt > 0)
      {
         gs_sef_err_sec_cnt++;
      }

      /* Compute the severely errored seconds */
      if(gs_crc_cnt >=18 || s_los_sef_lpr_tot > 0)
      {
         gs_contiguous_good_sec_cnt = 0;  /* Reset the contiguous good sec counter */
         gs_contiguous_bad_sec_cnt++;
         gs_sev_err_sec_cnt++;
         gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_SESCnt++; // XDSLRTFW-1562
         //Feature_ALL_ALL_FT_ReInit_Triggers(Start_End)
         guc_consecutive_sev_err_sec_cnt++; //SMS01501977 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (Start_End)

      }
      else
      {
         gs_contiguous_good_sec_cnt++;    /* Increment the contiguous good sec counter */
         gs_contiguous_bad_sec_cnt = 0;   /* Reset the contiguous sev errored sec count */
         //Feature_ALL_ALL_FT_ReInit_Triggers(Start_End)
         guc_consecutive_sev_err_sec_cnt=0; //SMS01501977 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (Start_End)
      }


      /* Compute the line unavailable seconds count */
      if(gft_line_unavailable == TRUE)
      {
         gs_unavail_err_sec_cnt++;
         gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_UASLCnt++; // XDSLRTFW-1562

      }

      /****************************/
      /* Reset the 1 second count */
      /****************************/

      gs_fec_ecs_cnt = 0;
      gs_crc_cnt = 0;
      gs_los_cnt = 0;
      gs_sef_cnt = 0;
      gs_lpr_detect = 0;

   }

   /************************/
   /* Near end LOS failure */
   /************************/
   UpdateFailureInfo(gt_TxIbData.uc_flos_def, &gt_LOSneFailureCount, &gs_NearEndFailure,
            PLAM_LOS_FailureBit);

   /************************/
   /* Near end LOF failure */
   /************************/

   UpdateFailureCounts(gt_TxIbData.uc_fsef_def, &gt_LOFneFailureCount);

   /* If no LOS defect/failure check for LOF failure */
   if ((gt_TxIbData.uc_flos_def != PRESENT) && ((gs_NearEndFailure & PLAM_LOS_FailureBit) == 0))
   {
      if (gt_LOFneFailureCount.s_present == NUM_SFRAMES_2P5SEC)
      {
         /* Update te PLAM CMV for LOF failure */
         gs_NearEndFailure |= PLAM_LOF_FailureBit;
      }
   }

    //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
   /************************/
   /* Near end LOM failure */
   /************************/
    gt_TxIbData.uc_flom_def = TERMINATED;
    if ((gt_NearEndParam.s_SnrMargin < 0) ||
        (((gs_RxMinRequestedSTMargin << 8) < gs_RxDesiredMargin) && (gt_NearEndParam.s_SnrMargin < (gs_RxMinRequestedSTMargin << 1))))
            // Retrain if margin is too low (note: gs_RxMinRequestedSTMargin: Q16.0; gs_RxDesiredMargin: Q8.8; gt_NearEndParam.s_SnrMargin: Q15.1)
    {
       gt_TxIbData.uc_flom_def = PRESENT;
    }
    UpdateFailureCounts(gt_TxIbData.uc_flom_def, &gt_LOMneFailureCount);

   // XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (StartEnd)
   if (gt_LOMneFailureCount.s_present == NUM_SFRAMES_20SEC)
      /* Update the PLAM CMV for LOM failure */
      gs_NearEndFailure |= PLAM_LOM_FailureBit;
    //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)

    // XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (Start)
   if(gt_ReInit_Threshold.s_LOM_ReInit_Threshold == 0)
       gt_ReInit_Threshold.s_LOM_ReInit_Threshold = 60;

   if (gt_LOMneFailureCount.s_present >= (NUM_SFRAMES_1SEC * gt_ReInit_Threshold.s_LOM_ReInit_Threshold))
      gft_TriggerLOMReInit = TRUE;
   else
        gft_TriggerLOMReInit = FALSE;
    // XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (End)


    //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)

    { //ATM Mode selected

         /***************/
         /* NCD Failure */
         /***************/

   UpdateFailureInfo(gt_TxIbData.uc_fncd_i_anom, &gt_NCD_LP0_neFailureCount, &gs_NearEndFailure,
                     PLAM_NCD_LP0_FailureBit);



   UpdateFailureInfo(gt_TxIbData.uc_fncd_f_anom, &gt_NCD_LP1_neFailureCount, &gs_NearEndFailure,
                     PLAM_NCD_LP1_FailureBit);

         /***************/
         /* LCD Failure */
         /***************/
   UpdateFailureInfo(gt_TxIbData.uc_flcd_i_def, &gt_LCD_LP0_neFailureCount, &gs_NearEndFailure,
                     PLAM_LCD_LP0_FailureBit);

   UpdateFailureInfo(gt_TxIbData.uc_flcd_f_def, &gt_LCD_LP1_neFailureCount, &gs_NearEndFailure,
                     PLAM_LCD_LP1_FailureBit);

    }
    //else
    //{ //PTM mode selected. PTM for DMT is not clear. According to SriRam, PTM code pointers are sent in G.Hs message only for Bis & Plus modes.
        //So, below code is commented out. This code is also not tested.
    //  //ReUsed "gt_LCD_BC0_neFailureCount" for "OOS defect" purpose
   //  UpdateFailureInfo(gt_tx_Anomaly.s_cd_flag[0], &gt_LCD_LP0_neFailureCount, &gs_NearEndFailure,
   //          PLAM_OOS_FailureBit);
    //}
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)
   /*******   10 second counts for reseting the failures **********/

   Map_BCLP_Failures_dmt(&gs_NearEndFailure);
   /* Clear the failure counts to prevent overflow */
   InitializeFailureCountPresent(&gt_LOFneFailureCount, NUM_SFRAMES_2P5SEC);

   /* Terminate the failure bit if no defect for 10 seconds */
   TerminateFailureBit(&gt_LOFneFailureCount, &gs_NearEndFailure, PLAM_LOF_FailureBit, NUM_SFRAMES_10SEC);

   // XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (Start)
   /* Terminate the failure bit if no defect for 10 seconds */
   TerminateFailureBit(&gt_LOMneFailureCount, &gs_NearEndFailure, PLAM_LOM_FailureBit, NUM_SFRAMES_10SEC);
   //XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (End)

   /************ Check for line availability *************/

   if((gs_contiguous_bad_sec_cnt == 10)  && (gft_line_unavailable == FALSE))
   {
      /* If 10 consecutive seconds bad */
      /* Increment the total unavailable seconds count */
      gs_unavail_err_sec_cnt += gs_contiguous_bad_sec_cnt;
      gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_UASLCnt += gs_contiguous_bad_sec_cnt; // XDSLRTFW-1562

      /* Set flag for line unavailability */
      gft_line_unavailable = 1;

      /* Reset the counter to prevent overflow */
      gs_contiguous_bad_sec_cnt = 0;

   }
   else
   {
      if(gft_line_unavailable == TRUE)
      {
         /* Check if line can be declared back available */
         if(gs_contiguous_good_sec_cnt == 10)
         {
            /* If contiguous 10 good seconds, line is available */
            gft_line_unavailable = FALSE;

            /* The 10 good seconds are excluded from the unavailable line seconds */
            gs_unavail_err_sec_cnt -= gs_contiguous_good_sec_cnt;
            gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_UASLCnt -= gs_contiguous_good_sec_cnt; // XDSLRTFW-1562

            /* Reset the counter to prevent overflow */
            gs_contiguous_good_sec_cnt = 0;
         }
      }

   }

   /******        Loss of Power     ********/

   if ((CNTLArray[CNTL_ModemDying] == CNTL_ModemSendDyingGasp) || gs_NE_LPR_indication)
   {
      gs_NearEndFailure |= PLAM_LPR_FailureBit;
      // XDSLRTFW-201 Feature_US_ALL_ALL_LPR(start)
      if (gus_Set_LPR & DSL_ModemSendDyingGasp) //Check only DSL 5 0 Bit-0
      {
         gs_lpr_detect = FALSE;  //Intentional so don't increment CRC counters
      }
      else
      // XDSLRTFW-201 Feature_US_ALL_ALL_LPR(end)
      gs_lpr_detect = TRUE;
      //XDSLRTFW-3708 Control of GPIO14 to indicate dying gasp for ADSL (Start)
   //This section is for GPIO14 control for DMT Dying Gasp
      if (gus_Cnfg_Misc & CNFG_MISC_VRX518_ENABLE_GPIO14_FOR_DYING_GASP)
      {
         volatile uint32 ul_RegAddress;
         uint32 ul_AddressPointedByBAR18;
         uint32 ul_data;

         // VRX518 CHIPID_EFUSE (relative) base address which is stored in first 20 bits of DSP_XMEM_BAR18
         // address location. 12 MS bits are used for PCIe_BaseAddress
         // all the address access via BAR18 register must be located within 64K byte address range from it's base address
         ul_AddressPointedByBAR18 = (*((volatile uint32 *)DSP_XMEM_BAR18)) & 0xFFFFF;

         // note1: memory locations below is located outside ARC memory region. According to coding guideline
         // these memory locations must be accessed via DMA!
         // This memory is needed to be accessed during Dying Gasp. Before power goes down a very small time
         // will be available so the this memory is accessed via direct access.
         // !! These memory access is an exception!!

         // Note2: address offset range is checked intentionally. If there is any problem in address offset renge
         // then it would be caught in InitVRX518Regs_for_Gpio14() function.


         // Set VRx518 GPIO14 pin voltage from high to low
         ul_RegAddress = (uint32)(&__StartOfSramBAR18) + (uint32)(VRX518_GPIO_FUNC_OUTCLR_0_ADDRESS - ul_AddressPointedByBAR18);
         ul_data = *(volatile uint32 *)ul_RegAddress;
         ul_data |= 0x4000; // set bit 14 to 1
         *(volatile uint32 *)ul_RegAddress = ul_data;
      }
      //XDSLRTFW-3708 Control of GPIO14 to indicate dying gasp for ADSL (End)
   }

}
/***************************************************************************************
;  Subroutine Name: Map_BCLP_Failures_dmt
;
;  Description:
;  This function is used to set the NCD/LCD PLAM indicator bits for BC0 based on
;  the values of the LP0, LP1 indicators and the BC to LP mapping.
;
;  Prototype:
;     void Map_BCLP_Failures_bis(int16 *pFailure)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/
void Map_BCLP_Failures_dmt(int16 *pFailure)
{
   int16 s_Failure = *pFailure;
   int16 s_mask,s_shift;

   s_mask = (0x0500);

   s_shift = 4 - (gt_RxShowTimeVars.t_BCParms[0].sa_BC_LPath);
   // Always set bit 9, NCD for BC1, since only BC0 is used.
   //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
   s_Failure = ((s_Failure << s_shift) & s_mask) | (s_Failure & (~s_mask));
   //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
   *pFailure = s_Failure;

}

#endif /* DO_PLAM */
