/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   AllocateDataBuffers_PreHndshk.c
;
;  Assigns pointers to various data buffers.
;
;****************************************************************************/
/**********************************************************************/
// AllocateDataBuffers_PreHndshk.c
//
// History
//
// 25/01/2012 Kannan: No of FDQ adaptation Channels increased from 32 to 48 for ADSL1 mode
//            to do the showtime SNR update faster, which will help to do the
//            bitswap faster while applying sudden RFI, comments added.
//       Grep BugFix_DS_ADSL1_ALL_SuddenRFI
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// ******************************************************************

#include "typedef.h"
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "cmv.h"
#include "ghs.h"
#include "hndshk_Data.h"
#include "data_alloc.h"
#include "tdq_init.h"
#include "fft_tab.h"
#include "dec_adap_data.h"
#include "exchdata.h"
#include "platform.h"
#include "ec_init.h"
#include "string.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#define PRINT_DATA_ALLOCATION
#ifdef PRINT_DATA_ALLOCATION
FILE *data_allocation_ptr;
#endif

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): Increase QLN points to 512
//extern uint8 guca_QLN[RX_NUM_TONES>>1];
extern uint8 guca_QLN[RX_NUM_TONES];
extern uint8 guca_hs_dummy[];
extern int16 gsa_EC_Train_Seq[];
extern int16 *usa_sym_taper_tail;
extern int32 gla_tmpBuf[];


//assign pointers in an incremental way
//The following local-variables are used.
//l_offset: always remember the previously allocated buffer size
//vp_start_addr: record the starting address of the previous buffer
#define INC_MALLOC(dest, ttype, ssize)                  \
    dest = ttype (vp_start_addr+l_offset);              \
    vp_start_addr = (uint8*)(dest);                     \
    l_offset = ssize;


/****************************************************************************
;  Prototype: void AllocateHSrelatedBuffers(void)
;
;   Simply a part of AllocateDataBuffers_PreHndshk() that was split out
;  because it was needed  by the TEST_HS_DECODE test.
;****************************************************************************/
void AllocateHSrelatedBuffers(void)
{
   uint8  i;

    uint8 *vp_start_addr;
    int32 l_offset;
/*------------------------------------------------------------------------------------------------------------------*/
/*             guca_HndshkBuf Allocation                                                        */
/*------------------------------------------------------------------------------------------------------------------*/

      //===============================
      // Part I. Allocate guca_HndshkBuf buffers
      //===============================
      // see gdata.c for the definition of guca_HndshkBuf

      //===============================
      // Part II. Assign pointers
      //===============================

      /********************************************************************************/
      /*                                                          */
      /* Handshake Buffer Allocation                                       */
      /*                                                          */
      /********************************************************************************/
      // Used throughout handshake, will be overwritten when handshake finishes
      // Altogether 2K bytes.
      // gpuca_RxMsgBuf: starting addresses of a 0.5KB buffer
      // gpuca_DecodeBuf:starting addresses of a 1KB buffer
      // gpuca_RxMsgBuf: starting addresses of a 0.5KB buffer
      gpuca_RxMsgBuf = guca_HndshkBuf;
      gpuca_DecodeBuf= gpuca_RxMsgBuf + MESSAGE_BUF_LEN;
      gpuca_TxMsgBuf = gpuca_DecodeBuf + DECODE_BUF_LEN;
      // Because gpuca_TxMsgBuf may overflow, don't allocate anything state-machine critical immediately after it !
      // We will fail gracefully if we detect overflow, as long as the subsequent memory locations are something
      //that doesn't involve the state machine or the g.hs state machine.  gpt_RxInfo/Save etc is a safe variable.

      // current InfoField_t is of size 308 bytes
      // current Adsl2AllInfo_t   is of size 204 bytes
      // Used throughout handshake, will be overwritten when handshake finishes
      // Update the addresses of *t_BisInfo for the above four variables
      gpt_RxInfo = (InfoField_t*)(void *)(gpuca_TxMsgBuf + MESSAGE_BUF_LEN);
      gpt_RxInfoSave = (InfoField_t*)(void *)((uint8*)gpt_RxInfo+sizeof(InfoField_t));
      gpt_TxInfo = (InfoField_t*)(void *)((uint8*)gpt_RxInfoSave+sizeof(InfoField_t));
      gpt_TxInfoSave = (InfoField_t*)(void *)((uint8*)gpt_TxInfo+sizeof(InfoField_t));

      /* For Tx information, we know how much size the Vendor info we need. So here
      we assume that we only need one block for TxInfo and TxInfoSave. For Rx, RxInfoSave,
      still keep the previous setting, 5 blocks, with each block (256-7)bytes.*/
      for (i = 0; i < MAX_NUM_NS_BLOCK; i++) {
         gpt_RxInfo->ta_NS_Info[i].puca_NSVendorSpec = (uint8*)((uint8*)gpt_TxInfoSave + sizeof(InfoField_t)
            + i*MAX_NS_VENDOR_INFO_LEN);

         gpt_RxInfoSave->ta_NS_Info[i].puca_NSVendorSpec = (uint8*)((uint8*)gpt_TxInfoSave + sizeof(InfoField_t)
            + (i+MAX_NUM_NS_BLOCK)*MAX_NS_VENDOR_INFO_LEN);

         gpt_TxInfo->ta_NS_Info[i].puca_NSVendorSpec = (uint8*)((uint8*)gpt_TxInfoSave + sizeof(InfoField_t)
            + (2*MAX_NUM_NS_BLOCK)*MAX_NS_VENDOR_INFO_LEN);

         gpt_TxInfoSave->ta_NS_Info[i].puca_NSVendorSpec = (uint8*)((uint8*)gpt_TxInfoSave + sizeof(InfoField_t)
            +(2*MAX_NUM_NS_BLOCK+1)*MAX_NS_VENDOR_INFO_LEN);
      }



      /* For every annex we intend to support, allocate memory to store corresponding Adsl2AllInfo_t structure */
      /* Current sizeof(Adsl2AllInfo_t) ~ 408 bytes. Hence we use guca_HndshkBuf, twiddle memory and snr buffers  */
      /* for memory allocation */
#pragma Offwarn(240)
#ifdef ISDN
      gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B] = (Adsl2AllInfo_t*)((uint8*)gpt_TxInfoSave->ta_NS_Info[MAX_NUM_NS_BLOCK-1].puca_NSVendorSpec + MAX_NS_VENDOR_INFO_LEN);
      gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_M] = (Adsl2AllInfo_t*)((uint8*)gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B] + sizeof(Adsl2AllInfo_t));
      gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B] = (Adsl2AllInfo_t*)((uint8*)gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_M] + sizeof(Adsl2AllInfo_t));

      gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_B] = (Adsl2AllInfo_t*)((uint8*)gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B] + sizeof(Adsl2AllInfo_t));
      gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_M] = (Adsl2AllInfo_t*)((uint8*)gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_B] + sizeof(Adsl2AllInfo_t));
      gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_B] = (Adsl2AllInfo_t*)((uint8*)gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_M] + sizeof(Adsl2AllInfo_t));

      gpt_RxInfo->pta_G9923xInfo[G992_3_ANNEX_B] = (Adsl2AllInfo_t*)((uint8*)gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_B] + sizeof(Adsl2AllInfo_t));

        //start to use new buffer
        vp_start_addr = (uint8 *)guca_hs_dummy;
        l_offset = 0;

      INC_MALLOC(gpt_RxInfo->pta_G9923xInfo[G992_3_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfo->pta_G9925xInfo[G992_5_ANNEX_B], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));

        INC_MALLOC(gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_B], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_B], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        //G992.5.M
        INC_MALLOC(gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfo->pta_G9925xInfo[G992_5_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));

        //G992.3.J
        INC_MALLOC(gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_J], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfo->pta_G9923xInfo[G992_3_ANNEX_J], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_J], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_J], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        //G992.5.J
        INC_MALLOC(gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_J], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfo->pta_G9925xInfo[G992_5_ANNEX_J], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_J], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_J], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));

#else
      gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A] = (Adsl2AllInfo_t*)(void *)((uint8*)gpt_TxInfoSave->ta_NS_Info[MAX_NUM_NS_BLOCK-1].puca_NSVendorSpec + MAX_NS_VENDOR_INFO_LEN);
      gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_M] = (Adsl2AllInfo_t*)(void *)((uint8*)gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A] + sizeof(Adsl2AllInfo_t));
      gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A] = (Adsl2AllInfo_t*)(void *)((uint8*)gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_M] + sizeof(Adsl2AllInfo_t));

      gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_A] = (Adsl2AllInfo_t*)(void *)((uint8*)gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A] + sizeof(Adsl2AllInfo_t));
      gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_M] = (Adsl2AllInfo_t*)(void *)((uint8*)gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_A] + sizeof(Adsl2AllInfo_t));
      gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_A] = (Adsl2AllInfo_t*)(void *)((uint8*)gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_M] + sizeof(Adsl2AllInfo_t));

      gpt_RxInfo->pta_G9923xInfo[G992_3_ANNEX_A] = (Adsl2AllInfo_t*)(void *)((uint8*)gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_A] + sizeof(Adsl2AllInfo_t));

        //start to use new buffer
        vp_start_addr = (uint8 *)guca_hs_dummy;
        l_offset = 0;

        INC_MALLOC(gpt_RxInfo->pta_G9923xInfo[G992_3_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfo->pta_G9925xInfo[G992_5_ANNEX_A], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));

        INC_MALLOC(gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_A], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_A], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        //G992.5.M
        INC_MALLOC(gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfo->pta_G9925xInfo[G992_5_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_M], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));

        //G992.3.I
        INC_MALLOC(gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_I], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfo->pta_G9923xInfo[G992_3_ANNEX_I], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_TxInfoSave->pta_G9923xInfo[G992_3_ANNEX_I], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfoSave->pta_G9923xInfo[G992_3_ANNEX_I], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        //G992.5.I
        INC_MALLOC(gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_I], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfo->pta_G9925xInfo[G992_5_ANNEX_I], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_TxInfoSave->pta_G9925xInfo[G992_5_ANNEX_I], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
        INC_MALLOC(gpt_RxInfoSave->pta_G9925xInfo[G992_5_ANNEX_I], (Adsl2AllInfo_t*), sizeof(Adsl2AllInfo_t));
#pragma Onwarn(240)
#endif//ISDN

      //reused specifically for Tssi info in handshake
#ifdef BIS_CODESWAP
      memset(gsa_RxHlogDS, 0, sizeof(gsa_RxHlogDS));
      gpusa_CLR_USTssiIndex = (uint16*)(void *)gsa_RxHlogDS;
      gpuca_CLR_USTssiValue = (uint8*)(void *)gpusa_CLR_USTssiIndex + MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED);
      gpfta_CLR_USTssiSi    = (uint8*) gpuca_CLR_USTssiValue + MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED);

      memset(guca_RxBat, 0, sizeof(guca_RxBat));
      gpusa_CL_USTssiIndex = (uint16*)(void *)guca_RxBat;
      gpuca_CL_USTssiValue  = (uint8*)(void *)gpusa_CL_USTssiIndex + MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED);
      gpfta_CL_USTssiSi     = (uint8*) gpuca_CL_USTssiValue+MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED);
#else
      memset(gusa_CLR_USTssiIndex, 0, sizeof(gusa_CLR_USTssiIndex));
      memset(guca_CLR_USTssiValue, 0, sizeof(guca_CLR_USTssiValue));
      memset(gfta_CLR_USTssiSi, 0, sizeof(gfta_CLR_USTssiSi));
      gpusa_CLR_USTssiIndex = (uint16*) gusa_CLR_USTssiIndex;
      gpuca_CLR_USTssiValue = (uint8*) guca_CLR_USTssiValue;
      gpfta_CLR_USTssiSi    = (uint8*) gfta_CLR_USTssiSi;

      memset(gusa_CL_USTssiIndex, 0, sizeof(gusa_CL_USTssiIndex));
      memset(guca_CL_USTssiValue, 0, sizeof(guca_CL_USTssiValue));
      memset(gfta_CL_USTssiSi, 0, sizeof(gfta_CL_USTssiSi));
      gpusa_CL_USTssiIndex = (uint16*) gusa_CL_USTssiIndex;
      gpuca_CL_USTssiValue  = (uint8*) guca_CL_USTssiValue;
      gpfta_CL_USTssiSi     = (uint8*) gfta_CL_USTssiSi;

#endif
}

#ifndef TEST_HS_DECODE

#ifdef ADSL_62_XYMEM
    extern int16 gsa_YBlock_Extended[];
#endif
/*****************************************************************************
;  Prototype:
;        AllocateDataBuffers_PreHndshk()
;
;
;****************************************************************************/
void AllocateDataBuffers_PreHndshk(void)
{
    uint8 *vp_start_addr;
    int32 l_offset;

   AllocateHSrelatedBuffers();

      /* The following code is actually for simulation only. They shouldn't be put into firmware*/
#ifndef TARGET_HW       // This is for Socrates code requirement.
#ifdef LEAVE_TRAIL
      for (i = 0; i < MAX_NUM_NS_BLOCK; i++) {
         gt_TrailRxInfoSave.ta_NS_Info[i].puca_NSVendorSpec = guca_RxSaveNSVendorSpec[i*MAX_NS_VENDOR_INFO_LEN];
         gt_TrailTxInfoSave.ta_NS_Info[i].puca_NSVendorSpec = guca_TxSaveNSVendorSpec;
      }
      for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED; i++) {
         gt_TrailRxInfoSave.pta_G9923xInfo[i] = &gta_TrailRxSaveG9923xInfo[i];
         gt_TrailTxInfoSave.pta_G9923xInfo[i] = &gta_TrailTxSaveG9923xInfo[i];
         gt_TrailMSInfo.pta_G9923xInfo[i] = &gta_TrailMSInfoG9923xInfo[i];
      }
      for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED; i++) {
         gt_TrailRxInfoSave.pta_G9925xInfo[i] = &gta_TrailRxSaveG9925xInfo[i];
         gt_TrailTxInfoSave.pta_G9925xInfo[i] = &gta_TrailTxSaveG9925xInfo[i];
         gt_TrailMSInfo.pta_G9925xInfo[i] = &gta_TrailMSInfoG9925xInfo[i];
      }
#endif  //LEAVE_STATE_NAMES_TRAIL
#endif   //TARGET_HW

      /********************************************************************************/
      /*                                                          */
      /* Frame Alignment & TDQ Training Buffer Allocation                     */
      /* NOTE: MultiTdqRxSignal (channel impulse response) exists from frame        */
      /*       alignment through TDQ training                              */
      /* NOTE: TDQ buffers exist at start of MEDLEY                           */
      /*                                                          */
      /********************************************************************************/
      /* Reuse the Handshake buffer with some of the arrays in tdq training */
      /* total no of words below is
      2*TDQ_LENGTH + 2*TDQ_LENGTH*TDQ_LENGTH + (TDQ_LENGTH*(TDQ_LENGTH+1)) +
      2* R_MAT_SIZE + (R_MAT_SIZE*(R_MAT_SIZE+1)) + 2*TDQ_LENGTH + 2*TDQ_LENGTH +
      2* RX_BUFFER_SIZE
        = 32+512+272+34+272+32+32+1024 =  2210 words */
      fa_Rxx = (Float32 *)(void *)guca_HndshkBuf;                 // vector that holds X'X
      fa_WFull = fa_Rxx+TDQ_LENGTH;    // Fast TDQ.
      fa_A = fa_WFull + TDQ_LENGTH*TDQ_LENGTH;     // holds A from (**)
      fa_TempBuf = fa_A + (TDQ_LENGTH*(TDQ_LENGTH+1))/2;             // temporary buffer to hold outputs of backsub
   // sparse matrix used for Cholesky (holds A and c)
      fa_R = fa_TempBuf+R_MAT_SIZE;
      fa_Xtz = fa_R + (R_MAT_SIZE*(R_MAT_SIZE+1))/2;        // X'z
      fa_Temp = fa_Xtz + TDQ_LENGTH;

   // This is the estimated channel impulse response.
      gsa_MultiTdqRxSignal = (int16 *)(void *)((Float32 *)fa_Temp + TDQ_LENGTH);

   // needed for diag mode

      gpuca_RMSG2_LD =  (uint8 *)(void *)(gsa_MultiTdqRxSignal + (2*RX_NUM_TONES));

      /********************************************************************************/
      /*                                                          */
      /* MEDLEY & Bitload Buffer Allocation                                */
      /*                                                          */
      /********************************************************************************/
      gsa_RxFineGainPlusBitChannel = (int16 *)(void *)guca_HndshkBuf;

      gsa_FDQ_coef_in = gsa_FDQ_coef_sav = gsa_RxFineGainPlusBitChannel + RX_NUM_TONES;
      guca_FDQ_exp_best  = (uint8 *)(void *)(gsa_FDQ_coef_sav + (2*RX_NUM_TONES));
      guca_FDQ_exp_in = guca_FDQ_exp_sav =  (uint8 *)(guca_FDQ_exp_best + RX_NUM_TONES); //// = 512 +512 + 512+512 =2048




#ifndef TARGET_HW
#ifdef PRINT_DATA_ALLOCATION
      /********************************************************************************/
      /*                                                          */
      /* PRINT Handshake Buffer Allocation                                 */
      /*                                                          */
      /********************************************************************************/
      data_allocation_ptr = fopen("data_allocation.txt","w");
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"---------------------------------------------\n");
      fprintf(data_allocation_ptr," Handshake Buffer Allocation                -\n");
      fprintf(data_allocation_ptr,"---------------------------------------------\n");
      fprintf(data_allocation_ptr,"\n\n");
      gpt_RxInfoSave = (InfoField_t*)((uint8*)gpt_RxInfo+sizeof(InfoField_t));
      fprintf(data_allocation_ptr,"InfoField Structure Total Size (Bytes)   \t\t%d\t\t\n", sizeof(InfoField_t));
      fprintf(data_allocation_ptr,"InfoField Structure Bis Size (Bytes)     \t\t%d\t\t\n", sizeof(Adsl2AllInfo_t));
      fprintf(data_allocation_ptr,"\n\nTime Slot 0 - Handshake\n\n");
      fprintf(data_allocation_ptr,"RxMsgBuf   \t\t%d\t\t%d\n", (int32)gpuca_RxMsgBuf - (int32)guca_HndshkBuf, (int32)gpuca_DecodeBuf - (int32)gpuca_RxMsgBuf);
      fprintf(data_allocation_ptr,"DecodeBuf  \t\t%d\t\t%d\n", (int32)gpuca_DecodeBuf - (int32)guca_HndshkBuf, (int32)gpuca_DecodeBuf - (int32)gpuca_RxMsgBuf);
      fprintf(data_allocation_ptr,"TxMsgBuf   \t\t%d\t\t%d\n", (int32)gpuca_TxMsgBuf - (int32)guca_HndshkBuf, (int32)gpuca_DecodeBuf - (int32)gpuca_RxMsgBuf);
      fprintf(data_allocation_ptr,"RxInfo     \t\t%d\t\t%d\n", (int32)gpt_RxInfo - (int32)guca_HndshkBuf, (int32)gpt_RxInfoSave - (int32)gpt_RxInfo);
      fprintf(data_allocation_ptr,"RxInfo     \t\t%d\t\t%d\n", (int32)gpt_RxInfoSave - (int32)guca_HndshkBuf, (int32)gpt_TxInfo - (int32)gpt_RxInfoSave);
      fprintf(data_allocation_ptr,"TxInfo     \t\t%d\t\t%d\n", (int32)gpt_TxInfo - (int32)guca_HndshkBuf, (int32)gpt_TxInfoSave - (int32)gpt_TxInfo);
      fprintf(data_allocation_ptr,"TxInfoSave \t\t%d\t\t%d\n", (int32)gpt_TxInfoSave - (int32)guca_HndshkBuf, (int32)gpt_RxInfo->ta_NS_Info[0].puca_NSVendorSpec - (int32)gpt_TxInfoSave);

      fprintf(data_allocation_ptr,"RxInfo NS Info:\n");
      for (i = 0; i < (MAX_NUM_NS_BLOCK-1); i++) {
         fprintf(data_allocation_ptr," NSInfo %d \t\t%d\t\t%d\n",i,
               (int32)gpt_RxInfo->ta_NS_Info[i].puca_NSVendorSpec - (int32)guca_HndshkBuf,
               (int32)gpt_RxInfo->ta_NS_Info[i+1].puca_NSVendorSpec - (int32)gpt_RxInfo->ta_NS_Info[i].puca_NSVendorSpec);
      }
      fprintf(data_allocation_ptr," NSInfo %d \t\t%d\t\t%d\n",4,
            (int32)gpt_RxInfo->ta_NS_Info[4].puca_NSVendorSpec - (int32)guca_HndshkBuf,
            (int32)gpt_RxInfoSave->ta_NS_Info[0].puca_NSVendorSpec - (int32)gpt_RxInfo->ta_NS_Info[4].puca_NSVendorSpec);


      fprintf(data_allocation_ptr,"RxInfoSave NS Info:\n");
      for (i = 0; i < (MAX_NUM_NS_BLOCK-1); i++) {
         fprintf(data_allocation_ptr," NSInfo %d \t\t%d\t\t%d\n",4,
               (int32)gpt_RxInfoSave->ta_NS_Info[i].puca_NSVendorSpec - (int32)guca_HndshkBuf,
               (int32)gpt_RxInfoSave->ta_NS_Info[i+1].puca_NSVendorSpec - (int32)gpt_RxInfoSave->ta_NS_Info[i].puca_NSVendorSpec);
      }
      fprintf(data_allocation_ptr," NSInfo %d \t\t%d\t\t%d\n",4,
            (int32)gpt_RxInfoSave->ta_NS_Info[4].puca_NSVendorSpec - (int32)guca_HndshkBuf,
            (int32)gpt_TxInfo->ta_NS_Info[0].puca_NSVendorSpec - (int32)gpt_RxInfoSave->ta_NS_Info[4].puca_NSVendorSpec);


      fprintf(data_allocation_ptr,"TxInfo NS Info:\n");
      for (i = 0; i < (MAX_NUM_NS_BLOCK-1); i++) {
         fprintf(data_allocation_ptr," NSInfo %d \t\t%d\t\t%d\n",i,
               (int32)gpt_TxInfo->ta_NS_Info[i].puca_NSVendorSpec - (int32)guca_HndshkBuf,
               (int32)gpt_TxInfo->ta_NS_Info[i+1].puca_NSVendorSpec - (int32)gpt_TxInfo->ta_NS_Info[i].puca_NSVendorSpec);
      }
      fprintf(data_allocation_ptr," NSInfo %d \t\t%d\t\t%d\n",4,
            (int32)gpt_TxInfo->ta_NS_Info[4].puca_NSVendorSpec - (int32)guca_HndshkBuf,
            (int32)gpt_TxInfoSave->ta_NS_Info[0].puca_NSVendorSpec - (int32)gpt_TxInfo->ta_NS_Info[4].puca_NSVendorSpec);


      fprintf(data_allocation_ptr,"TxInfoSave NS Info:\n");
      for (i = 0; i < (MAX_NUM_NS_BLOCK-1); i++) {
         fprintf(data_allocation_ptr," NSInfo %d \t\t%d\t\t%d\n",4,
               (int32)gpt_TxInfoSave->ta_NS_Info[i].puca_NSVendorSpec - (int32)guca_HndshkBuf,
               (int32)gpt_TxInfoSave->ta_NS_Info[i+1].puca_NSVendorSpec - (int32)gpt_TxInfoSave->ta_NS_Info[i].puca_NSVendorSpec);
      }
      fprintf(data_allocation_ptr," NSInfo %d \t\t%d\t\t\n",4,
            (int32)gpt_TxInfoSave->ta_NS_Info[4].puca_NSVendorSpec - (int32)guca_HndshkBuf);

      fprintf(data_allocation_ptr,"\n\n");


      /********************************************************************************/
      /*                                                          */
      /* PRINT Channel Discovery Buffer Allocation                         */
      /*                                                          */
      /********************************************************************************/
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"\n\nTime Slot 1 - Channel Discovery\n\n");

      /********************************************************************************/
      /*                                                          */
      /* PRINT Frame alignment and TDQ Buffer Allocation                      */
      /*                                                          */
      /********************************************************************************/
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"\n\nTime Slot 1 - TDQ Training\n\n");
      fprintf(data_allocation_ptr,"Rxx        \t\t%d\t\t\n", (int32)fa_Rxx - (int32)guca_HndshkBuf);
      fprintf(data_allocation_ptr,"WFull      \t\t%d\t\t\n", (int32)fa_WFull - (int32)guca_HndshkBuf);
      fprintf(data_allocation_ptr,"A          \t\t%d\t\t\n", (int32)fa_A - (int32)guca_HndshkBuf);
      fprintf(data_allocation_ptr,"TempBuf    \t\t%d\t\t\n", (int32)fa_TempBuf - (int32)guca_HndshkBuf);
      fprintf(data_allocation_ptr,"R          \t\t%d\t\t\n", (int32)fa_R - (int32)guca_HndshkBuf);
      fprintf(data_allocation_ptr,"Xtz        \t\t%d\t\t\n", (int32)fa_Xtz - (int32)guca_HndshkBuf);
      fprintf(data_allocation_ptr,"Temp       \t\t%d\t\t\n", (int32)fa_Temp - (int32)guca_HndshkBuf);
      fprintf(data_allocation_ptr,"MultiTdqRxSignal      \t\t%d\t\t\n", (int32)gsa_MultiTdqRxSignal - (int32)guca_HndshkBuf);

      /********************************************************************************/
      /*                                                          */
      /* PRINT Medley and Bitload and TDQ Buffer Allocation                   */
      /*                                                          */
      /********************************************************************************/
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"\n\nTime Slot 1 - Medley\n\n");
      fprintf(data_allocation_ptr,"RxFineGainPlusBitChannel       \t\t%d\t\t\n", (int32)gsa_RxFineGainPlusBitChannel - (int32)guca_HndshkBuf);
      fprintf(data_allocation_ptr,"FDQ_coef_sav          \t\t%d\t\t\n", (int32)gsa_FDQ_coef_sav - (int32)guca_HndshkBuf);
      fprintf(data_allocation_ptr,"FDQ_exp_best          \t\t%d\t\t\n", (int32)guca_FDQ_exp_best - (int32)guca_HndshkBuf);
      fprintf(data_allocation_ptr,"FDQ_exp_sav           \t\t%d\t\t\n", (int32)guca_FDQ_exp_sav - (int32)guca_HndshkBuf);

      fclose(data_allocation_ptr);

#endif
#endif
/*------------------------------------------------------------------------------------------------------------------*/
/*             gpsa_CommonMemoryBlock0/1 Allocation                                                   */
/*------------------------------------------------------------------------------------------------------------------*/

      //===============================
      // Part I. Allocate buffers
      //===============================

      /* rx tones buffer needs to be allocated before the handshake */
      gsa_RxBuffer8X_0 = gpsa_CommonMemoryBlock0;


      /* do not move this array around, might create  problems on socrates */
      // To accommodate Plus mode on Hercules platform, we move gsa_RxToneBuf to (gsa_RxBuffer8X_0 + 4*(RX_NUM_TONES))
      // during MoveToFrameStartInt and restore it to gsa_RxBuffer8X_0 + 6*(RX_NUM_TONES) during MoveToFdqDoneInt.
      // Due to the radix-4 FFT used by Hercules, we need to run a 2048-pt FFT in Plus where zeros have been placed between
      // TD samples. When reading TD samples using GetRxTime fcn, need to remove all zeros.
        // In other words, in Plus mode we DMA 1024 16-bit words when reading freq domain data and 2048 words
        // when reading time domain data. Every other time domain sample is a zero.
      gsa_RxBuffer8X_1 = gpsa_CommonMemoryBlock1;  //0 - 2047 DMT; 0-1023 G.Lite
#ifdef ADSL_62_XYMEM
      gsa_RxToneBuf = (int16 *) gsa_RxBuffer8X_1;
#else
      gsa_RxToneBuf = (int16 *) gsa_RxBuffer8X_0 + 6*(RX_NUM_TONES);
#endif


      //===============================
      // Part II. Assign additional pointers (no additional memory is allocated here).
      //===============================

      //============================================
      // Pointers within gsa_RxBuffer8X_0 buffer. (2K in full, 1K in Lite)
      //============================================
      // Used during by SetPgaForToneDetection(), which is called during handshake
      // and Channel discovery.
      // Buffer of size 2*NUM_TONES_
#ifdef ADSL_62_XYMEM
        gpsa_RxToneBuf_sav = gsa_XBlock_Extended;

      // Used during Chan Discovery for DetectMultiTones.
      // Buffer of size 2*NUM_TONES_
        gpsa_RxToneBuf_sav2 = (int16 *)gsa_RxBuffer8X_1 + 2*(RX_NUM_TONES);
#else
        gpsa_RxToneBuf_sav = (int16 *)gsa_RxBuffer8X_0 + 4*(RX_NUM_TONES);

      // Used during Chan Discovery for DetectMultiTones.
      // Buffer of size 2*NUM_TONES_
        gpsa_RxToneBuf_sav2 = (int16 *)gsa_RxBuffer8X_0 + 2*(RX_NUM_TONES);
#endif


      // Used throughout training, but may be overwritten for BG tasks
      // which use the accumulated signal
      gla_RxAccumBuf = (int32 *)(void *)gsa_RxBuffer8X_0;

#ifdef AMAZON_AFE
      // Used in programmable hybrid training phase (during R-C-REVERB1 and R-C-PILOT2
      // in DMT and during R-C-REVERB1 and R-C-TREF1 in BIS/PLUS)
      gpla_BgHybAccumBuf = &gla_RxAccumBuf[RX_NUM_TONES];   // Buffer length: (2*(HYB_DECIM_FACTOR * HYB_DECIM_POINTS + 1))*sizeof(int32)
#elif defined (VRX518)
      gpla_BgHybAccumBuf = &gla_BgHybAccumBuf[0];
#endif   /* End of #ifdef AMAZON_AFE... */

      // Start Time slot 0 - During TDQ training.
      gsa_RxRepFrameAlignBuf = (int16 *) gsa_RxBuffer8X_0; /* overlay on RxAccumBuf */
      // End Time slot 0.

      // Start Time slot 1 - After TDQ training.
//    gsa_RxRepFDQTrainBuf = (int16 *)((int32 *)gsa_RxBuffer8X_0 + 2*(RX_NUM_TONES));
      gsa_RxRepFDQTrainBuf = (int16 * ) gsa_RxBuffer8X_0 ;

      // End Time slot 1.

      // Start Time slot X - Showtime
      gla_RxShowtimeSnrAccumBuf = (int32 *)(void *)gsa_RxBuffer8X_0;
      gsa_RxShowtimeFDQAccumBuf = (int16 *)(void *)gla_RxShowtimeSnrAccumBuf;
      gsa_RxShowtimeFDQRepBuf = (int16 *) gsa_RxShowtimeFDQAccumBuf;
      /********************************************************************************************************/
      /* SS has either SNR or FDQ adaptation on at a given instant. This is not so in DD adaptation and hence */
      /* we need separate snr and fdq accum buffers. Also, we need a separate buffer for recieved fdq outputs.*/
      /* The other buffers are to store intermediate data to enable fast processing                         */
      /* Note: Care has to be taken for working of swengine(doesnt use DD Snr/Fdq) while overlaying buffers    */
      /* To summarise, we use the original 4*RX_NUM_TONES [2048 words] long Showtime Accum Buf as follows:     */
      /* BugFix_DS_ADSL1_ALL_SuddenRFI (START)                                                                */
      /* gla_RxShowtimeSnrAccumBuf  :  4*(DD_MAX_TONES_PER_SYMBOL) [4*48 = 192 words]                       */
      /* gsa_DD_rxFDQOutput[0]      :  2*(DD_MAX_TONES_PER_SYMBOL) [2*48 = 96 words]                        */
      /* gsa_DD_rxFDQOutput[1]      :  2*(DD_MAX_TONES_PER_SYMBOL) [2*48 = 96 words]                        */
      /* gpsa_DD_rxFDQErrCorrBuf    :  2*(DD_MAX_TONES_PER_SYMBOL) [2*48 = 96 words]                        */
      /* gpsa_DD_1byRxCombinedGains :  2*(DD_MAX_TONES_PER_SYMBOL) [2*48 = 96 words]                        */
      /* gpsa_DD_RxGainScaleShifts  :  2*(DD_MAX_TONES_PER_SYMBOL)   [2*48 = 96 words]                      */
      /* gpsa_DD_CmplxMultScratchPadX  :  4*(DD_MAX_TONES_PER_SYMBOL)   [4*48 = 192 words]                  */
      /* gpusa_pre_dec_h_lsw        :  DEC_ORDER_MAX           [1*480 = 480 words]                          */
      /* gpuc_rx_clear_eoc_buff     :  RX_CLEAR_EOC_DATA_SIZE     [1*128 = 128 words]                         */
      /* gpsa_NoiseSeparationSnrAdj :  RX_NUM_TONES            [1*512 = 512 words]                            */
      /* BugFix_DS_ADSL1_ALL_SuddenRFI (END)                                                                */
      /********************************************************************************************************/
      // X Memory
      gsa_DD_rxFDQOutput[0] = (int16 *)(void *)gla_RxShowtimeSnrAccumBuf   + 4*(DD_MAX_TONES_PER_SYMBOL);         //Buffer Size 2*(DD_MAX_TONES_PER_SYMBOL) words
      gsa_DD_rxFDQOutput[1] = (int16 *)   gsa_DD_rxFDQOutput[0]      + 2*(DD_MAX_TONES_PER_SYMBOL);         //Buffer Size 2*(DD_MAX_TONES_PER_SYMBOL) words
      gpsa_DD_rxFDQErrCorrBuf = (int16 *) gsa_DD_rxFDQOutput[1]      + 2*(DD_MAX_TONES_PER_SYMBOL);         //Buffer Size 4*(DD_MAX_TONES_PER_SYMBOL) words
      gpsa_DD_1byRxCombinedGains = (int16 *) gpsa_DD_rxFDQErrCorrBuf    + 2*(DD_MAX_TONES_PER_SYMBOL);         //Buffer Size 2*(DD_MAX_TONES_PER_SYMBOL) words
      gpsa_DD_RxGainScaleShifts = (int16 *)  gpsa_DD_1byRxCombinedGains + 2*(DD_MAX_TONES_PER_SYMBOL);         //Buffer Size 2*(DD_MAX_TONES_PER_SYMBOL) words
      gpsa_DD_CmplxMultScratchPadX = (int16 *)  gpsa_DD_RxGainScaleShifts  + 2*(DD_MAX_TONES_PER_SYMBOL);         //Buffer Size 4*(DD_MAX_TONES_PER_SYMBOL) words
      /* Assign memory needed for DEC adaptation (an array of DEC coefficient LSWs). */

      //Buffer Size DEC_ORDER_MAX words
      gpusa_pre_dec_h_lsw        = (uint16 *)(void *)gpsa_DD_CmplxMultScratchPadX+ 4*(DD_MAX_TONES_PER_SYMBOL);         //Buffer Size DEC_ORDER_MAX words
      guca_Tx_ME_HDLCMsgBuffer      = (uint8 *)(void *)gpusa_pre_dec_h_lsw + DEC_ORDER_MAX;
      gt_RxClearEocBuf_CMV.gpus_RxClearEocBuf = (int16 *)(void *)((uint8 *) guca_Tx_ME_HDLCMsgBuffer + MAX_TX_ME_HDLC_MSG_SIZE);
      gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_Length = RX_CLEAR_EOC_DATA_SIZE*2;    // length in bytes
      gpsa_NoiseSeparationSnrAdj = (int16 *)(gt_RxClearEocBuf_CMV.gpus_RxClearEocBuf + RX_CLEAR_EOC_DATA_SIZE);
      // End Time slot X.


#ifndef TARGET_HW
#ifdef PRINT_DATA_ALLOCATION
      /********************************************************************************/
      /*                                                          */
      /* PRINT gsa_RxBuffer8X_0 Allocation                                 */
      /*                                                          */
      /********************************************************************************/

      data_allocation_ptr = fopen("data_allocation.txt","a");
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"---------------------------------------------\n");
      fprintf(data_allocation_ptr," gsa_RxBuffer8X_0 Allocation               -\n");
      fprintf(data_allocation_ptr,"---------------------------------------------\n");
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"gsa_RxToneBuf               \t\t%d\t\t\n", (int32)gsa_RxToneBuf-(int32)gpsa_CommonMemoryBlock0);
      fprintf(data_allocation_ptr,"gla_RxAccumBuf              \t\t%d\t\t\n", (int32)gla_RxAccumBuf-(int32)gpsa_CommonMemoryBlock0);

      fprintf(data_allocation_ptr,"\n\nTime Slot 0 - \n\n");
      fprintf(data_allocation_ptr,"gsa_RxRepFrameAlignBuf      \t\t%d\t\t\n", (int32)gsa_RxRepFrameAlignBuf-(int32)gpsa_CommonMemoryBlock0);

      fprintf(data_allocation_ptr,"\n\nTime Slot 1 - post-TDQ\n\n");
      fprintf(data_allocation_ptr,"gsa_RxRepFDQTrainBuf        \t\t%d\t\t\n", (int32)gsa_RxRepFDQTrainBuf-(int32)gpsa_CommonMemoryBlock0);

      fprintf(data_allocation_ptr,"\n\nTime Slot 2 - SHOWTIME\n\n");
      fprintf(data_allocation_ptr,"gla_RxShowtimeSnrAccumBuf   \t\t%d\t\t\n", (int32)gla_RxShowtimeSnrAccumBuf-(int32)gpsa_CommonMemoryBlock0);
      fprintf(data_allocation_ptr,"gsa_RxShowtimeFDQAccumBuf   \t\t%d\t\t\n", (int32)gsa_RxShowtimeFDQAccumBuf-(int32)gpsa_CommonMemoryBlock0);
      fprintf(data_allocation_ptr,"gsa_RxShowtimeFDQRepBuf     \t\t%d\t\t\n", (int32)gsa_RxShowtimeFDQRepBuf-(int32)gpsa_CommonMemoryBlock0);

      fclose(data_allocation_ptr);
#endif
#endif


      //============================================
      // Pointers within gsa_RxBuffer8X_1 buffer.
      //============================================
#ifdef AMAZON_AFE
      // Start Time slot -1 - During programmable hybrid training.
      gpla_HybRevRefPwr = (int32 *) gsa_RxBuffer8X_1;                // Buffer length: HYB_NUM_HYBRIDS*sizeof(int32)
      gpsa_SignalPSD = (int16 *) (gpla_HybRevRefPwr + HYB_NUM_HYBRIDS); // Buffer length: (HYB_DECIM_POINTS+1)*HYB_NUM_HYBRIDS*sizeof(int16)
    #ifdef HYB_REG_POINTERS
      gpusa_HybridReg0 = (uint16 *) (gpsa_SignalPSD + (HYB_DECIM_POINTS+1)*HYB_NUM_HYBRIDS); // Buffer length: HYB_NUM_HYBRIDS*sizeof(uint16)
      gpusa_HpfEqReg = (uint16 *) (gpusa_HybridReg0 + HYB_NUM_HYBRIDS); // Buffer length: HYB_NUM_HYBRIDS*sizeof(uint16)
      gpsa_PGARegTable = (int16 *) (gpusa_HpfEqReg + HYB_NUM_HYBRIDS);  // Buffer length: HYB_NUM_HYBRIDS*sizeof(int16)
    #else
      gpsa_PGARegTable = (int16 *) (gpsa_SignalPSD + (HYB_DECIM_POINTS+1)*HYB_NUM_HYBRIDS);  // Buffer length: HYB_NUM_HYBRIDS*sizeof(int16)
    #endif
      gpsa_PGARequiredTable = (int16 *) (gpsa_PGARegTable + HYB_NUM_HYBRIDS); // Buffer length: HYB_NUM_HYBRIDS*sizeof(int16)
      // End Time slot -1.
#elif defined (VRX518)
      //VR9_AFE
      gpla_HybRevRefPwr = &gla_HybRevRefPwr[0];                // Buffer length: HYB_NUM_HYBRIDS*sizeof(int32)
      gpsa_SignalPSD = &gsa_SignalPSD[0];
#endif   /* End of #ifdef AMAZON_AFE */

      /* FDQ Coefs -- Used through training (pretty much) and in showtime */
      /* The FDQ Coefs need to be in Y memory since L2 processing of fdq  */
      /* coefs use Y memory based dual mac implementation(FdqMultiplyLoop)*/
#ifdef ADSL_62_XYMEM
      //FDQ coefs are stored in YBlock_Extended during training.
      gsa_FDQ_coef_out = gsa_pre_FDQ_coef = (int16 *)gsa_YBlock_Extended;
#else
      // the upper 4K of YMEM is not used by AFE code; so we can use it for the FDQ coefs
      gsa_FDQ_coef_out = gsa_pre_FDQ_coef = (int16 *) gsa_RxBuffer8X_1 + 4*(RX_NUM_TONES);
#endif
      guca_pre_FDQ_exp = (uint8 *)(void *)gusa_AnnexBMJInterp1_3;
      guca_FDQ_exp_out = guca_pre_FDQ_exp;

#ifdef FLOAT_IN_SW
      // Start Time slot 0 - During TDQ training.
      // This is a scratch memory buffer used in various ways in TdqInit().
      // Caution:  This buffer is overwritten during TDQ scaling if Lite mode and TDQ at 2208.
#ifdef ADSL_62_XYMEM
      gsa_TDQTrainingSignal = (int16 *)(void *)gla_tmpBuf;
#else
      gsa_TDQTrainingSignal = (int16 *) gsa_RxBuffer8X_1;
#endif
      // End Time slot 0.
#endif

      // Start Time slot 1 - During DEC training.
      // The length of this buffer depends on the DEC_TRAINING_PERIOD, the
      // DEC_UPSAMPLING_FACTOR, DEC_ORDER and MAX_DEC_DELAY.  For DEC_ORDER = 400
      // and MAX_DEC_DELAY = 31, the maximum length is 1296 words.  In this case,
      // the cross correlation will overwrite up to the first 11 locations of
      // gsa_MedleySnrBuf, but leave gsa_CReverbRefTones untouched.
#ifdef ADSL_62_XYMEM
//    gla_RxDECXcorr = (int32 *)(gsa_RxBuffer8X_0 + 2*(RX_NUM_TONES));
      gla_RxDECXcorr = (int32 *)(gla_tmpBuf);
#else
      gla_RxDECXcorr = (int32 *)gsa_RxBuffer8X_1;
#endif
      // End Time Slot 1

      // Start Time slot 1.5 - Right after DEC training.
      gsa_CQuietRefTones = (int16 *) (gsa_RxBuffer8X_1 + 2*(RX_NUM_TONES));

      // End Time Slot 1.5

#ifdef ADSL_62_XYMEM

        // Start Time Slot 2 - After DEC training, During Medley until BitLoading
        // caution, gsa_TDQTrainingSignal is used during medley as well which is of size 1024
      // During COMB2, gsa_FDQ_coef_best is used to calculate DSPCB  and needs to be in Y-Mem
      // it will be moved to lower half of YExtended starting from medley.
        gsa_FDQ_coef_best = (int16 *) (gsa_RxBuffer8X_1 + 2*(RX_NUM_TONES));
      // gsa_unpk_PN512 shared gsa_CReverbRefTones in medley.
        gsa_unpk_PN512 = (int16 *) (gsa_RxBuffer8X_1 + 2*(RX_NUM_TONES));

        // End Time Slot 2

        // Time slot 2 - After Medley bitloading including showtime.
        gsa_RxCombinedGains =  (int16 *)gsa_XBlock_Extended;
        gsa_RxShowtimeSnrBuf = (int16 *)gsa_XBlock_Extended + RX_NUM_TONES;
        gsa_RxToneOrder =      (int16 *)gsa_XBlock_Extended + 2*(RX_NUM_TONES);
        gsa_RxFineGains =      (int16 *)gsa_XBlock_Extended + 3*(RX_NUM_TONES);
#else
      // Start Time Slot 2 - After DEC training, During Medley until BitLoading
      // caution, gsa_TDQTrainingSignal is used during medley as well which is of size 1024
      gsa_FDQ_coef_best = (int16 *)  gsa_RxBuffer8X_1;
      gsa_unpk_PN512 = (int16 *) gsa_RxBuffer8X_1 + 2*(RX_NUM_TONES);

      // End Time Slot 2

      // Time slot 2 - After Medley bitloading including showtime.
      gsa_RxCombinedGains =  (int16 *)gsa_RxBuffer8X_1;
      gsa_RxShowtimeSnrBuf = (int16 *)gsa_RxBuffer8X_1 + RX_NUM_TONES;
      gsa_RxToneOrder =      (int16 *)gsa_RxBuffer8X_1 + 2*(RX_NUM_TONES);
      gsa_RxFineGains =      (int16 *)gsa_RxBuffer8X_1 + 3*(RX_NUM_TONES);
#endif

      /* The following pointers are used for Bis diagnostics mode only */

      /* Consecutive memory locations used for Hlog */
      /* computed at time of transmission in diag mode, so no need to store off-chip */
      gpuca_RMSG6_LD =  (uint8 *)(void *)gsa_RxHlogDS;
      /* Memory used for Quiet line noise measurement */
      gpuca_RMSG8_LD =  (uint8 *) guca_QLN;

      /* The following pointers are used during the computation of diagnostic parameters */
      gpsa_RxHlin = (int16 *)(void *)gpuca_RMSG2_LD;  /* assumes consecutive memory allocation for RMSG2 through RMSG5*/

      /* Pointer to Loop Diagnostics message array. */
      gpuca_RMSGx_LD = guca_RxBat;

      // End Time slot 2.

#ifdef ADSL_62_XYMEM
      //located in the lower half of the YMem, comb2 signal is used as reference in comb snr calculation
        gsa_Comb2SignalBuf = (int16 *)gsa_RxBuffer8X_1 + 2*(RX_NUM_TONES);

        //located in the lower half of the YMem
        gsa_CReverbRefTones = (int16 *)gsa_RxBuffer8X_1 + 2*(RX_NUM_TONES);
#else
      // During Channel Discovery.
      gsa_Comb2SignalBuf = (int16 *) gsa_RxBuffer8X_1 + 6*(RX_NUM_TONES);

      // CReverbRefTones used throughout training
      gsa_CReverbRefTones = (int16 *) gsa_RxBuffer8X_1 + 6*(RX_NUM_TONES);
#endif
      /********************************************************************************************************/
      /* DD based SNR/FDQ Adaptation no longer needs the CReverb Reference Buffer.                    */
      /* However, we need a separate buffer in Y memoy for reference qam outputs. Hence we reuse the CReverb   */
      /* buffer from training to store some post-medley/showtime buffers                              */
      /* Note: Care has to be taken for working of swengine(doesnt use DD Snr/Fdq) while overlaying buffers */
      /* To summarise, we use the original 2*RX_NUM_TONES [1024 words] long CReverb Ref Buffer as follows:  */
      /* gsa_DD_rxQAMOutput         :  2*(DD_MAX_TONES_PER_SYMBOL)   [64 words]                       */
      /* gpsa_DD_NoiseError         :  2*(DD_MAX_TONES_PER_SYMBOL)   [64 words]                       */
      /* gpsa_DD_CmplxMultScratchPadY  :  4*(DD_MAX_TONES_PER_SYMBOL)   [128 words](overlaps gpsa_DD_NoiseError)*/
      /* gsa_TempRxFineGains        :  RX_NUM_TONES            [512 words]                      */
      /* gsa_Showtime_TxToneBuf     :  TX_FFT_LENGTH+2            [130 words]                      */
      /********************************************************************************************************/
      // Y Memory
#ifdef ADSL_62_XYMEM
        // recall that the gsa_FDQ_coef_out buffer occupies the first 2KB of Y_MEM
        // so the DD buffers could be in the 2nd 2KB of Y_MEM
#endif
      gsa_DD_rxQAMOutput         = (int16 *) gsa_CReverbRefTones;                                  //Buffer Size 2*(DD_MAX_TONES_PER_SYMBOL) words
      gpsa_DD_NoiseError         = (int16 *) gsa_DD_rxQAMOutput         + 2*(DD_MAX_TONES_PER_SYMBOL);         //Buffer Size 2*(DD_MAX_TONES_PER_SYMBOL) words
      gpsa_DD_CmplxMultScratchPadY= (int16 *)   gpsa_DD_NoiseError;                                      //Buffer Size 4*(DD_MAX_TONES_PER_SYMBOL) words
      // These two buffers are redefined in SWExec after this call, since DDSNR/FDQ not used.
      gsa_TempRxFineGains        = (int16 *) gpsa_DD_CmplxMultScratchPadY+ 4*(DD_MAX_TONES_PER_SYMBOL);        //Buffer Size RX_NUM_TONES words
      gsa_Showtime_TxToneBuf     = (int16 *) gsa_TempRxFineGains        + RX_NUM_TONES;                     //Buffer Size TX_FFT_LENGTH+2 words

      // End Time slot X.

#ifndef TARGET_HW
#ifdef PRINT_DATA_ALLOCATION
      /********************************************************************************/
      /*                                                          */
      /* PRINT gsa_RxBuffer8X_1 Allocation                                 */
      /*                                                          */
      /********************************************************************************/

      data_allocation_ptr = fopen("data_allocation.txt","a");
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"---------------------------------------------\n");
      fprintf(data_allocation_ptr," gsa_RxBuffer8X_1 Allocation               -\n");
      fprintf(data_allocation_ptr,"---------------------------------------------\n");
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"\n\nDefault (restored after DEC Training \n\n");
      fprintf(data_allocation_ptr,"gsa_CReverbRefTones         \t\t%d\t\t\n", (int32)gsa_CReverbRefTones-(int32)gpsa_CommonMemoryBlock1);
      fprintf(data_allocation_ptr,"\n\nTime Slot 0 - TDQ Training \n\n");
      fprintf(data_allocation_ptr,"gsa_TDQTrainingSignal       \t\t%d\t\t\n", (int32)gsa_TDQTrainingSignal-(int32)gpsa_CommonMemoryBlock1);

      fprintf(data_allocation_ptr,"\n\nTime Slot 1 - DEC Training \n\n");
      fprintf(data_allocation_ptr,"gla_RxDECXcorr              \t\t%d\t\t\n", (int32)gla_RxDECXcorr-(int32)gpsa_CommonMemoryBlock1);

      fprintf(data_allocation_ptr,"\n\nTime Slot 2 - Medley \n\n");
      fprintf(data_allocation_ptr,"gsa_FDQ_coef_best           \t\t%d\t\t\n", (int32)gsa_FDQ_coef_best-(int32)gpsa_CommonMemoryBlock1);
      fprintf(data_allocation_ptr,"gsa_unpk_PN512              \t\t%d\t\t\n", (int32)gsa_unpk_PN512-(int32)gpsa_CommonMemoryBlock1);
      fprintf(data_allocation_ptr,"gsa_MedleySnrBuf            \t\t%d\t\t\n", (int32)gsa_MedleySnrBuf-(int32)gpsa_CommonMemoryBlock1);

      fprintf(data_allocation_ptr,"\n\nTime Slot 3 - SHOWTIME\n\n");
      fprintf(data_allocation_ptr,"gsa_RxCombinedGains         \t\t%d\t\t\n", (int32)gsa_RxCombinedGains-(int32)gpsa_CommonMemoryBlock1);
      fprintf(data_allocation_ptr,"gsa_RxShowtimeSnrBuf        \t\t%d\t\t\n", (int32)gsa_RxShowtimeSnrBuf-(int32)gpsa_CommonMemoryBlock1);
      fprintf(data_allocation_ptr,"gsa_RxToneOrder             \t\t%d\t\t\n", (int32)gsa_RxToneOrder-(int32)gpsa_CommonMemoryBlock1);
      fprintf(data_allocation_ptr,"gsa_RxFineGains             \t\t%d\t\t\n", (int32)gsa_RxFineGains-(int32)gpsa_CommonMemoryBlock1);

      fclose(data_allocation_ptr);
#endif
#endif



/*------------------------------------------------------------------------------------------------------------------*/
/*             gsa_CommonTwidMem Allocation                                                  */
/*------------------------------------------------------------------------------------------------------------------*/

#define N256   1024

      /********************************************************************************/
      /*                                                          */
      /* Initialization Buffer Allocation                               */
      /*                                                          */
      /********************************************************************************/
      /* total length is N256/4+N256/4+N256/4+1+N256/2 = 641 */
      /* gsa_CommonTwidMem is provisioned for 1762 words, so
      even adsl+ tables will fit in here */
      gsa_twid_real256 = (int16 *)gsa_CommonTwidMem;
      gsa_twid_imag256 = (int16 *)gsa_twid_real256 + N256/4;
      gsa_sk_tab256 = (int16 *) gsa_twid_imag256 + N256/4;
      // gsa_bit_reverse_idx256 is of size N256/2
      gsa_bit_reverse_idx256 = (int16 *) gsa_sk_tab256 + N256/4+1;

      /********************************************************************************/
      /*                                                          */
      /* Initialization - Messaging Buffer Allocation                      */
      /*                                                          */
      /********************************************************************************/
      /* gsa_CommonTwidMem is provisioned for 1762 words                      */

      /* BIS: total length of guca_R_PARAMS_bis is                         */
      /* LEN_R_PARAMS_MESSAGE_BYTES+MAX_PADDING_BYTES = 2095 bytes or 1048 words.      */
      /* DMT Annex A,B: length of gpsa_DS_BitAndGain is RX_NUM_TONES = 512 words.      */
      /* DMT Annex C: length of gpsa_DS_BitAndGain is 2*RX_NUM_TONES = 1024 words.  */
      /* only one of these pointers is used each run (depending on mode selection)  */

      guca_R_PARAMS_bis = (uint8 *)(void *)gsa_CommonTwidMem;
      //The below buffer initialization is done post handshake since gpsa_DS_BitAndGain
      //is mapped to DMT datat codeswap page
//    gpsa_DS_BitAndGain = (uint16 *)gsa_CommonTwidMem;

      /********************************************************************************/
      /*                                                          */
      // Initialization - DMT Exchange
      /*                                                          */
      /********************************************************************************/

      gsa_RxExchMsg1 = gsa_EC_Train_Seq;  // Required size is R_C_RATES_RA_RX_LEN 16-bit words.

      /********************************************************************************/
      /*                                                          */
      /* SHOWTIME Buffer Allocation                                     */
      /*                                                          */
      /********************************************************************************/
      // if ADSL+ HDLC buffer increase in size, then commontwid memory size has to increase
      // size is MAX_RX_HDLC_MSG_SIZE + MAX_RX_HDLC_MSG_SIZE + MAX_RX_ME_HDLC_MSG_SIZE
      //         MAX_TX_HDLC_MSG_SIZE + MAX_TX_ME_HDLC_MSG_SIZE + 3*4*TX_FFT_SIZE bytes
      //      = (1030-256) + (1030-256) + 256 + 700 + 32 + 768 = 3304 < 1762*2

      // these four buffers will be overlaid with BitAndGain (2048 bytes in DMT AnnexC)

#ifndef TARGET_HW
      guca_rx_hdlc_msg_buffer = (uint8 *)gsa_CommonTwidMem;
#else
      // This buffer is used for ADSL2 HDLC processing as well as DMT Clear EOC processing.
      guca_rx_hdlc_msg_buffer = (uint8 *)(void *)gsa_EC_Train_Seq;
#endif//0/1
      guca_RxHDLCMsgBuffer = (uint8 *)guca_rx_hdlc_msg_buffer + MAX_RX_HDLC_MSG_SIZE;
      guca_Rx_ME_HDLCMsgBuffer = (uint8 *)guca_RxHDLCMsgBuffer + MAX_RX_HDLC_MSG_SIZE;
      guca_TxHDLCMsgBuffer = (uint8 *) guca_Rx_ME_HDLCMsgBuffer + MAX_RX_ME_HDLC_MSG_SIZE;

#ifndef ADSL_62
      // these two buffers are common to BIS/DMT
      gpsa_DECAdaptationTxData = (int16 *)((uint8 *)guca_TxHDLCMsgBuffer + MAX_TX_HDLC_MSG_SIZE);

      /* Make sure that DEC data accumulation array starts at the 32 bit word boundary. */
      gpla_DECAdaptationRxDataAccum = (int32 *) ((int32)(gpsa_DECAdaptationTxData + sizeof(int16)) & (~0x3));
#endif

      /********************************************************************************/
      /*                                                          */
      /* EC-train pointers Allocation                                   */
      /*                                                          */
      /********************************************************************************/
        vp_start_addr = (uint8 *)(void *)gsa_EC_Train_Seq;
        l_offset = 0;
//duplicate-defined constant!!!! to make pointer allocation possible, actual
//definition in ec_init.c
//Note the macro to allocate pointer takes size with a unit of byte.
#pragma Offwarn(240)
#define TAIL_TAPER_LEN  (40)
#ifdef ADSL_62
        INC_MALLOC(usa_sym_taper_tail, (int16*), TAIL_TAPER_LEN*2);
        INC_MALLOC(gsa_DECTrainBuf32, (int16*), 64*2);
        INC_MALLOC(gsa_DECCorrBuf32, (int16*), 64*2);
        INC_MALLOC(gsa_DECTrainBuf_AnnexA, (int16*), 512*2);
        INC_MALLOC(gsa_DECCorrBuf_AnnexA, (int16*), 512*2);
        INC_MALLOC(gsa_DECTrainBuf_AnnexA_Plus, (int16*), 1024*2);
        INC_MALLOC(gsa_DECCorrBuf_AnnexA_Plus, (int16*), 1024*2);
        INC_MALLOC(gsa_DECTrainBuf_AnnexL_Mask1, (int16*), 128*2);
        INC_MALLOC(gsa_DECCorrBuf_AnnexL_Mask1, (int16*), 128*2);
        INC_MALLOC(gsa_DECTrainBuf_AnnexL_Mask2, (int16*), 128*2);
        INC_MALLOC(gsa_DECCorrBuf_AnnexL_Mask2, (int16*), 128*2);
//        INC_MALLOC(gusa_DS_Tssi_Value, (uint16*), RX_NUM_TONES*2);
#else
        INC_MALLOC(usa_sym_taper_tail, (int16*), TAIL_TAPER_LEN*2);
        INC_MALLOC(gsa_DECTrainBuf32, (int16*), 64*2);
        INC_MALLOC(gsa_DECCorrBuf32, (int16*), 64*2);
        INC_MALLOC(gsa_DECTrainBuf_AnnexA, (int16*), 128*2);
        INC_MALLOC(gsa_DECCorrBuf_AnnexA, (int16*), 128*2);
        INC_MALLOC(gsa_DECTrainBuf_AnnexB, (int16*), 128*2);
        INC_MALLOC(gsa_DECCorrBuf_AnnexB, (int16*), 128*2);
        INC_MALLOC(gsa_DECTrainBuf_AnnexL_Mask1, (int16*), 128*2);
        INC_MALLOC(gsa_DECCorrBuf_AnnexL_Mask1, (int16*), 128*2);
        INC_MALLOC(gsa_DECTrainBuf_AnnexL_Mask2, (int16*), 128*2);
        INC_MALLOC(gsa_DECCorrBuf_AnnexL_Mask2, (int16*), 128*2);
#endif
#pragma Onwarn(240)
#ifndef TARGET_HW
#ifdef PRINT_DATA_ALLOCATION
      /********************************************************************************/
      /*                                                          */
      /* PRINT twiddle memory Allocation                                */
      /*                                                          */
      /********************************************************************************/

      data_allocation_ptr = fopen("data_allocation.txt","a");
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"---------------------------------------------\n");
      fprintf(data_allocation_ptr," Twiddle Memory Allocation                  -\n");
      fprintf(data_allocation_ptr,"---------------------------------------------\n");
      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"\n\nTime Slot 0 - Initialization \n\n");
      fprintf(data_allocation_ptr,"gsa_twid_real256            \t\t%d\t\t\n", (int32)gsa_twid_real256-(int32)gsa_CommonTwidMem);
      fprintf(data_allocation_ptr,"gsa_twid_imag256            \t\t%d\t\t\n", (int32)gsa_twid_imag256-(int32)gsa_CommonTwidMem);
      fprintf(data_allocation_ptr,"gsa_sk_tab256               \t\t%d\t\t\n", (int32)gsa_sk_tab256-(int32)gsa_CommonTwidMem);
      fprintf(data_allocation_ptr,"gsa_bit_reverse_idx256      \t\t%d\t\t\n", (int32)gsa_bit_reverse_idx256-(int32)gsa_CommonTwidMem);

      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"\n\nTime Slot 1 - Initialization - Messaging \n\n");
      fprintf(data_allocation_ptr,"guca_R_PARAMS_bis            \t\t%d\t\t\n", (int32)guca_R_PARAMS_bis-(int32)gsa_CommonTwidMem);
      fprintf(data_allocation_ptr,"gpsa_DS_BitAndGain           \t\t%d\t\t\n", (int32)gpsa_DS_BitAndGain-(int32)gsa_CommonTwidMem);

      fprintf(data_allocation_ptr,"\n\n");
      fprintf(data_allocation_ptr,"\n\nTime Slot 2 - Showtime \n\n");
      fprintf(data_allocation_ptr,"guca_rx_hdlc_msg_buffer     \t\t%d\t\t\n", (int32)guca_rx_hdlc_msg_buffer-(int32)gsa_CommonTwidMem);
      fprintf(data_allocation_ptr,"guca_RxHDLCMsgBuffer        \t\t%d\t\t\n", (int32)guca_RxHDLCMsgBuffer-(int32)gsa_CommonTwidMem);
      fprintf(data_allocation_ptr,"guca_TxHDLCMsgBuffer        \t\t%d\t\t\n", (int32)guca_TxHDLCMsgBuffer-(int32)gsa_CommonTwidMem);
      fprintf(data_allocation_ptr,"gsa_DECAdaptationTxData     \t\t%d\t\t\n", (int32)gpsa_DECAdaptationTxData-(int32)gsa_CommonTwidMem);

      fclose(data_allocation_ptr);
#endif
#endif

#undef N256
}

#endif      // TEST_HS_DECODE

#undef INC_MALLOC

