/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   BGChooseRevSegBin.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "gdata_dmt.h"
#include "gdata_bis.h"
#include "rt_tones.h"
#include "cmv.h"
#include "bitload_const.h"
#include "pll.h"
#include <string.h>

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background functions to choose best window for Reverb/Segue detection
 *               Optimal window is considered the one with the best average Reverb3 SNR.
 *
 *  Prototype: void BGChooseRevSegBin(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE void BGChooseRevSegBin(int16 *psa_snr)
{
   int16 s_num_bins;
   int16 sa_save_old_snrs[NUM_REVERB_SEGUE_BINS+2];
   int16 s_bin_index, s_snrbest = 0, s_binbest = 0;
   int16 *psa_snrbuf;
   int16 s_RxFirstChannel, s_RxLastChannel;

   /* Clear RS Detect Arrays that have been initialized before Link Start for fast retrain */
   gs_RSDetect_NumBins = 0;
   memset(gsa_RSDetect_Bins, 0, sizeof(int16)*NUM_REVERB_SEGUE_BINS);
   memset(gsa_RSDetect_PNSeq, 0, sizeof(int16)*((NUM_REVERB_SEGUE_BINS+7)>>3));

   /* Do not consider pilot tone in the RS detection */
   sa_save_old_snrs[NUM_REVERB_SEGUE_BINS] = psa_snr[gs_CPilotTone];
   sa_save_old_snrs[NUM_REVERB_SEGUE_BINS+1] = psa_snr[gs_AuxPilotToneIdx];
   psa_snr[gs_CPilotTone] = gs_RSDetect_SnrThreshold;
   psa_snr[gs_AuxPilotToneIdx] = gs_RSDetect_SnrThreshold;

   /* Select Tones For RS detection namely Tones with best snrs that meet gs_RSDetect_SnrThreshold */
   for(s_num_bins= 0; s_num_bins < NUM_REVERB_SEGUE_BINS; s_num_bins++)
   {

      s_RxFirstChannel = gs_RxFirstChannel;
      s_RxLastChannel  = gs_RxLastChannel;

      if ((gs_CurrentCoChipset == ADI_CO_CHIPSET) || (gs_CurrentCoChipset ==  ANCDA_CO_CHIPSET))
      {
      //    ADI-bugfix:
      //    DMT  Annex-B
      //    during Tranceiver-Training: ADI-CO transmits tones 61-255 (C-Reverb1-3)
      //    during Channel-analysis:   ADI-CO transmits tones 65-250 (C-Rates1, C-Medley, ...)
      //    Detection of C-RATES1 fails if line-noise forces high SNR on tones 61-64 and 252-255
      //    => take corner tones for Reverb/Segue detection out of supported set
      //       For DMT Anx A, change the last tone only.

         if (gl_SelectedMode & (MODE_ADSL1))
         {
#ifdef ISDN
            s_RxFirstChannel = (s_RxFirstChannel> 65) ? s_RxFirstChannel :  65;
#endif

            s_RxLastChannel  = (s_RxLastChannel <250) ? s_RxLastChannel  : 250;

         }
      }

      s_bin_index = s_RxFirstChannel ;
      psa_snrbuf = &psa_snr[s_RxFirstChannel] ;
      s_snrbest = 0 ;

      /* Choose tone with the highest snr */
      while(s_bin_index <= s_RxLastChannel)
      {
         if((!(( gl_SelectedMode & (MODE_ADSL2)  )) ||   /* G992.1/G992.2 */
            IS_TONEFLAGSET(p_MEDLEYset_DS, s_bin_index)) &&       /* G992.3/G992.4/G992.5 AND tone is a part of MEDLEYSet */
            (*psa_snrbuf > s_snrbest))                      /* check for tone with max snr */
         {
            s_binbest   = s_bin_index;
            s_snrbest   = *psa_snrbuf;
         }

         psa_snrbuf++;
         s_bin_index++;
      }

      /* Found a new tone that qualifies for RS Detection */
      if(s_snrbest > gs_RSDetect_SnrThreshold)
      {
         /* Update RSDetect Array */
         gs_RSDetect_NumBins++;
         gsa_RSDetect_Bins[s_num_bins] = s_binbest;

         /* Do not consider this tone in the next iteration */
         sa_save_old_snrs[s_num_bins] = s_snrbest;
         psa_snr[s_binbest] = gs_RSDetect_SnrThreshold;
      }
      /* Did not find a new tone that qualifies for RS Detection */
      else
      {
         break;
      }
   }


   if(gs_RSDetect_NumBins == 0)
   {
        gs_RSDetect_NumBins++;
      gsa_RSDetect_Bins[s_num_bins] = s_binbest;
      sa_save_old_snrs[s_num_bins] = s_snrbest;
      psa_snr[s_binbest] = gs_RSDetect_SnrThreshold;
   }

   /* Get PN Sequence and retrieve original snrs for tones that were selected for RS Detection */
   for(s_num_bins = 0; s_num_bins < gs_RSDetect_NumBins; s_num_bins++)
   {
      int16 s_pn_seq;
      /* Get PN Sequence for tones selected for RS Detection */
      s_pn_seq = gusa_PN512Tab[gsa_RSDetect_Bins[s_num_bins]>>3];
      s_pn_seq >>= ((gsa_RSDetect_Bins[s_num_bins]&0x7)<<1);
      s_pn_seq &= 0x3;

      /* Update RSDetect Array */
      gsa_RSDetect_PNSeq[s_num_bins>>3] |= (s_pn_seq << ((s_num_bins&0x7)<<1));

      /* retrieve original snr for tones selected for RS Detection */
      psa_snr[gsa_RSDetect_Bins[s_num_bins]] = sa_save_old_snrs[s_num_bins];
   }

   /* retrieve original snr of pilot tone */
   psa_snr[gs_CPilotTone] = sa_save_old_snrs[NUM_REVERB_SEGUE_BINS];
   psa_snr[gs_AuxPilotToneIdx] = sa_save_old_snrs[NUM_REVERB_SEGUE_BINS+1];

    guc_AccumState = TRAINING_DONE ;
}
