/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   GenMedly.c
 *
 *   Definition of GenerateMedley.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include <string.h>


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : GenerateMedley
 *
 *  Description:  Generates the frequency domain version of the C_Medley or
 *  R_Medley signal for one symbol period and clears the DC and Nyquist tones.
 *  The psuedo random sequence is periodic, if the end of the table is reached,
 *  then generation contiues from the beginning of the table.
 *
 *
 *  Prototype:  GenerateMedley(int16 *psa_unpk_PN,
 *                         int16 *psa_EncPN,
 *                         int16 s_offset,
 *                         int16 s_PN_Len,
 *                         int16 s_numtones)
 *
 *  Input Arguments:
 *      psa_unpk_PN     - pointer to array of unpacked psuedo random sequence
 *      s_offset        - offset to first unpacked data bit of sequence to
 *                        encode during this symbol period
 *      s_PN_Len          - number of bits in psuedo random sequence
 *      s_numbits       - number of bits of sequence being output during
 *                        this symbol period
 *
 *  Output Arguments:
 *      psa_EncPN       - pointer to encoded psuedo random sequence,
 *                        frequency domain representation of the Medley
 *                        signal being transmitted.
 *
 *  Returns: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void GenerateMedley(int16 *psa_unpk_PN, int16 *psa_EncPN, int16 s_offset, int16 s_PN_Len, int16 s_numbits) {

    int16 imax;

    /* ==================================================================== */
    /*  setup up loop to copy values from unpacked table to output array */
    /*  check to see end of table will be reached */
    /* ==================================================================== */

    imax = s_offset + s_numbits;
    if (imax > s_PN_Len) imax = s_PN_Len;   /* don't allow index to go past end of table */

   if (imax-s_offset > 0)
      memcpy(psa_EncPN, psa_unpk_PN+s_offset, sizeof(int16)*(imax-s_offset));

    /* ==================================================================== */
    /*  wrap around to beginning of table to get remaining values */
    /* ==================================================================== */
    imax = s_offset + s_numbits - s_PN_Len;

   if (imax > 0)
      memcpy(psa_EncPN+s_PN_Len-s_offset, psa_unpk_PN, sizeof(int16)*imax);

    /*  clear DC and Nyquist */
    psa_EncPN[0] = 0;
    psa_EncPN[1] = 0;

} /*  GenerateMedley */


