/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   GenRvbTwoDisjointBands.c
 *
 *
 *-------------------------------------------------------------------------
 */

#include "common.h"
#include "ifft_fix.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "pn_tab.h"
#include <string.h>
#include "tx_ops2.h"
#include "cmv.h"
#include "pll.h"


/*^^^
*------------------------------------------------------------------------
 *
 *  Name: Gen_Reverb_Two_Disjoint_Bands
 *
 *  Description:
 *    Generates two disjoint frequency bands of the
 *    C_Reverb or R_REVERB signal.
 *
 *  Prototype:
 *    void Gen_Reverb_Two_Disjoint_Bands(int16 *psa_OutBuf,
 *                         int16 s_signal_id,
 *                         int16 s_NumChn,
 *                                  int16 s_RvrbFirstBand_LeftChn,
 *                                  int16 s_RvrbFirstBand_RightChn,
 *                                  int16 s_RvrbSecondBand_LeftChn,
 *                                  int16 s_RvrbSecondBand_RightChn,
 *                         int16 s_Gain);
 *
 *  Input Arguments:
 *    s_signal_id          - indicates which signal (C_REVERB or R_REVERB) to generate
 *    s_NumChn          - total number of channels
 *      s_RvrbFirstBd_LeftChn - left channel of first band to send C_Reverb
 *      s_RvrbFirstBd_RightChn   - Right channel of first band to send C_Reverb
 *      s_RvrbSecondBd_LeftChn   - left channel of second band to send C_Reverb
 *      s_RvrbSecondBd_RightChn  - Right channel of second band to send C_Reverb
 *    s_Gain               - amplitude of each frequency component
 *
 *  Output Arguments:
 *      int16 *psa_OutBuf  - pointer to the freqency domain representation of C_Reverb signal
 *
 *  Return:
 *    none
 *
 *------------------------------------------------------------------------
 *^^^
 */
void Gen_Reverb_Two_Disjoint_Bands(int16 *psa_OutBuf, int16 s_signal_id, int16 s_NumChn,
      int16 s_RvrbFirstBd_LeftChn, int16 s_RvrbFirstBd_RightChn,
      int16 s_RvrbSecondBd_LeftChn, int16 s_RvrbSecondBd_RightChn, int16 s_Gain)
{

   int16 i;

   /* ==================================================================== */
   /*  Encode the psuedo random sequence */
   /* ==================================================================== */
   if(s_signal_id == GEN_REVERB_TYPE_CO) {
      SyncSymbol(psa_OutBuf, s_NumChn, gusa_PN512Tab, s_Gain);

      /* Insert pilot tone */
      if (gft_AuxPilot == AUX_PILOT_DISABLE ||
         !(( gl_SelectedMode & (MODE_ADSL2)  )))
      {
         psa_OutBuf[2*gs_CPilotTone] = s_Gain;
         psa_OutBuf[2*gs_CPilotTone+1] = s_Gain;
      }
   }
   else
      // Generate RT Reverb.
      SyncSymbol(psa_OutBuf, s_NumChn, gusa_PN_US_Tab, s_Gain);

   /* ==================================================================== */
   /*  Clear unused frequency bins */
   /* ==================================================================== */

   /*  Clear below first band */
   for (i=0; i<s_RvrbFirstBd_LeftChn; i++) {
      psa_OutBuf[2*i] = 0;
      psa_OutBuf[2*i+1] = 0;
   }

   /*  Clear between first and second bands */
   for (i=(s_RvrbFirstBd_RightChn+1); i<s_RvrbSecondBd_LeftChn; i++) {
      psa_OutBuf[2*i] = 0;
      psa_OutBuf[2*i+1] = 0;
   }

   /*  Clear above second band */
   for (i=(s_RvrbSecondBd_RightChn+1); i<s_NumChn; i++) {
      psa_OutBuf[2*i] = 0;
      psa_OutBuf[2*i+1] = 0;
   }  /*  clear above Second channel */
}
