/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   HybridTraining.c
*
*   Functions supporting programmable hybrid training.
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// HybridTraining.c
//
// History
//
// 29/11/2010 Palaksha/Bhadra: Added Framework to integrate hybrid training
//            modules to "SLEEP" state codeswap page.
//            Grep for "XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo"
//
// ******************************************************************

#include "common.h"
#include "states.h"
#include "gdata.h"
#include "afe_hyb.h"
#include "afe.h"
#include "pga_set.h"
#include <string.h>
#include "fifo.h"
#include "vecpwr.h"
#include "noiseacc.h"
#include "snr.h"
#include "cmv.h"
#include "dsp_op.h"
#include "pll.h"
#include "HybridTraining.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"





/******************************/
/***  Definitions           ***/
/******************************/

#define PGA2_BYPASS_GAIN (-8 << 8)
#define PGA1_BYPASS_GAIN (0 << 8)

extern uint16 gusa_HybMetric[VRX518_MAX_NUM_ADAP_HYB_SETTINGS];


//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE void InitHybridVars_VR9(void)
{
   /* Some variables need to be initialized only once. Initialize them here. */
   guc_BkgdTaskState = BKGDTASK_DONE;
   gs_HybIndex = 0;
   gs_HybMaxMetric = -1;
   gs_HybMaxIndex = -1;
   gl_HybMetricSum = 0;
      guc_HybTssiOff = 0;

#ifndef ISDN
   if (gl_SelectedMode & (MODE_G992_5))
      gs_dbg_DecimPoints = HYB_DECIM_POINTS;
  if (gs_force_Decimpoints)
      gs_dbg_DecimPoints = gs_force_Decimpoints;

#else
   //VR9_AnxB_HybImp Start
   if (gl_SelectedMode & (MODE_G992_5))
   {
      gs_dbg_DecimPoints = HYB_DECIM_POINTS;
   gs_HybEndTone = gs_HybStartTone + (HYB_DECIM_FACTOR * gs_dbg_DecimPoints);
   }
   else
   {
      gs_dbg_DecimPoints = HYB_DECIM_POINTS_3B1B;
      gs_HybEndTone = gs_HybStartTone + (HYB_DECIM_FACTOR * gs_dbg_DecimPoints);
   }

   if (gs_force_Decimpoints)
   {
      gs_dbg_DecimPoints = gs_force_Decimpoints;
   gs_HybEndTone = gs_HybStartTone + (HYB_DECIM_FACTOR * gs_dbg_DecimPoints);
   }
   // VR9_AnxB_HybImp End
#endif


}
/*******************************************************************************
*
*  Prototype: void ComputeExtraPGAMargin_AnxLBTLoops(void)
*
*  This function checks if there is a need to give extra 3dB PGA margin for Anx L bridge Tap loops
*  In case hybrid selected is between 3 and 31 (which is the case for long bridge tap loops),
*  give extra PGA margin of 3dB. This is to avoid CRCs seen on these loops.
*
*  Arguments:
*
*  Returns:
*
*  Global Variables:
*     gs_HybIndex (I):     Index of the loaded hybrid
*     gs_PGA_margin_delta_AnxL_BTloops : delta margin to be added to PGA margin
*     gs_pga_margin_AnxL_BTLoops :  Extra PGA margin for AnxL BT loops
*
*******************************************************************************/
C_SCOPE void ComputeExtraPGAMargin_AnxLBTLoops(void)
{
   if ((gs_HybIndex > 0)
      && (gs_HybIndex < 27)
      )
      gs_PGA_margin_delta_AnxL_BTloops = gs_pga_margin_AnxL_BTLoops;
   else
      gs_PGA_margin_delta_AnxL_BTloops=0;

   //XDSLRTFW-2033 (start)
#ifndef ISDN
   if((gt_INFX_CMV.us_OperatorSpBits7 & CMV_NoAFEMargin_AnnexLBT)
      &&(gft_CNXT_A_LongLoops == TRUE)
      )
   {
      gs_PGA_margin_delta_AnxL_BTloops=0;
   }
#endif
   //XDSLRTFW-2033 (end)

}


/*******************************************************************************
*
*  Prototype: void InitHybridAccum(int16 s_TrainingType)
*
*  This functions performs initialization needed before each accumulation in hybrid
*  training pipeline.
*
*  Arguments:
*     s_TrainingType (I):     Accumulation type:   0 - Accumulation for AGC1 calculation
*                                      1 - Accumulation for AGC2 calculation
*                                      2 - Accumulation for signal PSD measurement
*                                      3 - Accumulation for noise PSD measurement
*
*  Returns:
*
*  Global Variables:
*     gs_RxSubStateCnt (O):   Substate count
*     gl_Pa (O):           Power accumulation variable
*     gla_RxAccumBuf (O):     PSD accumulation variable
*
*******************************************************************************/
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE void InitHybridAccum(int16 s_TrainingType)
{
   gs_RxSubStateCnt = 0;
   if (s_TrainingType < 2)
   {
      gl_Pa = 0;
   }
   else
   {
      memset(gla_RxAccumBuf, 0, sizeof(int32)*(2*(HYB_DECIM_FACTOR * gs_dbg_DecimPoints + 1)));
   }
}

//VR9_AFE Hybrid Training Pipeline Algorithm
/*******************************************************************************
*
*  Prototype: FlagT HybridTrainingPipeline_VR9(int16 s_TrainingType)
*
*  This function implements the hybrid training pipeline for all four accumulation types
*  and thus it is the core of the hybrid training state machine.
*
*  Arguments:
*     s_TrainingType (I):        Accumulation type:   0 - Accumulation for AGC1 calculation
*                                         1 - Accumulation for AGC2 calculation
*                                         2 - Accumulation for signal PSD measurement
*                                         3 - Accumulation for noise PSD measurement
*
*  Returns:                FALSE if training pipeline is still in progress
*                          TRUE if the training pipeline is complete
*
*  Global Variables:
*     gs_HybIndex (I/O):         Index of the hybrid for which the accumulation is currently performed
*     gpsa_PGARegTable (I/O):    PGA register values for each hybrid
*     gs_RxSubStateCnt (I/O)
*     gl_Pa (I/O):            Power accumulation variable
*     gla_RxAccumBuf (I/O):      PSD accumulation variable
*     guc_HybNumHybrids (I):     Number of hybrids used in training
*     gs_HybridAccumCnt (I):     Variable holding number of accumulations
*     gs_Log2HybridAccumCnt (I): Variable holding log2 of number of accumulations
*     gsa_CReverbRefTones (I):   Reference for noise accumulation (zeroed out before hybrid training)
*     gs_RxSamplesPerFrame (I)
*     gs_Log2RxSamplesPerFrame (I)
*     gs_PGA_margin (I)
*     gs_LoadHybIndex (O):    Index of the hybrid to be loaded during time critical task
*     gpsa_PGARequiredTable (O): Required PGA values for each hybrid
*     gs_BgHybIndex (O):         Index of the hybrid to be processed in the background
*     gs_HPFEq_Reg_Setting (O):  Variable that holds HPF and equalizer settings
*     gs_BgHybAccumShift (O):    Shift to be performed in background to PSD accumulation
*     gpla_BgHybAccumBuf (O):    PSD accumulation buffer used in background
*     gsa_RxToneBuf (O)
*     gs_PGA_required (O)
*
*******************************************************************************/
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE FlagT HybridTrainingPipeline_VR9(int16 s_TrainingType)
{
#if 0
    return TRUE;
#else

    int16 s_HybGainIndex;
    int16 s_PGA_margin;
   int16 s_offset = 0;
    int16 s_margin = 0;
    gs_RxSubStateCnt++;

    if (gs_RxSubStateCnt < (gs_HybridAccumCnt+1)) //+1, Since gs_RxSubStateCnt is pre incremented
    {
      // AFE New data available after 4 symbols, i.e
      // 4 ==> FG load(1 sym) + Set AFE(1 sym)+ Stry(1 sym) + FFT(1 sym), Next symbol data available
      // Load the AFE Register values only 2 symbols ahead of accumulation count to avoid
      // unstable data in the ongoing accumulated samples.
      // At the end of accumulation we puposefully skip 2 symbols to avoid unstable data in the
      // next accumulation.
      if (gs_RxSubStateCnt == gs_HybridAccumCnt - 1) //-1, Since gs_RxSubStateCnt is pre incremented
      {
         /* Prepare for the next AGC/PSD accumulation. */
         gs_LoadHybIndex = gs_HybIndex + 1;

         if (gs_LoadHybIndex == (int16)guc_HybNumHybrids)
         {
            /* Prepare for the first AGC/PSD accumulation. */
            gs_LoadHybIndex = 0;
         }
         else
         {
         /* Set hybrid, HPF, and PGA for the next accumulation. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, AFED_LoadHybridHPFAndPGA_VR9);
         }
      }//end if (gs_RxSubStateCnt == gs_HybridAccumCnt - 2)


      /* Accumulate hybrid training data. */
      if (s_TrainingType < 2)
      {
         s_offset = 2; // ignore DC
         /* Accumulate power for AGC training. */
         gl_Pa += VectorPower(gsa_RxToneBuf, s_offset, (gs_RxSamplesPerFrame-s_offset), (int16)(gs_Log2RxSamplesPerFrame + gs_Log2HybridAccumCnt));

         s_HybGainIndex = (gs_HybIndex * VRX_HYB_AFE_REG_GAINS);
         if (s_TrainingType == 1)
            gsa_HybGain[s_HybGainIndex + AGC2_DC_OFFSET] = gsa_RxToneBuf[0];
         else
            gsa_HybGain[s_HybGainIndex + AGC1_DC_OFFSET] = gsa_RxToneBuf[0];

#ifdef VR9_HYB_TRAIN_DEBUG
#if 0
         if((gs_Set_Pause==0x299) &&  (gs_RxSubStateCnt == gs_dbg_count) &&
            (s_TrainingType == gs_dbg_type ) && (gs_HybIndex == gs_dbg_hybindex))Pause(0x2991);
#endif
#endif //VR9_HYB_TRAIN_DEBUG
      }
      else
      {
         /* Accumulate PSDs for SNR calculation. */
         NoiseAcc(gla_RxAccumBuf, (int16)0, gsa_RxToneBuf, (int16)0, (int16)0, (int16)0, gsa_CReverbRefTones, (int16)gs_HybStartTone, (int16)gs_HybEndTone);
         /* Accumulate reverb reference power threshold for the current hybrid (needed for */
         /* subsequent tone detections in Bis/Plus) when both sides are transmitting reverb. */
         if (s_TrainingType == 2)
         {
            gpla_HybRevRefPwr[gs_HybIndex] += (VectorPower(gsa_RxToneBuf, (int16) (2*(gs_CPilotTone-5)), (int16)(2*11), gs_DetectTone_PwrCalcShifts)
                                    - VectorPower(gsa_RxToneBuf, (int16) (2*gs_CPilotTone), 2, gs_DetectTone_PwrCalcShifts));
         }
#if 0//def VR9_HYB_TRAIN_DEBUG
         if((gs_Set_Pause==0x303) &&  (gs_RxSubStateCnt == gs_dbg_count) &&
            (s_TrainingType == gs_dbg_type ) && (gs_HybIndex == gs_dbg_hybindex))Pause(0x3031);
#endif //VR9_HYB_TRAIN_DEBUG
      }
   }
   else  // gs_RxSubStateCnt >= gs_HybridAccumCnt
   {
      //Discard 2 symbols for AFE settling
      if (gs_RxSubStateCnt == (gs_HybridAccumCnt+2))
      {
         /* This frame is corrupted by the hybrid/AGC change and therefore can not be */
         /* used for accumulations, so do the data processing here. */
         if (s_TrainingType < 2)
         {
            s_HybGainIndex = (gs_HybIndex * VRX_HYB_AFE_REG_GAINS);

            gs_PGA_set = gsa_HybGain[s_HybGainIndex + PGA_SET_OFFSET];
            gs_AGC1_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC1_GAIN_SET_OFFSET];
            gs_AGC2_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC2_GAIN_SET_OFFSET];

            /* For AnxL BT loops, identified based on the chosen hybrid configurations, check for extra pga margin*/
            if(STATArray[STAT_Mode] & STAT_ConfigMode_G992_3_L)
               ComputeExtraPGAMargin_AnxLBTLoops(); // Add extra PGA margin of 3dB for BT annex L Loops
            /* Calculate required gain. */
            //gs_AGC2_compensation = (PGA2_BYPASS_GAIN - ((gs_AGC2_Fixed_Gain + gs_AGC2_Gain_Set + gs_AGC3_Gain_Set) << 8));
            gs_AGC2_compensation = (gs_AGC2_Gain_Set) << 8;

           //s_PGA_margin =gs_PGA_margin;
            if (s_TrainingType == 0)
               s_PGA_margin = gs_PGA_margin_AGC1;
            else
               s_PGA_margin = gs_PGA_margin_AGC2;
            s_margin = s_PGA_margin;
            gs_PGA_required = PD_DB - ConvertToDB(gl_Pa) - gs_ADC_margin - (s_PGA_margin+gs_PGA_margin_delta_AnxL_BTloops) + gs_AGC2_compensation;
#ifdef FD_ACCUM_FOR_PGA
               gs_PGA_required -= gs_td_fd_pwr_offset;
#endif

            if (s_TrainingType == 0)
            {
               gs_AGC1_compensation = (gs_AGC1_Gain_Set << 8);
               //gs_PGA_required -= gs_AGC1_compensation;
               gs_PGA_required = gs_PGA_required - PGA2_BYPASS_GAIN + ((gs_AGC1_Gain_Set<<8) - gs_AGC1_Margin);
               AFED_CalcAGC1(gs_PGA_required);
#if 0
               //If AGC1 gain required < -6dB, then use these special Hybrid Settings to provide another -4dB gain
               //before AGC1 block.
               if (gs_PGA_required < (-6<<8))
               {
                  //update the Hybrid Buffer with special Hybrid settings.
                  //These Spl Hyb values shall be used while training AGC2
                  UpdateHybridBuffer_VR9();
               }
#endif
               //Save PGA Register values
               gsa_HybGain[s_HybGainIndex + HYB_IDX_OFFSET] = gs_HybIndex;
               gsa_HybGain[s_HybGainIndex + PGA_REQ_OFFSET] = (gs_AGC1_Gain_Set << 8); //gs_PGA_required <= gs_AGC1_Gain_Set in PGA1 training
               gsa_HybGain[s_HybGainIndex + PGA_SET_OFFSET] = gs_PGA_set;
               //gsa_HybGain[s_HybGainIndex + AGC1_DC_OFFSET] = gsa_RxToneBuf[0];
               s_margin += gs_ADC_margin+gs_PGA_margin_delta_AnxL_BTloops+gs_AGC1_Margin;
               gsa_HybGain[s_HybGainIndex + AGC1_PGA_MARGIN] = s_margin;
               gsa_HybGain[s_HybGainIndex + AGC1_GAIN_SET_OFFSET] = gs_AGC1_Gain_Set;
               gsa_HybGain[s_HybGainIndex + AGC1_GL_PA_OFFSET]    = (uint16)(gl_Pa>>16);
               gsa_HybGain[s_HybGainIndex + AGC1_GL_PA_OFFSET+1]  = (uint16)(gl_Pa & 0xFFFF);
               gsa_HybGain[s_HybGainIndex + AGC1_GS_AGC2_COMP]    = gs_AGC2_compensation;
               gsa_HybGain[s_HybGainIndex + AGC1_GS_PGA_REQUIRED] = gs_PGA_required;
               gsa_HybGain[s_HybGainIndex + AGC1_GS_AGC1_COMP] = gs_AGC1_compensation;
#ifdef VR9_HYB_TRAIN_DEBUG
               if(gs_Set_Pause==0x300) Pause(0x3001);
#endif //VR9_HYB_TRAIN_DEBUG
            }
            else  // s_TrainingType==1
            {
               //Input: AGC2Var_gain + AGC2_FixedGain + AGC3_VarGain
               //gs_PGA_required += PGA2_BYPASS_GAIN;
               AFED_CalcAGC2(gs_PGA_required);

               //Save PGA Register values
               gsa_HybGain[s_HybGainIndex + PGA_REQ_OFFSET] += gs_PGA_required;
               gsa_HybGain[s_HybGainIndex + PGA_SET_OFFSET] = gs_PGA_set;
               gsa_HybGain[s_HybGainIndex + AGC2_GAIN_SET_OFFSET] = gs_AGC2_Gain_Set;
               gsa_HybGain[s_HybGainIndex + AGC2_GL_PA_OFFSET]    = (uint16)(gl_Pa>>16);
               gsa_HybGain[s_HybGainIndex + AGC2_GL_PA_OFFSET+1]  = (uint16)(gl_Pa & 0xFFFF);
               gsa_HybGain[s_HybGainIndex + AGC2_GS_AGC2_COMP]    = gs_AGC2_compensation;
               gsa_HybGain[s_HybGainIndex + AGC2_GS_PGA_REQUIRED] = gs_PGA_required;
               gsa_HybGain[s_HybGainIndex + AGC2_GS_AGC1_COMP] = gs_AGC1_Gain_Set;
               //gsa_HybGain[s_HybGainIndex + AGC2_DC_OFFSET] = gsa_RxToneBuf[0];
               s_margin += gs_ADC_margin+gs_PGA_margin_delta_AnxL_BTloops;
               gsa_HybGain[s_HybGainIndex + AGC2_PGA_MARGIN] = s_margin;
#ifdef VR9_HYB_TRAIN_DEBUG
               if(gs_Set_Pause==0x302) Pause(0x3003);
#endif //VR9_HYB_TRAIN_DEBUG
            }
         }
         else  // s_TrainingType>=2
         {
            if (guc_BkgdTaskState == BKGDTASK_DONE)
            {
               /* Prepare for background processing of accumulated data. */
               gs_BgHybIndex = gs_HybIndex;
               gs_BgHybAccumShift = gs_Log2HybridAccumCnt - 2;
               memcpy(gpla_BgHybAccumBuf, gla_RxAccumBuf, sizeof(int32)*(2*(HYB_DECIM_FACTOR * gs_dbg_DecimPoints + 1)));
               guc_BkgdTaskState = BKGDTASK_IN_PROGRESS;
               if (s_TrainingType == 2)
               {
                  /* Calculate and store signal PSD in dB in background. */
                  AddFunctionToBkgdFifo((PtrToBkgdFunc)BgHybCalcSignalPSD);
               }
               else
               {
                  /* Calculate SNRs and compare metrics in background. */
                  AddFunctionToBkgdFifo((PtrToBkgdFunc)BgHybCalcAndCompMetric);
               }
            }
            else
            {
               /* Processing from the previous hybrid did not complete. Go to the failure state. */
               gs_RxNextState = FAIL_RX;
               gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

               /* Set exception handler variables */
               gus_ExceptionState   = gs_RxState;
               gus_ExceptionCode = E_CODE_HYB_ACCUM_FAILURE;
            }
         }


         if (++gs_HybIndex < (int16)guc_HybNumHybrids) {
            /* Initialize for the next accumulation. */
            InitHybridAccum(s_TrainingType);
         }
         else {
            /* Initialize for the next pipeline. */
            gs_HybIndex = 0;
            return TRUE;
         }
      } //   end of (gs_RxSubStateCnt == gs_HybridAccumCnt+2)
   }// end of (gs_RxSubStateCnt >= gs_HybridAccumCnt)

   return FALSE;
#endif
} //HybridTrainingPipeline_VR9()


/*******************************************************************************
*
*  Prototype: void BgHybCalcSignalPSD(void)
*
*  This function processes and stores decimated signal PSD accumulation.
*
*  Arguments:
*
*  Returns:
*
*  Global Variables:
*     gpla_BgHybAccumBuf (I/O):  Accumulated signal PSD
*     guc_BkgdTaskState (I/O)
*     gs_BgHybAccumShift (I):    Shift to be applied to the raw signal PSD accumulation
*     gs_BgHybIndex (I):         Index of the processed hybrid
*     gpsa_SignalPSD (O):        Decimated signal PSD values for all hybrids
*
*******************************************************************************/
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE void BgHybCalcSignalPSD(void)
{
   int16 i;
   int16 s_Index;
   int16 s_SignalPSD;

   /* Round the PSD accumulation. */
   RoundNoiseAccum(gpla_BgHybAccumBuf, gpla_BgHybAccumBuf, 0, (HYB_DECIM_FACTOR * gs_dbg_DecimPoints + 1), gs_BgHybAccumShift);
   /* Convert accumulation to dB and store decimated signal PSD. */
   s_Index = (gs_dbg_DecimPoints + 1) * gs_BgHybIndex;
   for (i = 0; i <= gs_dbg_DecimPoints; i++)
   {
      /* Convert signal PSD to dB. */
      s_SignalPSD = ConvertToDB(gpla_BgHybAccumBuf[HYB_DECIM_FACTOR*i]);
      /* Saturate PSD to prevent overflows or underflows in subsequent SNR calculation */
      /* (ConvertToDB() function returns large negative result if PSD = 0). */
      if (s_SignalPSD < 0)
         s_SignalPSD = 0;
      /* Store signal PSD. */
      gpsa_SignalPSD[s_Index++] = s_SignalPSD;
   }
   /* Format reverb reference power threshold. */
   gpla_HybRevRefPwr[gs_BgHybIndex] >>= HYB_LOG2_SIG_PSD_ACCUM_CNT;

   guc_BkgdTaskState = BKGDTASK_DONE;
}


/*******************************************************************************
*
*  Prototype: void BgHybCalcAndCompMetric(void)
*
*  This function processes noise PSD accumulation, calculates SNRs, and
*  calculates and compares metrics for all hybrids.
*
*  Arguments:
*
*  Returns:
*
*  Global Variables:
*     gpla_BgHybAccumBuf (I/O):  Accumulated signal PSD
*     guc_BkgdTaskState (I/O)
*     gs_BgHybAccumShift (I):    Shift to be applied to the raw signal PSD accumulation
*     gs_BgHybIndex (I):         Index of the processed hybrid
*     gpsa_SignalPSD (I):        Decimated signal PSD values for all hybrids
*     gsa_ReverbEchoSnrBuf (O):  SNR calculated as (signal_power - noise_power)
*     gs_HybMaxMetric (O)
*     gs_HybMaxIndex (O)
*     gl_HybMetricSum (O)
*
*******************************************************************************/

//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE void BgHybCalcAndCompMetric(void)
{
   int16 i, j;
   int16 s_Index;
   int16 s_DecimIndex;
   int16 s_SignalPSD;
   int16 s_NoisePSD;
   int16 s_Metric;

   /* Round the PSD accumulation. */
   RoundNoiseAccum(gpla_BgHybAccumBuf, gpla_BgHybAccumBuf, 0, (HYB_DECIM_FACTOR * gs_dbg_DecimPoints + 1), gs_BgHybAccumShift);
   /* Calculate SNRs and estimate supported number of bits. */
   s_Index = 0;
   s_DecimIndex = (gs_dbg_DecimPoints + 1) * gs_BgHybIndex;
   for (i = 0; i < gs_dbg_DecimPoints; i++)
   {
      for (j = 0; j < HYB_DECIM_FACTOR; j++)
      {
         /* Interpolate signal PSD. */
         s_SignalPSD = gpsa_SignalPSD[s_DecimIndex];
         s_SignalPSD += j * ((gpsa_SignalPSD[s_DecimIndex+1] - s_SignalPSD) >> HYB_LOG2_DECIM_FACTOR);
         /* Convert noise PSD to dB. */
         s_NoisePSD = ConvertToDB(gpla_BgHybAccumBuf[s_Index]);
         /* Saturate PSD to prevent overflows or underflows in subsequent SNR calculation */
         /* (ConvertToDB() function returns large negative result if PSD = 0). */
         if (s_NoisePSD < 0)
            s_NoisePSD = 0;
         //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
        if((STATArray[STAT_MacroState] == STAT_MFD) ||
           (guc_NLNF_Enable == 1)) // In case FW can't send STAT_MFD to SW
         {
             /* Calculate SNR (signal power - noise power). */
             gsa_ReverbEchoSnrBuf[gs_HybStartTone + s_Index] =
                0x4E44 - s_NoisePSD;
             //Note: Taking Constellation reference Point as 0x2000,
             //       RefSigPower = 20log10(0x2000) = 78.267 ==> 20036 (in 8.8 format) ==> 0x4E44
         }
         else
         {
#endif
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE

         /* Calculate SNR (signal power - noise power). */
         gsa_ReverbEchoSnrBuf[gs_HybStartTone + s_Index] = s_SignalPSD - s_NoisePSD;
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
         }
#endif
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
         //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (End)
         s_Index++;
      }
      /* Increment index to the signal PSD array. */
      s_DecimIndex++;
   }
   //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
   //Force SNR on G.Hs tones to zero.
   if((STATArray[STAT_MacroState] == STAT_MFD) ||
        (guc_NLNF_Enable == 1))  //In case FW can't send STAT_MFD to SW
   {
         gsa_ReverbEchoSnrBuf[gsa_DnCarSetA43[0]] = 0;
         gsa_ReverbEchoSnrBuf[gsa_DnCarSetA43[1]] = 0;
         gsa_ReverbEchoSnrBuf[gsa_DnCarSetA43[2]] = 0;
         gsa_ReverbEchoSnrBuf[gsa_DnCarSetB43_J43[0]]= 0;
         gsa_ReverbEchoSnrBuf[gsa_DnCarSetB43_J43[1]] = 0;
         gsa_ReverbEchoSnrBuf[gsa_DnCarSetB43_J43[2]] = 0;
         gsa_ReverbEchoSnrBuf[44] = 0;
         gsa_ReverbEchoSnrBuf[48] = 0;
         gsa_ReverbEchoSnrBuf[52] = 0;
         gsa_ReverbEchoSnrBuf[60] = 0;
   }
#endif
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
   //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (End)


   /* Calculate metric and compare it to the maximum. */
   s_Metric = GetTotalBits();

   gusa_HybMetric[gs_BgHybIndex] = s_Metric; //Store the Hybrid Metric for debug purpose

   if (s_Metric > gs_HybMaxMetric)
   {
      gs_HybSecondBestMetric = gs_HybMaxMetric;
      gs_HybSecondBestIndex = gs_HybMaxIndex;
      gs_HybMaxMetric = s_Metric;
      gs_HybMaxIndex = gs_BgHybIndex;
   }
   else if (s_Metric > gs_HybSecondBestMetric)
   {
      gs_HybSecondBestMetric = s_Metric;
      gs_HybSecondBestIndex = gs_BgHybIndex;
   }
   /* Update sum of metrics over all the hybrids. */
   gl_HybMetricSum += s_Metric;
   /* Store the metric for default (straight loop) hybrid. */
   if (gs_BgHybIndex == STRAIGHTLOOP_HYBIDX)
   {
      gs_HybZeroMetric = s_Metric;
   }

   guc_BkgdTaskState = BKGDTASK_DONE;
}


/*******************************************************************************
*
*  Prototype: int16 GetTotalBits(void)
*
*  This function calculates the total number of bits supported with given SNRs
*  between HYB_START_TONE and HYB_END_TONE.
*
*  Arguments:
*
*  Returns:                Total number of bits assuming fast path and trellis coding.
*
*  Global Variables:
*     gsa_ReverbEchoSnrBuf (I)
*     gsa_ConstellationSNR (I):  SNRs needed to support corresponding constellations
*     guca_RxBat (O):            Bit allocation table
*
*******************************************************************************/
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE int16 GetTotalBits(void)
{
   int16 s_ch;
   int16 s_qc;
   int16 s_NegativeFineGain;
   int16 s_PositiveFineGain;
   int32 l_FineGainSum;
   int16 s_NumLoadedChannels;
   int16 s_Threshold;
   int16 s_TotalBits;

   /* Calculate bitloading without fine gains. */
   l_FineGainSum = 0;
   s_NumLoadedChannels = 0;
   for (s_ch = gs_HybStartTone; s_ch < gs_HybEndTone; s_ch++)
   {
      guca_RxBat[s_ch] = 0;
      for (s_qc = 15; s_qc >= RX_MIN_BITS_PER_TONE; s_qc--)
      {
         s_NegativeFineGain = (gsa_ConstellationSNR[s_qc] + HYB_PHY_MARGIN) - gsa_ReverbEchoSnrBuf[s_ch];
         if (s_NegativeFineGain <= 0)
         {
            guca_RxBat[s_ch] = (uint8)s_qc;
            if (s_NegativeFineGain < -HYB_MAX_FINE_GAIN)
            {
               s_NegativeFineGain = -HYB_MAX_FINE_GAIN;
            }
            l_FineGainSum += s_NegativeFineGain;
            s_NumLoadedChannels++;
            break;
         }
      }
   }
   /* First go through the unloaded tones since we gain more bits using positive fine gains on these */
   /* tones than on the others. */
   for (s_ch = gs_HybStartTone; s_ch < gs_HybEndTone; s_ch++)
   {
      if (guca_RxBat[s_ch] == 0)
      {
         s_PositiveFineGain = (gsa_ConstellationSNR[RX_MIN_BITS_PER_TONE] + HYB_PHY_MARGIN) - gsa_ReverbEchoSnrBuf[s_ch];
         if ((s_PositiveFineGain <= HYB_MAX_FINE_GAIN) && (l_FineGainSum + s_PositiveFineGain <= 0))
         {
            guca_RxBat[s_ch] = RX_MIN_BITS_PER_TONE;
            l_FineGainSum += s_PositiveFineGain;
            s_NumLoadedChannels++;
         }
      }
   }
   /* Now process the rest of the tones. Prioritize the fine gain assignment by using a threshold */
   /* that increases from min fine gain to max fine gain. */
   for (s_Threshold = 0x0080; s_Threshold <= HYB_MAX_FINE_GAIN; s_Threshold += 0x0080)
   {
      for (s_ch = gs_HybStartTone; s_ch < gs_HybEndTone; s_ch++)
      {
         s_qc = (int16)guca_RxBat[s_ch];
         if ((s_qc == 0) || (s_qc == RX_MAX_BITS_PER_TONE))
            continue;

         /* Calculate required fine gain to bitload one more bit. */
         s_PositiveFineGain = (gsa_ConstellationSNR[s_qc+1] + HYB_PHY_MARGIN) - gsa_ReverbEchoSnrBuf[s_ch];

         /* If the fine gain is too large, skip the tone. */
         if (s_PositiveFineGain > s_Threshold)
            continue;

         /* If the fine gain is below the threshold, check if sum of fine gains remains */
         /* negative after addition of a bit and if so add a bit to this tone. */
         s_NegativeFineGain = (gsa_ConstellationSNR[s_qc] + HYB_PHY_MARGIN) - gsa_ReverbEchoSnrBuf[s_ch];
         if (s_NegativeFineGain < -HYB_MAX_FINE_GAIN)
         {
            s_NegativeFineGain = -HYB_MAX_FINE_GAIN;
         }
         s_PositiveFineGain -= s_NegativeFineGain;
         if (l_FineGainSum + s_PositiveFineGain <= 0)
         {
            guca_RxBat[s_ch] += 1;
            l_FineGainSum += s_PositiveFineGain;
         }
      }
   }
   /* Calculate total bits. */
   s_TotalBits = 0;
   for (s_ch = gs_HybStartTone; s_ch < gs_HybEndTone; s_ch++)
   {
      s_TotalBits += (int16)guca_RxBat[s_ch];
   }
   /* Subtract the TCM bits. */
   s_TotalBits -= (s_NumLoadedChannels + 9) >> 1;
   /* In case TCM requires more bits than supported, limit the total bits to zero. */
   if (s_TotalBits < 0)
      s_TotalBits = 0;

   return s_TotalBits;
}


/*******************************************************************************
*
*  Prototype: void AdjustRevRefPwr(void)
*
*  This function adjusts reverb reference power threshold based on the ratio of
*  signal powers around the pilot tone for default and selected hybrid. Note
*  that this function is used only in Bis/Plus modes.
*
*  Arguments:
*
*  Returns:
*
*  Global Variables:
*     gl_DetectTone_RevRefPwr (I/O):      Reverb reference power threshold to be adjusted
*     gpla_HybRevRefPwr (I):           Pointer to the array of signal power accumulations
*     gs_LoadHybIndex (I):          Index of the loaded hybrid
*
*******************************************************************************/
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE void AdjustRevRefPwr(void)
{
   int16 s_shift;

   /* Make sure that the product below does not overflow. */
   s_shift = 31 - norm_l(gl_DetectTone_RevRefPwr) - norm_l(gpla_HybRevRefPwr[gs_LoadHybIndex]);
   if (s_shift < 0)
      s_shift = 0;

   gl_DetectTone_RevRefPwr *= (gpla_HybRevRefPwr[gs_LoadHybIndex] >> s_shift);
   gl_DetectTone_RevRefPwr /= (gpla_HybRevRefPwr[0] >> s_shift);
}


