/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: InitTDQfilter.c
*
*-------------------------------------------------------------------------------
*/
#include "typedef.h"
#include "gdata.h"
#include "InitTDQfilter.h"

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void SetTDQtoUnity(void)
*
*   Description:
*
*  Set TDQ taps to correspond to Unity TDQ
*
*  Arguments:
*     none
*
*  Global Variables:gsa_pre_tdq_h, gs_pre_tdq_h_exp
*
*-------------------------------------------------------------------
*^^^
*/


void SetTDQtoUnity(void)
{
   int i;

   /* Set TDQ to UnityTdq. */
   gsa_pre_tdq_h[0] = 0x4000;

   for (i=1; i<gs_TDQLen; i++)
      gsa_pre_tdq_h[i] = 0;

   gs_pre_tdq_h_exp = 14;

}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void SetInitialTDQ(void)
*
*   Description:
*
*  Set TDQ taps to correspond to a highpass filter with cutoff at tone 32.
*   Designed a 15 tap TDQ filter correspnding to firls(14, [0, 32/512, 36/512,1], [0 0 1 1])
*
*  Arguments:
*     none
*
*  Global Variables:gsa_pre_tdq_h, gs_pre_tdq_h_exp
*
*-------------------------------------------------------------------
*^^^
*/

void SetInitialTDQ(void)
{
   int i;
   /* set initial TDQ to correspond to HPF, this is required to reduce the echo in handshake.
   currently for echo limited loops, PGA in handshake is getting set based on echo of transmitted tones,
   resulting in low PGA values and eventually failing detection at long loops
   firls(14, [0, 32/512, 36/512,1], [0 0 1 1]);*/

   int16 s_temp[16]={-1748, -1924, -2081, -2216, -2325, -2405, -2454,30298, -2454, -2405, -2325, -2216, -2081, -1924, -1748, 0};

   for (i=0; i<16; i++)
      gsa_pre_tdq_h[i] = s_temp[i];

   gs_pre_tdq_h_exp = 14;


}

