/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   PreSelectReverbSegueDetector.C
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */
// *****************************************************************************
// PreSelectReverbSegueDetector.c
//
// History
//
// Raghu:INP = 8 REIN Test Failure against some DSLAMs only with 60pps impulse rate.
//    New procedure is uesd for choosing the tones used for Sync symbol detection in Showtime.
//    a) We avoid consecutive tones to be used for detection. We go for block interleave type of tone selection and the depth 8 tones
//    b) Try to choose tones with more than 12 bit allocation in the first iteration.  Next iteration reduce the bit allocation threshold by 2
//    Step a & b are done till number of tones needed for Reverb Segue detection is completed
//    For Code changes grep for "XDSLRTFW-374 (ADSLRTFW-1361): IOP_DS_PLUS_FR_TelefonicaOnSite_INP_REIN_Tests (start)"
//
// 22/03/2013 Ram: Selection of tones for Reverb/Segue detection made more robust.
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
// 25-04-2013 Prashant: Merged the following fix for SES defect with Margin Verification test (TR100:B.2.1.2)
//       Anantha: Fix for SES defect found with high noise margin test cases. Root cause for the issue is
//       Reverb segue detection tones are first 10 loaded bins. In high noise cases like FB noise first 5-6 tones are loaded with
//       1-bit and reverb or segue sequence is 2 bit (4-QAM) psuedo random sequence. Changing the logic to select tones with
//       highest bitloading in same order. it is seen that if order of the tones is changed port drops
//    grep pattern XDSLRTFW-601: BugFix_DS_All_All_SESFail
// 16-06-2014 Varun : NVLTG link drop seen with fixed rate test cases when CMV INFO 103 26 bit#7(mask 0x8) is enabled.There is a flaw in
//                    logic used to select the highest bit loaded bins. Choosing initial fixed threshold and then iterating through the
//                    loops may not always converge. This will not work in the fixed rate case and fails to choose the bins for reverb
//                    segue detection and thus linkdrops after entering the showtime. Also enabling this CMV gives stability with
//                    NVLTC in rein cases. Therefore logic is made general to work for all COs and removed the CMV. Minimum tone depth required to
//                    work with NVLTC rein case is found to be 4 after the experiment and min bit load threshold can be 2
//                    Grep for XDSLRTFW-1788(START_END)
// *****************************************************************************
#include "const.h"
#include "const_bis.h"
#include "gdata.h"
#include "gdata_bis.h"

#include "string.h"
#include "const.h"
#include "bitload_const.h"
#include "pll.h"

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    PreSelectReverbSegueDetector
 *
 * Prototype:
 *    void PreSelectReverbSegueDetector(void);
 *
 *  Abstract:
 *    PreReverbSegueDetector() -
 *
 *    This function sets up the h/w reverb segue detector
 *
 *
 *  Returns:
 *
 *  Global Variables Used:
 *      None
 *------------------------------------------------------------------------
 */

#define     min(a,b) ((a>b) ? (b) : (a))
C_SCOPE void PreSelectReverbSegueDetector(void)
{
   //XDSLRTFW-1788(START_END)
   int s_toneidx, s_numTones = 0,s_toneIntlDepth =4 ,s_BitThresh=2,inc = s_toneIntlDepth>>1;//guc_MaxBinThresh

   uint8 *puca_RxBat;
   int16 *psa_RxFineGains;


       // XDSLRTFW-374 (ADSLRTFW-1361): IOP_DS_PLUS_FR_TelefonicaOnSite_INP_REIN_Tests (start)
 //      if( (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_NEW_REVSEG_DET_TONE_SEL) == 0)

      s_toneidx = gs_RxFirstChannel;
      psa_RxFineGains = gsa_RxFineGains;
      puca_RxBat = guca_RxBat;
      while ((s_numTones < NUM_REVERB_SEGUE_BIN_CHECKS) &&
               (inc > 0))
      {
         // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
         if ((puca_RxBat[s_toneidx] >= s_BitThresh) &&
            (psa_RxFineGains[s_toneidx] != NEG_INFINITY_DB) &&
            (s_toneidx != gs_AuxPilotToneIdx) &&
            (s_toneidx != gs_CPilotTone) )
         {
            gsa_PreSel_RSDetectBins[s_numTones++] = s_toneidx;
            // Choose the next tone that is s_toneIntlDepth apart.
            s_toneidx = s_toneidx + s_toneIntlDepth;
         }
         else
         {
            //increment the tone idx to next tone
            s_toneidx++;
         }
         // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
         // By this we avoid choosing neighbouring tones for reverb segue detection
         // tones with bit allocation greater than s_BitThresh are done
         // next round go for tones with lower bit allocation, so reduce
         // threshold by factor of 2
         // next round start first channel + inc, where inc is tone interleave depth/2
         // eg. 1st round  33      , 33+i        , 33+2*i         ... with bits > s_BitThresh
         //     2nd round  33 + i/2, 33 + i/2 + i, 33 + i/2 + 2*i ... with bits > s_BitThresh/2
         //     3rd round  33 + i/4, 33 + i/4 + i, 33 + i/4 + 2*i ... with bits > s_BitThresh/2
         // where i is the interleav depth
         if (s_toneidx >= gs_RxLastChannel)
         {
            s_toneidx = gs_RxFirstChannel + inc;
            //XDSLRTFW-1788(START_END)
            // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
            s_BitThresh = s_BitThresh >> 1;
            //s_BitThresh = s_BitThresh - 2;
            // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
            inc = inc >> 1;
         }
      }

      if (s_numTones < NUM_REVERB_SEGUE_BIN_CHECKS)
      {
         for (;s_numTones< NUM_REVERB_SEGUE_BIN_CHECKS;s_numTones++)
            gsa_PreSel_RSDetectBins[s_numTones] = gsa_PreSel_RSDetectBins[0];
      }

      // XDSLRTFW-374 (ADSLRTFW-1361): IOP_DS_PLUS_FR_TelefonicaOnSite_INP_REIN_Tests (end)
}


